/*
 *
 * j-chkmail - filtre de messagerie pour sendmail - MILTER
 *
 * Copyright (c) 2001, 2002 Ecole des Mines de Paris
 *
 *  Auteur     : Jose Marcio Martins da Cruz
 *               martins@paris.ensmp.fr
 *
 *  Historique :
 *  Creation     : janvier 2002
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include <j-sys.h>

#include "j-chkmail.h"

#include "j-filter.h"

extern int      log_level;


void            usage ();
static void     dump_p_stats_all (p_stats *, char *, p_stats *, char *, int, int);
static void     dump_p_stats (p_stats *, char *, int, int);
static int      dump_state (int, int, int, int);

/* ****************************************************************************
 *                                                                            *
 *                                                                            *
 **************************************************************************** */
static void
dump_p_stats (st, title, c, all)
     p_stats        *st;
     char           *title;
     int             c;
     int             all;
{
  char            out[256];
  char           *p;

  printf ("\n%s\n", title);
  strcpy (out, ctime (&st->start));

  if ((p = strchr (out, '\n')) != NULL)
    *p = '\0';
  printf ("%c %-30s : %s\n", c, "Start", out);
  printf ("%c %-30s : %10ld\n", c, "# Start-up", st->value[STAT_RESTART]);
  printf ("%c %-30s : %10ld\n", c, "# Messages", st->value[STAT_MSGS]);
  printf ("%c %-30s : %10ld\n", c, "# KBytes", st->value[STAT_BYTES] >> 4);
  printf ("%c %-30s : %10ld\n", c, "# Connect", st->value[STAT_CONNECT]);
  printf ("%c %-30s : %10ld\n", c, "# Abort", st->value[STAT_ABORT]);
  printf ("%c %-30s : %10ld\n", c, "# Close", st->value[STAT_CLOSE]);
  if (all || st->value[STAT_ENVTO] > 0)
    printf ("%c %-30s : %10ld\n", c, "# ENV RCPT", st->value[STAT_ENVTO]);
  if (all || st->value[STAT_FILES] > 0)
    printf ("%c %-30s : %10ld\n", c, "# Attached files", st->value[STAT_FILES]);
  if (all || st->value[STAT_XFILES] > 0)
    printf ("%c %-30s : %10ld\n", c, "# X-Files", st->value[STAT_XFILES]);
  if (all || st->value[STAT_VIRUS] > 0)
    printf ("%c %-30s : %10ld\n", c, "# Virus", st->value[STAT_VIRUS]);
  if (all || st->value[STAT_LUSERS] > 0)
    printf ("%c %-30s : %10ld\n", c, "# Reject Local Users", st->value[STAT_LUSERS]);
  if (all || st->value[STAT_OUTLOOK] > 0)
    printf ("%c %-30s : %10ld\n", c, "# Reject Outlook", st->value[STAT_OUTLOOK]);
  if (all || st->value[STAT_NO_TO_HEADERS] > 0)
    printf ("%c %-30s : %10ld\n", c, "# Reject No RCPT Headers",
            st->value[STAT_NO_TO_HEADERS]);
  if (all || st->value[STAT_NO_FROM_HEADERS] > 0)
    printf ("%c %-30s : %10ld\n", c, "# Reject No Senders ",
            st->value[STAT_NO_FROM_HEADERS]);
  if (all || st->value[STAT_MAX_RCPT] > 0)
    printf ("%c %-30s : %10ld\n", c, "# Reject Exceed Max RCPT",
            st->value[STAT_MAX_RCPT]);
  if (all || st->value[STAT_THROTTLE] > 0)
    printf ("%c %-30s : %10ld\n", c, "# Reject Exceed Throttle",
            st->value[STAT_THROTTLE]);
  if (all || st->value[STAT_RESOLVE_FAIL] > 0)
    printf ("%c %-30s : %10ld\n", c, "# Resolve FAIL", st->value[STAT_RESOLVE_FAIL]);
  if (all || st->value[STAT_RESOLVE_FORGED] > 0)
    printf ("%c %-30s : %10ld\n", c, "# Resolve FORGED",
            st->value[STAT_RESOLVE_FORGED]);

}

/* ****************************************************************************
 *                                                                            *
 *                                                                            *
 **************************************************************************** */
static void
dump_p_stats_all (sta, titlea, stb, titleb, all, nf)
     p_stats        *sta;
     char           *titlea;
     p_stats        *stb;
     char           *titleb;
     int             all;
     int             nf;
{
  char            out[256];
  char           *p;
  int             i;

  strcpy (out, ctime (&sta->start));
  if ((p = strchr (out, '\n')) != NULL)
    *p = '\0';
  printf ("\n%-30s %s\n", titlea, out);

  strcpy (out, ctime (&stb->start));
  if ((p = strchr (out, '\n')) != NULL)
    *p = '\0';
  printf ("%-30s %s\n", titleb, out);

  printf ("%-40s   : %10ld  %10ld\n",
          "# Start-up", sta->value[STAT_RESTART], stb->value[STAT_RESTART]);
  printf ("%-40s   : %10ld  %10ld\n",
          "# Messages", sta->value[STAT_MSGS], stb->value[STAT_MSGS]);
  printf ("%-40s   : %10ld  %10ld\n",
          "# KBytes", sta->value[STAT_BYTES] >> 4, stb->value[STAT_BYTES] >> 4);
  printf ("%-40s   : %10ld  %10ld\n",
          "# Connect", sta->value[STAT_CONNECT], stb->value[STAT_CONNECT]);

  if (nf) {
    for (i = STAT_ABORT; i < DIM_STATS; i++) {
      if (sta->value[i] > 0 || stb->value[i] > 0) {
        char           *p = stats_title (i);

        if (p)
          printf ("* %-40s : %10ld  %10ld\n", p, sta->value[i], stb->value[i]);
      }
    }
  } else {
    printf ("# %-40s : %10ld  %10ld\n",
            "Abort", sta->value[STAT_ABORT], stb->value[STAT_ABORT]);
    printf ("# %-40s : %10ld  %10ld\n",
            "Close", sta->value[STAT_CLOSE], stb->value[STAT_CLOSE]);

    if (sta->value[STAT_ENVTO] > 0 || stb->value[STAT_ENVTO] > 0)
      printf ("# %-40s : %10ld  %10ld\n",
              "ENV RCPT", sta->value[STAT_ENVTO], stb->value[STAT_ENVTO]);

    if (all || sta->value[STAT_FILES] > 0 || stb->value[STAT_FILES] > 0)
      printf ("# %-40s : %10ld  %10ld\n",
              "Attached files", sta->value[STAT_FILES], stb->value[STAT_FILES]);
    if (all || sta->value[STAT_XFILES] > 0 || stb->value[STAT_XFILES] > 0)
      printf ("# %-40s : %10ld  %10ld\n",
              "X-Files", sta->value[STAT_XFILES], stb->value[STAT_XFILES]);
    if (all || sta->value[STAT_VIRUS] > 0 || stb->value[STAT_VIRUS] > 0)
      printf ("# %-40s : %10ld  %10ld\n",
              "Virus", sta->value[STAT_VIRUS], stb->value[STAT_VIRUS]);
    if (all || sta->value[STAT_LUSERS] > 0 || stb->value[STAT_LUSERS] > 0)
      printf ("# %-40s : %10ld  %10ld\n",
              "Reject Local Users", sta->value[STAT_LUSERS], stb->value[STAT_LUSERS]);
    if (all || sta->value[STAT_MAX_RCPT] > 0 || stb->value[STAT_MAX_RCPT] > 0)
      printf ("# %-40s : %10ld  %10ld\n",
              "Reject Exceed Max RCPT",
              sta->value[STAT_MAX_RCPT], stb->value[STAT_MAX_RCPT]);
    if (all || sta->value[STAT_THROTTLE] > 0 || stb->value[STAT_THROTTLE] > 0)
      printf ("# %-40s : %10ld  %10ld\n",
              "Reject Exceed Throttle",
              sta->value[STAT_THROTTLE], stb->value[STAT_THROTTLE]);
    if (all || sta->value[STAT_RESOLVE_FAIL] > 0 || stb->value[STAT_RESOLVE_FAIL] > 0)
      printf ("# %-40s : %10ld  %10ld\n", "Resolve FAIL",
              sta->value[STAT_RESOLVE_FAIL], stb->value[STAT_RESOLVE_FAIL]);
    if (all || sta->value[STAT_RESOLVE_FORGED] > 0
        || stb->value[STAT_RESOLVE_FORGED] > 0)
      printf ("# %-40s : %10ld  %10ld\n", "Resolve FORGED",
              sta->value[STAT_RESOLVE_FORGED], stb->value[STAT_RESOLVE_FORGED]);
    if (all || sta->value[STAT_NO_TO_HEADERS] > 0 || stb->value[STAT_NO_TO_HEADERS] > 0)
      printf ("# %-40s : %10ld  %10ld\n", "Reject No RCPT Headers",
              sta->value[STAT_NO_TO_HEADERS], stb->value[STAT_NO_TO_HEADERS]);
    if (all || sta->value[STAT_NO_FROM_HEADERS] > 0
        || stb->value[STAT_NO_FROM_HEADERS] > 0)
      printf ("# %-40s : %10ld  %10ld\n", "Reject No Senders ",
              sta->value[STAT_NO_FROM_HEADERS], stb->value[STAT_NO_FROM_HEADERS]);
    if (all || sta->value[STAT_BODY_CONTENTS] > 0 || stb->value[STAT_BODY_CONTENTS] > 0)
      printf ("# %-40s : %10ld  %10ld\n", "Reject body contents",
              sta->value[STAT_BODY_CONTENTS], stb->value[STAT_BODY_CONTENTS]);
    if (all || sta->value[STAT_SUBJECT_CONTENTS] > 0
        || stb->value[STAT_SUBJECT_CONTENTS] > 0)
      printf ("# %-40s : %10ld  %10ld\n", "Reject subject contents",
              sta->value[STAT_SUBJECT_CONTENTS], stb->value[STAT_SUBJECT_CONTENTS]);
    if (all || sta->value[STAT_HEADERS_CONTENTS] > 0
        || stb->value[STAT_HEADERS_CONTENTS] > 0)
      printf ("# %-40s : %10ld  %10ld\n", "Reject headers contents",
              sta->value[STAT_HEADERS_CONTENTS], stb->value[STAT_HEADERS_CONTENTS]);
    if (all || sta->value[STAT_BINARY] > 0 || stb->value[STAT_BINARY] > 0)
      printf ("# %-40s : %10ld  %10ld\n",
              "Reject binary encoded body",
              sta->value[STAT_BINARY], stb->value[STAT_BINARY]);
    if (all || sta->value[STAT_BASE64] > 0 || stb->value[STAT_BASE64] > 0)
      printf ("# %-40s : %10ld  %10ld\n",
              "Reject base 64 encoded body",
              sta->value[STAT_BASE64], stb->value[STAT_BASE64]);
    if (all || sta->value[STAT_QUOTED_PRINTABLE] > 0
        || stb->value[STAT_QUOTED_PRINTABLE] > 0)
      printf ("# %-40s : %10ld  %10ld\n",
              "Reject quoted printable encoded body",
              sta->value[STAT_QUOTED_PRINTABLE], stb->value[STAT_QUOTED_PRINTABLE]);
    if (all || sta->value[STAT_OUTLOOK] > 0 || stb->value[STAT_OUTLOOK] > 0)
      printf ("# %-40s : %10ld  %10ld\n",
              "Reject Outlook", sta->value[STAT_OUTLOOK], stb->value[STAT_OUTLOOK]);
  }
}

/* ****************************************************************************
 *                                                                            *
 *                                                                            *
 **************************************************************************** */
static int
dump_state (jp, jg, all, nf)
     int             jp;
     int             jg;
     int             all;
     int             nf;
{
  int             fd;
  j_stats         st;
  char           *p;
  char           *j_state_file = J_STATE_FILE;

  if (j_state_file == NULL || strlen (j_state_file) == 0) {
    printf ("undefined state file\n");
    return -1;
  }
  if ((fd = open (j_state_file, O_RDONLY)) >= 0) {
    if (read (fd, &st, sizeof (st)) == sizeof (st)) {
      char            out[256];

      close (fd);

      printf ("%-30s : %s\n", "Version", PACKAGE);

      strcpy (out, ctime (&st.last_save));
      if ((p = strchr (out, '\n')) != NULL)
        *p = '\0';
      printf ("%-30s : %s\n", "Last counters dump", out);

      if (!jp && !jg)
        dump_p_stats (&st.glob, "*** GLOBAL DATA ***\n", 'G', all);

      if (!jp && jg)
        dump_p_stats (&st.glob, "*** GLOBAL DATA ***\n", 'G', all);

      if (jp && !jg)
        dump_p_stats (&st.proc, "*** PROCESSUS DATA ***\n", 'P', all);

      if (jp && jg)
        dump_p_stats_all (&st.proc,
                          "*** PROCESSUS DATA ***",
                          &st.glob, "*** GLOBAL DATA ***", all, nf);
    } else {
      close (fd);
      printf ("Error reading %s file : %s\n", j_state_file, strerror (errno));
      return 1;
    }
  } else {
    printf ("Error opening %s file : %s\n", j_state_file, strerror (errno));
    return 1;
  }
  return 0;
}



/* ****************************************************************************
 *                                                                            *
 *                                                                            *
 **************************************************************************** */
static long
str2secs (s)
     char           *s;
{
  int             l;
  long            n;
  char            strn[16];

  if ((s == NULL) || (strlen (s) == 0))
    return 3600;

  if ((l = strspn (s, "0123456789")) == 0)
    return 3600;

  if (l >= (sizeof (strn)))
    return 3600;

  memset (strn, 0, sizeof (strn));
  strncpy (strn, s, l);

#if HAVE_STRTOL
  n = strtol (strn, (char **) NULL, 10);
  if (errno == ERANGE || errno == EINVAL || n <= 0)
    n = 3600;
#else
  n = atoi (strn);
  if (n <= 0 | n > 32)
    n = 3600;
#endif
  s += l;

  if (strlen (s) == 0)
    return n;

  switch (*s) {
    case 's':
    case 'S':
      return n;
      break;
    case 'm':
    case 'M':
      return 60 * n;
      break;
    case 'h':
    case 'H':
      return 3600 * n;
      break;
    case 'd':
    case 'D':
      return 86400 * n;
      break;
  }
  return 3600;
}

/* ****************************************************************************
 *                                                                            *
 *                                                                            *
 **************************************************************************** */
int
main (int argc, char **argv)
{
  const char     *args = "hpgatrdcnvql:";
  int             c;
  int             jp = 0, jg = 0;
  int             jt = 0, jr = 0;
  int             jq = 0;

  int             verbose = 0;
  int             hostnames = 0;
  int             histogram = TRUE;
  int             newformat = FALSE;

  char            host[256];

  long            dt = 3600;

  log_level = 20;
  memset (host, 0, sizeof (host));

  while ((c = getopt (argc, argv, args)) != -1) {
    switch (c) {
      case 'h':
        usage ();
        exit (0);
        break;
      case 'p':
        jp = 1;
        jg = 0;
        break;
      case 'g':
        jp = 0;
        jg = 1;
        break;
      case 'a':
        jp = jg = 1;
        break;
      case 't':
        jt++;
        break;
      case 'r':
        jr++;
        break;
      case 'c':
        histogram = FALSE;
        break;
      case 'd':
        hostnames = TRUE;
        break;
      case 'v':
        verbose = 1;
        break;
      case 'n':
        newformat = TRUE;
        break;
      case 'q':
        jq = 1;
        break;
      case 'l':
        dt = str2secs (optarg);
        break;
      default:
        printf ("Error ... \n");
        exit (0);
    }
  }
  if (optind < argc && strlen (argv[optind]) > 0)
    snprintf (host, sizeof (host), "%s", argv[optind]);

  if ((jr > 0 && jt > 0) || ((jp > 0 || jg > 0) && (jr > 0 || jt > 0))) {
    usage ();
    exit (1);
  }

  if (jp > 0 || jg > 0)
    if (dump_state (jp, jg, verbose, newformat) > 0)
      printf ("ERROR\n");
  if (jt > 0) {
    throttle_read_table (NULL);
    throttle_update_table (21600);
    throttle_print_table (jt - 1, verbose, hostnames);
  }

  if (jr > 0) {
    resolve_tab_read (NULL);
    resolve_tab_update (FALSE);
    resolve_tab_print (jr - 1, verbose, histogram, hostnames);
  }

  if (jq > 0) {
    char           *p = NULL, *name = NULL;
    char            ip[256];

    *ip = '\0';
    if (strlen (host) > 0) {
      if (j_gethostbyname (host, ip, sizeof (ip))) {
        name = host;
        p = ip;
      } else
        p = host;
    }

    printf ("%-30s : %s\n", "Version", PACKAGE);

    (void) raw_history_open (TRUE);
    res_history_update (NULL, p, 0, dt);

    res_history_print (NULL, p, NULL, verbose, hostnames);
    (void) raw_history_close ();
  }

  if (!(jp || jt || jg || jr || jq))
    usage ();

  return 0;
}

/* ****************************************************************************
 *                                                                            *
 *                                                                            *
 **************************************************************************** */
void
usage ()
{
  printf ("Usage : j-printstats options\n");
  printf ("    j-printstats -a | -p | -g\n");
  printf ("        -p  : print running process j-chkmail counters\n");
  printf ("        -g  : print j-chkmail counters from last reset\n");
  printf ("        -a  : print both counters\n");
  printf ("    j-printstats -t[td]\n");
  printf ("        -t  : throttle data (summary)\n");
  printf ("        -tt : throttle data (detail)\n");
  printf ("        -d  : resolve IP addresses\n");
  printf ("    j-printstats -r[rdc]\n");
  printf ("        -r  : dns resolve data (summary)\n");
  printf ("        -rr : dns resolve data (detail)\n");
  printf ("        -d  : resolve IP addresses\n");
  printf ("        -c  : data presented in cumulative mode (default : histogram)\n");
  printf ("    j-printstats -q [ -l dt [ s | m | h | d ] ] [ -v | ip | hostname ]\n");
  printf ("        -q  : query gateway activity\n");
  printf ("        -l  : period of interest - default unit : secs\n");
  printf ("        -v  : verbose - meaninful only if gateway not specified\n");
  printf ("              prints summary for each client gateway\n");

  printf ("\n%s - Copyright Ecole des Mines de Paris - (C) 2002\n", PACKAGE);
  printf ("  Compiled on %s %s\n\n", __DATE__, __TIME__);
}
