/*
 *
 * j-chkmail - filtre de messagerie pour sendmail - MILTER
 *
 * Copyright (c) 2001, 2002 Ecole des Mines de Paris
 *
 *  Auteur     : Jose Marcio Martins da Cruz
 *               martins@paris.ensmp.fr
 *
 *  Historique :
 *  Creation     : janvier 2002
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include <j-sys.h>

#include "j-chkmail.h"



static void         usage ();

static int          print_rec (void *k, void *v);

int
main (argc, argv)
     int                 argc;
     char              **argv;
{
  const char         *args = "h123b:rivdf";
  int                 c;

  int                 verbose = 0;
  int                 r;

  char               *dbname = NULL;
  int                 dbtype = 2;
  int                 dbreverse = FALSE;

  int                 dbdump = FALSE;

  void               *dbh;

  int                 dbtext = FALSE;

  while ((c = getopt (argc, argv, args)) != -1) {
    switch (c) {
      case 'f':
        dbtext = TRUE;
        break;
      case 'h':
        usage ();
        exit (0);
        break;
      case '1':
        dbtype = 1;
        break;
      case '2':
        dbtype = 2;
        break;
      case 'b':
        if (optarg == NULL || *optarg == '\0') {
          fprintf (stderr, "Error %s\n", optarg ? optarg : "");
          exit (1);
        }
        if (dbname != NULL) {
          fprintf (stderr, "Error : only one -b option allowed\n");
          exit (1);
        }
        if ((dbname = strdup (optarg)) == NULL) {
          fprintf (stderr, "FATAL ERROR - memory allocation dbname\n");
          exit (1);
        }
        break;
      case 'r':
        dbreverse = TRUE;
        break;
      case 'v':
        verbose = 1;
        break;
      case 'd':
        dbdump = TRUE;
        break;
      default:
        fprintf (stderr, "invalid option\n");
        exit (1);
    }
  }

  if (dbtext) {
    j_rd_text_file (NULL, dbtype, dbreverse, NULL);
    exit (0);
  }

  if (dbname == NULL) {
    fprintf (stderr, "Missing -b option\n");
    exit (1);
  }

  if (*dbname == '-') {
    fprintf (stderr, "dbname not valid : %s\n", dbname);
    exit (1);
  }

  if (dbdump) {
    if ((dbh = j_db_open (dbname)) != NULL) {
      int                 nb;

      j_db_walk (dbh, print_rec);
      nb = j_db_count (dbh);
      printf (" -> %d enregistrements\n", nb);
      j_db_close (dbh);
    }
    exit (0);
  }

  r = j_db_create (NULL, dbname, dbtype, dbreverse);


  return 0;
}


/* ****************************************************************************
 *                                                                            *
 *                                                                            *
 **************************************************************************** */
static void
usage ()
{
  printf ("Usage : j-makemap options\n");
  printf ("  %s\n", PACKAGE);
  printf ("  Compiled on %s %s\n", __DATE__, __TIME__);
  printf ("        -b table : specifies table name\n");
  printf ("        -1       : single column (key only)\n");
  printf ("        -2       : two columns (key / value)\n");
  printf ("        -h       : help (print this and exits)\n");
  printf ("        -v       : verbose\n");
  printf ("\n%s - Copyright Ecole des Mines de Paris - (C) 2002\n\n",
          PACKAGE);
}


int
print_rec (k, v)
     void               *k;
     void               *v;
{
  if (k == NULL)
    return -1;
  if (v == NULL)
    v = (void *) "";

  printf ("%-40s -> %s\n", (char *) k, (char *) v);
  return 0;
}
