/*
 *
 * j-chkmail - filtre de messagerie pour sendmail - MILTER
 *
 * Copyright (c) 2001, 2002 Ecole des Mines de Paris
 *
 *  Auteur     : Jose Marcio Martins da Cruz
 *               martins@paris.ensmp.fr
 *
 *  Historique :
 *  Creation     : janvier 2002
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include <j-sys.h>

#include "j-chkmail.h"
#include "j-log.h"

int             j_output = J_SYSLOG;

/* ****************************************************************************
 *                                                                            * 
 *                                                                            *
 **************************************************************************** */
void
j_print_msg (out, priority, msg)
     int             out;
     int             priority;
     char           *msg;
{
  if (msg == NULL)
    return;
  if (out == J_SYSLOG || out == J_OUT_ALL) {
    syslog (priority, "%s", msg);
  }
  if (out == J_STDOUT || out == J_OUT_ALL) {
    printf ("%s\n", msg);
  }
}

/* ****************************************************************************
 *                                                                            * 
 *                                                                            *
 **************************************************************************** */
void
j_print_msg_sys (out, priority, msg)
     int             out;
     int             priority;
     char           *msg;
{
  char           *p;

  if (msg == NULL)
    return;

  p = errno != 0 ? strerror (errno) : "";
  if (out == J_SYSLOG || out == J_OUT_ALL) {
    syslog (priority, "%s : %s", msg, p);
  }
  if (out == J_STDOUT || out == J_OUT_ALL) {
    printf ("%s : %s\n", msg, p);
  }
}


/* ****************************************************************************
 *                                                                            * 
 *                                                                            *
 **************************************************************************** */
void
j_log_files (id, files)
     unsigned long   id;
     attachment     *files;
{
  FILE           *flog;
  attachment     *p;
  time_t          t = time (NULL);

  char           *xfiles_log = cf_get_str (CF_XFILES_LOG_FILE);

  if (xfiles_log == NULL || strlen (xfiles_log) == 0)
    return;

  if (strcasecmp (xfiles_log, "NONE") == 0)
    return;

  if ((flog = fopen (xfiles_log, "a")) != NULL) {
    p = files;
    while (p) {
      char           *serror;

      if (p->name == NULL || strlen (p->name) == 0)
        continue;

      switch (p->exefile) {
        case 0:
          serror = "---";
          break;
        case 1:
          serror = "XXX";
          break;
        default:
          serror = "???";
      }
      fprintf (flog, "%10ld %08lX %s %s %s\n",
               (long) t, id, serror,
               p->mimetype ? p->mimetype : "mime-unknown", p->name);
      p = p->next;
    }

    fclose (flog);
    if (chmod (xfiles_log, S_IRUSR | S_IWUSR | S_IRGRP | S_IROTH) != 0) {
      syslog (LOG_ERR, "%s : error changing xfiles file mode %s",
              J_FUNCTION, strerror (errno));
    }
  } else {
    char            logbuf[1024];

    snprintf (logbuf, sizeof (logbuf), "Error opening %s file", xfiles_log);
    j_print_msg_sys (j_output, LOG_ERR, logbuf);
  }
}

/* ****************************************************************************
 *                                                                            * 
 *                                                                            *
 **************************************************************************** */
void
j_syslog (conn_id, why, peer_addr, peer_name, envfrom, envto, from, mailer)
     time_t          conn_id;
     char           *why;
     char           *peer_addr;
     char           *peer_name;
     char           *envfrom;
     char           *envto;
     char           *from;
     char           *mailer;
{
  syslog (LOG_INFO, "%08lX : %s", (long) conn_id, why ? why : "UNKNOWN REASON");
  if (peer_addr != NULL && strlen (peer_addr) > 0)
    syslog (LOG_INFO, "  PEER ADDR %s", peer_addr);
  if (peer_name != NULL && strlen (peer_name) > 0)
    syslog (LOG_INFO, "  PEER NAME %s", peer_name);
  if (envfrom != NULL && strlen (envfrom) > 0)
    syslog (LOG_INFO, "  ENV FROM  %s", envfrom);
  if (envto != NULL && strlen (envto) > 0)
    syslog (LOG_INFO, "  ENV TO    %s", envto);
  if (from != NULL && strlen (from) > 0)
    syslog (LOG_INFO, "  FROM      %s", from);
  if (mailer != NULL && strlen (mailer) > 0)
    syslog (LOG_INFO, "  MAILER    %s", mailer);
}

/* ****************************************************************************
 *                                                                            *
 *                                                                            *
 **************************************************************************** */
void
log_sock_addr (addr)
     struct sockaddr_in *addr;
{
  char            s[256];

  if (log_level >= 20) {
    if (j_inet_ntop (&addr->sin_addr, s, sizeof (s)) == NULL) {
      strcpy (s, "NULL");
    }
    syslog (LOG_DEBUG, "addr = %s, port = %d, family = %d\n",
            s, ntohs (addr->sin_port), addr->sin_family);
  }
}



/* ****************************************************************************
 *                                                                            * 
 *                                                                            *
 **************************************************************************** */
#ifndef SYSLOG_NAMES

typedef struct _code {
  char           *c_name;
  int             c_val;
} CODE;

static CODE     prioritynames[] = {
  {"alert", LOG_ALERT},
  {"crit", LOG_CRIT},
  {"debug", LOG_DEBUG},
  {"emerg", LOG_EMERG},
  {"err", LOG_ERR},
  {"error", LOG_ERR},           /* DEPRECATED */
  {"info", LOG_INFO},
  {"notice", LOG_NOTICE},
  {"panic", LOG_EMERG},         /* DEPRECATED */
  {"warn", LOG_WARNING},        /* DEPRECATED */
  {"warning", LOG_WARNING},
  {NULL, -1}
};



static CODE     facilitynames[] = {
  {"auth", LOG_AUTH},
  {"cron", LOG_CRON},
  {"daemon", LOG_DAEMON},
  {"kern", LOG_KERN},
  {"lpr", LOG_LPR},
  {"mail", LOG_MAIL},
  {"news", LOG_NEWS},
  {"security", LOG_AUTH},       /* DEPRECATED */
  {"syslog", LOG_SYSLOG},
  {"user", LOG_USER},
  {"uucp", LOG_UUCP},
  {"local0", LOG_LOCAL0},
  {"local1", LOG_LOCAL1},
  {"local2", LOG_LOCAL2},
  {"local3", LOG_LOCAL3},
  {"local4", LOG_LOCAL4},
  {"local5", LOG_LOCAL5},
  {"local6", LOG_LOCAL6},
  {"local7", LOG_LOCAL7},
  {NULL, -1}
};

#endif

int
set_log_facility (ps)
     char           *ps;
{
  CODE           *p = facilitynames;

  while (p->c_name && strcasecmp (p->c_name, ps))
    p++;

  if (p->c_name) {
    log_facility = p->c_val;
    return 0;
  }
  return 1;
}

char           *
facility_name (facility)
     int             facility;
{
  CODE           *p = facilitynames;

  while (p->c_name && p->c_val != facility)
    p++;
  return (p->c_name ? p->c_name : "");
}

int
facility_value (ps)
     char           *ps;
{
  CODE           *p = facilitynames;

  if (ps == NULL)
    return -1;
  while (p->c_name && strcasecmp (p->c_name, ps))
    p++;

  if (p->c_name) {
    return p->c_val;
  }
  return -1;
}

/* ****************************************************************************
 *                                                                            * 
 *                                                                            *
 **************************************************************************** */
int
log_priority (ps)
     char           *ps;
{
  CODE           *p = prioritynames;

  while (p->c_name) {
    if (strcmp (p->c_name, ps) == 0)
      return p->c_val;
    p++;
  }
  return LOG_DEBUG;
}
