/*
 *
 * j-chkmail - filtre de messagerie pour sendmail - MILTER
 *
 * Copyright (c) 2001, 2002 Ecole des Mines de Paris
 *
 *  Auteur     : Jose Marcio Martins da Cruz
 *               martins@paris.ensmp.fr
 *
 *  Historique :
 *  Creation     : janvier 2002
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include <j-sys.h>

#include "j-chkmail.h"

#define USE_SOCKETPAIR    1

#if (USE_SOCKETPAIR == 1) && !defined (HAVE_SOCKETPAIR)
#define USE_SOCKETPAIR    0
#endif

/* ****************************************************************************
 *                                                                            *
 *                                                                            *
 **************************************************************************** */
int
open_channel (p)
     int                 p[2];
{
#if USE_SOCKETPAIR == 1
  return (socketpair (AF_UNIX, SOCK_STREAM, 0, p));
#else
  return (pipe (p));
#endif
}

/* ****************************************************************************
 *                                                                            *
 *                                                                            *
 **************************************************************************** */
int
send_msg_channel (p, msg, who)
     int                 p[2];
     int                 msg;
     int                 who;
{
  int                 val;
  int                 chan;

  chan = (who == CHAN_FATHER ? 1 : 0);

  if ((val = fcntl (p[chan], F_GETFL, 0)) < 0) {
    syslog (LOG_WARNING, "%s : can't get pipe status : %s", J_FUNCTION,
            strerror (errno));
    return 1;
  }
  val &= O_ACCMODE;
  if (val != O_WRONLY && val != O_RDWR) {
    syslog (LOG_WARNING, "%s : pipe closed ?", J_FUNCTION);
    return 1;
  }

  if (write (p[chan], &msg, sizeof (msg)) != sizeof (msg)) {
    if (errno == EPIPE || log_level > 20)
      syslog (LOG_WARNING, "%s : write %d -> pipe : %s", J_FUNCTION, msg,
              strerror (errno));
    return 1;
  }
  return 0;
}

/* ****************************************************************************
 *                                                                            *
 *                                                                            *
 **************************************************************************** */
int
recv_msg_channel (p, msg, who)
     int                 p[2];
     int                *msg;
     int                 who;
{
  int                 val;
  int                 chan;

  chan = (who == CHAN_FATHER ? 1 : 0);

  if ((val = fcntl (p[chan], F_GETFL, 0)) < 0) {
    syslog (LOG_WARNING, "%s : can't get pipe status : %s", J_FUNCTION,
            strerror (errno));
    return 1;
  }
  val &= O_ACCMODE;
  if (val != O_RDONLY && val != O_RDWR) {
    syslog (LOG_WARNING, "%s : pipe closed ?", J_FUNCTION);
    return 1;
  }

  if (read (p[chan], msg, sizeof (*msg)) != sizeof (*msg)) {
    if (log_level > 20)
      syslog (LOG_WARNING, "%s : read <- pipe : %s", J_FUNCTION,
              strerror (errno));
    return 1;
  }
  return 0;
}
