/*
 *
 * j-chkmail - filtre de messagerie pour sendmail - MILTER
 *
 * Copyright (c) 2001, 2002 Ecole des Mines de Paris
 *
 *  Auteur     : Jose Marcio Martins da Cruz
 *               martins@paris.ensmp.fr
 *
 *  Historique :
 *  Creation     : janvier 2002
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include <j-sys.h>

#include "j-fileexp.h"

#define SZ_BLOCK    32

#ifndef FALSE
#define FALSE 0
#endif
#ifndef TRUE
#define TRUE 1
#endif


int                 debug = 0;

/* ****************************************************************************
 *                                                                            * 
 *                                                                            *
 **************************************************************************** */

fext_rec           *j_fext = NULL;
int                 sz_fext = 0;
int                 nb_fext = 0;


/* ************************************
 *                                    * 
 *                                    *
 ************************************ */
static int
realloc_fext ()
{
  int                 x_sz_fext = sz_fext + SZ_BLOCK;
  fext_rec           *x_jfext;
  int                 i;

  if ((x_jfext = realloc (j_fext, x_sz_fext * sizeof (fext_rec)))) {
    sz_fext = x_sz_fext;
    j_fext = x_jfext;
    for (i = nb_fext; i < sz_fext; i++)
      memset (j_fext + i, 0, sizeof (fext_rec));
  } else
    return 1;
  return 0;
}

/* ************************************
 *                                    * 
 *                                    *
 ************************************ */
int
free_fext ()
{
  int                 i;

  for (i = 0; i < nb_fext; i++) {
    if (j_fext[i].reg_ok)
      regfree (&j_fext[i].re);
    j_fext[i].reg_ok = 0;
  }
  free (j_fext);
  j_fext = NULL;
  sz_fext = nb_fext = 0;

  return 0;
}

/* ************************************
 *                                    * 
 *                                    *
 ************************************ */
int
add_fext (str)
     char               *str;
{
  if (nb_fext == sz_fext && realloc_fext ()) {
    return FALSE;
  }
  strcpy (j_fext[nb_fext].expr, str);
  nb_fext++;
  return TRUE;
}

/* ****************************************************************************
 *                                                                            * 
 *                                                                            *
 **************************************************************************** */

fregex_rec         *j_fregex = NULL;
int                 sz_fregex = 0;
int                 nb_fregex = 0;


/* ************************************
 *                                    * 
 *                                    *
 ************************************ */
static int
realloc_fregex ()
{
  int                 x_sz_fregex = sz_fregex + SZ_BLOCK;
  fregex_rec         *x_jfregex;
  int                 i;

  if ((x_jfregex = realloc (j_fregex, x_sz_fregex * sizeof (fregex_rec)))) {
    sz_fregex = x_sz_fregex;
    j_fregex = x_jfregex;
    for (i = nb_fregex; i < sz_fregex; i++)
      memset (j_fregex + i, 0, sizeof (fregex_rec));
  } else
    return 1;
  return 0;
}

/* ************************************
 *                                    * 
 *                                    *
 ************************************ */
int
free_fregex ()
{
  int                 i;

  for (i = 0; i < nb_fregex; i++) {
    if (j_fregex[i].reg_ok)
      regfree (&j_fregex[i].re);
    j_fregex[i].reg_ok = 0;
  }
  free (j_fregex);
  j_fregex = NULL;
  sz_fregex = nb_fregex = 0;

  return 0;
}

/* ************************************
 *                                    * 
 *                                    *
 ************************************ */
int
add_fregex (str)
     char               *str;
{
  if (nb_fregex == sz_fregex && realloc_fregex ()) {
    return FALSE;
  }
  strcpy (j_fregex[nb_fregex].expr, str);
  nb_fregex++;
  return TRUE;
}

/* ****************************************************************************
 *                                                                            * 
 *                                                                            *
 **************************************************************************** */
char               *J_FILE_EXT = NULL;

static char        *extensions[] = { "exe", "bat", "pif", "scr", "sct", "com",
  "cmd", "lnk", "vb", "vbs", "vbe", "je",
  "js", "jse", "msi", "msp", "reg", "bas",
  "bin", "btm", "dll", "drv", "inf", "ini",
  "shb", "shs", "sys", "vxd", "ade", "adp",
  "chm", "cpl", "crt", "hlp", "hta", "ins",
  "isp", "mdb", "mde", "msc", "mst", "pcd",
  "url", "wsc", "wsf", "wsh", NULL
};

static char       **sorted_ext = NULL;

char               *J_DEFAULT_EXT = NULL;

/* ************************************
 *                                    * 
 *                                    *
 ************************************ */
int
sort_extensions (const void *a, const void *b)
{
  char               *p, *q;

  p = *((char **) a);
  q = *((char **) b);
  return strcmp (p, q);
}

void
init_default_file_extensions ()
{
  char              **p = extensions;
  char                sin[2048], sout[2048];

  char              **s = NULL;

  if (sorted_ext == NULL && (s = malloc (sizeof (extensions))) != NULL) {
    int                 i = 0;

    while ((s[i] = extensions[i]) != NULL)
      i++;
    s[i] = NULL;
    qsort (s, i, sizeof (*s), sort_extensions);
    sorted_ext = s;
    p = s;
  }

  if (*p) {
    strcpy (sin, *p);
    while (*++p) {
      sprintf (sin, "%s|%s", sin, *p);
    }
  }
  sprintf (sout, "[.](%s)$", sin);
  if (J_DEFAULT_EXT)
    free (J_DEFAULT_EXT);
  J_DEFAULT_EXT = strdup (sout);
}

/* ************************************
 *                                    * 
 *                                    *
 ************************************ */
void
init_file_extension_regex ()
{
  char                sin[2048], sout[2048];
  int                 i;

  if (J_DEFAULT_EXT == NULL)
    init_default_file_extensions ();

  if (J_FILE_EXT && J_FILE_EXT != J_DEFAULT_EXT) {
    free (J_FILE_EXT);
    J_FILE_EXT = NULL;
  }

  if (nb_fext == 0) {
    char              **p = sorted_ext;

    for (p = sorted_ext; *p != NULL; p++)
      add_fext (*p);
  }

  if (nb_fext > 0) {
    memset (sin, 0, sizeof (sin));
    for (i = 0; i < nb_fext; i++) {
      if (*sin)
        sprintf (sin, "%s|%s", sin, j_fext[i].expr);
      else
        sprintf (sin, "%s", j_fext[i].expr);
    }
    sprintf (sout, "[.](%s)$", sin);
    J_FILE_EXT = strdup (sout);
    if (debug) {
      syslog (LOG_WARNING, " nb_fext = %d", nb_fext);
      syslog (LOG_WARNING, " EXTENSIONS = %s", J_FILE_EXT);
    }
  } else {
    J_FILE_EXT = J_DEFAULT_EXT;
  }
}


/* ************************************
 *                                    *
 *                                    *
 ************************************ */
void
list_filename_extensions ()
{
  int                 i;
  char                line[128];
  char                temp[32];

  if (nb_fext > 0) {
    strcpy (line, "");
    for (i = 0; i < nb_fext; i++) {
      snprintf (temp, sizeof (temp), "%-5s ", j_fext[i].expr);
      strcat (line, temp);
      if (strlen (line) + 16 > 64) {
        printf ("    -  EXT : %s\n", line);
        strcpy (line, "");
      }
    }
    if (strlen (line) > 0)
      printf ("    -  EXT : %s\n", line);
  } else {
    char              **p = extensions;

    strcpy (line, "");
    for (p = extensions; *p != NULL; p++) {
      snprintf (temp, sizeof (temp), "%-5s ", *p);
      strcat (line, temp);
      if (strlen (line) + 16 > 64) {
        printf ("    -  EXT : %s\n", line);
        strcpy (line, "");
      }
    }
    if (strlen (line) > 0)
      printf ("    -  EXT : %s\n", line);
  }
}

/* ****************************************************************************
 *                                                                            * 
 *                                                                            *
 **************************************************************************** */
int
check_filename_regex (fname)
     char               *fname;
{
  int                 i;
  int                 res = 0;

  for (i = 0; i < nb_fregex; i++) {
    if (!j_fregex[i].reg_ok)
      j_fregex[i].reg_ok =
        !regcomp (&j_fregex[i].re, j_fregex[i].expr,
                  REG_ICASE | REG_EXTENDED);
    res =
      !regexec (&j_fregex[i].re, fname, (size_t) 0, NULL,
                REG_NOTBOL | REG_NOTEOL);
    regfree (&j_fregex[i].re);
    j_fregex[i].reg_ok = 0;
    if (res)
      return 1;
  }
  return 0;
}

/* ************************************
 *                                    * 
 *                                    *
 ************************************ */
int
check_filename_extension (fname)
     char               *fname;
{
  regex_t             re;
  int                 res = 0;

  if (!regcomp (&re, J_FILE_EXT, REG_ICASE | REG_EXTENDED)) {
    res = !regexec (&re, fname, (size_t) 0, NULL, 0);
    regfree (&re);
  } else
    return -1;

  if (debug)
    syslog (LOG_WARNING, " %-20s -> %d (%s)", fname, res, J_FILE_EXT);
  return res;
}


/* ************************************
 *                                    * 
 *                                    *
 ************************************ */
int
check_filename (fname)
     char               *fname;
{
  if (!fname || strlen (fname) == 0)
    return -1;
  return check_filename_extension (fname) || check_filename_regex (fname);
}
