/*
 *
 * j-chkmail - filtre de messagerie pour sendmail - MILTER
 *
 * Copyright (c) 2001, 2002 Ecole des Mines de Paris
 *
 *  Auteur     : Jose Marcio Martins da Cruz
 *               martins@paris.ensmp.fr
 *
 *  Historique :
 *  Creation     : janvier 2002
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include <j-sys.h>

#include "j-divers.h"


/* ****************************************************************************
 *                                                                            * 
 *                                                                            *
 **************************************************************************** */
char               *
jstrdup (s)
     char               *s;
{
  char               *p;

  if (s == NULL)
    return NULL;

  p = malloc (strlen (s) + 1);

  if (p != NULL)
    strcpy (p, s);
  return p;
}

/* ****************************************************************************
 *                                                                            * 
 *                                                                            *
 **************************************************************************** */
void
strlower (char *s)
{
  if (s == NULL)
    return;
  for (; *s; s++)
    *s = tolower (*s);
}

/* ****************************************************************************
 *                                                                            * 
 *                                                                            *
 **************************************************************************** */
void
strset (dst, c, len)
     char               *dst;
     int                 c;
     int                 len;
{
  memset (dst, (int) c, len);
  dst[len] = '\0';
}

/* ****************************************************************************
 *                                                                            * 
 *                                                                            *
 **************************************************************************** */
void
strchknull (s, len)
     char               *s;
     int                 len;
{
  char               *p = s;

  if (s == NULL)
    return;

  while (len-- > 0) {
    if (*p == '\0')
      *p = ' ';
    p++;
  }
}

/* ****************************************************************************
 *                                                                            * 
 *                                                                            *
 **************************************************************************** */
int
string_has_tag (str, tag)
     char               *str;
     char               *tag;
{
  char               *t;
  int                 res = 0;

  if (str == NULL || tag == NULL)
    return res;

  if ((t = strdup (str)) != NULL) {
    strlower (t);
    res = strstr (t, tag) != NULL;
    free (t);
  }
  return res;
}

/* ****************************************************************************
 *                                                                            * 
 *                                                                            *
 **************************************************************************** */
void
center_string (dst, org, len)
     char               *dst;
     char               *org;
     int                 len;
{
  int                 i;
  char               *p;

  memset (dst, 0, len);
  i = (len - strlen (org)) / 2;
  for (p = dst; i > 0; i--)
    *p++ = ' ';
  strcat (dst, org);
}

/* ****************************************************************************
 *                                                                            * 
 *                                                                            *
 **************************************************************************** */
int
nb_valid_pointer (a, b, c)
     char               *a;
     char               *b;
     char               *c;
{
  int                 r = 0;

  if (a)
    r++;
  if (b)
    r++;
  if (c)
    r++;
  return r;
}

/* ****************************************************************************
 *                                                                            * 
 *                                                                            *
 **************************************************************************** */

void
split_args (in, out)
     char               *in;
     char               *out[];
{
  char               *p = in;
  int                 i = 0, n;

  while (*p) {
    if ((n = strcspn (p, " \t\n")) > 0) {
      out[i++] = p;
      p += n;
      *p++ = '\0';
    }
    p += strspn (p, " \t\n");
  }
  out[i] = NULL;
}

/* ****************************************************************************
 *                                                                            * 
 *                                                                            *
 **************************************************************************** */
char               *
j_basename (out, in)
     char               *out;
     char               *in;
{
  char               *p, *t;

  if (in == NULL || out == NULL)
    return NULL;

  if ((t = strdup (in)) == NULL)
    return NULL;

  if ((p = strrchr (t, '/')) != NULL && *(p + 1) == '\0')
    *p = '\0';

  if ((p = strrchr (t, '/')) != NULL) {
    p++;
  } else
    p = t;

  strcpy (out, p);
  free (t);
  return out;
}
