/*
 *
 * j-chkmail - filtre de messagerie pour sendmail - MILTER
 *
 * Copyright (c) 2001, 2002 Ecole des Mines de Paris
 *
 *  Auteur     : Jose Marcio Martins da Cruz
 *               martins@paris.ensmp.fr
 *
 *  Historique :
 *  Creation     : janvier 2002
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include <j-sys.h>

#include "j-decode.h"

static int          htoi (int);
static char        *def_ext_attr_chars ();
static char        *def_attr_chars ();

/* ****************************************************************************
 *                                                                            * 
 *                                                                            *
 **************************************************************************** */
int
is_rfc2047_encoded (s)
     char               *s;
{
  return is_rfc1521_encoded (s);
}

/* ****************************************************************************
 *                                                                            * 
 *                                                                            *
 **************************************************************************** */
int
decode_rfc2047 (out, in)
     char               *out;
     char               *in;
{
  return decode_rfc1521 (out, in);
}

/* ****************************************************************************
 *                                                                            * 
 *                                                                            *
 **************************************************************************** */
int
is_rfc1521_encoded (s)
     char               *s;
{
  regex_t             re;
  int                 res = 0;

  if (!regcomp (&re, "=[?].*[?][qQbB][?].*[?]=", REG_ICASE | REG_EXTENDED)) {
    res = !regexec (&re, s, (size_t) 0, NULL, REG_NOTBOL | REG_NOTEOL);
    regfree (&re);
  }
  return res;
}

/* ****************************************************************************
 *                                                                            * 
 *                                                                            *
 **************************************************************************** */
int
decode_rfc1521 (out, in)
     char               *out;
     char               *in;
{
  char               *q = out, *p = in, *pi = in;

  if (!is_rfc1521_encoded (in)) {
    strcpy (out, in);
    return 0;
  }

  memset (q, 0, strlen (pi));
  while (*pi && *pi != '=' && pi[1] != '?')
    *q++ = *pi++;
  *q = '\0';
  if ((p = strstr (pi, "=?")) != NULL) {
    int                 qp = 0;
    int                 b64 = 0;

    p = strstr (pi, "?Q?");
    if (p == NULL)
      p = strstr (pi, "?q?");
    if (p)
      qp = 1;
    if (p == NULL) {
      p = strstr (pi, "?B?");
      if (p == NULL)
        p = strstr (pi, "?b?");
      if (p)
        b64 = 1;
    }

    if (qp) {
      int                 ok = 0;

      p += strlen ("?Q?");
      while (*p && !ok) {
        switch (*p) {
          case '=':
            if ((strlen (p) > 2) &&
                isxdigit ((int) p[1]) && isxdigit ((int) p[2])) {
              *q++ = 16 * htoi (p[1]) + htoi (p[2]);
              p += 3;
            } else {
              *q++ = *p;
              p++;
            }
            break;
          case '?':
            p++;
            if (*p == '=') {
              ok = 1;
              p++;
            }
            break;
          default:
            *q++ = *p++;
        }
      }
      *q = '\0';
    }
    if (b64) {
      p += strlen ("?b?");
      /* JOE - a faire - base 64 */
    }
    if (!b64 && !qp) {
      p = pi;
    }
    *q = '\0';
  } else
    p = pi;
  strcpy ((char *) q, (char *) p);
  return 0;
}

/* ****************************************************************************
 *                                                                            * 
 *                                                                            *
 **************************************************************************** */
int
is_rfc2231_encoded (s)
     char               *s;
{
  regex_t             re;
  int                 res = 0;

  char               *attr_chars = def_attr_chars ();
  char               *ext_attr_chars = def_ext_attr_chars ();
  char                rexp[256];

  if (attr_chars != NULL && ext_attr_chars != NULL) {
    sprintf (rexp, "[%s]*'.*'[%s]*", attr_chars, ext_attr_chars);

    if (!regcomp (&re, rexp, REG_ICASE | REG_EXTENDED)) {
      res = !regexec (&re, s, (size_t) 0, NULL, REG_NOTBOL | REG_NOTEOL);
      regfree (&re);
    }
  }
  return res;
}

/* ****************************************************************************
 *                                                                            * 
 *                                                                            *
 **************************************************************************** */
int
decode_rfc2231 (out, in)
     char               *out;
     char               *in;
{
  char               *q = out, *p = in, *pi = in;

  if (!is_rfc2231_encoded (in)) {
    strcpy (out, in);
    return 0;
  }

  memset (q, 0, strlen (pi));
  if ((p = strchr (pi, '\'')) == NULL)
    return 0;
  pi = ++p;
  if ((p = strchr (pi, '\'')) == NULL)
    return 0;

  p++;
  while (*p) {
    switch (*p) {
      case '%':
        if ((strlen (p) >= 2) &&
            isxdigit ((int) p[1]) && isxdigit ((int) p[2])) {
          *q++ = 16 * htoi (p[1]) + htoi (p[2]);
          p += 3;
        } else
          p++;
        break;
      default:
        *q++ = *p++;
    }
  }
  *q = '\0';
  return 1;
}

/* ****************************************************************************
 *                                                                            * 
 *                                                                            *
 **************************************************************************** */

static char        *
def_attr_chars ()
{
  static char        *chars = NULL;
  static char        *p;

  if (chars == NULL) {
    int                 c;

    if ((chars = malloc (256)) == NULL)
      return "ERROR";
    memset (chars, 0, 256);
    for (p = chars, c = 0x20; c < 0x7F; c++) {
      if (strchr (" *'%", c) == NULL && strchr (TSPECIALS, c) == NULL)
        *p++ = c;
    }
    *p = '\0';
  }

  return chars;
}

/* ****************************************************************************
 *                                                                            * 
 *                                                                            *
 **************************************************************************** */

static char        *
def_ext_attr_chars ()
{
  static char        *chars = NULL;
  static char        *p;

  if (chars == NULL) {
    int                 c;

    if ((chars = malloc (256)) == NULL)
      return "ERROR";
    memset (chars, 0, 256);
    for (p = chars, c = 0x20; c < 0x7F; c++) {
      if (strchr (" *'", c) == NULL && strchr (TSPECIALS, c) == NULL)
        *p++ = c;
    }
    *p = '\0';
  }

  return chars;
}

/* ****************************************************************************
 *                                                                            * 
 *                                                                            *
 **************************************************************************** */

static int
htoi (c)
     int                 c;
{
  char               *HCHARS = "0123456789ABCDEF";
  char               *p;

  if ((p = strchr (HCHARS, toupper (c))) != NULL)
    return (int) (p - HCHARS);
  return 0;
}


/* ****************************************************************************
 *                                                                            * 
 *                                                                            *
 **************************************************************************** */
int
strascii (s, exa, exb)
     char               *s;
     char               *exa;
     char               *exb;
{
  int                 i;
  char                c;
  char                ascii[128];

  if (s == NULL || strlen (s) == 0)
    return 0;

  memset (ascii, 0, sizeof (ascii));
  for (i = 0, c = 0x20; c < 0x7F; c++) {
    if ((exa == NULL || strchr (exa, c) == NULL) &&
        (exb == NULL || strchr (exb, c) == NULL))
      ascii[i++] = c;
  }
  return strspn (s, ascii);
}

/* ****************************************************************************
 *                                                                            * 
 *                                                                            *
 **************************************************************************** */
#define B64 "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/"

int
isb64char (c)
     char               *c;
{
  return (strchr (B64, (int) c) ? 1 : 0);
}

char
b64index (c)
     char                c;
{
  char               *p = strchr (B64, c);

  if (p)
    return (p - B64);
  return -1;
}

static int
decode_buf64 (o, i)
     char               *o;
     char               *i;
{
  i[0] = b64index (i[0]);
  i[1] = b64index (i[1]);
  i[2] = b64index (i[2]);
  i[3] = b64index (i[3]);

  if (i[0] < 0 || i[1] < 0 || i[2] < 0 || i[3] < 0)
    return 1;

  o[0] = (i[0] << 2) | (i[1] >> 4);
  o[1] = (i[1] << 4) | (i[2] >> 2);
  o[2] = (i[2] << 6) | i[3];

  return 0;
}

int
base64_decode (out, in, nout, nin)
     char               *out;
     char               *in;
     uint32_t           *nout;
     uint32_t           *nin;
{
  char               *p = in;
  char               *q = out;
  int                 res = 0;

  char                dbuf[4];
  int                 di = 0;

  int                 done = 0;

  uint32_t            no = 0;

  if ((in == NULL) || (out == NULL))
    return 0;

  memset (dbuf, 0, sizeof (dbuf));
  *q = '\0';
  no = 1;

  while (p && *p && !done) {

    if (*p == '=') {
      while (di < 4)
        dbuf[di++] = 0;
      break;
    }

    if (strchr (" \t\r\n", *p)) {
      p++;
      continue;
    }

    if (!isb64char (*p)) {
      res = 1;
      break;
    }

    dbuf[di++] = *p;

    if (di == 4) {
      if ((nout != NULL) && (no + 3 > *nout))
        break;
      decode_buf64 (q, dbuf);
      q += 3;
      no += 3;
      *q = '\0';
      di = 0;
      memset (dbuf, 0, sizeof (dbuf));
    }

    p++;
    continue;

  }
  if ((res == 0) && (di > 0)) {
    if ((nout == NULL) || (no + 3 < *nout)) {
      decode_buf64 (q, dbuf);
      q += 3;
      no += 3;
      *q = '\0';
    }
  }
  *q = '\0';

  if (nin != NULL)
    *nin = (uint32_t ) (p - in);
  if (nout != NULL)
    *nout = (uint32_t ) (q - out);

  return res;
}
