/*
 *
 * j-chkmail - filtre de messagerie pour sendmail - MILTER
 *
 * Copyright (c) 2001, 2002 Ecole des Mines de Paris
 *
 *  Auteur     : Jose Marcio Martins da Cruz
 *               martins@paris.ensmp.fr
 *
 *  Historique :
 *  Creation     : janvier 2002
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include <j-sys.h>

#include "j-chkmail.h"


/* ****************************************************************************
 *                                                                            *
 *                                                                            *
 **************************************************************************** */


/* ********************* */

#undef USE_DBM

/*
 * Berkeley DB
 */
#if HAVE_LIBDB && HAVE_DB_H && HAVE_DBM_DB
#define USE_DBM 1

#define USE_DB 1
#define DB_DBM_HSEARCH 1
#include <db.h>

#endif

/*
 * NDBM
 */
#if HAVE_LIBNDBM && HAVE_NDBM_H && HAVE_DBM_NDBM
#define USE_DBM 1

#define USE_DB 1
#include <ndbm.h>

#endif

/*
 * GDBM
 */
#if HAVE_LIBGDBM && (HAVE_NDBM_H || HAVE_GDBM_H) && HAVE_DBM_GDBM
#define USE_DBM 1

#define USE_DB 1

#if HAVE_NDBM_H
#include <ndbm.h>
#elif HAVE_GDBM_H
#include <gdbm.h>
#endif

#endif



/******************************************************************************
 *                                                                            * 
 *                                                                            *
 **************************************************************************** */
#if USE_DBM == 1
static int          j_db_store (DBM *, char *, char *);
#endif

/* ****************************************************************************
 *                                                                            *
 *                                                                            *
 **************************************************************************** */
int
j_db_create (fname, dbname, dbtype, dbreverse)
     char               *dbname;
     char               *fname;
     int                 dbtype;
     int                 dbreverse;
{
#if USE_DBM == 1
#define BSIZE 1024
  DBM                *jdb;
  char                s[BSIZE];
  FILE               *fin = stdin;

  if ((jdb = dbm_open (dbname, O_WRONLY | O_CREAT | O_TRUNC, 0644)) == NULL) {
    printf ("dbm_open(%s) return NULL : %s\n", dbname, strerror (errno));
    return -1;
  }

  if (fname != NULL) {
    if ((fin = fopen (fname, "r")) == NULL) {
      printf ("fopen(%s) return NULL : %s\n", fname, strerror (errno));
      return -1;
    }
  }

  memset (s, 0, sizeof (s));
  while (fgets (s, BSIZE, fin) == s) {
    char               *pk = NULL, *pv = NULL;
    char               *q;

    s[BSIZE - 1] = '\0';
    if ((pk = strchr (s, '\n')) != NULL)
      *pk = '\0';

    pk = s;
    pk += strspn (pk, " \t");
    if ((strlen (pk) == 0) || (*pk == '#'))
      continue;
    q = pk + strlen (pk) - 1;
    while ((q != pk) && (*q == ' ' || *q == '\t')) {
      *q-- = '\0';
    }

    if (dbtype == 2) {
      pv = pk + strcspn (pk, " \t");
      if (*pv != '\0') {
        q = pv;
        pv += strspn (pv, " \t");
        *q = '\0';
      }
      if (dbreverse) {
        q = pv;
        pv = pk;
        pk = q;
      }
    }

    if (strlen (pk) > 0) {
      int                 res;

      if ((res = j_db_store (jdb, pk, pv)) != 0) {
        /* separate negative and positive errors */
        if (res < 0) {
          /* fatal error */
        } else {
          /* non fatal error */
        }
      }
    }
    memset (s, 0, sizeof (s));
  }

  if (fname != NULL) {
    fclose (fin);
  }

  dbm_close (jdb);

  return 0;
#else
  return -2;
#endif
}

/* ****************************************************************************
 *                                                                            *
 *                                                                            *
 **************************************************************************** */
void               *
j_db_open (dbname)
     char               *dbname;
{
#if USE_DBM == 1
  DBM                *jdb = NULL;

  if ((jdb = dbm_open (dbname, O_RDONLY, 0644)) == NULL) {
    printf ("dbm_open return NULL : %s\n", strerror (errno));
  }
  return jdb;
#else
  return NULL;
#endif
}

/* ****************************************************************************
 *                                                                            * 
 *                                                                            *
 **************************************************************************** */
void
j_db_close (dbh)
     void               *dbh;
{
#if USE_DBM == 1
  if (dbh)
    dbm_close (dbh);
#endif
}

/* ****************************************************************************
 *                                                                            * 
 *                                                                            *
 **************************************************************************** */
int
j_db_get (dbh, key, val)
     void               *dbh;
     char               *key;
     char               *val;
{
#if USE_DBM == 1
  return 0;
#else
  return -2;
#endif
}

/* ****************************************************************************
 *                                                                            * 
 *                                                                            *
 **************************************************************************** */
int
j_db_count (dbh)
     void               *dbh;
{
#if USE_DBM == 1
  int                 nb = 0;
  datum               key;

  for (key = dbm_firstkey (dbh); key.dptr != NULL; key = dbm_nextkey (dbh)) {
    nb++;
  }

  return nb;
#else
  return -2;
#endif
}

/* ****************************************************************************
 *                                                                            * 
 *                                                                            *
 **************************************************************************** */
int
j_db_walk (dbh, func)
     void               *dbh;
     int                 (*func) (void *, void *);
{
#if USE_DBM == 1
  datum               key, val;
  int                 nb = 0;

  if (dbh == NULL || func == NULL)
    return -1;

  for (key = dbm_firstkey (dbh); key.dptr != NULL; key = dbm_nextkey (dbh)) {
    char               *k, *v;

    val = dbm_fetch (dbh, key);
    k = key.dptr ? key.dptr : "";
    v = val.dptr ? val.dptr : "";
    func (k, v);
    nb++;
  }
  return nb;
#else
  return -2;
#endif
}

/* ****************************************************************************
 *                                                                            *
 *                                                                            *
 **************************************************************************** */
int
j_db_dump (dbh, func)
     void               *dbh;
     int                 (*func) (void *, void *);
{
#if USE_DBM == 1
#define BSIZE 1024
  datum               key;
  int                 nb = 0;

  for (key = dbm_firstkey (dbh); key.dptr != NULL; key = dbm_nextkey (dbh)) {
    char               *k, *v;
    datum               val;

    val = dbm_fetch (dbh, key);
    k = key.dptr ? key.dptr : "";
    v = val.dptr ? val.dptr : "";
    if (func == NULL) {
      printf ("key : %-40s - value : %s\n", k, v);
    } else {
      func (k, v);
    }
    nb++;
  }

  return nb;
#else
  return -2;
#endif
}



/******************************************************************************
 *                                                                            * 
 *                                                                            *
 **************************************************************************** */
#if USE_DBM == 1
static int
j_db_store (db, k, v)
     DBM                *db;
     char               *k;
     char               *v;
{
  datum               key;
  datum               value;

  int                 result;

  if (k == NULL || strlen (k) == 0)
    return -1;

  key.dptr = k;
  key.dsize = strlen (k) + 1;

  if (v == NULL)
    v = "";

  value.dptr = v;
  value.dsize = strlen (v) + 1;

  printf ("- k = %-40s v = %s\n", k, v);

  if ((result = dbm_store (db, key, value, DBM_REPLACE)) < 0) {
    printf ("dbm_store return NULL : %s\n", strerror (errno));
  }
  return result;
}

#endif
