/*
 *
 * j-chkmail - filtre de messagerie pour sendmail - MILTER
 *
 * Copyright (c) 2001, 2002 Ecole des Mines de Paris
 *
 *  Auteur     : Jose Marcio Martins da Cruz
 *               martins@paris.ensmp.fr
 *
 *  Historique :
 *  Creation     : janvier 2002
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include <j-sys.h>

#include "j-chkmail.h"

#undef  DEBUG
#define DEBUG 0

/* ****************************************************************************
 *                                                                            *
 *                                                                            *
 **************************************************************************** */

OPT_REC        *opt;

static char    *compileConf[] = {
#ifdef _POSIX_SOURCE
  "_POSIX_SOURCE",
#endif
#if STDC_HEADERS
  "STDC_HEADERS",
#endif
#if TIME_WITH_SYS_TIME
  "TIME_WITH_SYS_TIME",
#endif
#if HAVE_INTTYPES_H
  "HAVE_INTTYPES_H",
#endif
#if HAVE_THREAD_H
  "HAVE_THREAD_H",
#endif
#if HAVE_PTHREAD_H
  "HAVE_PTHREAD_H",
#endif
#if HAVE_VALUES_H
  "HAVE_VALUES_H",
#endif
#if HAVE_LIMITS_H
  "HAVE_LIMITS_H",
#endif
#if HAVE_MATH_H
  "HAVE_MATH_H",
#endif
#if HAVE_MEMORY_H
  "HAVE_MEMORY_H",
#endif
#if HAVE_REGEX_H
  "HAVE_REGEX_H",
#endif
#if HAVE_SEARCH_H
  "HAVE_SEARCH_H",
#endif
#if HAVE_STDINT_H
  "HAVE_STDINT_H",
#endif
#if HAVE_STDARG_H
  "HAVE_STDARG_H",
#endif
#if HAVE_STDLIB_H
  "HAVE_STDLIB_H",
#endif
#if HAVE_STRING_H
  "HAVE_STRING_H",
#endif
#if HAVE_STRINGS_H
  "HAVE_STRINGS_H",
#endif
#if HAVE_SYS_TYPES_H
  "HAVE_SYS_TYPES_H",
#endif
#if HAVE_SYS_STAT_H
  "HAVE_SYS_STAT_H",
#endif
#if HAVE_SYS_TIME_H
  "HAVE_SYS_TIME_H",
#endif
#if HAVE_SYS_WAIT_H
  "HAVE_SYS_WAIT_H",
#endif
#if HAVE_SYS_RESOURCE_H
  "HAVE_SYS_RESOURCE_H",
#endif
#if HAVE_SYS_SOCKET_H
  "HAVE_SYS_SOCKET_H",
#endif
#if HAVE_POLL_H
  "HAVE_POLL_H",
#endif
#if HAVE_SYS_POLL_H
  "HAVE_SYS_POLL_H",
#endif
#if HAVE_SYSLOG_H
  "HAVE_SYSLOG_H",
#endif
#if HAVE_PWD_H
  "HAVE_PWD_H",
#endif
#if HAVE_GRP_H
  "HAVE_GRP_H",
#endif
#if HAVE_UNISTD_H
  "HAVE_UNISTD_H",
#endif
#if HAVE_FCNTL_H
  "HAVE_FCNTL_H",
#endif
#if HAVE_DIRENT_H
  "HAVE_DIRENT_H",
#endif
#if HAVE_SIGNAL_H
  "HAVE_SIGNAL_H",
#endif
#if HAVE_CTYPE_H
  "HAVE_CTYPE_H",
#endif
#if HAVE_NETDB_H
  "HAVE_NETDB_H",
#endif
#if HAVE_NETINET_IN_H
  "HAVE_NETINET_IN_H",
#endif
#if HAVE_ARPA_INET_H
  "HAVE_ARPA_INET_H",
#endif
#if HAVE_SYS_LOADAVG_H
  "HAVE_SYS_LOADAVG_H",
#endif
#if HAVE_DB_H
  "HAVE_DB_H",
#endif
#if HAVE_NDBM_H
  "HAVE_NDBM_H",
#endif
#if HAVE_GDBM_H
  "HAVE_GDBM_H",
#endif

#if HAVE_BOOL
  "HAVE_BOOL",
#endif
#if HAVE_INT16_T
  "HAVE_INT16_T",
#endif
#if HAVE_UINT16_T
  "HAVE_UINT16_T",
#endif
#if HAVE_INT32_T
  "HAVE_INT32_T",
#endif
#if HAVE_UINT32_T
  "HAVE_UINT32_T",
#endif
#if HAVE_SIZE_T
  "HAVE_SIZE_T",
#endif
#if HAVE_SSIZE_T
  "HAVE_SSIZE_T",
#endif
#if HAVE_SOCKET_T
  "HAVE_SOCKET_T",
#endif
#if HAVE_SOCKLEN_T
  "HAVE_SOCKLEN_T",
#endif
#if HAVE_MODE_T
  "HAVE_MODE_T",
#endif
#if HAVE_OFF_T
  "HAVE_OFF_T",
#endif

#if HAVE_HRTIME_T
  "HAVE_HRTIME_T",
#endif
#if HAVE_IN_ADDR6_T
  "HAVE_IN_ADDR6_T",
#endif
#if HAVE_IN_ADDR_T
  "HAVE_IN_ADDR_T",
#endif

#if RETSIGTYPE
  "RETSIGTYPE",
#endif

#if HAVE_LIBCOMPAT
  "HAVE_LIBCOMPAT",
#endif
#if HAVE_LIBMILTER
  "HAVE_LIBMILTER",
#endif
#if HAVE_LIBMILTER_MFAPI_H
  "HAVE_LIBMILTER_MFAPI_H",
#endif
#if HAVE_LIBNSL
  "HAVE_LIBNSL",
#endif
#if HAVE_LIBPTHREAD
  "HAVE_LIBPTHREAD",
#endif
#if HAVE_LIBRESOLV
  "HAVE_LIBRESOLV",
#endif
#if HAVE_LIBDB
  "HAVE_LIBDB",
#endif
#if HAVE_LIBGDBM
  "HAVE_LIBGDBM",
#endif
#if HAVE_LIBNDBM
  "HAVE_LIBNDBM",
#endif
#if HAVE_LIBSM
  "HAVE_LIBSM",
#endif
#if HAVE_LIBSOCKET
  "HAVE_LIBSOCKET",
#endif
#if HAVE_LIBKSTAT
  "HAVE_LIBKSTAT",
#endif

#if HAVE_MAX
  "HAVE_MAX",
#endif
#if HAVE_GETHOSTNAME
  "HAVE_GETHOSTNAME",
#endif
#if HAVE_GETHOSTBYADDR
  "HAVE_GETHOSTBYADDR",
#endif
#if HAVE_GETHOSTBYNAME
  "HAVE_GETHOSTBYNAME",
#endif
#if HAVE_GETIPNODEBYADDR
  "HAVE_GETIPNODEBYADDR",
#endif
#if HAVE_GETIPNODEBYNAME
  "HAVE_GETIPNODEBYNAME",
#endif
#if HAVE_INET_ADDR
  "HAVE_INET_ADDR",
#endif
#if HAVE_INET_NTOA
  "HAVE_INET_NTOA",
#endif
#if HAVE_INET_ATON
  "HAVE_INET_ATON",
#endif
#if HAVE_INET_NTOP
  "HAVE_INET_NTOP",
#endif
#if HAVE_INET_PTON
  "HAVE_INET_PTON",
#endif
#if HAVE_GETRUSAGE
  "HAVE_GETRUSAGE",
#endif
#if HAVE_GETRLIMIT
  "HAVE_GETRLIMIT",
#endif
#if HAVE_SETRLIMIT
  "HAVE_SETRLIMIT",
#endif
#if HAVE_MEMCPY
  "HAVE_MEMCPY",
#endif
#if HAVE_REGCOMP
  "HAVE_REGCOMP",
#endif
#if HAVE_SOCKET
  "HAVE_SOCKET",
#endif
#if HAVE_SELECT
  "HAVE_SELECT",
#endif
#if HAVE_POLL
  "HAVE_POLL",
#endif
#if HAVE_SOCKETPAIR
  "HAVE_SOCKETPAIR",
#endif
#if HAVE_THR_SETCONCURRENCY
  "HAVE_THR_SETCONCURRENCY",
#endif
#if HAVE_STRCHR
  "HAVE_STRCHR",
#endif
#if HAVE_STRTOL
  "HAVE_STRTOL",
#endif
#if HAVE_STRCSPN
  "HAVE_STRCSPN",
#endif
#if HAVE_STRDUP
  "HAVE_STRDUP",
#endif
#if HAVE_STRERROR
  "HAVE_STRERROR",
#endif
#if HAVE_STRFTIME
  "HAVE_STRFTIME",
#endif
#if HAVE_CTIME
  "HAVE_CTIME",
#endif
#if HAVE_CTIME_R
  "HAVE_CTIME_R",
#endif
#if HAVE_STRLCPY
  "HAVE_STRLCPY",
#endif
#if HAVE_STRSPN
  "HAVE_STRSPN",
#endif
#if HAVE_STRSTR
  "HAVE_STRSTR",
#endif
#if HAVE_MKSTEMP
  "HAVE_MKSTEMP",
#endif
#if HAVE_MKTEMP
  "HAVE_MKTEMP",
#endif
#if HAVE_OPENDIR
  "HAVE_OPENDIR",
#endif
#if HAVE_READDIR
  "HAVE_READDIR",
#endif
#if HAVE_READDIR_R
  "HAVE_READDIR_R",
#endif
#if HAVE_ERF
  "HAVE_ERF",
#endif
#if HAVE_ERFC
  "HAVE_ERFC",
#endif
#if HAVE_ERFI
  "HAVE_ERFI",
#endif
#if NEED_SM_SNPRINTF
  "NEED_SM_SNPRINTF",
#endif
#if HAVE_GETLOADAVG
  "HAVE_GETLOADAVG",
#endif

#if HAVE_KSTAT_CLOSE
  "HAVE_KSTAT_CLOSE",
#endif
#if HAVE_KSTAT_H
  "HAVE_KSTAT_H",
#endif
#if HAVE_KSTAT_OPEN
  "HAVE_KSTAT_OPEN",
#endif
#if HAVE_KSTAT_READ
  "HAVE_KSTAT_READ",
#endif
#if HAVE_KSTAT_LOOKUP
  "HAVE_KSTAT_LOOKUP",
#endif


#if HAVE_LSTAT
  "HAVE_LSTAT",
#endif
#if HAVE_STAT
  "HAVE_STAT",
#endif
#if HAVE_CLOCK
  "HAVE_CLOCK",
#endif
#if HAVE_TIME
  "HAVE_TIME",
#endif
#if HAVE_SLEEP
  "HAVE_SLEEP",
#endif
#if HAVE_USLEEP
  "HAVE_USLEEP",
#endif
#if HAVE_GETHRTIME
  "HAVE_GETHRTIME",
#endif
#if HAVE_SMFI_SETBACKLOG
  "HAVE_SMFI_SETBACKLOG",
#endif
#if HAVE_SMFI_SIGNAL
  "HAVE_SMFI_SIGNAL",
#endif
#if HAVE_SMFI_STOP
  "HAVE_SMFI_STOP",
#endif

#if HAVE_DBM_DB
  "HAVE_DBM_DB",
#endif
#if HAVE_DBM_NDBM
  "HAVE_DBM_NDBM",
#endif
#if HAVE_DBM_GDBM
  "HAVE_DBM_GDBM",
#endif


  NULL
};

/* ****************************************************************************
 *                                                                            * 
 *                                                                            *
 **************************************************************************** */


void
dump_j_conf ()
{
  int             i;
  char            str[256];
  char          **s;
  struct rlimit   rlp;

  printf ("Joe's j-chkmail configuration : %s\n", PACKAGE);

  if (opt->arg_v > 1) {

    printf ("\n");
    printf ("---> j-chkmail compile-time configuration\n");
    printf ("     Compiled on %s %s\n", __DATE__, __TIME__);
    printf ("     %s\n\n", UNAME);

    s = compileConf;
    *str = '\0';
    while (*s) {
      sprintf (str, "%s %-26s", str, *s);
      if (strlen (str) > 48) {
        printf ("      %s\n", str);
        *str = '\0';
      }
      s++;
    }
    printf ("      %s\n\n", str);
    printf ("       RUN_AS_USER  : %s\n", RUN_AS_USER);
    printf ("       RUN_AS_GROUP : %s\n", RUN_AS_GROUP);
    printf ("      \n");

  }

  printf ("--> j-chkmail command line options\n");
  *str = '\0';
  if (opt->arg_h) {
    strcat (str, " -h");
  }
  if (opt->arg_v) {
    strcat (str, " -v");
  }
  printf ("\n");

  if (opt->arg_p != NULL) {
    strcat (str, " -p ");
    strcat (str, opt->arg_p);
  }
  if (opt->arg_i != NULL) {
    strcat (str, " -i ");
    strcat (str, opt->arg_i);
  }
  if (opt->arg_u != NULL) {
    strcat (str, " -u ");
    strcat (str, opt->arg_u);
  }
  if (opt->arg_d != NULL) {
    strcat (str, " -d ");
    strcat (str, opt->arg_d);
  }
  if (opt->arg_c != NULL) {
    strcat (str, " -c ");
    strcat (str, opt->arg_c);
  }
  if (opt->arg_l != NULL) {
    strcat (str, " -l ");
    strcat (str, opt->arg_l);
  }
  if (strlen (str) > 0)
    printf (" %s\n", str);

  printf ("\n");
  printf ("---> Configuration file options : \n");
  cf_dump (opt->arg_v > 1);

  printf ("\n");
  printf ("--> j-chkmail run-time configuration\n");
  printf ("    SOCKET               %s\n", sm_sock);

  *str = '\0';
  printf ("    FILE NAME EXTENSIONS :\n");
  list_filename_extensions ();
  printf ("    FILE NAME REGULAR EXPRESSIONS :\n");
  for (i = 0; i < nb_fregex; i++) {
    printf ("    - %s /%-12s/ %s\n", str, j_fregex[i].expr, j_fregex[i].remark);
  }
  if (i == 0)
    printf ("    - NOTHING TO DECLARE\n");
  printf ("\n");

#if HAVE_GETRLIMIT
  if (getrlimit (RLIMIT_NOFILE, &rlp) == 0) {
    printf ("       RLIMIT_NOFILE    : %6ld (soft) - %6ld (hard)\n",
            (long) rlp.rlim_cur, (long) rlp.rlim_max);
    printf ("       FD_SETSIZE       : %6ld\n", (long) FD_SETSIZE);
    printf ("       USE_SELECT_LIMIT : %6s\n",
            cf_get_int (CF_USE_SELECT_LIMIT) == OPT_YES ? "YES" : "NO");
  }
#endif
  printf ("\n");
}
