/*
 *
 * j-chkmail - filtre de messagerie pour sendmail - MILTER
 *
 * Copyright (c) 2001, 2002 Ecole des Mines de Paris
 *
 *  Auteur     : Jose Marcio Martins da Cruz
 *               martins@paris.ensmp.fr
 *
 *  Historique :
 *  Creation     : janvier 2002
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include <j-sys.h>

#include "j-chkmail.h"



/* ****************************************************************************
 *                                                                            *
 *                                                                            *
 **************************************************************************** */
void
cleanup_spool (dirname, maxage)
     char               *dirname;
     unsigned long       maxage;
{
  DIR                *dir;
  struct dirent      *p;
  struct stat         st;
  char                fname[1024];
  time_t              now = time (NULL);
  int                 nb = 0;

  if (dirname == NULL)
    return;

  if (log_level >= 9)
    syslog (LOG_INFO, "*** Cleaning up spool dir : %s", dirname);

  if (maxage == 0) {
    syslog (LOG_INFO, "%s : MAX_AGE == 0 : no spool cleaning up", J_FUNCTION);
    return;
  }

  if ((dir = opendir (dirname)) != NULL) {
    while ((p = readdir (dir)) != NULL) {
      snprintf (fname, sizeof (fname), "%s/%s", dirname, p->d_name);
#if HAVE_LSTAT
      if (lstat (fname, &st) == 0) {
#else
      if (stat (fname, &st) == 0) {
#endif
        if (S_ISREG (st.st_mode)) {
          if (st.st_mtime + maxage < now) {
            nb++;
            if (log_level > 10)
              syslog (LOG_INFO, "* Deleting file : %s", fname);
            unlink (fname);
          }
        }
      } else {
        syslog (LOG_WARNING, "%s : lstat : %s %s", J_FUNCTION,
                fname, strerror (errno));
      }
    }
    closedir (dir);
  } else {
    syslog (LOG_WARNING, "%s : opendir : %s", J_FUNCTION, strerror (errno));
  }
  if (log_level >= 9)
    syslog (LOG_INFO, "*** %d files deleted", nb);
}
