/*
 *
 * j-chkmail - filtre de messagerie pour sendmail - MILTER
 *
 * Copyright (c) 2001, 2002 Ecole des Mines de Paris
 *
 *  Auteur     : Jose Marcio Martins da Cruz
 *               martins@paris.ensmp.fr
 *
 *  Historique :
 *  Creation     : janvier 2002
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include <j-sys.h>

#include "j-chkmail.h"

#undef  DEBUG
#define DEBUG 0



/*****************************************************************************
 *                                                                           * 
 *                                                                           *
 *****************************************************************************/
#define HOST_LEN          256

typedef struct {
  char                host[HOST_LEN];
} HOST_REC;

static j_table      htbl;

static pthread_mutex_t st_mutex = PTHREAD_MUTEX_INITIALIZER;

static int          use_db = FALSE;

/*****************************************************************************
 *                                                                           * 
 *                                                                           *
 *****************************************************************************/
void
dump_classw_table ()
{
  HOST_REC            p;

  printf ("Let's dump j_classw_table : \n");
  if (j_table_get_first (&htbl, &p) == 0) {
    do {
      printf ("-> HOST : %-20s\n", p.host);
    } while (j_table_get_next (&htbl, &p) == 0);
  }
}

/*****************************************************************************
 *                                                                           * 
 *                                                                           *
 *****************************************************************************/
static int
host_comp (pa, pb)
     const void         *pa;
     const void         *pb;
{
  HOST_REC           *a = (HOST_REC *) pa;
  HOST_REC           *b = (HOST_REC *) pb;

  return strcasecmp (a->host, b->host);
}

/*****************************************************************************
 *                                                                           * 
 *                                                                           *
 *****************************************************************************/
static int
add_host_rec (k, v)
     char               *k;
     char               *v;
{
  HOST_REC            r;

  memset (&r, 0, sizeof (r));
  if (k == NULL || strlen (k) == 0)
    return 0;
  if (v == NULL)
    v = "";

  strlcpy (r.host, k, sizeof (r.host));

  return j_table_add (&htbl, &r);
}

/*****************************************************************************
 *                                                                           * 
 *                                                                           *
 *****************************************************************************/
int
load_classw_table (fname)
     char               *fname;
{
  int                 res = 0;
  static int          htbl_ok = FALSE;

  pthread_mutex_lock (&st_mutex);

  if (htbl_ok == FALSE) {
    memset (&htbl, 0, sizeof (htbl));
    res = j_table_init (&htbl, sizeof (HOST_REC), 256, host_comp);
    if (res == 0)
      htbl_ok = TRUE;
  }
  if (res == 0)
    res = j_table_clear (&htbl);

  if (res == 0) {
    if (use_db) {
      void               *dbh;

      if ((dbh = j_db_open (fname)) != NULL) {
        res = j_db_walk (dbh, add_host_rec);
        j_db_close (dbh);
      } else
        res = -1;
    } else {
      res = j_rd_text_file (fname, RD_ONE_COLUMN, RD_NORMAL, add_host_rec);
    }
  }

  if (res == 0)
    res = j_table_sort (&htbl);

  pthread_mutex_unlock (&st_mutex);

#if 0
  dump_classw_table ();
#endif

  return res;
}

/*****************************************************************************
 *                                                                           * 
 *                                                                           *
 *****************************************************************************/
int
check_classw (host)
     char               *host;
{
  HOST_REC            p;
  int                 res;

  if (host == NULL)
    return FALSE;

  memset (&p, 0, sizeof (p));
  strlcpy (p.host, host, sizeof (p.host));

  pthread_mutex_lock (&st_mutex);
  res = (j_table_fetch (&htbl, &p) != 0 ? FALSE : TRUE);
  pthread_mutex_unlock (&st_mutex);

  return res;
}
