/*
 *
 * j-chkmail - filtre de messagerie pour sendmail - MILTER
 *
 * Copyright (c) 2001, 2002 Ecole des Mines de Paris
 *
 *  Auteur     : Jose Marcio Martins da Cruz
 *               martins@paris.ensmp.fr
 *
 *  Historique :
 *  Creation     : janvier 2002
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include <j-sys.h>

#include "j-buffer.h"


/*****************************************************************************
 *                                                                           * 
 *                                                                           *
 *****************************************************************************/
long
bufspn (buf, sz, accept)
     char               *buf;
     long                sz;
     char               *accept;
{
  long                n;
  char               *p;

  for (p = buf, n = 0; n < sz; n++, p++) {
    if (strchr (accept, *p) == NULL)
      break;
  }
  return n;
}


/*****************************************************************************
 *                                                                           * 
 *                                                                           *
 *****************************************************************************/
long
bufcspn (buf, sz, reject)
     char               *buf;
     long                sz;
     char               *reject;
{
  long                n;
  char               *p;

  for (p = buf, n = 0; n < sz; n++, p++) {
    if (strchr (reject, *p) != NULL)
      break;
  }
  return n;
}

/*****************************************************************************
 *                                                                           * 
 *                                                                           *
 *****************************************************************************/
int
buf_get_line (dst, szdst, org, szorg)
     char               *dst;
     long                szdst;
     char               *org;
     long                szorg;
{
  int                 i = 0, nbc = 0;
  char               *p = org;

  if (org == NULL || dst == NULL || strlen (org) == 0)
    return 0;

  *dst = '\0';

  if (*p == '\r') {
    p++;
    if (*p == '\n')
      return 2;
    else
      return 1;
  }
  if (*p == '\n') {
    p++;
    if (*p == '\r')
      return 2;
    else
      return 1;
  }

  i = 0;
  p = org;
  while ((i < szorg) && *p && (*p != '\r') && (*p != '\n')) {
    i++;
    p++;
  }

  if (i > 0) {
    if (i < szdst) {
      strncpy (dst, org, i);
      dst[i] = '\0';
    } else {
      syslog (LOG_WARNING, "%s : line length > dest buf size\n", J_FUNCTION);
    }
  }
  szorg -= i;
  nbc = i;

  if (*p == '\r') {
    p++;
    if (*p == '\n')
      return nbc + 2;
    else
      return nbc + 1;
  }
  if (*p == '\n') {
    p++;
    if (*p == '\r')
      return nbc + 2;
    else
      return nbc + 1;
  }

  return nbc;
}
