/*
 *
 * j-chkmail - filtre de messagerie pour sendmail - MILTER
 *
 * Copyright (c) 2001, 2002 Ecole des Mines de Paris
 *
 *  Auteur     : Jose Marcio Martins da Cruz
 *               martins@paris.ensmp.fr
 *
 *  Historique :
 *  Creation     : janvier 2002
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include <j-sys.h>

#include "libmilter/mfapi.h"

#include "j-chkmail.h"


/* ****************************************************************************
 *                                                                            *
 *                                                                            *
 **************************************************************************** */

#define SZBUF 1024

static int          av_decode_answer_none (char *, int);
static int          av_decode_answer_user (char *, int);
static int          av_decode_answer_uvscan (char *, int);
static int          av_decode_answer_sophos (char *, int);
static int          av_decode_answer_trend (char *, int);

/* ****************************************************************************
 *                                                                            *
 *                                                                            *
 **************************************************************************** */
int
av_decode_answer (av, answer, res)
     int                 av;
     char               *answer;
     int                 res;
{
  if (log_level >= 20)
    syslog(LOG_DEBUG, "%s : av=%d answer=%s res=%d", 
	   J_FUNCTION, av, answer, res);
  switch (av) {
    case AV_NONE:
      return av_decode_answer_none (answer, res);
      break;
    case AV_USER:
      return av_decode_answer_user (answer, res);
      break;
    case AV_UVSCAN:
      return av_decode_answer_uvscan (answer, res);
      break;
    case AV_SOPHOS:
      return av_decode_answer_sophos (answer, res);
      break;
    case AV_TREND:
      return av_decode_answer_trend (answer, res);
      break;
  }
  return AVRES_ERROR;
}



/* ****************************************************************************
 *                                                                            *
 *                                                                            *
 **************************************************************************** */
static int
av_decode_answer_none (answer, res)
     char               *answer;
     int                 res;
{
  char                buf[SZBUF];
  char               *p = answer;
  int                 dl;
  char               *q;

  while (strlen (p) > 0) {
    dl = strcspn (p, "\n\r");
    if (dl == 0) {
      p++;
      continue;
    }
    memcpy (buf, p, dl);
    buf[dl] = '\0';
    p += dl;
    if ((q = strstr (buf, "Found")) != NULL) {
      char               *t;
      int                 n;

      if ((t = strstr (q, "the")) != NULL) {
        q = t + strlen ("the");
        q += strspn (q, " \t");
        n = strcspn (q, " \t");
        q[n] = '\0';
      }
      strcpy (answer, q);
      return 1;
      break;
    }
  }
  *answer = '\0';
  return 0;
}

/* ****************************************************************************
 *                                                                            *
 *                                                                            *
 **************************************************************************** */
static int
av_decode_answer_user (answer, res)
     char               *answer;
     int                 res;
{
 switch (res) {
    case 0:
      strcpy (answer, "OK");
      return AVRES_OK;
      break;
    case 2:
      res = AVRES_VIRUS;
      break;
    case 3:
      res = AVRES_POLICY;
      break;
    default:
      strcpy (answer, "ERROR");
      return AVRES_ERROR;
      break;
  }

  return res;
}


/* ****************************************************************************
 *                                                                            *
 *                                                                            *
 **************************************************************************** */
static int
av_decode_answer_uvscan (answer, res)
     char               *answer;
     int                 res;
{
  char                buf[SZBUF];
  char               *p = answer;
  int                 dl;
  char               *q;
  char               *srch;

  switch (res) {
    case 0:
      strcpy (answer, "OK");
      return AVRES_OK;
      break;
    case 13:
      res = AVRES_VIRUS;
      break;
    default:
      strcpy (answer, "ERROR");
      return AVRES_ERROR;
      break;
  }
  while (strlen (p) > 0) {
    dl = strcspn (p, "\n\r");
    if (dl == 0) {
      p++;
      continue;
    }
    memcpy (buf, p, dl);
    buf[dl] = '\0';
    p += dl;
    srch = "Found";
    if ((q = strstr (buf, srch)) != NULL) {
      char               *t;

      q += strlen (srch);
      if (*q == ':')
        q++;
      q += strspn (q, ": \t");

      srch = "virus or variant";
      if ((t = strstr (buf, srch)) != NULL)
        q = t + strlen (srch);
      q += strspn (q, ": \t");

      srch = "the";
      if ((t = strstr (buf, srch)) != NULL)
        q = t + strlen (srch);
      q += strspn (q, ": \t");

      dl = strcspn (q, " \t");
      if (dl > 0) {
        snprintf (answer, dl, "%s", q);
        return res;
      }
    }
  }
  *answer = '\0';
  return AVRES_ERROR;
}

/* ****************************************************************************
 *                                                                            *
 *                                                                            *
 **************************************************************************** */
static int
av_decode_answer_sophos (answer, res)
     char               *answer;
     int                 res;
{
  char                buf[SZBUF];
  char               *p = answer;
  int                 dl;
  char               *q;

  switch (res) {
    case 0:
      strcpy (answer, "OK");
      return AVRES_OK;
      break;
    case 3:
      res = AVRES_VIRUS;
      break;
    default:
      strcpy (answer, "ERROR");
      return AVRES_ERROR;
      break;
  }
  while (strlen (p) > 0) {
    dl = strcspn (p, "\n\r");
    if (dl == 0) {
      p++;
      continue;
    }
    memcpy (buf, p, dl);
    buf[dl] = '\0';
    p += dl;
    if ((q = strstr (buf, "Virus")) != NULL) {
      char               *t, *s;

      s = answer;
      if ((t = strchr (buf, '\'')) != NULL) {
        for (t++; *t != '\0' && *t != '\''; t++)
          *s++ = *t;
      }
      *s = '\0';
      if (strlen (answer) > 0)
        return res;
    }
  }
  *answer = '\0';
  return res;
}


/* ****************************************************************************
 *                                                                            *
 *                                                                            *
 **************************************************************************** */
static int
av_decode_answer_trend (answer, res)
     char               *answer;
     int                 res;
{
  char                buf[SZBUF];
  char               *p = answer;
  int                 dl;
  char               *q;
  char               *srch;

  switch (res) {
    case 0:
      strcpy (answer, "OK");
      return AVRES_OK;
      break;
    case 1:
    case 2:
      res = AVRES_VIRUS;
      break;
    default:
      strcpy (answer, "ERROR");
      return AVRES_ERROR;
      break;
  }
  while (strlen (p) > 0) {
    dl = strcspn (p, "\n\r");
    if (dl == 0) {
      p++;
      continue;
    }
    memcpy (buf, p, dl);
    buf[dl] = '\0';
    p += dl;

    srch = "Found virus";
    if ((q = strstr (buf, srch)) != NULL) {
      q += strlen (srch);
      q += strspn (q, " \t");
      dl = strcspn (q, " \t");
      if (dl > 0) {
        snprintf (answer, dl, "%s", q);
        return res;
      }
    }
  }
  *answer = '\0';
  return res;
}
