/*
 *
 * j-chkmail - filtre de messagerie pour sendmail - MILTER
 *
 * Copyright (c) 2001, 2002 Ecole des Mines de Paris
 *
 *  Auteur     : Jose Marcio Martins da Cruz
 *               martins@paris.ensmp.fr
 *
 *  Historique :
 *  Creation     : janvier 2002
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include <j-sys.h>

#include "libmilter/mfapi.h"

#include "j-avclient.h"

#include "j-chkmail.h"


/* ****************************************************************************
 *                                                                            *
 *                                                                            *
 **************************************************************************** */
static int      decode_answer (char *);

/* ****************************************************************************
 *                                                                            *
 *                                                                            *
 **************************************************************************** */
#define BUFSIZE   2048

int
check_virus (answer, question)
     char           *answer;
     char           *question;
{
  int             sd;
  struct sockaddr_in his_sock;
  struct hostent *hp;

  char            buf[BUFSIZE];
  int             nb;

  int             res = 0;

  if (answer == NULL || question == NULL || strlen (question) == 0)
    return -1;

  memset (buf, 0, sizeof (buf));
  /* on cree le socket d'emission ... */

  if ((sd = socket (AF_INET, SOCK_STREAM, 0)) < 0) {
    syslog (LOG_ERR, "j-avclient : socket %s", strerror (errno));
    return -1;
  }

  /* adresse destinataire */
  if ((hp = gethostbyname ("localhost")) == NULL) {
    syslog (LOG_ERR, "j-avclient : gethostbyname %s", strerror (errno));
    res = -1;
  }

  if (res >= 0) {
    memcpy ((char *) &his_sock.sin_addr, hp->h_addr, hp->h_length);
    his_sock.sin_family = AF_INET;
    his_sock.sin_port = htons (av_port);

    if (log_level >= 20)
      log_sock_addr (&his_sock);
  }

  /* emission sur sd vers his_sock d'un message de taille size */
  if (res >= 0) {
    if (connect (sd, (struct sockaddr *) &his_sock, sizeof (his_sock)) < 0) {
      syslog (LOG_ERR, "j-avclient : connect sur socket %s", strerror (errno));
      res = -1;
    }
  }

  if (res >= 0) {
    res = -1;
    sprintf (buf, "%s", question);

    if (j_fd_ready (sd, J_SOCK_WRITE, 10000) == J_SOCK_READY) {
      res = 0;
      if ((nb = send (sd, buf, strlen (buf) + 1, 0)) < 0) {
        syslog (LOG_ERR, "Sendto sur socket %s", strerror (errno));
        res = -1;
      }
    }

    if (log_level >= 20)
      syslog (LOG_DEBUG, "j-avclient - SEND %s\n", buf);
  }

  if (res >= 0) {
    time_t          av_to = cf_get_int (CF_AV_TIMEOUT) * 1000;

    res = -1;
    memset (buf, 0, sizeof (buf));

    if (av_to == 0)
      av_to = 60000;

    if (j_fd_ready (sd, J_SOCK_READ, av_to) == J_SOCK_READY) {
      if ((nb = recv (sd, buf, sizeof (buf), 0)) >= 0) {
        strcpy (answer, buf);
        res = decode_answer (answer);
      }
    }

    if (log_level >= 20)
      syslog (LOG_DEBUG, "j-avclient - RECV %s\n", buf);
    if (log_level >= 20)
      syslog (LOG_DEBUG, "j-avclient - RES  %s - %d\n", answer, res);
  }
  /* fermeture du socket d'emission */

  shutdown (sd, 2);
  close (sd);

  return res;
}


/* ****************************************************************************
 *                                                                            *
 *                                                                            *
 **************************************************************************** */
static int
decode_answer (answer)
     char           *answer;
{
  char            st[1024], *p;
  int             i, res;

  memset (st, 0, sizeof (st));
  p = answer + strspn (answer, " \t");

  i = strspn (p, "1234567890");
  strncpy (st, p, i);
  st[i] = '\0';

  res = atoi (st);
  p += i;
  p += strcspn (p, " \t");
  strcpy (answer, p);
  return res;
}
