/*
 *
 * j-chkmail - filtre de messagerie pour sendmail - MILTER
 *
 * Copyright (c) 2001, 2002 Ecole des Mines de Paris
 *
 *  Auteur     : Jose Marcio Martins da Cruz
 *               martins@paris.ensmp.fr
 *
 *  Historique :
 *  Creation     : janvier 2002
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include <j-sys.h>

#include "libmilter/mfapi.h"

#include "j-avserver.h"

#include "j-chkmail.h"


/* ****************************************************************************
 *                                                                            *
 *                                                                            *
 **************************************************************************** */
#define DO_CHECK_AV 1

static char    *j_spool_dir = J_SPOOLDIR;

#define SZ_QUEUE   64


/* ****************************************************************************
 *                                                                            *
 *                                                                            *
 **************************************************************************** */
static struct flock lock_it, unlock_it;

static int      lock_fd = -1;

static time_t   AV_TIMEOUT = 60;

#define FILE_MODE (S_IRUSR | S_IWUSR | S_IRGRP | S_IROTH)


int             nconnect = 0;


void            j_pf_lock_init (char *);

void            j_pf_lock_wait ();

void            j_pf_lock_release ();


static void     j_pf_child_main (int, int);

pid_t           j_pf_child_make (int, int);

/* ****************************************************************************
 *                                                                            * 
 *                                                                            *
 **************************************************************************** */


/* ****************************************************************************
 *                                                                            *
 *                                                                            *
 **************************************************************************** */
#define BUFSIZE  1024
static int      ac_check (char *, char *);
static int      check_fname (char *, char *);


static int
answer_request (from, sd, nc)
     struct sockaddr_in *from;
     int             sd;
     int             nc;
{
  char            buf[BUFSIZE];
  int             nbytes;

  char            texte[BUFSIZE];
  char            answer[BUFSIZE];
  int             res = 0;
  int             avres = 0;


  log_sock_addr (from);

  if (j_fd_ready (sd, J_SOCK_READ, 10000) != J_SOCK_READY)
    return -1;

  memset (buf, 0, sizeof (buf));
  if ((nbytes = recv (sd, buf, sizeof (buf), 0)) < 0) {
    syslog (LOG_ERR, "Erreur pendant reception de nom de fichier : %s",
            strerror (errno));
    return -1;
  }

  sprintf (texte, "QUESTION (%3d): %s", nc, buf);
  if (log_level >= 20)
    syslog (LOG_DEBUG, "%s\n", texte);


  if (DO_CHECK_AV) {
    res = ac_check (answer, buf);
    if (log_level >= 20)
      syslog (LOG_DEBUG, "%s : before Q : %s -> A : %s (%d)", J_FUNCTION, buf, answer,
              res);

    avres = av_decode_answer (av_type, answer, res);

    if (log_level >= 20)
      syslog (LOG_DEBUG, "%s : after  Q : %s -> A : %s (%d)", J_FUNCTION, buf, answer,
              avres);
  } else {
    res = check_fname (answer, buf);
  }

  if (res == AVRES_OK) {

  }

  sprintf (texte, "%3d %s", avres, answer);
  if (log_level >= 20)
    syslog (LOG_DEBUG, "TEXTE = %s\n", texte);

  if (j_fd_ready (sd, J_SOCK_WRITE, 10000) != J_SOCK_READY)
    return -1;

  if ((nbytes = send (sd, texte, strlen (texte) + 1, 0)) < 0) {
    syslog (LOG_ERR, "Error receiving av answer : %s", strerror (errno));
    return -1;
  }
  return 0;
}

/* ****************************************************************************
 *                                                                            *
 *                                                                            *
 **************************************************************************** */
static int
get_result (int r)
{
  if ((r & 0xff) == 0)
    return (r >> 8) & 0xff;
  return r & 0xFF;
}

/* ****************************************************************************
 *                                                                            *
 *                                                                            *
 **************************************************************************** */
#define SZBUF 1024

static int
ac_check (answer, fname)
     char           *answer;
     char           *fname;
{
  pid_t           pid;
  int             p[2];
  char            buf[SZBUF];
  char            file[SZBUF];

  if (answer == NULL || fname == NULL)
    exit (1);

  strcpy (answer, "");

  if (pipe (p) < 0) {
    syslog (LOG_ERR, "Error creating av pipe : %s", strerror (errno));
    exit (1);
  }

  if ((pid = fork ()) < 0) {
    syslog (LOG_ERR, "Error forking av process : %s", strerror (errno));
    exit (1);
  }

  /* child - talks */
  if (pid == 0) {
    int             i;

    /* redirect stdout to p[1] */
    close (STDOUT_FILENO);
    dup2 (p[1], STDOUT_FILENO);
    /* and close unused stdin */
    close (STDIN_FILENO);

    if (DO_CHECK_AV) {
      snprintf (file, sizeof (file), "%s/%s", j_spool_dir, fname);
      snprintf (file, sizeof (file), "%s", fname);

      for (i = 0; av_args[i] != NULL; i++);

      av_args[i] = file;

      execv (av_args[0], av_args);
    } else {
      execlp ("./revert", "./revert", fname, NULL);
    }

    /* shall never execute this... */
    exit (1);
  }

  /* parent */
  if (pid > 0) {
    int             stat_loc;
    int             n, i = 0;
    int             status;
    time_t          t_init;

    AV_TIMEOUT = cf_get_int (CF_AV_TIMEOUT);
    if (AV_TIMEOUT == 0)
      AV_TIMEOUT = 60;

    memset (buf, 0, SZBUF);

    close (STDIN_FILENO);
    if (dup2 (p[0], STDIN_FILENO) < 0) {
      syslog (LOG_ERR, "%s : Error dup2 pipe : %s", J_FUNCTION, strerror (errno));
      exit (1);
    }

    t_init = time (NULL);
    while ((t_init + AV_TIMEOUT) > time (NULL)) {
      int             res = 0;

      if ((res = j_fd_ready (0, J_SOCK_READ, 500)) == J_SOCK_READY) {
        while ((n = read (0, buf, SZBUF)) > 0) {
          i++;
          strncpy (answer, buf, n);
          if (log_level >= 20)
            syslog (LOG_DEBUG, "GET from child %s", answer);
        }
        break;
      }

      if (res == J_SOCK_ERROR)
        break;
    }

    t_init = time (NULL);
    status = 0;
    while ((t_init + 10) >= time (NULL)) {

      status = waitpid (-1, &stat_loc, WNOHANG);
      if (status == pid)
        break;
      if (errno == EINTR) {
        sleep (1);
        continue;
      }
      syslog (LOG_ERR, "%s : Error waiting av process : status = %d %d %d : %s",
              J_FUNCTION, status, pid, stat_loc, strerror (errno));
      break;
    }

    if ((status != pid) && ((t_init + 10) < time (NULL))) {

      t_init = time (NULL);
      while ((t_init + 10) >= time (NULL)) {
        kill (pid, SIGTERM);
        sleep (1);
        status = waitpid (-1, &stat_loc, WNOHANG);
        if (status == pid)
          break;
        if (errno == EINTR)
          continue;
        syslog (LOG_ERR, "%s : Error waiting av process : status = %d %d %d : %s",
                J_FUNCTION, status, pid, stat_loc, strerror (errno));
        break;
      }
    }

    if (log_level >= 20)
      syslog (LOG_DEBUG, " -> CHILDREN ENDED %3d %08lX %3d\n",
              i, (long) stat_loc, get_result (stat_loc));


    if (log_level >= 20)
      syslog (LOG_DEBUG, "ac_check : parent : %d : %s %s", get_result (stat_loc),
              answer, buf);

    return get_result (stat_loc);
  }
  exit (1);
}



/* *******************************************
 *                                           *
 *                                           *
 ******************************************* */
static int
check_fname (dst, src)
     char           *dst;
     char           *src;
{
  char           *t;
  int             i;

  t = dst;
  for (i = strlen (src); i > 0; i--)
    *t++ = src[i - 1];
  *t = '\0';
  return 0;
}


/* ****************************************************************************
 *                                                                            *
 *                                                                            *
 **************************************************************************** */
void
j_pf_lock_init (filename)
     char           *filename;
{
  char            lock_file[1024];

  snprintf (lock_file, sizeof (lock_file), "%s.XXXXXX", filename);

#if HAVE_MKSTEMP
  lock_fd = mkstemp (lock_file);
#else
  mktemp (lock_file);
  lock_fd = open (lock_file, O_CREAT | O_WRONLY, FILE_MODE);
#endif

  if (log_level > 20)
    syslog (LOG_DEBUG, "lock_fd = %d", lock_fd);

  unlink (lock_file);

  lock_it.l_type = F_WRLCK;
  lock_it.l_whence = SEEK_SET;
  lock_it.l_start = 0;
  lock_it.l_len = 0;

  unlock_it.l_type = F_UNLCK;
  unlock_it.l_whence = SEEK_SET;
  unlock_it.l_start = 0;
  unlock_it.l_len = 0;

}

/* *******************************************
 *                                           *
 *                                           *
 ******************************************* */
void
j_pf_lock_wait ()
{
  int             rc;

  while ((rc = fcntl (lock_fd, F_SETLKW, &lock_it)) < 0) {
    if (errno == EINTR)
      continue;
    else {
      syslog (LOG_ERR, "j_pf_lock_wait error : %s", strerror (errno));
      exit (1);
    }
  }
}

/* *******************************************
 *                                           *
 *                                           *
 ******************************************* */
void
j_pf_lock_release ()
{
  if (fcntl (lock_fd, F_SETLKW, &unlock_it) < 0) {
    syslog (LOG_ERR, "j_pf_lock_release error : %s", strerror (errno));
    exit (1);
  }
}



/* *******************************************
 *                                           *
 *                                           *
 ******************************************* */
pid_t
j_pf_child_make (i, listen_fd)
     int             i;
     int             listen_fd;
{
  pid_t           pid;

  if ((pid = fork ()) > 0)
    return pid;

  if (pid < 0)
    return -1;

  j_pf_child_main (i, listen_fd);

  return 0;
}

/* *******************************************
 *                                           *
 *                                           *
 ******************************************* */
static void
j_pf_child_main (i, listen_fd)
     int             i;
     int             listen_fd;
{
  int             sd;

  struct sockaddr_in from;

#if 1
  socklen_t       fromlen;
#else
  size_t          fromlen;
#endif

  AV_TIMEOUT = cf_get_int (CF_AV_TIMEOUT);

  for (;;) {
    fromlen = sizeof (from);
    memset (&from, 0, fromlen);

    j_pf_lock_wait ();
    sd = accept (listen_fd, (struct sockaddr *) &from, &fromlen);
    j_pf_lock_release ();

    while (waitpid (-1, NULL, WNOHANG) > 0);
    if (sd < 0) {
      continue;
    }
    nconnect++;

    if (answer_request (&from, sd, nconnect)) {

    }
    shutdown (sd, SHUT_RDWR);

    close (sd);
  }
}
