/*
 *
 * j-chkmail - filtre de messagerie pour sendmail - MILTER
 *
 * Copyright (c) 2001, 2002 Ecole des Mines de Paris
 *
 *  Auteur     : Jose Marcio Martins da Cruz
 *               martins@paris.ensmp.fr
 *
 *  Historique :
 *  Creation     : janvier 2002
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */


#ifndef __MIMELIST_H__



/*
 *
 */

typedef struct content_text {
  char               *name;
  char               *value;
} content_text;

#define   NB_ATTR      32

typedef struct content_field {
  int                 field_type;
  char               *value;
  content_text        attr[NB_ATTR];
  struct content_field *next;
} content_field;

void                add_content_field_attr (content_field *, char *, char *);
void                save_content_field (content_field *, content_field **);
void                free_content_field (content_field *);
void                free_content_field_rec (content_field *);
void                free_content_field_list (content_field *);


typedef struct attachment {
  char               *name;
  char               *disposition;
  char               *mimetype;
  int                 exefile;
  struct attachment  *next;
} attachment;



void                free_attachment_list (attachment *);

void                add_attachment (attachment * file, attachment **);

int                 extract_attachments (content_field *, attachment **);

int                 get_file_disposition (content_field *, char *, char *);


#define __MIMELIST_H__

#endif
