
#ifndef _KSTATS_

typedef struct {
  int           n;
  double        st;
  double        st2;
} STATS;

#define         MAX_CLASS       8

double  kmean(STATS *s);
double  kstddev(STATS *s);

void    kstats_reset(STATS *);
void    kstats_update(STATS *, double );
void    kstats_print(STATS *);
void    print_inference(STATS *, double , char *);


double FGauss(double x);
double erf(double x);
double erfc(double x);

double FGaussI(double x);
double erfi(double x);
double erfci(double x);

double confidence_interval(double p, double stddev, int n);

#define _KSTATS_

#endif


