/*
 *
 * j-chkmail - filtre de messagerie pour sendmail - MILTER
 *
 * Copyright (c) 2001, 2002 Ecole des Mines de Paris
 *
 *  Auteur     : Jose Marcio Martins da Cruz
 *               martins@paris.ensmp.fr
 *
 *  Historique :
 *  Creation     : janvier 2002
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef __JTHROTTLE_H__

#ifndef TRUE
# define FALSE	0
# define TRUE 	1
#endif             /* ! true */

bool                throttle_init (int);
void                throttle_free();
bool                throttle_resize(size_t , size_t);

int                 throttle_add_host_entry (char *, time_t);
int                 throttle_add_rcpt_entry (char *, int, time_t);

int                 throttle_update_table (time_t);
void                throttle_update_thread(void);

void                throttle_log_table ();
void                throttle_print_table (int, int, int);
void                throttle_save_table (char *);
int                 throttle_read_table (char *);

int                 throttle_check_host (char *);
int                 throttle_check_rcpt (char *);

unsigned int        throttle_get_short(void);
unsigned int        throttle_get_long(void);

extern unsigned int throttle_interval;  /* 1 minute */
extern unsigned int throttle_window;  /* 10 minutes */

void                update_global_throttle(time_t);
bool                update_throttle_dos();
bool                check_throttle_dos(void);
void                log_throttle_stats(void);

#define __JTHROTTLE_H__
#endif
