/*
 *
 * j-chkmail - filtre de messagerie pour sendmail - MILTER
 *
 * Copyright (c) 2001, 2002 Ecole des Mines de Paris
 *
 *  Auteur     : Jose Marcio Martins da Cruz
 *               martins@paris.ensmp.fr
 *
 *  Historique :
 *  Creation     : janvier 2002
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef __JTABLE_H_

#ifndef TRUE
# define FALSE	0
# define TRUE 	1
#endif             /* ! true */

typedef struct j_table {
  size_t              sz;
  int                 chunk;
  int                 dim;
  int                 nb;
  int                 index;
  void               *data;
  int                 (*comp) (const void *, const void *);
} j_table;

int                 j_table_init (j_table *, size_t, int,
                                  int (*)(const void *, const void *));
int                 j_table_free (j_table *);
int                 j_table_clear (j_table *);
int                 j_table_add (j_table *, void *);
int                 j_table_count (j_table *);
int                 j_table_fetch (j_table *, void *);
int                 j_table_get_ind (j_table *, void *, int);
int                 j_table_get_first (j_table *, void *);
int                 j_table_get_next (j_table *, void *);
int                 j_table_sort (j_table *);
int                 j_table_find (j_table *, void *);

void               *j_table_fetch_ptr (j_table *, void *);
void               *j_table_get_ind_ptr (j_table *, int);
void               *j_table_get_first_ptr (j_table *);
void               *j_table_get_next_ptr (j_table *);

#define __JTABLE_H_
#endif
