/*
 *
 * j-chkmail - filtre de messagerie pour sendmail - MILTER
 *
 * Copyright (c) 2001, 2002 Ecole des Mines de Paris
 *
 *  Auteur     : Jose Marcio Martins da Cruz
 *               martins@paris.ensmp.fr
 *
 *  Historique :
 *  Creation     : janvier 2002
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef __JSTATS_H__

#ifndef TRUE
# define FALSE	0
# define TRUE 	1
#endif             /* ! true */

#define           STAT_RESTART            0
#define           STAT_BYTES              1
#define           STAT_MSGS               2
#define           STAT_CONNECT            3
#define           STAT_ABORT              4
#define           STAT_CLOSE              5
#define           STAT_ENVTO              6
#define           STAT_FILES              7
#define           STAT_XFILES             8
#define           STAT_VIRUS              9
#define           STAT_LUSERS            10
#define           STAT_OUTLOOK           11
#define           STAT_NO_TO_HEADERS     12
#define           STAT_NO_FROM_HEADERS   13

#define           STAT_RESOLVE_FAIL      14
#define           STAT_RESOLVE_FORGED    15
#define           STAT_MAX_RCPT          16
#define           STAT_THROTTLE          17

#define           STAT_NO_SUBJECT_HEADER 18
#define           STAT_NO_HEADERS        19

#define           STAT_BODY_CONTENTS     21
#define           STAT_SUBJECT_CONTENTS  22
#define           STAT_HEADERS_CONTENTS  23
#define           STAT_HELO_CONTENTS     24

#define           STAT_POLICY            30

#define           STAT_BINARY            31
#define           STAT_BASE64            32
#define           STAT_QUOTED_PRINTABLE  33

#define           STAT_RCPT_THROTTLE     41

#define           STAT_XX                50


#define           DIM_STATS             128


typedef struct p_stats {
  pid_t           pid;
  time_t          start;
  long            value[DIM_STATS];
} p_stats;

typedef struct j_stats {
  long            signature;
  long            vers;
  char            version[128];
  time_t          last_save;
  p_stats         glob;
  p_stats         proc;
} j_stats;


void            log_stats (int, int);

void            stats_inc (int, long);

void            stats_reset ();

void            init_proc_state ();

void            save_state ();

void            read_state ();

void            reset_state ();

int             print_state ();

char           *stats_title (int);

#define __JSTATS_H__
#endif
