/*
 *
 * j-chkmail - filtre de messagerie pour sendmail - MILTER
 *
 * Copyright (c) 2001, 2002 Ecole des Mines de Paris
 *
 *  Auteur     : Jose Marcio Martins da Cruz
 *               martins@paris.ensmp.fr
 *
 *  Historique :
 *  Creation     : janvier 2002
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef __JRESOLVE_H__

#ifndef TRUE
# define FALSE	0
# define TRUE 	1
#endif             /* ! true */


#define RESOLVE_NULL      -1
#define RESOLVE_OK        0
#define RESOLVE_FAIL      1
#define RESOLVE_FORGED    2
#define RESOLVE_TEMPFAIL  3

#define  RESOLVE_VAL(i)   ((i) == RESOLVE_OK ? "OK" : \
                           (i) == RESOLVE_FAIL ? "FAIL" : \
                           (i) == RESOLVE_FORGED ? "FORGED" : \
                           (i) == RESOLVE_TEMPFAIL ? "TEMPFAIL" : "NULL")

void            resolve_tab_init (void);

int             resolve_tab_add_entry (char *, time_t, int, int);

int             resolve_tab_update (int);
void            resolve_tab_update_thread ();

void            resolve_tab_log ();
void            resolve_tab_print (int, int, int, int);
void            resolve_tab_save (char *);
int             resolve_tab_read (char *);

int             resolve_tab_check_host (char *, int);


extern unsigned int resolve_interval; /* 1 minute */
extern unsigned int resolve_window; /* 10 minutes */

#define __JRESOLVE_H__
#endif
