/*
 *
 * j-chkmail - filtre de messagerie pour sendmail - MILTER
 *
 * Copyright (c) 2001, 2002 Ecole des Mines de Paris
 *
 *  Auteur     : Jose Marcio Martins da Cruz
 *               martins@paris.ensmp.fr
 *
 *  Historique :
 *  Creation     : janvier 2002
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef __JNETWORKS_H_

#ifndef TRUE
# define FALSE	0
# define TRUE 	1
#endif             /* ! true */

#define N_UNKNOWN    0
#define N_LOCAL      1
#define N_FRIEND     4
#define N_DOMAIN     2
#define N_KNOWN      (N_LOCAL | N_FRIEND | N_DOMAIN)

#define IS_FRIEND(class)  (((class) & N_FRIEND) != 0 ? TRUE : FALSE)
#define IS_DOMAIN(class)  (((class) & N_DOMAIN) != 0 ? TRUE : FALSE)
#define IS_LOCAL(class)   (((class) & N_LOCAL) != 0 ? TRUE : FALSE)
#define IS_KNOWN(class)   (((class) & N_KNOWN) != 0 ? TRUE : FALSE)
#define IS_UNKNOWN(class) (((class) & N_KNOWN) == 0 ? TRUE : FALSE)

int                 load_networks_table (char *);

int                 check_host_class (char *);

void                dump_networks_table ();

#define    NET_CLASS(class)  (IS_LOCAL(class) ? "LOCAL" : \
                              IS_DOMAIN(class) ? "DOMAIN" : \
                              IS_FRIEND(class) ? "FRIEND" : "UNKNOWN")


#define __JNETWORKS_H_
#endif
