/*
 *
 * j-chkmail - filtre de messagerie pour sendmail - MILTER
 *
 * Copyright (c) 2001, 2002 Ecole des Mines de Paris
 *
 *  Auteur     : Jose Marcio Martins da Cruz
 *               martins@paris.ensmp.fr
 *
 *  Historique :
 *  Creation     : janvier 2002
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef __JFILTER_H__

#ifndef TRUE
# define FALSE	0
# define TRUE 	1
#endif             /* ! true */


#include "libmilter/mfapi.h"

#include "j-history.h"


#define MLFIPRIV	((struct mlfiPriv *) smfi_getpriv(ctx))


typedef struct rcpt_rec {
  char           *rcpt;
  struct rcpt_rec *next;
} rcpt_rec;



typedef struct mlfiPriv {
  unsigned long   conn_id;
  CONNID_T        id;
  char           *peer_addr;
  char           *peer_name;
  char           *ident;

  int             resolve_res;
  int             resolve_grant;
  int             rej_resolve;

  char           *helohost;

  char           *env_from;
  char           *env_to;
  struct rcpt_rec *env_rcpt;
  int             env_nb_rcpt;

  char           *hdr_mailer;
  char           *hdr_from;
  char           *hdr_to;
  char           *hdr_subject;
  char           *hdr_mime_version;
  int             hdr_content_encoding;

  char           *hdr_boundary;

  bool            hdr_has_from;
  bool            hdr_has_to;
  bool            hdr_has_cc;
  bool            hdr_has_bcc;
  bool            hdr_has_subject;
  bool            hdr_has_mime_version;
  bool            hdr_has_content_type;
  bool            hdr_is_list;
  bool            hdr_has_headers;

  char            body_chunk[SZ_CHUNK];
  int             body_res_scan;
  int             body_scan_state;
  int             body_nb;

  content_field   tcontent;
  content_field  *lcontent;

  int             msg_regex_matches;
  unsigned long   msg_size;
  unsigned long   nb_bytes;

  char           *fname;
  FILE           *fp;
  bool            fp_open;
  bool            save_msg;

#if HAVE_HRTIME_T
  hrtime_t        t_open;
  hrtime_t        t_close;
#else
  time_t          t_open;
  time_t          t_close;
#endif

  int             throttle;
  int             rej_throttle;

  long            flags;
  int             why;
  int             result;
  int             ip_class;
  int             nb_rcpt;
  int             nb_files;
  int             nb_xfiles;
  int             nb_virus;
  int             nb_policy;
  int             host_access;
  int             nb_msgs;
  int             abort;

  int             rej_rcpt;
  int             rej_rcpt_throttle;
  int             rej_regex;
  int             rej_luser;
} mlfiPriv;


#define __JFILTER_H__
#endif
