/*
 *
 * j-chkmail - filtre de messagerie pour sendmail - MILTER
 *
 * Copyright (c) 2001, 2002 Ecole des Mines de Paris
 *
 *  Auteur     : Jose Marcio Martins da Cruz
 *               martins@paris.ensmp.fr
 *
 *  Historique :
 *  Creation     : janvier 2002
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */


#ifndef __JCHKMAIL_H__

#include "version.h"
#include "defs.h"

#include "j-sys.h"


#if !defined(CRLF)
#define CRLF      "\r\n"
#endif

#include "j-decode.h"
#include "j-divers.h"
#include "j-strings.h"
#include "j-buffer.h"
#include "j-fileexp.h"
#include "j-cf.h"
#include "j-config.h"
#include "j-stats.h"
#include "mimelist.h"
#include "scanmail.h"
#include "j-scanregex.h"
#include "j-log.h"
#include "j-signal.h"
#include "j-avserver.h"
#include "j-avchild.h"
#include "j-avclient.h"
#include "j-avdecode.h"
#include "j-main.h"
#include "j-cleanspool.h"
#include "j-msg.h"
#include "j-throttle.h"

#include "j-resolve-tab.h"
#include "j-inet.h"
#include "j-ipc.h"
#include "j-resource.h"
#include "j-db.h"
#include "j-table.h"
#include "j-rdfile.h"
#include "j-users-tab.h"
#include "j-classw-tab.h"
#include "j-nets-tab.h"
#include "j-host-access.h"
#include "j-user-access.h"
#include "j-mailregex.h"
#include "kstats.h"

/* ****************************************************************************
 *                                                                            *
 *                                                                            *
 **************************************************************************** */
#define DEBUG     0

#define SZ_CHUNK         8192

#define MAX_LINE_LEN     2048

#define SIGNATURE        0xF0071234


#ifndef HAVE_MAX
#define max(a,b)   ((a) > (b) ? (a) : (b))
#define min(a,b)   ((a) < (b) ? (a) : (b))
#endif

int             j_chkmail ();

#ifdef DEBUG
#define DPRINTF(arg)     printf(arg)
#else
#define DPRINTF(arg)
#endif

/* ****************************************************************************
 *                                                                            *
 *                                                                            *
 **************************************************************************** */


typedef struct {
  uint32_t        t[2];
  char            id[16];
} CONNID_T;



#define MIME_ENCODE_NONE                  0
#define MIME_ENCODE_7BIT                  0
#define MIME_ENCODE_8BIT                  2
#define MIME_ENCODE_BINARY                3
#define MIME_ENCODE_BASE64                4
#define MIME_ENCODE_QUOTED_PRINTABLE      5
#define MIME_ENCODE_OTHER                 6

/* ****************************************************************************
 *                                                                            *
 *                                                                            *
 **************************************************************************** */

#define INC_STATS_ENCODE                  1
#undef  INC_STATS_ENCODE

#define CHECK_RESOLVE_AT_CONNECT          0
#undef  CHECK_RESOLVE_AT_CONNECT

#define USE_NEW_NETWORKS_TABLE            1
#define USE_NEW_CLASSW_TABLE              1
#define DO_REJECT_BODY_CONTENTS           1
#define DO_CHECK_BODY_BASE64              1

#define RFC2046_MSGS_ARE_XFILES           0
#undef  RFC2046_MSGS_ARE_XFILES

#define __JCHKMAIL_H__
#endif
