/*
 *
 * j-chkmail - filtre de messagerie pour sendmail - MILTER
 *
 * Copyright (c) 2001, 2002 Ecole des Mines de Paris
 *
 *  Auteur     : Jose Marcio Martins da Cruz
 *               martins@paris.ensmp.fr
 *
 *  Historique :
 *  Creation     : janvier 2002
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */


#ifndef __J_CF_H__

/* **************************************************** */

#define     CF_VERSION                            1

#define     CF_DOMAIN                            11
#define     CF_J_HOSTNAME                        12
#define     CF_PRESENCE                          13
#define     CF_USER                              14
#define     CF_GROUP                             15

/* resources */
#define     CF_FILE_DESCRIPTORS                  51
#define     CF_FD_FREE_SOFT                      52
#define     CF_FD_FREE_HARD                      53
#define     CF_USE_SELECT_LIMIT                  54

#define     CF_FILTER_THROTTLE                   60

#define     CF_SOCKET                           101
#define     CF_INET_SOCK                        102
#define     CF_UNIX_SOCK                        103

#define     CF_WARN_SENDER                      201
#define     CF_WARN_RCPT                        202
#define     CF_J_SENDER                         203
#define     CF_J_SUBJECT                        204

#define     CF_LOG_FACILITY                     301
#define     CF_LOG_LEVEL                        302
#define     CF_LOG_ATTACHMENTS                  305
#define     CF_LOG_COUNTERS                     306
#define     CF_DUMP_COUNTERS                    307


#define     CF_STATS_INTERVAL                   351
#define     CF_CLEANUP_INTERVAL                 352
#define     CF_QUARANTINE_MAX_AGE               353

#define     CF_ERROR_MSG_FILE                   401
#define     CF_CW_FILE                          402
#define     CF_NETS_FILE                        403
#define     CF_USERS_FILE                       404
#define     CF_HOST_ACCESS_FILE                 405
#define     CF_USER_ACCESS_FILE                 406
#define     CF_REGEX_FILE                       407
#define     CF_CONF_MODE                        408

#define     CF_AUTO_RELOAD_CONF                 411
#define     CF_AUTO_RELOAD_TABLES               412

#define     CF_WORKDIR                          501
#define     CF_SPOOLDIR                         502
#define     CF_PID_FILE                         503
#define     CF_STATE_FILE                       504
#define     CF_STATS_FILE                       505
#define     CF_XFILES_LOG_FILE                  506
#define     CF_REGEX_LOG_FILE                   507

#define     CF_HISTORY_ENTRIES                  511

/* 
 * Contents checking 
 */
#define     CF_DELETE_EXEC_FILES                601
#define     CF_XFILES                           602
#define     CF_FILE_EXT                         603
#define     CF_FILE_REGEX                       604
#define     CF_XFILE_SAVE_MSG                   605

#define     CF_AV_ACTION                        651
#define     CF_AV_PORT                          652
#define     CF_AV_NB_SERVERS                    653
#define     CF_AV_TYPE                          654
#define     CF_AV_PATH                          655
#define     CF_AV_ARGS                          656
#define     CF_AV_SCOPE                         657
#define     CF_AV_SAVE_MSG                      658
#define     CF_AV_TIMEOUT                       659

#define     CF_CHECK_HEADERS_CONTENT            801
#define     CF_CHECK_SUBJECT_CONTENT            802
#define     CF_CHECK_HELO_CONTENT               803

#define     CF_CHECK_BODY_CONTENT               806
#define     CF_CONTENT_CHECK_SCORE              807
#define     CF_CONTENT_CHECK_SIZE               808
#define     CF_CONTENT_CHECK_ORIGIN             809

#define     CF_DUMP_FOUND_REGEX                 811

#define     CF_ENCODING_BINARY                  851
#define     CF_ENCODING_BASE64                  852
#define     CF_ENCODING_QUOTED_PRINTABLE        853

#define     CF_CHECK_BODY_LINE_LENGTH           860

/*
 * Behaviour checking
 */
#define     CF_CHECK_THROTTLE                  901
#define     CF_CHECK_THROTTLE_CONN             902
#define     CF_CHECK_THROTTLE_RCPT             903

#define     CF_RCPT_THROTTLE_FROM_DOMAIN       908
#define     CF_RCPT_THROTTLE_FROM_LOCAL        909
#define     CF_RCPT_THROTTLE_FROM_FRIEND       910
#define     CF_RCPT_THROTTLE_FROM_OUTSIDE      911

#define     CF_CONN_THROTTLE_FROM_DOMAIN       912
#define     CF_CONN_THROTTLE_FROM_LOCAL        913
#define     CF_CONN_THROTTLE_FROM_FRIEND       914
#define     CF_CONN_THROTTLE_FROM_OUTSIDE      915

#define     CF_RES_THROTTLE_FROM_DOMAIN        916
#define     CF_RES_THROTTLE_FROM_LOCAL         917
#define     CF_RES_THROTTLE_FROM_FRIEND        918
#define     CF_RES_THROTTLE_FROM_OUTSIDE       919

#define     CF_CHECK_NB_RCPT                   931

#define     CF_MAX_RCPT_FROM_DOMAIN            932
#define     CF_MAX_RCPT_FROM_LOCAL             933
#define     CF_MAX_RCPT_FROM_FRIEND            934
#define     CF_MAX_RCPT_FROM_OUTSIDE           935

#define     CF_RESOLVE_FAIL                   1001
#define     CF_RESOLVE_FORGED                 1002
#define     CF_RESOLVE_ACCEPT_06H             1003
#define     CF_RESOLVE_ACCEPT_12H             1004
#define     CF_RESOLVE_ACCEPT_18H             1005
#define     CF_RESOLVE_ACCEPT_24H             1006

#define     CF_NO_TO_HEADERS                  1101
#define     CF_NO_FROM_HEADERS                1102
#define     CF_NO_SUBJECT_HEADER              1103
#define     CF_NO_HEADERS                     1104

#define     CF_CHECK_USER_ACCESS              1105
#define     CF_DEFAULT_USER_ACCESS            1106
#define     CF_CHECK_LOCAL_USERS              1107

#define     CF_CHECK_DOMAIN_ADDRESS           1201

#define     CF_OUTLOOK                        1202
#define     CF_OUTLOOK_LOCAL                  1203
#define     CF_OUTLOOK_DOMAIN                 1204
#define     CF_OUTLOOK_FRIEND                 1205


/* **************************************************** */

#define     OPT_NO                0
#define     OPT_YES               1

#define     OPT_OK                0
#define     OPT_REJECT            1
#define     OPT_WARN              2
#define     OPT_DISCARD           3

#define     OPT_TEMPFAIL          2

#define     OPT_SHOW              0
#define     OPT_HIDE              1

#define     OPT_SYSTEM            0
#define     OPT_SENDMAIL          1

#define     OPT_OTHER           255

#define     OPT_SENDER            0

#define     OPT_SUBJECT           0

#define     AV_NONE               0
#define     AV_USER               1
#define     AV_UVSCAN             2
#define     AV_SOPHOS             3
#define     AV_TREND              4

#define     OPT_TEXT              0
#define     OPT_DB                1

#define     OPT_ALL               0
#define     OPT_ATTACHMENTS       1

#define     OPT_ALL               0
#define     OPT_UNKNOWN           1


/* **************************************************** */

int             configure (char *, int);
int             cf_read_file (char *);

int             cf_init ();

void            cf_clear_values ();
void            cf_defaults ();

void            cf_dump ();

int             cf_set_val (int id, char *val);

int             cf_set_str_val (int id, char *val);
int             cf_append_str_val (int id, char *val);

int             cf_set_int_val (int id, int val);
int             cf_set_enum_val (int id, int val);

char           *cf_get_str (int id);
int             cf_get_int (int id);

extern char    *conf_file;
extern int      log_level;
extern int      log_facility;

extern unsigned int statistics_interval;

extern char     sm_sock[];

extern char     domain[];

extern int      priority;

#define __J_CF_H__
#endif
