#! /usr/bin/perl -w

#
# exit values :
#    0 : no problem
#    1 : program error
#    2 : message contains virus, ...
#    3 : message violates site policy ...
# 
# 
use strict;

sub AVRES_OK { 0; }
sub AVRES_VIRUS { 1; }
sub AVRES_ERROR { 2; }
sub AVRES_POLICY { 3; }

# words I don't want to find inside message ...
my @unwanted = ("viagra", "freesex");

my $result = AVRES_OK;

my %HEADERS = ();

my $line;

# Let's skip Unix From line ...
if (defined($line = <>)) {

}

my $header = 1;
my ($nl, $nh, $nhl, $nb) = (0, 0, 0, 0);
my ($attr, $value);

# Let's read message
while ($line = <>) {
  chomp($line);

  $nl++;

  # First of all, header processing
  if ($header) {
    # Empty line -> end of header
    if ($line =~ /^$/) {
      $header = 0;
    } else {
      if (! ($line =~ /^[\ \t]/)) {
	($attr, $value) = split(":", $line, 2);
	eff_blancs($attr);
	eff_blancs($value);

	$HEADERS{$attr} = $value;
	$nh++;
      } else {
	$value .= "\n" . $line;
	$HEADERS{$attr} = $value;
      }
      $nhl++;
    }
    next;
  }

  # Body processing
  $nb++;
  foreach (@unwanted) {
    if ($line =~ /$_/) {
      printf "***\n";
      printf "***  Message body contains unwanted word ($_) at line $nl\n";
      printf "***\n";
      $result = AVRES_POLICY;
      last;
    }
  }
}

if (0) {
  printf "\n";
  foreach (sort keys %HEADERS) {
    printf " -> %-25s : %s\n", $_, $HEADERS{$_};
  }
}

exit $result;

# ---------------------------------------------------------
#
#
sub eff_blancs {
  return "" if $#_ < 0 || length($_[0]) < 1;
  $_[0] =~ s/^\ +|\ +$//g;
  return $_[0];
}

