/*
 *
 * j-chkmail - filtre de messagerie pour sendmail - MILTER
 *
 * Copyright (c) 2001, 2002 Ecole des Mines de Paris
 *
 *  Auteur     : Jose Marcio Martins da Cruz
 *               martins@paris.ensmp.fr
 *
 *  Historique :
 *  Creation     : janvier 2002
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

/*
# Sample j-chkmail user filter
#
# exit values :
#    0 : no problem
#    1 : program error
#    2 : message contains virus, ...
#    3 : message violates site policy ...
# 
# 
*/

#define         AVRES_OK      0
#define         AVRES_VIRUS   1
#define         AVRES_ERROR   2
#define         AVRES_POLICY  3


int       check_header(char *);
int       check_body(char *);

int
main (argc, argv)
     int                 argc;
     char              **argv;
{

  char                buf[1024];
  int                 nl = 0, n, nhead = 0, nbody = 0;
  FILE               *fin;

  int                 body = 0;

  int                 result = AVRES_OK;

  if (argc < 2) {
    fprintf (stderr, "Error : too few parameters\n");
    exit (AVRES_ERROR);
  }

  if ((fin = fopen (argv[1], "r")) == NULL) {
    fprintf (stderr, "Error : can't open input file \n");
    exit (AVRES_ERROR);
  }

  /* Skip From line */
  if (fgets (buf, sizeof (buf), fin) == NULL) {
    exit (AVRES_ERROR);
  }

  while ((fgets (buf, sizeof (buf), fin)) != NULL) {
    nl++;

    n = strcspn(buf, "\r\n");
    buf[n] = '\0';

    if (strlen(buf) == 0) {
      body = 1;
      continue;
    }

    if (body) {
      nbody ++;
      if (check_body(buf))
	result = AVRES_POLICY;
    } else {
      nhead++;
      if (check_header(buf))
	result = AVRES_POLICY;
    }
  }

  fclose (fin);

#if 0
  printf (" File %s contains %d lines\n", argv[1], nl);
  printf (" Head : %d\n", nhead);
  printf (" Body : %d\n", nbody);
#endif

  exit (result);
}


int
check_header(s)
     char *s;
{
  return 0;
}

int 
check_body(s)
     char *s;
{
  char *word = "freesex";

  if (strstr(s, word) != (char *) NULL) {
    printf("***\r\n");
    printf("*** Message contents violates site policy : %s\r\n", word);
    printf("***\r\n");
    return 1;
  }
  return 0;
}
