#! /usr/bin/perl -w

use strict;
use Time::Local;

my $fname = "/var/jchkmail/j-files";

my %STATS = ();
my %EXT   = ();
my %XSTAT = ();
my %DSTAT = ();

my %CLK2DAY = ();

my $tlast = 0;

my $now = time();

my $hostname = `hostname`;
chomp $hostname;

my $date = `date`;
chomp $date;

my $ext;

my $ok = 0;

open FIN, $fname or die "*** Can't open input file $fname";

my ($clk, $conn, $type, $mime, $xfile);
while (<FIN>) {
  chomp;
  ($clk, $conn, $type, $mime, $xfile) = split (" ", $_, 5);;
  next if $type =! /XXX/;
  my $cle = clock2day($clk);

  $cle = int ($clk / 86400);
  $CLK2DAY{$cle} = clock2day($clk);

  $tlast = $cle if $cle > $tlast;

  print $_, "\n" if 0;

  if (defined($xfile) && ($xfile =~ /\.([^.]*)$/)) {
    my $ext = $1;

    $ext =~ tr/A-Z/a-z/;

    $EXT{$ext} = 1;

    push @{$STATS{$cle}}, $ext;

    $XSTAT{$cle}{$ext}++;

    if (exists($DSTAT{$cle})) {
      $DSTAT{$cle}++;
    } else {
      $DSTAT{$cle} = 1;
    }
    $ok = 1;
  }
}
close FIN;

if (!$ok) {
  print <<TXT2;

  $date

  No records found

TXT2
  exit 1;
}

print <<TXT1;

  j-chkmail weekly report on $date

  Unsafe files detected on server : $hostname

  Week ending on $CLK2DAY{$tlast}

TXT1

my ($cle, $total);

printf "----------------------------------------------------------|------\n";
printf "         ";
foreach $cle (sort keys %XSTAT) {
  next if $cle + 7 <= $tlast;
  printf " %5s ", $CLK2DAY{$cle};
}
printf "|\n";

printf "----------------------------------------------------------|------\n";
foreach $ext (sort keys %EXT) {
  my $nbext;
  my $line = "";
  $line = sprintf  "* .%-5s ", $ext;
  foreach $cle (sort keys %XSTAT) {
    next if $cle + 7 <= $tlast;
    my $n = 0;
    $n = $XSTAT{$cle}{$ext} if exists($XSTAT{$cle}{$ext});
    $line .= sprintf " %5d ", $n;
    $nbext += $n;
  }
  printf "%s| %5d \n", $line, $nbext if $nbext > 0;
  $total += $nbext;
}

printf "----------------------------------------------------------|------\n";
printf "  TOTAL  ";

foreach $cle (sort keys %XSTAT) {
  next if $cle + 7 <= $tlast;
  printf " %5d ", $DSTAT{$cle};
}
printf "| %5d\n", $total;

printf "\n\n";

exit 0;



sub clock2day {
  my ($c, undef) = @_;
  return 0 if ! defined($c);

  my ($sec,$min,$hour,$mday,$mon,$year,$wday,$yday) = gmtime($c);

  return sprintf "%02d/%02d", $mday, $mon + 1;
  return sprintf "%02d/%02d", $mon + 1, $mday;
  return sprintf "%02d/%02d", $mday, $mon + 1;
}

sub clock2month {
  my ($c, undef) = @_;
  return 0 if ! defined($c);

  my ($sec,$min,$hour,$mday,$mon,$year,$wday,$yday) = gmtime($c);
  return $mon + 1;
}
