#! //usr/local/perl/bin/perl -w

# this is for after install
use lib qw( /opt/rrdtool/lib/perl ../lib/perl );

$end = 0;

if ($end < 0) {
	$si = sprintf "%dh", $end - 4;
	$sf = sprintf "%dh", $end;
} else {
  $si = "-4h";
  $sf = "now";
}

use RRDs;

my $RRD_DIR = "rrd";
my $IMG_DIR = "images";


RRDs::graph ("$IMG_DIR/charge.hour.png",
						 "--title", "Charge (4 heures)",
						 "--start", $si,
             "--end",   $sf,
						 "--lower-limit", 0,
						 "--imgformat", "PNG",
						 "--vertical-label", " units / 5 min ",
						 "--width", 300, "--height", 150,
						 "DEF:conn=$RRD_DIR/charge.rrd:conn:AVERAGE",
						 "DEF:abort=$RRD_DIR/charge.rrd:abort:AVERAGE",
						 "DEF:close=$RRD_DIR/charge.rrd:close:AVERAGE",
						 "DEF:msgs=$RRD_DIR/charge.rrd:msgs:AVERAGE",
						 "DEF:to=$RRD_DIR/charge.rrd:to:AVERAGE",
						 "DEF:attach=$RRD_DIR/charge.rrd:attach:AVERAGE",
             "CDEF:a=conn,1,*",  
             "CDEF:b=abort,1,*",
             "CDEF:c=close,1,*",
             "CDEF:d=msgs,1,*",
             "CDEF:e=to,1,*",
             "CDEF:f=attach,1,*",
						 "LINE2:a#0000FF:Connexions",
						 "LINE2:b#FF0000:Abort",
						 "LINE2:c#00CC00:Close",
						 "LINE2:d#008888:Messages",
						 "LINE2:e#888800:To",
						 "LINE2:f#000000:Attachments");

RRDs::graph ("$IMG_DIR/charge.day.png",
						 "--title", "Charge (1 jour)",
						 "--start", "-1day",
						 "--lower-limit", 0,
						 "--imgformat", "PNG",
						 "--vertical-label", " units / heure ",
						 "--width", 300, "--height", 150,
						 "DEF:conn=$RRD_DIR/charge.rrd:conn:AVERAGE",
						 "DEF:abort=$RRD_DIR/charge.rrd:abort:AVERAGE",
						 "DEF:close=$RRD_DIR/charge.rrd:close:AVERAGE",
						 "DEF:msgs=$RRD_DIR/charge.rrd:msgs:AVERAGE",
						 "DEF:to=$RRD_DIR/charge.rrd:to:AVERAGE",
						 "DEF:attach=$RRD_DIR/charge.rrd:attach:AVERAGE",
             "CDEF:a=conn,12,*",
             "CDEF:b=abort,12,*",
             "CDEF:c=close,12,*",
             "CDEF:d=msgs,12,*",
             "CDEF:e=to,12,*",
             "CDEF:f=attach,12,*",
						 "LINE2:a#0000FF:Connexions",
						 "LINE2:b#FF0000:Abort",
						 "LINE2:c#00CC00:Close",
						 "LINE2:d#008888:Messages",
						 "LINE2:e#888800:To",
						 "LINE2:f#000000:Attachments");

RRDs::graph ("$IMG_DIR/charge.week.png",
						 "--title", "Charge (1 semaine)",
						 "--start", "-7day",
						 "--lower-limit", 0,
						 "--imgformat", "PNG",
						 "--vertical-label", " units / heure ",
						 "--width", 300, "--height", 150,
						 "DEF:conn=$RRD_DIR/charge.rrd:conn:AVERAGE",
						 "DEF:abort=$RRD_DIR/charge.rrd:abort:AVERAGE",
						 "DEF:close=$RRD_DIR/charge.rrd:close:AVERAGE",
						 "DEF:msgs=$RRD_DIR/charge.rrd:msgs:AVERAGE",
						 "DEF:to=$RRD_DIR/charge.rrd:to:AVERAGE",
						 "DEF:attach=$RRD_DIR/charge.rrd:attach:AVERAGE",
             "CDEF:a=conn,12,*",
             "CDEF:b=abort,12,*",
             "CDEF:c=close,12,*",
             "CDEF:d=msgs,12,*",
             "CDEF:e=to,12,*",
             "CDEF:f=attach,12,*",
						 "LINE2:a#0000FF:Connexions",
						 "LINE2:b#FF0000:Abort",
						 "LINE2:c#00CC00:Close",
						 "LINE2:d#008888:Messages",
						 "LINE2:e#888800:To",
						 "LINE2:f#000000:Attachments");

RRDs::graph ("$IMG_DIR/charge.month.png",
						 "--title", "Charge (1 mois)",
						 "--start", "-1month",
						 "--lower-limit", 0,
						 "--imgformat", "PNG",
						 "--vertical-label", " units / heure ",
						 "--width", 300, "--height", 150,
						 "DEF:conn=$RRD_DIR/charge.rrd:conn:AVERAGE",
						 "DEF:abort=$RRD_DIR/charge.rrd:abort:AVERAGE",
						 "DEF:close=$RRD_DIR/charge.rrd:close:AVERAGE",
						 "DEF:msgs=$RRD_DIR/charge.rrd:msgs:AVERAGE",
						 "DEF:to=$RRD_DIR/charge.rrd:to:AVERAGE",
						 "DEF:attach=$RRD_DIR/charge.rrd:attach:AVERAGE",
             "CDEF:a=conn,12,*",
             "CDEF:b=abort,12,*",
             "CDEF:c=close,12,*",
             "CDEF:d=msgs,12,*",
             "CDEF:e=to,12,*",
             "CDEF:f=attach,12,*",
						 "LINE2:a#0000FF:Connexions",
						 "LINE2:b#FF0000:Abort",
						 "LINE2:c#00CC00:Close",
						 "LINE2:d#008888:Messages",
						 "LINE2:e#888800:To",
						 "LINE2:f#000000:Attachments");


RRDs::graph ("$IMG_DIR/rejets.hour.png",
						 "--title", "Rejets (4 heures)",
						 "--start", $si,
             "--end",   $sf,
						 "--lower-limit", 0,
						 "--imgformat", "PNG",
						 "--vertical-label", " units / 5 min ",
						 "--width", 300, "--height", 150,
						 "DEF:exes=$RRD_DIR/rejets.rrd:exes:AVERAGE",
						 "DEF:no_from=$RRD_DIR/rejets.rrd:no_from:AVERAGE",
						 "DEF:no_to=$RRD_DIR/rejets.rrd:no_to:AVERAGE",
						 "DEF:luser=$RRD_DIR/rejets.rrd:luser:AVERAGE",
						 "DEF:outlook=$RRD_DIR/rejets.rrd:outlook:AVERAGE",
             "CDEF:a=exes,1,*",
             "CDEF:b=no_from,1,*",
             "CDEF:c=no_to,1,*",
             "CDEF:d=luser,1,*",
             "CDEF:e=outlook,1,*",
						 "LINE2:a#0000FF:Executables",
						 "LINE2:b#FF0000:Sans champs From",
						 "LINE2:c#00CC00:Sans champs To",
						 "LINE2:d#888800:Local User",
						 "LINE2:e#000000:Outlook Express");

RRDs::graph ("$IMG_DIR/rejets.day.png",
						 "--title", "Rejets (1 jour)",
						 "--start", "-1day",
						 "--lower-limit", 0,
						 "--imgformat", "PNG",
						 "--vertical-label", " units / heure ",
						 "--width", 300, "--height", 150,
						 "DEF:exes=$RRD_DIR/rejets.rrd:exes:AVERAGE",
						 "DEF:no_from=$RRD_DIR/rejets.rrd:no_from:AVERAGE",
						 "DEF:no_to=$RRD_DIR/rejets.rrd:no_to:AVERAGE",
						 "DEF:luser=$RRD_DIR/rejets.rrd:luser:AVERAGE",
						 "DEF:outlook=$RRD_DIR/rejets.rrd:outlook:AVERAGE",
             "CDEF:a=exes,12,*",
             "CDEF:b=no_from,12,*",
             "CDEF:c=no_to,12,*",
             "CDEF:d=luser,12,*",
             "CDEF:e=outlook,12,*",
						 "LINE2:a#0000FF:Executables",
						 "LINE2:b#FF0000:Sans champs From",
						 "LINE2:c#00CC00:Sans champs To",
						 "LINE2:d#888800:Local User",
						 "LINE2:e#000000:Outlook Express");

RRDs::graph ("$IMG_DIR/rejets.week.png",
						 "--title", "Rejets (1 semaine)",
						 "--start", "-7day",
						 "--lower-limit", 0,
						 "--imgformat", "PNG",
						 "--vertical-label", " units / heure ",
						 "--width", 300, "--height", 150,
						 "DEF:exes=$RRD_DIR/rejets.rrd:exes:AVERAGE",
						 "DEF:no_from=$RRD_DIR/rejets.rrd:no_from:AVERAGE",
						 "DEF:no_to=$RRD_DIR/rejets.rrd:no_to:AVERAGE",
						 "DEF:luser=$RRD_DIR/rejets.rrd:luser:AVERAGE",
						 "DEF:outlook=$RRD_DIR/rejets.rrd:outlook:AVERAGE",
             "CDEF:a=exes,12,*",
             "CDEF:b=no_from,12,*",
             "CDEF:c=no_to,12,*",
             "CDEF:d=luser,12,*",
             "CDEF:e=outlook,12,*",
						 "LINE2:a#0000FF:Executables",
						 "LINE2:b#FF0000:Sans champs From",
						 "LINE2:c#00CC00:Sans champs To",
						 "LINE2:d#888800:Local User",
						 "LINE2:e#000000:Outlook Express");

RRDs::graph ("$IMG_DIR/rejets.month.png",
						 "--title", "Rejets (1 mois)",
						 "--start", "-1month",
						 "--lower-limit", 0,
						 "--imgformat", "PNG",
						 "--vertical-label", " units / heure ",
						 "--width", 300, "--height", 150,
						 "DEF:exes=$RRD_DIR/rejets.rrd:exes:AVERAGE",
						 "DEF:no_from=$RRD_DIR/rejets.rrd:no_from:AVERAGE",
						 "DEF:no_to=$RRD_DIR/rejets.rrd:no_to:AVERAGE",
						 "DEF:luser=$RRD_DIR/rejets.rrd:luser:AVERAGE",
						 "DEF:outlook=$RRD_DIR/rejets.rrd:outlook:AVERAGE",
             "CDEF:a=exes,12,*",
             "CDEF:b=no_from,12,*",
             "CDEF:c=no_to,12,*",
             "CDEF:d=luser,12,*",
             "CDEF:e=outlook,12,*",
						 "LINE2:a#0000FF:Executables",
						 "LINE2:b#FF0000:Sans champs From",
						 "LINE2:c#00CC00:Sans champs To",
						 "LINE2:d#888800:Local User",
						 "LINE2:e#000000:Outlook Express");

exit 0;




