.\" Automatically generated by Pod::Man version 1.02
.\" Thu Dec 27 02:04:13 2001
.\"
.\" Standard preamble:
.\" ======================================================================
.de Sh \" Subsection heading
.br
.if t .Sp
.ne 5
.PP
\fB\\$1\fR
.PP
..
.de Sp \" Vertical space (when we can't use .PP)
.if t .sp .5v
.if n .sp
..
.de Ip \" List item
.br
.ie \\n(.$>=3 .ne \\$3
.el .ne 3
.IP "\\$1" \\$2
..
.de Vb \" Begin verbatim text
.ft CW
.nf
.ne \\$1
..
.de Ve \" End verbatim text
.ft R

.fi
..
.\" Set up some character translations and predefined strings.  \*(-- will
.\" give an unbreakable dash, \*(PI will give pi, \*(L" will give a left
.\" double quote, and \*(R" will give a right double quote.  | will give a
.\" real vertical bar.  \*(C+ will give a nicer C++.  Capital omega is used
.\" to do unbreakable dashes and therefore won't be available.  \*(C` and
.\" \*(C' expand to `' in nroff, nothing in troff, for use with C<>
.tr \(*W-|\(bv\*(Tr
.ds C+ C\v'-.1v'\h'-1p'\s-2+\h'-1p'+\s0\v'.1v'\h'-1p'
.ie n \{\
.    ds -- \(*W-
.    ds PI pi
.    if (\n(.H=4u)&(1m=24u) .ds -- \(*W\h'-12u'\(*W\h'-12u'-\" diablo 10 pitch
.    if (\n(.H=4u)&(1m=20u) .ds -- \(*W\h'-12u'\(*W\h'-8u'-\"  diablo 12 pitch
.    ds L" ""
.    ds R" ""
.    ds C` `
.    ds C' '
'br\}
.el\{\
.    ds -- \|\(em\|
.    ds PI \(*p
.    ds L" ``
.    ds R" ''
'br\}
.\"
.\" If the F register is turned on, we'll generate index entries on stderr
.\" for titles (.TH), headers (.SH), subsections (.Sh), items (.Ip), and
.\" index entries marked with X<> in POD.  Of course, you'll have to process
.\" the output yourself in some meaningful fashion.
.if \nF \{\
.    de IX
.    tm Index:\\$1\t\\n%\t"\\$2"
.    .
.    nr % 0
.    rr F
.\}
.\"
.\" For nroff, turn off justification.  Always turn off hyphenation; it
.\" makes way too many mistakes in technical documents.
.hy 0
.if n .na
.\"
.\" Accent mark definitions (@(#)ms.acc 1.5 88/02/08 SMI; from UCB 4.2).
.\" Fear.  Run.  Save yourself.  No user-serviceable parts.
.bd B 3
.    \" fudge factors for nroff and troff
.if n \{\
.    ds #H 0
.    ds #V .8m
.    ds #F .3m
.    ds #[ \f1
.    ds #] \fP
.\}
.if t \{\
.    ds #H ((1u-(\\\\n(.fu%2u))*.13m)
.    ds #V .6m
.    ds #F 0
.    ds #[ \&
.    ds #] \&
.\}
.    \" simple accents for nroff and troff
.if n \{\
.    ds ' \&
.    ds ` \&
.    ds ^ \&
.    ds , \&
.    ds ~ ~
.    ds /
.\}
.if t \{\
.    ds ' \\k:\h'-(\\n(.wu*8/10-\*(#H)'\'\h"|\\n:u"
.    ds ` \\k:\h'-(\\n(.wu*8/10-\*(#H)'\`\h'|\\n:u'
.    ds ^ \\k:\h'-(\\n(.wu*10/11-\*(#H)'^\h'|\\n:u'
.    ds , \\k:\h'-(\\n(.wu*8/10)',\h'|\\n:u'
.    ds ~ \\k:\h'-(\\n(.wu-\*(#H-.1m)'~\h'|\\n:u'
.    ds / \\k:\h'-(\\n(.wu*8/10-\*(#H)'\z\(sl\h'|\\n:u'
.\}
.    \" troff and (daisy-wheel) nroff accents
.ds : \\k:\h'-(\\n(.wu*8/10-\*(#H+.1m+\*(#F)'\v'-\*(#V'\z.\h'.2m+\*(#F'.\h'|\\n:u'\v'\*(#V'
.ds 8 \h'\*(#H'\(*b\h'-\*(#H'
.ds o \\k:\h'-(\\n(.wu+\w'\(de'u-\*(#H)/2u'\v'-.3n'\*(#[\z\(de\v'.3n'\h'|\\n:u'\*(#]
.ds d- \h'\*(#H'\(pd\h'-\w'~'u'\v'-.25m'\f2\(hy\fP\v'.25m'\h'-\*(#H'
.ds D- D\\k:\h'-\w'D'u'\v'-.11m'\z\(hy\v'.11m'\h'|\\n:u'
.ds th \*(#[\v'.3m'\s+1I\s-1\v'-.3m'\h'-(\w'I'u*2/3)'\s-1o\s+1\*(#]
.ds Th \*(#[\s+2I\s-2\h'-\w'I'u*3/5'\v'-.3m'o\v'.3m'\*(#]
.ds ae a\h'-(\w'a'u*4/10)'e
.ds Ae A\h'-(\w'A'u*4/10)'E
.    \" corrections for vroff
.if v .ds ~ \\k:\h'-(\\n(.wu*9/10-\*(#H)'\s-2\u~\d\s+2\h'|\\n:u'
.if v .ds ^ \\k:\h'-(\\n(.wu*10/11-\*(#H)'\v'-.4m'^\v'.4m'\h'|\\n:u'
.    \" for low resolution devices (crt and lpr)
.if \n(.H>23 .if \n(.V>19 \
\{\
.    ds : e
.    ds 8 ss
.    ds o a
.    ds d- d\h'-1'\(ga
.    ds D- D\h'-1'\(hy
.    ds th \o'bp'
.    ds Th \o'LP'
.    ds ae ae
.    ds Ae AE
.\}
.rm #[ #] #H #V #F C
.\" ======================================================================
.\"
.IX Title "README 1"
.TH README 1 "0.4.8r2" "2001-11-28" """Html2Wml Documentation"""
.UC
.SH "NAME"
Html2Wml \*(-- Program that can convert \s-1HTML\s0 pages to \s-1WML\s0 pages
.SH "SYNOPSIS"
.IX Header "SYNOPSIS"
Html2Wml can be used as either a shell command: 
.PP
.Vb 1
\&  $ html2wml file.html
.Ve
or as a \s-1CGI:\s0 
.PP
.Vb 1
\&  /cgi-bin/html2wml.cgi?url=/index.html
.Ve
In both cases, the file can be either a local file or a \s-1URL\s0. 
.SH "DESCRIPTION"
.IX Header "DESCRIPTION"
Html2Wml converts \s-1HTML\s0 pages to \s-1WML\s0 decks, suitable for being viewed on a
Wap device. The program can be launched from a shell to statically convert 
a set of pages, or as a \s-1CGI\s0 to convert a particular (potentially dynamic) 
\&\s-1HTML\s0 resource. 
.PP
Althought the result is not guarantied to be valid \s-1WML\s0, it should be the 
case for most pages. Good \s-1HTML\s0 pages will most probably produce valid 
\&\s-1WML\s0 decks. To check and correct your pages, you can use W3C's softwares: 
the \fI\s-1HTML\s0 Validator\fR, available online at http://validator.w3.org 
and \fI\s-1HTML\s0 Tidy\fR, written by Dave Raggett. 
.PP
Html2Wml provides the following features: 
.Ip "\(bu" 4
translation of the links
.Ip "\(bu" 4
limitation of the cards size by splitting the result into several cards
.Ip "\(bu" 4
inclusion of files (similar to the \s-1SSI\s0)
.Ip "\(bu" 4
compilation of the result (using the \s-1WML\s0 Tools, see the section on "LINKS")
.Ip "\(bu" 4
a debug mode to check the result using validation functions
.SH "OPTIONS"
.IX Header "OPTIONS"
Please note that most of these options are also available when calling 
Html2Wml as a \s-1CGI\s0. In this case, boolean options are given the value 
\&\*(L"1\*(R" or \*(L"0\*(R", and other options simply receive the value they 
expect. For example, \f(CW\*(C`\-\-ascii\*(C'\fR becomes \f(CW\*(C`?ascii=1\*(C'\fR or \f(CW\*(C`?a=1\*(C'\fR. See the 
file \fIt/form.html\fR for an example on how to call Html2Wml as a \s-1CGI\s0. 
.Sh "Conversion Options"
.IX Subsection "Conversion Options"
.Ip "\-a, \-\-ascii" 4
.IX Item "-a, --ascii"
When this option is on, named \s-1HTML\s0 entities are converted to \s-1US-ASCII\s0
characters using the same 7 bit approximations as Lynx. For example, 
\&\f(CW\*(C`&copy;\*(C'\fR is translated to \*(L"(c)\*(R", and \f(CW\*(C`&szlig;\*(C'\fR is translated to \*(L"ss\*(R". 
This option is off by default.  
.Ip "\*(--collapse, \-\-nocollapse" 4
.IX Item "collapse, --nocollapse"
This option tells Html2Wml to collapse redundant whitespaces,
tabulations, carriage returns, lines feeds and empty paragraphs. The aim
is to reduce the size of the \s-1WML\s0 document as much as possible. Collapsing
empty paragraphs is necessary for two reasons. First, this avoids empty
screens (and on a device with only 4 lines of display, an empty screen can 
be quite ennoying). Second, Html2wml creates many empty paragraphs when
converting, because of the way the syntax reconstructor is programmed.
Deleting these empty paragraphs is necessary like cleaning the kitchen :\-)
.Sp
If this really bother you, you can desactivate this behaviour with the
\&\fB\*(--nocollapse\fR option. 
.Ip "\*(--ignore-images" 4
.IX Item "ignore-images"
This option tells Html2Wml to completly ignore all image links. 
.Ip "\*(--img-alt-text, \-\-noimg-alt-text" 4
.IX Item "img-alt-text, --noimg-alt-text"
This option tells Html2Wml to replace the image tags with their 
corresponding alternative text (as with a text mode web browser). 
This option is on by default. 
.Ip "\*(--linearize, \-\-nolinearize" 4
.IX Item "linearize, --nolinearize"
This option is on by default. This makes Html2Wml flattens the \s-1HTML\s0
tables (they are linearized), as Lynx does. I think this is better than
trying to use the native \s-1WML\s0 tables. First, they have extremely limited
features and possibilities compared to \s-1HTML\s0 tables. In particular, they
can't be nested. In fact this is normal because Wap devices are not
supposed to have a big \s-1CPU\s0 running at some zillions-hertz, and the
calculations needed to render the tables are the most complicated and
CPU-hogger part of \s-1HTML\s0. 
.Sp
Second, as they can't be nested, and as typical \s-1HTML\s0 pages heavily use 
imbricated tables to create their layout, it's impossible to decide which 
one could be kept. So the best thing is to keep none of them. 
.Sp
\&\fB[Note]\fR Although you can desactivate this behaviour, and although 
there is internal support for tables, the unlinearized mode has not 
been heavily tested with nested tables, and it may produce unexpected 
results. 
.Ip "\-n, \-\-numeric-non-ascii" 4
.IX Item "-n, --numeric-non-ascii"
This option tells Html2wml to convert all non-ASCII characters to 
numeric entities, i.e., "e\*'" becomes \f(CW\*(C`&#233;\*(C'\fR, and "\*8" 
becomes \f(CW\*(C`&#223;\*(C'\fR.  By default, this option is off. 
.Ip "\-p, \-\-nopre" 4
.IX Item "-p, --nopre"
This options tells Html2Wml not to use the <pre>
tag. This option was added because the compiler from \s-1WML\s0 Tools 0.0.4 
doesn't support this tag. 
.Sh "Links Reconstruction Options"
.IX Subsection "Links Reconstruction Options"
.Ip "\*(--hreftmpl=\fI\s-1TEMPLATE\s0\fR" 4
.IX Item "hreftmpl=TEMPLATE"
This options sets the template that will be used to reconstruct the
\&\f(CW\*(C`href\*(C'\fR\-type links. See the section on "LINKS RECONSTRUCTION" for more information. 
.Ip "\*(--srctmpl=\fI\s-1TEMPLATE\s0\fR" 4
.IX Item "srctmpl=TEMPLATE"
This option sets the template that will be used to reconstruct the
\&\f(CW\*(C`src\*(C'\fR\-type links. See the section on "LINKS RECONSTRUCTION" for more information. 
.Sh "Splitting Options"
.IX Subsection "Splitting Options"
.Ip "\-s, \-\-max-card-size=\fI\s-1SIZE\s0\fR" 4
.IX Item "-s, --max-card-size=SIZE"
This option allows you to limit the size (in bytes) of the generated
cards. Default is 1,500 bytes, which should be small enought to be loaded
on most Wap devices. See the section on "DECK SPLITTING" for more information. 
.Ip "\-t, \-\-card-split-threshold=\fI\s-1SIZE\s0\fR" 4
.IX Item "-t, --card-split-threshold=SIZE"
This option sets the threshold of the split event, which can occur 
when the size of the current card is between \f(CW\*(C`max\-card\-size\*(C'\fR \- 
\&\f(CW\*(C`card\-split\-threshold\*(C'\fR and \f(CW\*(C`max\-card\-size\*(C'\fR. Default value is 
50. See the section on "DECK SPLITTING" for more information. 
.Ip "\*(--next-card-label=\fI\s-1STRING\s0\fR" 4
.IX Item "next-card-label=STRING"
This options sets the label of the link that points to the next card. 
Default is \*(L"[&gt;&gt;]\*(R", which whill be rendered as "[>>]". 
.Ip "\*(--prev-card-label=\fI\s-1STRING\s0\fR" 4
.IX Item "prev-card-label=STRING"
This options sets the label of the link that points to the previous card. 
Default is \*(L"[&lt;&lt;]\*(R", which whill be rendered as "[<<]". 
.Sh "\s-1HTTP\s0 Authentication"
.IX Subsection "HTTP Authentication"
.Ip "\-U, \-\-http-user=\fI\s-1USERNAME\s0\fR" 4
.IX Item "-U, --http-user=USERNAME"
Use this option to set the username for an authenticated request. 
.Ip "\-P, \-\-http-passwd=\fI\s-1PASSWORD\s0\fR" 4
.IX Item "-P, --http-passwd=PASSWORD"
Use this option to set the password for an authenticated request. 
.Sh "Output Options"
.IX Subsection "Output Options"
.Ip "\-k, \-\-compile" 4
.IX Item "-k, --compile"
Setting this option tells Html2Wml to use the compiler from \s-1WML\s0 Tools
to compile the \s-1WML\s0 deck. If you want to create a real Wap site, you should
seriously use this option in order to reduce the size of the \s-1WML\s0 decks. 
Remember that Wap devices have very little amount of memory. If this is
not enought, use the splitting options. 
.Sp
Take a look in \fIwml_compilation/\fR for more information on how to use 
a \s-1WML\s0 compiler with Html2Wml. 
.Ip "\-o, \-\-output" 4
.IX Item "-o, --output"
Use this option (in shell mode) to specify an output file. 
By default, Html2Wml prints the result to standard output. 
.Sh "Debugging Options"
.IX Subsection "Debugging Options"
.Ip "\-d, \-\-debug[=\fI\s-1LEVEL\s0\fR]" 4
.IX Item "-d, --debug[=LEVEL]"
This option activates the debug mode. This prints the output result 
with line numbering and with the result of the \s-1XML\s0 check. If the \s-1WML\s0 
compiler was called, the result is also printed in hexadecimal an ascii 
forms. When called as a \s-1CGI\s0, all of this is printed as \s-1HTML\s0, so that can 
use any web browser for that purpose. 
.Ip "\*(--xmlcheck" 4
.IX Item "xmlcheck"
When this option is on, it send the \s-1WML\s0 output to \s-1XML:\s0:Parser to check 
its well-formedness. 
.SH "DECK SLICING"
.IX Header "DECK SLICING"
The \fIdeck slicing\fR is a feature that Html2Wml provides in order to 
match the low memory capabilities of most Wap devices. Many can't handle
cards larger than 2,000 bytes, therefore the cards must be sufficiently
small to be viewed by all Wap devices. To achieve this, you should compile
your \s-1WML\s0 deck, which reduce the size of the deck by 50%, but even then your
cards may be too big. This is where Html2Wml comes with the deck slicing
feature. This allows you to limit the size of the cards, currently only
\&\fIbefore\fR the compilation stage. 
.Sh "Slice by cards or by decks"
.IX Subsection "Slice by cards or by decks"
On some Wap phones, slicing the deck is not sufficient: the \s-1WML\s0 browser 
still tries to download the whole deck instead of just picking one 
card at a time. A solution is to slice the \s-1WML\s0 document by decks. 
See the figure below. 
.PP
.Vb 15
\&     _____________          _____________ 
\&    |    deck     |        |   deck #1   |
\&    |  _________  |        |  _________  |
\&    | | card #1 | |        | |  card   | |
\&    | |_________| |        | |_________| |
\&    |  _________  |        |_____________|
\&    | | card #2 | |        
\&    | |_________| |             . . .
\&    |  _________  |        
\&    | |   ...   | |         _____________
\&    | |_________| |        |   deck #n   |
\&    |  _________  |        |  _________  |
\&    | | card #n | |        | |  card   | |
\&    | |_________| |        | |_________| |
\&    |_____________|        |_____________|
.Ve
.Vb 2
\&      WML document           WML document
\&    sliced by cards        sliced by decks
.Ve
What this means is that Html2Wml generates several \s-1WML\s0 documents. 
In \s-1CGI\s0 mode, only the appropriate deck is sent, selected by the id 
given in parameter. If no id was given, the first deck is sent. 
.Sh "Note on size calculation"
.IX Subsection "Note on size calculation"
Currently, Html2Wml estimates the size of the card on the fly, by 
summing the length of the strings that compose the \s-1WML\s0 output, texts and 
tags. I say \*(L"estimates\*(R" and not \*(L"calculates\*(R" because computing the exact 
size would require many more calculations than the way it is done now. 
One may objects that there are only additions, which is correct, but knowing 
the \fIexact\fR size is not necessary. Indeed, if you compile the \s-1WML\s0, most of 
the strings of the tags will be removed, but not all. 
.PP
For example, take an image tag: 
\&\f(CW\*(C`<img src="images/dog.jpg" alt="Photo of a dog">\*(C'\fR. 
When compiled, the string \f(CW\*(C`"img"\*(C'\fR will be replaced by a one byte value. 
Same thing for the strings \f(CW\*(C`"src"\*(C'\fR and \f(CW\*(C`"alt"\*(C'\fR, and the spaces, double 
quotes and equal signs will be stripped. Only the text between double quote 
will be preserved... but not in every cases. 
Indeed, in order to go a step further, the compiler can also encode 
parts of the arguments as binary. For example, the string \f(CW\*(C`"http://www."\*(C'\fR 
can be encoded as a single byte (\f(CW\*(C`8F\*(C'\fR in this case). Or, if the attribute 
is \f(CW\*(C`href\*(C'\fR, the string \f(CW\*(C`href="http://\*(C'\fR can become the byte \f(CW\*(C`4B\*(C'\fR. 
.PP
As you see, it doesn't matter to know exactly the size of the textual
form of the \s-1WML\s0, as it will always be far superior to the size of the
compiled form. That's why I don't count all the characters that may be
actually written. 
.PP
Also, it's because I'm quite lazy ;\-)
.Sh "Why compiling the \s-1WML\s0 deck?"
.IX Subsection "Why compiling the WML deck?"
If you intent to create real \s-1WML\s0 pages, you should really 
consider to always compile them. If you're not convinced, here is an 
illustration. 
.PP
Take the following \s-1WML\s0 code snipet: 
.PP
.Vb 1
\&    <a href='http://www.yahoo.com/'>Yahoo!</a>
.Ve
It's the basic and classical way to code an hyperlink. It takes 42 bytes
to code this, because it is presented in a human-readable form. 
.PP
The \s-1WAP\s0 Forum has defined a compact binary representation of \s-1WML\s0 in its
specification, which is called \*(L"compiled \s-1WML\s0\*(R". It's a binary format, 
therefore you, a mere human, can't read that, but your computer can. And 
it's much faster for it to read a binary format than to read a textual 
format. 
.PP
The previous example would be, once compiled (and printed here as 
hexadecimal): 
.PP
.Vb 1
\&    1C 4A 8F 03 y a h o o 00 85 03 Y a h o o ! 00 01
.Ve
This only takes 20 bytes. Half the size of the human-readable form. 
For a Wap device, this means both less to download, and easier things 
to read. Therefore the processing of the document can be achieved in 
a short time compared to the tectual version of the same document. 
.PP
There is a last argument, and not the less important: many Wap devices
only read binary \s-1WML\s0. 
.SH "ACTIONS"
.IX Header "ACTIONS"
Actions are a feature similar to (but with far less functionalities!) the
\&\s-1SSI\s0 (Server Side Includes) available on good servers like Apache. In order
not to interfere with the real \s-1SSI\s0, but to keep the syntax easy to learn,
it differs in very few points. 
.Sh "Syntax"
.IX Subsection "Syntax"
Basically, the syntax to execute an action is: 
.PP
.Vb 1
\&    <!-- [action param1="value" param2='value'] -->
.Ve
Note that the angle brackets are part of the syntax. Except for that
point, Actions syntax is very similar to \s-1SSI\s0 syntax. 
.Sh "Available actions"
.IX Subsection "Available actions"
Currently, only two actions are available, but more can be implemented
on request. 
.Ip "include" 4
.IX Item "include"
.RS 4
.Ip "Description" 8
.IX Item "Description"
Includes a file in the document at the current point. Please note
that Html2Wml doesn't check nor parse the file, and if the file 
cannot be found, will silently die (this is the same behavior as \s-1SSI\s0). 
.Ip "Parameters" 8
.IX Item "Parameters"
\&\f(CW\*(C`virtual=url\*(C'\fR \*(-- The file is get by http.
.Sp
\&\f(CW\*(C`file=path\*(C'\fR \*(-- The file is read from the local disk.
.RE
.RS 4
.RE
.Ip "fsize" 4
.IX Item "fsize"
.RS 4
.Ip "Description" 8
.IX Item "Description"
Returns the size of a file at the current point of the document. 
.Ip "Parameters" 8
.IX Item "Parameters"
\&\f(CW\*(C`virtual=url\*(C'\fR \*(-- The file is get by http.
.Sp
\&\f(CW\*(C`file=path\*(C'\fR \*(-- The file is read from the local disk.
.Ip "Notes" 8
.IX Item "Notes"
If you use the file parameter, an absolute path is recommend. 
.RE
.RS 4
.RE
.Sh "Examples"
.IX Subsection "Examples"
If you want to share a navigation bar between several \s-1WML\s0 pages, you can
include it this way: 
.PP
.Vb 1
\&    <!-- [include virtual="nav.wml"] -->
.Ve
Of course, you have to write this navigation bar first :\-)
.SH "LINKS RECONSTRUCTION"
.IX Header "LINKS RECONSTRUCTION"
The links reconstruction engine is \s-1IMHO\s0 the most important part of
Html2Wml, because it's this engine that allows you to reconstruct the 
links of the \s-1HTML\s0 document being converted. It has two modes, depending 
upon whether Html2Wml was launched from the shell or as a \s-1CGI\s0. 
.PP
When used as a \s-1CGI\s0, this engine will reconstructs the links of the \s-1HTML\s0 
document so that all the urls will be passed to Html2Wml in order to 
convert the pointed files (pages or images). This is completly automatic 
and can't be customized for now (but I don't think it would be really 
useful). 
.PP
When used from the shell, this engine reconstructs the links with the 
given templates. Note that absolute URLs will be left untouched. The 
templates can be customized using the following syntax. 
.Sh "Templates"
.IX Subsection "Templates"
.Ip "\s-1HREF\s0 Template" 4
.IX Item "HREF Template"
This template controls the reconstruction of the \f(CW\*(C`href\*(C'\fR attribute of 
the \f(CW\*(C`A\*(C'\fR tag. Its value can be changed using the \fB\*(--hreftmpl\fR option. 
Default value is 
\&\f(CW\*(C`"{FILEPATH}{FILENAME}{$FILETYPE =~ s/s?html?/wml/o; $FILETYPE}"\*(C'\fR. 
.Ip "Image Source Template" 4
.IX Item "Image Source Template"
This template controls the reconstruction of the \f(CW\*(C`src\*(C'\fR attribute of 
the \f(CW\*(C`IMG\*(C'\fR tag. Its value can be changed using the \fB\*(--srctmpl\fR option. 
Default value is 
\&\f(CW\*(C`"{FILEPATH}{FILENAME}{$FILETYPE =~ s/gif|png|jpe?g/wbmp/o; $FILETYPE}"\*(C'\fR
.Sh "Syntax"
.IX Subsection "Syntax"
The template is a string that contains the new \s-1URL\s0. More precisely, it's 
a Text::Template template. Parameters can be interpolated as a constant 
or as a variable. The template is embraced between curcly bracets, and can 
contain any valid Perl code. 
.PP
The simplest form of a template is \f(CW\*(C`{\f(CI\s\-1PARAM\s0\f(CW}\*(C'\fR which just returns the 
value of \fI\s-1PARAM\s0\fR. If you want to do something more complex, you can use 
the corresponding variable; for example \f(CW\*(C`{"foo $\f(CI\s\-1PARAM\s0\f(CW bar"}\*(C'\fR, or 
\&\f(CW\*(C`{join "_", split " ", \f(CI\s\-1PARAM\s0\f(CW}\*(C'\fR. 
.PP
You may read the Text::Template manpage for more information on what is possible 
within a template. 
.PP
If the original \s-1URL\s0 contained a query part or a fragment part, then they 
will be appended to the result of the template. 
.Sh "Available parameters"
.IX Subsection "Available parameters"
.Ip "\s-1URL\s0" 4
.IX Item "URL"
This parameter contains the original \s-1URL\s0 from the \f(CW\*(C`href\*(C'\fR or \f(CW\*(C`src\*(C'\fR
attribute. 
.Ip "\s-1FILENAME\s0" 4
.IX Item "FILENAME"
This parameter contains the base name of the file. 
.Ip "\s-1FILEPATH\s0" 4
.IX Item "FILEPATH"
This parameter contains the leading path of the file. 
.Ip "\s-1FILETYPE\s0" 4
.IX Item "FILETYPE"
This parameter contains the suffix of the file. 
.PP
This can be resumed this way: 
.PP
.Vb 5
\&  URL = http://www.server.net/path/to/my/page.html
\&                             ------------^^^^ ----
\&                                 |        |     \e
\&                                 |        |      \e
\&                              FILEPATH FILENAME FILETYPE
.Ve
Note that \f(CW\*(C`FILETYPE\*(C'\fR contains all the extensions of the file, so if its name 
is \fIindex.html.fr\fR for example, \f(CW\*(C`FILETYPE\*(C'\fR contains "\f(CW\*(C`.html.fr\*(C'\fR". 
.Sh "Examples"
.IX Subsection "Examples"
To add a path option: 
.PP
.Vb 1
\&    {URL}$wap
.Ve
Using Apache, you can then add a Rewrite directive so that \s-1URL\s0 ending with 
\&\f(CW\*(C`$wap\*(C'\fR will be redirected to Html2Wml: 
.PP
.Vb 1
\&    RewriteRule  ^(/.*)\e$wap$  /cgi-bin/html2wml.cgi?url=$1
.Ve
To change the extension of an image: 
.PP
.Vb 1
\&    {FILEPATH}{FILENAME}.wbmp
.Ve
.SH "CAVEATS"
.IX Header "CAVEATS"
Currently, only the well-formedness of the resulting \s-1WML\s0 can be tested, not  
its validity. 
.PP
Inverted tags (like \*(L"<b>bold <i>italic</b></i>\*(R") may produce unexpected 
results. But only bad softwares do bad stuff like this. 
.SH "LINKS"
.IX Header "LINKS"
.Sh "Download"
.IX Subsection "Download"
.Ip "Nutialand" 4
.IX Item "Nutialand"
This is the web site of the author, where you can find the archives of 
all the releases of Html2Wml. 
.Sp
[ http://www.maddingue.org/techie/ ]
.Ip "Html2Wml on SourceForge" 4
.IX Item "Html2Wml on SourceForge"
This is the web site of the Html2Wml project, hosted by SourceForge.net. 
All the stable releases can be downloaded from this site. 
.Sp
[ http://htmlwml.sourceforge.net/ ]
.Sh "Resources"
.IX Subsection "Resources"
.Ip "The \s-1WAP\s0 Forum" 4
.IX Item "The WAP Forum"
This is the official site of the \s-1WAP\s0 Forum. You can find some technical 
information, as the specifications of all the technologies associated with 
the \s-1WAP\s0. 
.Sp
[ http://www.wapforum.org/ ]
.Ip "\s-1WAP\s0.com" 4
.IX Item "WAP.com"
This site has some useful information and links. In particular, it has 
a quite well done \s-1FAQ\s0. 
.Sp
[ http://www.wap.com/ ]
.Ip "The World Wide Web Consortium" 4
.IX Item "The World Wide Web Consortium"
Altough not directly related to the Wap stuff, you may find useful 
to read the specifications of the \s-1XML\s0 (\s-1WML\s0 is an \s-1XML\s0 application), and the 
specifications of the different stylesheet languages (\s-1CSS\s0 and \s-1XSL\s0), which 
include support for low-resolution devices. 
.Sp
[ http://www.w3.org/ ]
.Ip "MobiliX" 4
.IX Item "MobiliX"
This web site is dedicated to Mobile UniX systems. It leads you to a lot 
of useful hands-on information about installing and running Linux and \s-1BSD\s0 on 
laptops, PDAs and other mobile computer devices. 
.Sp
[ http://www.mobilix.org/ ]
.Sh "Programmers utilities"
.IX Subsection "Programmers utilities"
.Ip "\s-1HTML\s0 Tidy" 4
.IX Item "HTML Tidy"
This is a very handful utility which corrects your \s-1HTML\s0 files 
so that they conform to W3C standards. 
.Sp
[ http://www.w3.org/People/Raggett/tidy ]
.Ip "Kannel" 4
.IX Item "Kannel"
Kannel is an open source Wap and \s-1SMS\s0 gateway. 
A \s-1WML\s0 compiler is included in the distribution. 
.Sp
[ http://www.kannel.org/ ]
.Ip "\s-1WML\s0 Tools" 4
.IX Item "WML Tools"
This is a collection of utilities for \s-1WML\s0 programmers. This include 
a compiler, a decompiler, a viewer and a \s-1WBMP\s0 converter. 
.Sp
[ http://pwot.co.uk/wml/ ]
.Sh "\s-1WML\s0 browsers and Wap emulators"
.IX Subsection "WML browsers and Wap emulators"
.Ip "Opera 5.0" 4
.IX Item "Opera 5.0"
Opera is originaly a Web browser, but the version 5 has a good support 
for \s-1XML\s0 and \s-1WML\s0. Opera is available for free for several systems. 
.Sp
[ http://www.opera.com/ ]
.Ip "wApua" 4
.IX Item "wApua"
wApua is an open source \s-1WML\s0 browser written in Perl/Tk. 
It's easy to intall and to use. Its support for \s-1WML\s0 is incomplete, 
but sufficient for testing purpose. 
.Sp
[ http://fsinfo.cs.uni-sb.de/~abe/wApua/ ]
.Ip "Tofoa" 4
.IX Item "Tofoa"
Tofoa is an open source Wap emulator written in Python. 
Its installation is quite difficult, and its incomplete \s-1WML\s0 support 
makes it produce strange results, even with valid \s-1WML\s0 documents. 
.Sp
[ http://tofoa.free-system.com/ ]
.Ip "EzWAP" 4
.IX Item "EzWAP"
EzWAP, from \s-1EZOS\s0, is a commercial \s-1WML\s0 browser freely available for 
Windows 9x, \s-1NT\s0, 2000 and \s-1CE\s0. Compared to others Windows \s-1WML\s0 browsers, 
it requires very few resources, and is quite stable. Its support for 
the \s-1WML\s0 specs seems quite complete. A very good software. 
.Sp
[ http://tofoa.free-system.com/ ]
.Ip "Deck-It" 4
.IX Item "Deck-It"
Deck-It is a commercial Wap phone emulator, available for Windows and 
Linux/Intel only. It's a very good piece of software which really 
show how \s-1WML\s0 pages are rendered on a Wap phone, but one of its 
major default is that it cannot read local files. 
.Sp
[ http://www.pyweb.com/php/test_adapt.php3 ]
.Ip "WinWAP" 4
.IX Item "WinWAP"
WinWAP is a commercial Wap browser, freely available for Windows. 
.Sp
[ http://www.winwap.org/ ]
.Ip "QWmlBrowser" 4
.IX Item "QWmlBrowser"
QWmlBrowser (formerly known as \s-1WML\s0 BRowser) is an open source 
\&\s-1WML\s0 browser, written using the Qt toolkit. 
.Sp
[ http://www.wmlbrowser.org/ ]
.Ip "WAPreview" 4
.IX Item "WAPreview"
WAPreview is a Wap emulator written in Java. As it uses an \s-1HTML\s0 
based \s-1UI\s0 and needs a local web proxy, it runs quite slowly. 
.Sp
[ http://wapreview.sourceforge.net ]
.Ip "J2Wap" 4
.IX Item "J2Wap"
This is a Wap emulator written in Java. It uses the Java native 
\&\s-1GUI\s0, and claims to support binary \s-1WML\s0, but it doesn't seem to work 
at all at this time. 
.Sp
[ http://j2wap.sourceforge.net ]
.SH "ACKNOWLEDGEMENTS"
.IX Header "ACKNOWLEDGEMENTS"
Werner Heuser, for his numerous ideas, advices and his help for the debugging
.PP
Igor Khristophorov, for his numerous suggestions and patches
.PP
And all the people that send me bug reports: Daniele Frijia, Axel Jerabek
.SH "AUTHOR"
.IX Header "AUTHOR"
Se\*'bastien Aperghis-Tramoni <maddingue@free.fr>
.SH "COPYRIGHT"
.IX Header "COPYRIGHT"
Copyright (c)2000, 2001 Se\*'bastien Aperghis-Tramoni
.PP
This program is free software. You can redistribute it and/or modify it 
under the terms of the \s-1GNU\s0 General Public License, version 2 or later. 
