#!/bin/sh
# Cleanup the python-fastimport sources to our liking

# NOTE: The home page is https://github.com/jelmer/python-fastimport
# But the upstream release is called fastimport.
# As such there are confusing names.
# This script will attempt to rename both to python_fastimport to
# reflect the vendor and satisfy a module name a dash is not allowed.

# untar the distribution here, for example
# tar xvjpf python-fastimport-0.9.8.tar.gz

set -xe
rm -rf python_fastimport_tmp
if [ -d python-fastimport-* ]; then
	mv python-fastimport* python_fastimport_tmp
elif [ -d fastimport-* ]; then
	mv fastimport-* python_fastimport_tmp
else
	echo "No idea how to import!" >2
	exit 1
fi

find python_fastimport_tmp -mindepth 1 ! -name AUTHORS ! -name COPYING \
	! -name NEWS ! -name README.md \
	! -regex '^python_fastimport_tmp/fastimport\(.*\)' \
	-delete
mv python_fastimport_tmp/fastimport/* python_fastimport_tmp/
rmdir python_fastimport_tmp/fastimport

rm -rf python_fastimport
mv python_fastimport_tmp python_fastimport
