#include "config.h"

GtkWidget *init_mainWin(GtkWidget *widget)
{
   GtkWidget *mainWin;
   GtkWidget *vbox;
   GtkWidget *menubar;
   GtkWidget *notebook;
   GtkWidget *label;
   
   /* Setup the main window. */
   mainWin = gtk_window_new(GTK_WINDOW_TOPLEVEL);
   gtk_window_set_default_size(GTK_WINDOW(mainWin), 360, 360);
   gtk_window_set_title(GTK_WINDOW(mainWin), "gtkMserv");
   
   /* Setup the large, main vbox */
   vbox = gtk_vbox_new(0, FALSE);
   gtk_container_add(GTK_CONTAINER(mainWin), vbox);
   gtk_widget_show(vbox);

   /* Setup and pack the main menu */
   menubar = init_mainMenu();
   gtk_box_pack_start(GTK_BOX(vbox), menubar, FALSE, FALSE, 0);
   gtk_widget_show(menubar);

   /* The main notebook, bleh */
   notebook = gtk_notebook_new();
   gtk_box_pack_start(GTK_BOX(vbox), notebook, TRUE, TRUE, 0);
   gtk_widget_show(notebook);

   label = gtk_label_new("Currently Playing");
   gtk_notebook_append_page(GTK_NOTEBOOK(notebook), Session.StatusWin.window, label);
   gtk_widget_show(label);

   label = gtk_label_new("Albums");
   gtk_notebook_append_page(GTK_NOTEBOOK(notebook), Session.AlbumWin.window, label);
   gtk_widget_show(label);

   label = gtk_label_new("Queue");
   gtk_notebook_append_page(GTK_NOTEBOOK(notebook), Session.QueueWin.window, label);
   gtk_widget_show(label);

   label = gtk_label_new("Console");
   gtk_notebook_append_page(GTK_NOTEBOOK(notebook), Session.ConsoleWin.window, label);
   gtk_widget_show(label);

   /* Setup and pack the statusbar */
   Session.StatusBar = gtk_statusbar_new();
   gtk_box_pack_start(GTK_BOX(vbox), Session.StatusBar, FALSE, FALSE, 0);
   gtk_widget_show(Session.StatusBar);
   
   gtk_signal_connect (GTK_OBJECT(mainWin), "delete_event", 
		       GTK_SIGNAL_FUNC(main_quit), NULL);
   gtk_widget_show(mainWin);
   return(mainWin);
}

void console_init_window(void)
{
   GtkWidget *vbox;
   GtkWidget *hbox;
   GtkWidget *vscrollbar;
   
#if DEBUG
   printf("Initializing Console Window\n");
#endif

   Session.ConsoleWin.window = gtk_scrolled_window_new(NULL, NULL);
   vbox = gtk_vbox_new(0, FALSE);
   
   gtk_scrolled_window_set_policy(GTK_SCROLLED_WINDOW(Session.ConsoleWin.window), GTK_POLICY_AUTOMATIC, GTK_POLICY_AUTOMATIC);
   gtk_scrolled_window_add_with_viewport(GTK_SCROLLED_WINDOW(Session.ConsoleWin.window), vbox);
   
   /* OutputText */
   hbox = gtk_hbox_new(0, FALSE);
   gtk_box_pack_start(GTK_BOX(vbox), hbox, TRUE, TRUE, 0);
   
   Session.ConsoleWin.outputText = gtk_text_new(NULL, NULL);
   gtk_box_pack_start(GTK_BOX(hbox), Session.ConsoleWin.outputText, TRUE, TRUE, 0);
   vscrollbar = gtk_vscrollbar_new(GTK_TEXT(Session.ConsoleWin.outputText)->vadj);
   gtk_box_pack_start(GTK_BOX(hbox), vscrollbar, FALSE, FALSE, 0);

   /* Input Text */
   Session.ConsoleWin.inputEntry = gtk_entry_new();
   gtk_entry_set_max_length(GTK_ENTRY(Session.ConsoleWin.inputEntry), 1023);
   gtk_box_pack_start(GTK_BOX(vbox), Session.ConsoleWin.inputEntry, FALSE, FALSE, 0);
   gtk_signal_connect(GTK_OBJECT(Session.ConsoleWin.inputEntry),
		      "key_press_event",
		      GTK_SIGNAL_FUNC(on_inputEntry_key_press),
		      NULL);
   gtk_signal_connect_object(GTK_OBJECT(Session.ConsoleWin.inputEntry), "activate",
			     GTK_SIGNAL_FUNC(on_inputEntry_activate),
			     GTK_OBJECT(Session.ConsoleWin.inputEntry));
   
   gtk_widget_show_all(Session.ConsoleWin.window);
}

void configWin(void)
{
   GtkWidget *window;
   GtkWidget *notebook;
   GtkWidget *label;
   GtkWidget *hbox;
   GtkWidget *frame;
   GtkWidget *vbox;
   GtkWidget *okBut;
   GtkWidget *cancelBut;

   window = gtk_window_new(GTK_WINDOW_TOPLEVEL);

   vbox = gtk_vbox_new(FALSE, 5);
   gtk_container_add(GTK_CONTAINER(window), vbox);
   gtk_widget_show(vbox);

   notebook = gtk_notebook_new();
   gtk_box_pack_start(GTK_BOX(vbox), notebook, FALSE, FALSE, 0);
   gtk_notebook_set_tab_pos(GTK_NOTEBOOK(notebook), GTK_POS_TOP);
   gtk_widget_show(notebook);

   hbox = gtk_hbox_new(FALSE, 5);
   gtk_widget_show(hbox);

   /* Cancel Button */
   cancelBut = gtk_button_new_with_label("Cancel");
   gtk_box_pack_end(GTK_BOX(hbox), cancelBut, FALSE, FALSE, 10);
   gtk_container_border_width(GTK_CONTAINER(cancelBut), 20);
   gtk_signal_connect(GTK_OBJECT(cancelBut), "clicked",
		      GTK_SIGNAL_FUNC(on_configWin_cancelBut_clicked), window);
   gtk_widget_show(cancelBut);

   /* Ok Button */
   okBut = gtk_button_new_with_label("Ok");
   gtk_container_border_width(GTK_CONTAINER(okBut), 10);
   gtk_box_pack_end(GTK_BOX(hbox), okBut, FALSE, FALSE, 20);
   gtk_signal_connect(GTK_OBJECT(okBut), "clicked",
		      GTK_SIGNAL_FUNC(on_configWin_okBut_clicked), window);
   gtk_widget_show(okBut);   
    
   gtk_box_pack_start(GTK_BOX(vbox), hbox, FALSE, FALSE, 0);

   /* Config Frame */
   frame = gtk_frame_new(NULL);
   gtk_widget_show(frame);

   label = gtk_label_new("Connection");   
   gtk_notebook_append_page(GTK_NOTEBOOK(notebook), frame, label);

   vbox = gtk_vbox_new(TRUE, 5);

   gtk_container_set_border_width(GTK_CONTAINER(vbox), 10);
   gtk_container_add(GTK_CONTAINER(frame), vbox);
   gtk_widget_show(vbox);
   
   HBOX_LABEL_ENTRY_PAIR(hbox, label, Session.Setup.entry_login,
			 TRUE, "Login", 256, 60, 0);
   gtk_box_pack_start(GTK_BOX(vbox), hbox, TRUE, TRUE, 0);
   gtk_entry_set_text(GTK_ENTRY(Session.Setup.entry_login),
		      Session.Pref.login);
   
   HBOX_LABEL_ENTRY_PAIR(hbox, label, Session.Setup.entry_password,
			 TRUE, "Password", 256, 60, 0);
   gtk_box_pack_start(GTK_BOX(vbox), hbox, TRUE, TRUE, 0);
   gtk_entry_set_text(GTK_ENTRY(Session.Setup.entry_password),
				Session.Pref.password);

   HBOX_LABEL_ENTRY_PAIR(hbox, label, Session.Setup.entry_host,
			 TRUE, "Host", 256, 60, 0);
   gtk_box_pack_start(GTK_BOX(vbox), hbox, TRUE, TRUE, 0);
   gtk_entry_set_text(GTK_ENTRY(Session.Setup.entry_host),  Session.Pref.host);

   HBOX_LABEL_ENTRY_PAIR(hbox, label, Session.Setup.entry_port,
			 TRUE, "Port", 256, 60, 0);
   gtk_box_pack_start(GTK_BOX(vbox), hbox, TRUE, TRUE, 0);
   gtk_entry_set_text(GTK_ENTRY(Session.Setup.entry_port),  Session.Pref.port);

   gtk_widget_show(window);
}

/*   win_status related stuff. */
void status_init_window(void)
{
   GtkWidget *hbox, *main_vbox;
   GtkWidget *label;
   GtkWidget *fixed;
   GtkWidget *toolbar;

#if DEBUG
   printf("Initializing Status Window\n");
#endif
   
   /* Setup the initial window */
   Session.StatusWin.window = gtk_scrolled_window_new(NULL, NULL);
   main_vbox = gtk_vbox_new(FALSE, 0);

   gtk_scrolled_window_set_policy(GTK_SCROLLED_WINDOW(Session.StatusWin.window), GTK_POLICY_AUTOMATIC, GTK_POLICY_AUTOMATIC);
   gtk_scrolled_window_add_with_viewport(GTK_SCROLLED_WINDOW(Session.StatusWin.window), main_vbox);   

   /* Setup the toolbar/button bar */
   toolbar = gtk_toolbar_new(GTK_ORIENTATION_HORIZONTAL, GTK_TOOLBAR_TEXT);
   gtk_box_pack_start(GTK_BOX(main_vbox), toolbar, TRUE, TRUE, 0);
   
   gtk_toolbar_append_item(GTK_TOOLBAR(toolbar), "Stop", "Stop Playing",
			   NULL, NULL, mserv_cmd_stop, NULL);
   gtk_toolbar_append_item(GTK_TOOLBAR(toolbar), "Next", "Play Next Song",
			   NULL, NULL, mserv_cmd_next, NULL);
   gtk_toolbar_append_item(GTK_TOOLBAR(toolbar), "Pause", "Pause Output",
			   NULL, NULL, mserv_cmd_pause, NULL);
   gtk_toolbar_append_item(GTK_TOOLBAR(toolbar), "Play", "Start Playing",
			   NULL, NULL, mserv_cmd_play, NULL);
   

   /* Setup the fixed/updating info box. */
   fixed = gtk_fixed_new();
   gtk_box_pack_start(GTK_BOX(main_vbox), fixed, TRUE, TRUE, 0);

   HBOX_LABEL_ENTRY_PAIR(hbox, label, Session.StatusWin.Artist,
			 FALSE, "Artist", 0, 0, 0);
   gtk_fixed_put(GTK_FIXED(fixed), hbox, 0, 0);

   HBOX_LABEL_ENTRY_PAIR(hbox, label, Session.StatusWin.Song,
			 FALSE, "Song", 0, 0, 0);
   gtk_fixed_put(GTK_FIXED(fixed), hbox, 0, 25);

   HBOX_LABEL_ENTRY_PAIR(hbox, label, Session.StatusWin.Length, 
			 FALSE, "Length", 0, 0, 50);
   gtk_fixed_put(GTK_FIXED(fixed), hbox, 0, 50);
 
   HBOX_LABEL_ENTRY_PAIR(hbox, label, Session.StatusWin.Album_Number, 
			 FALSE, "Album Number", 0, 0, 50);
   gtk_fixed_put(GTK_FIXED(fixed), hbox, 0, 75);

   HBOX_LABEL_ENTRY_PAIR(hbox, label, Session.StatusWin.Track_Number, 
			 FALSE, "Track Number", 0, 0, 50);
   gtk_fixed_put(GTK_FIXED(fixed), hbox, 0, 100);

   HBOX_LABEL_ENTRY_PAIR(hbox, label, Session.StatusWin.Tracks_Included, 
			 FALSE, "Tracks Included", 0, 0, 50);
   gtk_fixed_put(GTK_FIXED(fixed), hbox, 0, 125);

   HBOX_LABEL_ENTRY_PAIR(hbox, label, Session.StatusWin.Tracks_Excluded, 
			 FALSE, "Tracks Excluded", 0, 0, 50);
   gtk_fixed_put(GTK_FIXED(fixed), hbox, 0, 150);

   HBOX_LABEL_ENTRY_PAIR(hbox, label, Session.StatusWin.Random, 
			 FALSE, "Random", 0, 0, 25);
   gtk_fixed_put(GTK_FIXED(fixed), hbox, 0, 175);

   HBOX_LABEL_ENTRY_PAIR(hbox, label, Session.StatusWin.Random_Factor, 
			 FALSE, "Random Factor", 0, 0, 40);
   gtk_fixed_put(GTK_FIXED(fixed), hbox, 0, 200);

   HBOX_LABEL_ENTRY_PAIR(hbox, label, Session.StatusWin.Last_Played, 
			 FALSE, "Last Played", 0, 0, 0);
   gtk_fixed_put(GTK_FIXED(fixed), hbox, 0, 225);
 
   gtk_widget_show_all(Session.StatusWin.window);
}



void main_quit(void)
{
   save_settings();
   gtk_main_quit();
}
