#include "config.h"

int is_digit(char *s)
{
  while(*s && s)
    {
      if (isdigit(*s++))
	continue;
      else       
	return FALSE;
    }	
  
  return TRUE;
}

int is_space(char *s)
{
  while(*s && s)
    {
      if (isspace(*s++))
	continue;
      else       
	return FALSE;
    }	
  
  return TRUE;
}

/* Stolen from  GkrellM and modified to take a function pointer. */
void timer(gint Hz, GtkFunction function)
{
   static gint 	timeout_id = 0;
   gint 	interval;

   if (timeout_id)
      gtk_timeout_remove(timeout_id);
   timeout_id = 0;

   if (Hz > 0)
   {
      interval = 1000 / Hz;
      interval = interval * 60 / 63;
      timeout_id = gtk_timeout_add(interval, (GtkFunction) function, NULL);
   }
}   
   
void print_outputText(char *s)
{   
   GtkAdjustment *adj = GTK_TEXT(Session.ConsoleWin.outputText)->vadj;
   
   gtk_text_freeze(GTK_TEXT(Session.ConsoleWin.outputText));
   gtk_text_insert(GTK_TEXT(Session.ConsoleWin.outputText), NULL, NULL, NULL, s, -1);
   gtk_text_thaw(GTK_TEXT(Session.ConsoleWin.outputText));
   gtk_adjustment_set_value(adj, adj->upper - adj->page_size);
}

void print_statusbar(GtkWidget *widget, char *string)
{
   static guint context_id = 0;
   static guint message_id = 0;

   if (context_id)
      gtk_statusbar_remove(GTK_STATUSBAR(widget), context_id, message_id);
   
   context_id = gtk_statusbar_get_context_id(GTK_STATUSBAR(widget), string);   
   message_id = gtk_statusbar_push(GTK_STATUSBAR(widget), context_id, string);
}
/* Read a file till it catches a newline. */
int read_newline_fp(FILE *fp, char *buf)
{
   int c, i;
   
   for (i = 0, c = fgetc(fp);
	c != '\n' && c != EOF;
	i++, c = fgetc(fp))
      buf[i] = c;

   buf[i] = '\0';
   
   if (c == EOF)
      return -1;
   else 
      return i;
}

char *read_newline_buf(char *buf, char *buf2)
{
   int i;
  
   if (!buf || !*buf)
      return NULL;

   for (i = 0; *buf != '\n' && *buf != '\0'; i++, buf++)
   {
      buf2[i] = *buf;
   }

   buf2[i] = '\0';
   buf++;

   return buf;
}
