// Copyright 2020 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.25.0
// 	protoc        v3.13.0
// source: google/cloud/talent/v4beta1/filters.proto

package talent

import (
	reflect "reflect"
	sync "sync"

	proto "github.com/golang/protobuf/proto"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	date "google.golang.org/genproto/googleapis/type/date"
	latlng "google.golang.org/genproto/googleapis/type/latlng"
	timeofday "google.golang.org/genproto/googleapis/type/timeofday"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	durationpb "google.golang.org/protobuf/types/known/durationpb"
	_ "google.golang.org/protobuf/types/known/fieldmaskpb"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
	wrapperspb "google.golang.org/protobuf/types/known/wrapperspb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// This is a compile-time assertion that a sufficiently up-to-date version
// of the legacy proto package is being used.
const _ = proto.ProtoPackageIsVersion4

// Specify whether to include telecommute jobs.
type LocationFilter_TelecommutePreference int32

const (
	// Default value if the telecommute preference isn't specified.
	LocationFilter_TELECOMMUTE_PREFERENCE_UNSPECIFIED LocationFilter_TelecommutePreference = 0
	// Exclude telecommute jobs.
	LocationFilter_TELECOMMUTE_EXCLUDED LocationFilter_TelecommutePreference = 1
	// Allow telecommute jobs.
	LocationFilter_TELECOMMUTE_ALLOWED LocationFilter_TelecommutePreference = 2
)

// Enum value maps for LocationFilter_TelecommutePreference.
var (
	LocationFilter_TelecommutePreference_name = map[int32]string{
		0: "TELECOMMUTE_PREFERENCE_UNSPECIFIED",
		1: "TELECOMMUTE_EXCLUDED",
		2: "TELECOMMUTE_ALLOWED",
	}
	LocationFilter_TelecommutePreference_value = map[string]int32{
		"TELECOMMUTE_PREFERENCE_UNSPECIFIED": 0,
		"TELECOMMUTE_EXCLUDED":               1,
		"TELECOMMUTE_ALLOWED":                2,
	}
)

func (x LocationFilter_TelecommutePreference) Enum() *LocationFilter_TelecommutePreference {
	p := new(LocationFilter_TelecommutePreference)
	*p = x
	return p
}

func (x LocationFilter_TelecommutePreference) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (LocationFilter_TelecommutePreference) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_talent_v4beta1_filters_proto_enumTypes[0].Descriptor()
}

func (LocationFilter_TelecommutePreference) Type() protoreflect.EnumType {
	return &file_google_cloud_talent_v4beta1_filters_proto_enumTypes[0]
}

func (x LocationFilter_TelecommutePreference) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use LocationFilter_TelecommutePreference.Descriptor instead.
func (LocationFilter_TelecommutePreference) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_talent_v4beta1_filters_proto_rawDescGZIP(), []int{2, 0}
}

// Specify the type of filtering.
type CompensationFilter_FilterType int32

const (
	// Filter type unspecified. Position holder, INVALID, should never be used.
	CompensationFilter_FILTER_TYPE_UNSPECIFIED CompensationFilter_FilterType = 0
	// Filter by `base compensation entry's` unit. A job is a match if and
	// only if the job contains a base CompensationEntry and the base
	// CompensationEntry's unit matches provided [units][google.cloud.talent.v4beta1.CompensationFilter.units].
	// Populate one or more [units][google.cloud.talent.v4beta1.CompensationFilter.units].
	//
	// See [CompensationInfo.CompensationEntry][google.cloud.talent.v4beta1.CompensationInfo.CompensationEntry] for definition of
	// base compensation entry.
	CompensationFilter_UNIT_ONLY CompensationFilter_FilterType = 1
	// Filter by `base compensation entry's` unit and amount / range. A job
	// is a match if and only if the job contains a base CompensationEntry, and
	// the base entry's unit matches provided
	// [CompensationUnit][google.cloud.talent.v4beta1.CompensationInfo.CompensationUnit] and
	// amount or range overlaps with provided
	// [CompensationRange][google.cloud.talent.v4beta1.CompensationInfo.CompensationRange].
	//
	// See [CompensationInfo.CompensationEntry][google.cloud.talent.v4beta1.CompensationInfo.CompensationEntry] for definition of
	// base compensation entry.
	//
	// Set exactly one [units][google.cloud.talent.v4beta1.CompensationFilter.units] and populate [range][google.cloud.talent.v4beta1.CompensationFilter.range].
	CompensationFilter_UNIT_AND_AMOUNT CompensationFilter_FilterType = 2
	// Filter by annualized base compensation amount and `base compensation
	// entry's` unit. Populate [range][google.cloud.talent.v4beta1.CompensationFilter.range] and zero or more [units][google.cloud.talent.v4beta1.CompensationFilter.units].
	CompensationFilter_ANNUALIZED_BASE_AMOUNT CompensationFilter_FilterType = 3
	// Filter by annualized total compensation amount and `base compensation
	// entry's` unit . Populate [range][google.cloud.talent.v4beta1.CompensationFilter.range] and zero or more [units][google.cloud.talent.v4beta1.CompensationFilter.units].
	CompensationFilter_ANNUALIZED_TOTAL_AMOUNT CompensationFilter_FilterType = 4
)

// Enum value maps for CompensationFilter_FilterType.
var (
	CompensationFilter_FilterType_name = map[int32]string{
		0: "FILTER_TYPE_UNSPECIFIED",
		1: "UNIT_ONLY",
		2: "UNIT_AND_AMOUNT",
		3: "ANNUALIZED_BASE_AMOUNT",
		4: "ANNUALIZED_TOTAL_AMOUNT",
	}
	CompensationFilter_FilterType_value = map[string]int32{
		"FILTER_TYPE_UNSPECIFIED": 0,
		"UNIT_ONLY":               1,
		"UNIT_AND_AMOUNT":         2,
		"ANNUALIZED_BASE_AMOUNT":  3,
		"ANNUALIZED_TOTAL_AMOUNT": 4,
	}
)

func (x CompensationFilter_FilterType) Enum() *CompensationFilter_FilterType {
	p := new(CompensationFilter_FilterType)
	*p = x
	return p
}

func (x CompensationFilter_FilterType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (CompensationFilter_FilterType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_talent_v4beta1_filters_proto_enumTypes[1].Descriptor()
}

func (CompensationFilter_FilterType) Type() protoreflect.EnumType {
	return &file_google_cloud_talent_v4beta1_filters_proto_enumTypes[1]
}

func (x CompensationFilter_FilterType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use CompensationFilter_FilterType.Descriptor instead.
func (CompensationFilter_FilterType) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_talent_v4beta1_filters_proto_rawDescGZIP(), []int{3, 0}
}

// The traffic density to use when calculating commute time.
type CommuteFilter_RoadTraffic int32

const (
	// Road traffic situation isn't specified.
	CommuteFilter_ROAD_TRAFFIC_UNSPECIFIED CommuteFilter_RoadTraffic = 0
	// Optimal commute time without considering any traffic impact.
	CommuteFilter_TRAFFIC_FREE CommuteFilter_RoadTraffic = 1
	// Commute time calculation takes in account the peak traffic impact.
	CommuteFilter_BUSY_HOUR CommuteFilter_RoadTraffic = 2
)

// Enum value maps for CommuteFilter_RoadTraffic.
var (
	CommuteFilter_RoadTraffic_name = map[int32]string{
		0: "ROAD_TRAFFIC_UNSPECIFIED",
		1: "TRAFFIC_FREE",
		2: "BUSY_HOUR",
	}
	CommuteFilter_RoadTraffic_value = map[string]int32{
		"ROAD_TRAFFIC_UNSPECIFIED": 0,
		"TRAFFIC_FREE":             1,
		"BUSY_HOUR":                2,
	}
)

func (x CommuteFilter_RoadTraffic) Enum() *CommuteFilter_RoadTraffic {
	p := new(CommuteFilter_RoadTraffic)
	*p = x
	return p
}

func (x CommuteFilter_RoadTraffic) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (CommuteFilter_RoadTraffic) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_talent_v4beta1_filters_proto_enumTypes[2].Descriptor()
}

func (CommuteFilter_RoadTraffic) Type() protoreflect.EnumType {
	return &file_google_cloud_talent_v4beta1_filters_proto_enumTypes[2]
}

func (x CommuteFilter_RoadTraffic) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use CommuteFilter_RoadTraffic.Descriptor instead.
func (CommuteFilter_RoadTraffic) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_talent_v4beta1_filters_proto_rawDescGZIP(), []int{4, 0}
}

// Enum indicating which set of [Profile.employment_records][google.cloud.talent.v4beta1.Profile.employment_records] to search
// against.
type EmployerFilter_EmployerFilterMode int32

const (
	// Default value.
	EmployerFilter_EMPLOYER_FILTER_MODE_UNSPECIFIED EmployerFilter_EmployerFilterMode = 0
	// Apply to all employers in [Profile.employment_records][google.cloud.talent.v4beta1.Profile.employment_records].
	EmployerFilter_ALL_EMPLOYMENT_RECORDS EmployerFilter_EmployerFilterMode = 1
	// Apply only to current employer in [Profile.employment_records][google.cloud.talent.v4beta1.Profile.employment_records].
	EmployerFilter_CURRENT_EMPLOYMENT_RECORDS_ONLY EmployerFilter_EmployerFilterMode = 2
	// Apply only to past (not current) employers in
	// [Profile.employment_records][google.cloud.talent.v4beta1.Profile.employment_records].
	EmployerFilter_PAST_EMPLOYMENT_RECORDS_ONLY EmployerFilter_EmployerFilterMode = 3
)

// Enum value maps for EmployerFilter_EmployerFilterMode.
var (
	EmployerFilter_EmployerFilterMode_name = map[int32]string{
		0: "EMPLOYER_FILTER_MODE_UNSPECIFIED",
		1: "ALL_EMPLOYMENT_RECORDS",
		2: "CURRENT_EMPLOYMENT_RECORDS_ONLY",
		3: "PAST_EMPLOYMENT_RECORDS_ONLY",
	}
	EmployerFilter_EmployerFilterMode_value = map[string]int32{
		"EMPLOYER_FILTER_MODE_UNSPECIFIED": 0,
		"ALL_EMPLOYMENT_RECORDS":           1,
		"CURRENT_EMPLOYMENT_RECORDS_ONLY":  2,
		"PAST_EMPLOYMENT_RECORDS_ONLY":     3,
	}
)

func (x EmployerFilter_EmployerFilterMode) Enum() *EmployerFilter_EmployerFilterMode {
	p := new(EmployerFilter_EmployerFilterMode)
	*p = x
	return p
}

func (x EmployerFilter_EmployerFilterMode) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (EmployerFilter_EmployerFilterMode) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_talent_v4beta1_filters_proto_enumTypes[3].Descriptor()
}

func (EmployerFilter_EmployerFilterMode) Type() protoreflect.EnumType {
	return &file_google_cloud_talent_v4beta1_filters_proto_enumTypes[3]
}

func (x EmployerFilter_EmployerFilterMode) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use EmployerFilter_EmployerFilterMode.Descriptor instead.
func (EmployerFilter_EmployerFilterMode) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_talent_v4beta1_filters_proto_rawDescGZIP(), []int{7, 0}
}

// Time fields can be used in TimeFilter.
type TimeFilter_TimeField int32

const (
	// Default value.
	TimeFilter_TIME_FIELD_UNSPECIFIED TimeFilter_TimeField = 0
	// Earliest profile create time.
	TimeFilter_CREATE_TIME TimeFilter_TimeField = 1
	// Latest profile update time.
	TimeFilter_UPDATE_TIME TimeFilter_TimeField = 2
)

// Enum value maps for TimeFilter_TimeField.
var (
	TimeFilter_TimeField_name = map[int32]string{
		0: "TIME_FIELD_UNSPECIFIED",
		1: "CREATE_TIME",
		2: "UPDATE_TIME",
	}
	TimeFilter_TimeField_value = map[string]int32{
		"TIME_FIELD_UNSPECIFIED": 0,
		"CREATE_TIME":            1,
		"UPDATE_TIME":            2,
	}
)

func (x TimeFilter_TimeField) Enum() *TimeFilter_TimeField {
	p := new(TimeFilter_TimeField)
	*p = x
	return p
}

func (x TimeFilter_TimeField) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (TimeFilter_TimeField) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_talent_v4beta1_filters_proto_enumTypes[4].Descriptor()
}

func (TimeFilter_TimeField) Type() protoreflect.EnumType {
	return &file_google_cloud_talent_v4beta1_filters_proto_enumTypes[4]
}

func (x TimeFilter_TimeField) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use TimeFilter_TimeField.Descriptor instead.
func (TimeFilter_TimeField) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_talent_v4beta1_filters_proto_rawDescGZIP(), []int{13, 0}
}

// The query required to perform a search query.
type JobQuery struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The query string that matches against the job title, description, and
	// location fields.
	//
	// The maximum number of allowed characters is 255.
	Query string `protobuf:"bytes,1,opt,name=query,proto3" json:"query,omitempty"`
	// The language code of [query][google.cloud.talent.v4beta1.JobQuery.query]. For example, "en-US". This field helps to
	// better interpret the query.
	//
	// If a value isn't specified, the query language code is automatically
	// detected, which may not be accurate.
	//
	// Language code should be in BCP-47 format, such as "en-US" or "sr-Latn".
	// For more information, see
	// [Tags for Identifying Languages](https://tools.ietf.org/html/bcp47).
	QueryLanguageCode string `protobuf:"bytes,14,opt,name=query_language_code,json=queryLanguageCode,proto3" json:"query_language_code,omitempty"`
	// This filter specifies the company entities to search against.
	//
	// If a value isn't specified, jobs are searched for against all
	// companies.
	//
	// If multiple values are specified, jobs are searched against the
	// companies specified.
	//
	// The format is
	// "projects/{project_id}/tenants/{tenant_id}/companies/{company_id}". For
	// example, "projects/foo/tenants/bar/companies/baz".
	//
	// If tenant id is unspecified, the default tenant is used. For
	// example, "projects/foo/companies/bar".
	//
	// At most 20 company filters are allowed.
	Companies []string `protobuf:"bytes,2,rep,name=companies,proto3" json:"companies,omitempty"`
	// The location filter specifies geo-regions containing the jobs to
	// search against. See [LocationFilter][google.cloud.talent.v4beta1.LocationFilter] for more information.
	//
	// If a location value isn't specified, jobs fitting the other search
	// criteria are retrieved regardless of where they're located.
	//
	// If multiple values are specified, jobs are retrieved from any of the
	// specified locations. If different values are specified for the
	// [LocationFilter.distance_in_miles][google.cloud.talent.v4beta1.LocationFilter.distance_in_miles] parameter, the maximum provided
	// distance is used for all locations.
	//
	// At most 5 location filters are allowed.
	LocationFilters []*LocationFilter `protobuf:"bytes,3,rep,name=location_filters,json=locationFilters,proto3" json:"location_filters,omitempty"`
	// The category filter specifies the categories of jobs to search against.
	// See [JobCategory][google.cloud.talent.v4beta1.JobCategory] for more information.
	//
	// If a value isn't specified, jobs from any category are searched against.
	//
	// If multiple values are specified, jobs from any of the specified
	// categories are searched against.
	JobCategories []JobCategory `protobuf:"varint,4,rep,packed,name=job_categories,json=jobCategories,proto3,enum=google.cloud.talent.v4beta1.JobCategory" json:"job_categories,omitempty"`
	// Allows filtering jobs by commute time with different travel methods (for
	//  example, driving or public transit).
	//
	// Note: This only works when you specify a [CommuteMethod][google.cloud.talent.v4beta1.CommuteMethod]. In this case,
	// [location_filters][google.cloud.talent.v4beta1.JobQuery.location_filters] is ignored.
	//
	//  Currently we don't support sorting by commute time.
	CommuteFilter *CommuteFilter `protobuf:"bytes,5,opt,name=commute_filter,json=commuteFilter,proto3" json:"commute_filter,omitempty"`
	// This filter specifies the exact company [Company.display_name][google.cloud.talent.v4beta1.Company.display_name]
	// of the jobs to search against.
	//
	// If a value isn't specified, jobs within the search results are
	// associated with any company.
	//
	// If multiple values are specified, jobs within the search results may be
	// associated with any of the specified companies.
	//
	// At most 20 company display name filters are allowed.
	CompanyDisplayNames []string `protobuf:"bytes,6,rep,name=company_display_names,json=companyDisplayNames,proto3" json:"company_display_names,omitempty"`
	// This search filter is applied only to
	// [Job.compensation_info][google.cloud.talent.v4beta1.Job.compensation_info]. For example, if the filter is specified
	// as "Hourly job with per-hour compensation > $15", only jobs meeting
	// these criteria are searched. If a filter isn't defined, all open jobs
	// are searched.
	CompensationFilter *CompensationFilter `protobuf:"bytes,7,opt,name=compensation_filter,json=compensationFilter,proto3" json:"compensation_filter,omitempty"`
	// This filter specifies a structured syntax to match against the
	// [Job.custom_attributes][google.cloud.talent.v4beta1.Job.custom_attributes] marked as `filterable`.
	//
	// The syntax for this expression is a subset of SQL syntax.
	//
	// Supported operators are: `=`, `!=`, `<`, `<=`, `>`, and `>=` where the
	// left of the operator is a custom field key and the right of the operator
	// is a number or a quoted string. You must escape backslash (\\) and
	// quote (\") characters.
	//
	// Supported functions are `LOWER([field_name])` to
	// perform a case insensitive match and `EMPTY([field_name])` to filter on the
	// existence of a key.
	//
	// Boolean expressions (AND/OR/NOT) are supported up to 3 levels of
	// nesting (for example, "((A AND B AND C) OR NOT D) AND E"), a maximum of 100
	// comparisons or functions are allowed in the expression. The expression
	// must be < 6000 bytes in length.
	//
	// Sample Query:
	// `(LOWER(driving_license)="class \"a\"" OR EMPTY(driving_license)) AND
	// driving_years > 10`
	CustomAttributeFilter string `protobuf:"bytes,8,opt,name=custom_attribute_filter,json=customAttributeFilter,proto3" json:"custom_attribute_filter,omitempty"`
	// This flag controls the spell-check feature. If false, the
	// service attempts to correct a misspelled query,
	// for example, "enginee" is corrected to "engineer".
	//
	// Defaults to false: a spell check is performed.
	DisableSpellCheck bool `protobuf:"varint,9,opt,name=disable_spell_check,json=disableSpellCheck,proto3" json:"disable_spell_check,omitempty"`
	// The employment type filter specifies the employment type of jobs to
	// search against, such as [EmploymentType.FULL_TIME][google.cloud.talent.v4beta1.EmploymentType.FULL_TIME].
	//
	// If a value isn't specified, jobs in the search results includes any
	// employment type.
	//
	// If multiple values are specified, jobs in the search results include
	// any of the specified employment types.
	EmploymentTypes []EmploymentType `protobuf:"varint,10,rep,packed,name=employment_types,json=employmentTypes,proto3,enum=google.cloud.talent.v4beta1.EmploymentType" json:"employment_types,omitempty"`
	// This filter specifies the locale of jobs to search against,
	// for example, "en-US".
	//
	// If a value isn't specified, the search results can contain jobs in any
	// locale.
	//
	//
	// Language codes should be in BCP-47 format, such as "en-US" or "sr-Latn".
	// For more information, see
	// [Tags for Identifying Languages](https://tools.ietf.org/html/bcp47).
	//
	// At most 10 language code filters are allowed.
	LanguageCodes []string `protobuf:"bytes,11,rep,name=language_codes,json=languageCodes,proto3" json:"language_codes,omitempty"`
	// Jobs published within a range specified by this filter are searched
	// against.
	PublishTimeRange *TimestampRange `protobuf:"bytes,12,opt,name=publish_time_range,json=publishTimeRange,proto3" json:"publish_time_range,omitempty"`
	// This filter specifies a list of job names to be excluded during search.
	//
	// At most 400 excluded job names are allowed.
	ExcludedJobs []string `protobuf:"bytes,13,rep,name=excluded_jobs,json=excludedJobs,proto3" json:"excluded_jobs,omitempty"`
}

func (x *JobQuery) Reset() {
	*x = JobQuery{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_talent_v4beta1_filters_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *JobQuery) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*JobQuery) ProtoMessage() {}

func (x *JobQuery) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_talent_v4beta1_filters_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use JobQuery.ProtoReflect.Descriptor instead.
func (*JobQuery) Descriptor() ([]byte, []int) {
	return file_google_cloud_talent_v4beta1_filters_proto_rawDescGZIP(), []int{0}
}

func (x *JobQuery) GetQuery() string {
	if x != nil {
		return x.Query
	}
	return ""
}

func (x *JobQuery) GetQueryLanguageCode() string {
	if x != nil {
		return x.QueryLanguageCode
	}
	return ""
}

func (x *JobQuery) GetCompanies() []string {
	if x != nil {
		return x.Companies
	}
	return nil
}

func (x *JobQuery) GetLocationFilters() []*LocationFilter {
	if x != nil {
		return x.LocationFilters
	}
	return nil
}

func (x *JobQuery) GetJobCategories() []JobCategory {
	if x != nil {
		return x.JobCategories
	}
	return nil
}

func (x *JobQuery) GetCommuteFilter() *CommuteFilter {
	if x != nil {
		return x.CommuteFilter
	}
	return nil
}

func (x *JobQuery) GetCompanyDisplayNames() []string {
	if x != nil {
		return x.CompanyDisplayNames
	}
	return nil
}

func (x *JobQuery) GetCompensationFilter() *CompensationFilter {
	if x != nil {
		return x.CompensationFilter
	}
	return nil
}

func (x *JobQuery) GetCustomAttributeFilter() string {
	if x != nil {
		return x.CustomAttributeFilter
	}
	return ""
}

func (x *JobQuery) GetDisableSpellCheck() bool {
	if x != nil {
		return x.DisableSpellCheck
	}
	return false
}

func (x *JobQuery) GetEmploymentTypes() []EmploymentType {
	if x != nil {
		return x.EmploymentTypes
	}
	return nil
}

func (x *JobQuery) GetLanguageCodes() []string {
	if x != nil {
		return x.LanguageCodes
	}
	return nil
}

func (x *JobQuery) GetPublishTimeRange() *TimestampRange {
	if x != nil {
		return x.PublishTimeRange
	}
	return nil
}

func (x *JobQuery) GetExcludedJobs() []string {
	if x != nil {
		return x.ExcludedJobs
	}
	return nil
}

// Filters to apply when performing the search query.
type ProfileQuery struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Keywords to match any text fields of profiles.
	//
	// For example, "software engineer in Palo Alto".
	Query string `protobuf:"bytes,1,opt,name=query,proto3" json:"query,omitempty"`
	// The location filter specifies geo-regions containing the profiles to
	// search against.
	//
	// One of [LocationFilter.address][google.cloud.talent.v4beta1.LocationFilter.address] or [LocationFilter.lat_lng][google.cloud.talent.v4beta1.LocationFilter.lat_lng] must be
	// provided or an error is thrown. If both [LocationFilter.address][google.cloud.talent.v4beta1.LocationFilter.address] and
	// [LocationFilter.lat_lng][google.cloud.talent.v4beta1.LocationFilter.lat_lng] are provided, an error is thrown.
	//
	// The following logic is used to determine which locations in
	// the profile to filter against:
	//
	// 1. All of the profile's geocoded [Profile.addresses][google.cloud.talent.v4beta1.Profile.addresses] where
	// [Address.usage][google.cloud.talent.v4beta1.Address.usage] is PERSONAL and [Address.current][google.cloud.talent.v4beta1.Address.current] is true.
	//
	// 2. If the above set of locations is empty, all of the profile's geocoded
	// [Profile.addresses][google.cloud.talent.v4beta1.Profile.addresses] where [Address.usage][google.cloud.talent.v4beta1.Address.usage] is
	// CONTACT_INFO_USAGE_UNSPECIFIED and [Address.current][google.cloud.talent.v4beta1.Address.current] is true.
	//
	// 3. If the above set of locations is empty, all of the profile's geocoded
	// [Profile.addresses][google.cloud.talent.v4beta1.Profile.addresses] where [Address.usage][google.cloud.talent.v4beta1.Address.usage] is PERSONAL or
	// CONTACT_INFO_USAGE_UNSPECIFIED and [Address.current][google.cloud.talent.v4beta1.Address.current] is not set.
	//
	// This means that any profiles without any [Profile.addresses][google.cloud.talent.v4beta1.Profile.addresses] that match
	// any of the above criteria will not be included in a search with location
	// filter. Furthermore, any [Profile.addresses][google.cloud.talent.v4beta1.Profile.addresses] where [Address.usage][google.cloud.talent.v4beta1.Address.usage] is
	// WORK or SCHOOL or where [Address.current][google.cloud.talent.v4beta1.Address.current] is false are not considered for
	// location filter.
	//
	// If a location filter isn't specified, profiles fitting the other search
	// criteria are retrieved regardless of where they're located.
	//
	// If [LocationFilter.negated][google.cloud.talent.v4beta1.LocationFilter.negated] is specified, the result doesn't contain
	// profiles from that location.
	//
	// If [LocationFilter.address][google.cloud.talent.v4beta1.LocationFilter.address] is provided, the
	// [LocationType][google.cloud.talent.v4beta1.Location.LocationType], center
	// point (latitude and longitude), and radius are automatically detected by
	// the Google Maps Geocoding API and included as well. If
	// [LocationFilter.address][google.cloud.talent.v4beta1.LocationFilter.address] cannot be geocoded, the filter
	// falls back to keyword search.
	//
	// If the detected
	// [LocationType][google.cloud.talent.v4beta1.Location.LocationType] is
	// [LocationType.SUB_ADMINISTRATIVE_AREA][google.cloud.talent.v4beta1.Location.LocationType.SUB_ADMINISTRATIVE_AREA],
	// [LocationType.ADMINISTRATIVE_AREA][google.cloud.talent.v4beta1.Location.LocationType.ADMINISTRATIVE_AREA],
	// or
	// [LocationType.COUNTRY][google.cloud.talent.v4beta1.Location.LocationType.COUNTRY],
	// the filter is performed against the detected location name (using exact
	// text matching). Otherwise, the filter is performed against the detected
	// center point and a radius of detected location radius +
	// [LocationFilter.distance_in_miles][google.cloud.talent.v4beta1.LocationFilter.distance_in_miles].
	//
	// If [LocationFilter.address][google.cloud.talent.v4beta1.LocationFilter.address] is provided,
	// [LocationFilter.distance_in_miles][google.cloud.talent.v4beta1.LocationFilter.distance_in_miles] is the additional radius on top of the
	// radius of the location geocoded from [LocationFilter.address][google.cloud.talent.v4beta1.LocationFilter.address]. If
	// [LocationFilter.lat_lng][google.cloud.talent.v4beta1.LocationFilter.lat_lng] is provided,
	// [LocationFilter.distance_in_miles][google.cloud.talent.v4beta1.LocationFilter.distance_in_miles] is the only radius that is used.
	//
	// [LocationFilter.distance_in_miles][google.cloud.talent.v4beta1.LocationFilter.distance_in_miles] is 10 by default. Note that the value
	// of [LocationFilter.distance_in_miles][google.cloud.talent.v4beta1.LocationFilter.distance_in_miles] is 0 if it is unset, so the server
	// does not differentiate [LocationFilter.distance_in_miles][google.cloud.talent.v4beta1.LocationFilter.distance_in_miles] that is
	// explicitly set to 0 and [LocationFilter.distance_in_miles][google.cloud.talent.v4beta1.LocationFilter.distance_in_miles] that is not
	// set. Which means that if [LocationFilter.distance_in_miles][google.cloud.talent.v4beta1.LocationFilter.distance_in_miles] is explicitly
	// set to 0, the server will use the default value of
	// [LocationFilter.distance_in_miles][google.cloud.talent.v4beta1.LocationFilter.distance_in_miles] which is 10. To work around this and
	// effectively set [LocationFilter.distance_in_miles][google.cloud.talent.v4beta1.LocationFilter.distance_in_miles] to 0, we recommend
	// setting [LocationFilter.distance_in_miles][google.cloud.talent.v4beta1.LocationFilter.distance_in_miles] to a very small decimal number
	// (such as 0.00001).
	//
	// If [LocationFilter.distance_in_miles][google.cloud.talent.v4beta1.LocationFilter.distance_in_miles] is negative, an error is thrown.
	LocationFilters []*LocationFilter `protobuf:"bytes,2,rep,name=location_filters,json=locationFilters,proto3" json:"location_filters,omitempty"`
	// Job title filter specifies job titles of profiles to match on.
	//
	// If a job title isn't specified, profiles with any titles are retrieved.
	//
	// If multiple values are specified, profiles are retrieved with any of the
	// specified job titles.
	//
	// If [JobTitleFilter.negated][google.cloud.talent.v4beta1.JobTitleFilter.negated] is specified, the result won't contain
	// profiles with the job titles.
	//
	// For example, search for profiles with a job title "Product Manager".
	JobTitleFilters []*JobTitleFilter `protobuf:"bytes,3,rep,name=job_title_filters,json=jobTitleFilters,proto3" json:"job_title_filters,omitempty"`
	// Employer filter specifies employers of profiles to match on.
	//
	// If an employer filter isn't specified, profiles with any employers are
	// retrieved.
	//
	// If multiple employer filters are specified, profiles with any matching
	// employers are retrieved.
	//
	// If [EmployerFilter.negated][google.cloud.talent.v4beta1.EmployerFilter.negated] is specified, the result won't contain
	// profiles that match the employers.
	//
	// For example, search for profiles that have working experience at "Google
	// LLC".
	EmployerFilters []*EmployerFilter `protobuf:"bytes,4,rep,name=employer_filters,json=employerFilters,proto3" json:"employer_filters,omitempty"`
	// Education filter specifies education of profiles to match on.
	//
	// If an education filter isn't specified, profiles with any education are
	// retrieved.
	//
	// If multiple education filters are specified, profiles that match any
	// education filters are retrieved.
	//
	// If [EducationFilter.negated][google.cloud.talent.v4beta1.EducationFilter.negated] is specified, the result won't contain
	// profiles that match the educations.
	//
	// For example, search for profiles with a master degree.
	EducationFilters []*EducationFilter `protobuf:"bytes,5,rep,name=education_filters,json=educationFilters,proto3" json:"education_filters,omitempty"`
	// Skill filter specifies skill of profiles to match on.
	//
	// If a skill filter isn't specified, profiles with any skills are retrieved.
	//
	// If multiple skill filters are specified, profiles that match any skill
	// filters are retrieved.
	//
	// If [SkillFilter.negated][google.cloud.talent.v4beta1.SkillFilter.negated] is specified, the result won't contain profiles
	// that match the skills.
	//
	// For example, search for profiles that have "Java" and "Python" in skill
	// list.
	SkillFilters []*SkillFilter `protobuf:"bytes,6,rep,name=skill_filters,json=skillFilters,proto3" json:"skill_filters,omitempty"`
	// Work experience filter specifies the total working experience of profiles
	// to match on.
	//
	// If a work experience filter isn't specified, profiles with any
	// professional experience are retrieved.
	//
	// If multiple work experience filters are specified, profiles that match any
	// work experience filters are retrieved.
	//
	// For example, search for profiles with 10 years of work experience.
	WorkExperienceFilter []*WorkExperienceFilter `protobuf:"bytes,7,rep,name=work_experience_filter,json=workExperienceFilter,proto3" json:"work_experience_filter,omitempty"`
	// Time filter specifies the create/update timestamp of the profiles to match
	// on.
	//
	// For example, search for profiles created since "2018-1-1".
	TimeFilters []*TimeFilter `protobuf:"bytes,8,rep,name=time_filters,json=timeFilters,proto3" json:"time_filters,omitempty"`
	// The hirable filter specifies the profile's hirable status to match on.
	HirableFilter *wrapperspb.BoolValue `protobuf:"bytes,9,opt,name=hirable_filter,json=hirableFilter,proto3" json:"hirable_filter,omitempty"`
	// The application date filters specify application date ranges to match on.
	ApplicationDateFilters []*ApplicationDateFilter `protobuf:"bytes,10,rep,name=application_date_filters,json=applicationDateFilters,proto3" json:"application_date_filters,omitempty"`
	// The application outcome notes filters specify the notes for the outcome of
	// the job application.
	ApplicationOutcomeNotesFilters []*ApplicationOutcomeNotesFilter `protobuf:"bytes,11,rep,name=application_outcome_notes_filters,json=applicationOutcomeNotesFilters,proto3" json:"application_outcome_notes_filters,omitempty"`
	// The application job filters specify the job applied for in the application.
	ApplicationJobFilters []*ApplicationJobFilter `protobuf:"bytes,13,rep,name=application_job_filters,json=applicationJobFilters,proto3" json:"application_job_filters,omitempty"`
	// This filter specifies a structured syntax to match against the
	// [Profile.custom_attributes][google.cloud.talent.v4beta1.Profile.custom_attributes] that are marked as `filterable`.
	//
	// The syntax for this expression is a subset of Google SQL syntax.
	//
	// String custom attributes: supported operators are =, != where the left of
	// the operator is a custom field key and the right of the operator is a
	// string (surrounded by quotes) value.
	//
	// Numeric custom attributes: Supported operators are '>', '<' or '='
	// operators where the left of the operator is a custom field key and the
	// right of the operator is a numeric value.
	//
	// Supported functions are LOWER(<field_name>) to
	// perform case insensitive match and EMPTY(<field_name>) to filter on the
	// existence of a key.
	//
	// Boolean expressions (AND/OR/NOT) are supported up to 3 levels of
	// nesting (for example "((A AND B AND C) OR NOT D) AND E"), and there can be
	// a maximum of 50 comparisons/functions in the expression. The expression
	// must be < 2000 characters in length.
	//
	// Sample Query:
	// (key1 = "TEST" OR LOWER(key1)="test" OR NOT EMPTY(key1))
	CustomAttributeFilter string `protobuf:"bytes,15,opt,name=custom_attribute_filter,json=customAttributeFilter,proto3" json:"custom_attribute_filter,omitempty"`
	// Deprecated. Use availability_filters instead.
	//
	// The candidate availability filter which filters based on availability
	// signals.
	//
	// Signal 1: Number of days since most recent job application.  See
	// [Availability.JobApplicationAvailabilitySignal][google.cloud.talent.v4beta1.Availability.JobApplicationAvailabilitySignal] for the details of this
	// signal.
	//
	// Signal 2: Number of days since last profile update. See
	// [Availability.ProfileUpdateAvailabilitySignal][google.cloud.talent.v4beta1.Availability.ProfileUpdateAvailabilitySignal]
	// for the details of this signal.
	//
	// The candidate availability filter helps a recruiter understand if a
	// specific candidate is likely to be actively seeking new job opportunities
	// based on an aggregated set of signals.  Specifically, the intent is NOT to
	// indicate the candidate's potential qualification / interest / close ability
	// for a specific job.
	//
	// Deprecated: Do not use.
	CandidateAvailabilityFilter *CandidateAvailabilityFilter `protobuf:"bytes,16,opt,name=candidate_availability_filter,json=candidateAvailabilityFilter,proto3" json:"candidate_availability_filter,omitempty"`
	// The availability filter which filters based on
	// [Profile.availability_signals][google.cloud.talent.v4beta1.Profile.availability_signals].
	//
	// The availability filter helps a recruiter understand if a
	// specific candidate is likely to be actively seeking new job opportunities
	// based on an aggregated set of signals.  Specifically, the intent is NOT to
	// indicate the candidate's potential qualification / interest / close ability
	// for a specific job.
	//
	// There can be at most one [AvailabilityFilter][google.cloud.talent.v4beta1.AvailabilityFilter] per
	// [signal_type][google.cloud.talent.v4beta1.AvailabilityFilter.signal_type]. If there are multiple
	// [AvailabilityFilter][google.cloud.talent.v4beta1.AvailabilityFilter] for a [signal_type][google.cloud.talent.v4beta1.AvailabilityFilter.signal_type],
	// an error is thrown.
	AvailabilityFilters []*AvailabilityFilter `protobuf:"bytes,18,rep,name=availability_filters,json=availabilityFilters,proto3" json:"availability_filters,omitempty"`
	// Person name filter specifies person name of profiles to match on.
	//
	// If multiple person name filters are specified, profiles that match any
	// person name filters are retrieved.
	//
	// For example, search for profiles of candidates with name "John Smith".
	PersonNameFilters []*PersonNameFilter `protobuf:"bytes,17,rep,name=person_name_filters,json=personNameFilters,proto3" json:"person_name_filters,omitempty"`
}

func (x *ProfileQuery) Reset() {
	*x = ProfileQuery{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_talent_v4beta1_filters_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ProfileQuery) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ProfileQuery) ProtoMessage() {}

func (x *ProfileQuery) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_talent_v4beta1_filters_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ProfileQuery.ProtoReflect.Descriptor instead.
func (*ProfileQuery) Descriptor() ([]byte, []int) {
	return file_google_cloud_talent_v4beta1_filters_proto_rawDescGZIP(), []int{1}
}

func (x *ProfileQuery) GetQuery() string {
	if x != nil {
		return x.Query
	}
	return ""
}

func (x *ProfileQuery) GetLocationFilters() []*LocationFilter {
	if x != nil {
		return x.LocationFilters
	}
	return nil
}

func (x *ProfileQuery) GetJobTitleFilters() []*JobTitleFilter {
	if x != nil {
		return x.JobTitleFilters
	}
	return nil
}

func (x *ProfileQuery) GetEmployerFilters() []*EmployerFilter {
	if x != nil {
		return x.EmployerFilters
	}
	return nil
}

func (x *ProfileQuery) GetEducationFilters() []*EducationFilter {
	if x != nil {
		return x.EducationFilters
	}
	return nil
}

func (x *ProfileQuery) GetSkillFilters() []*SkillFilter {
	if x != nil {
		return x.SkillFilters
	}
	return nil
}

func (x *ProfileQuery) GetWorkExperienceFilter() []*WorkExperienceFilter {
	if x != nil {
		return x.WorkExperienceFilter
	}
	return nil
}

func (x *ProfileQuery) GetTimeFilters() []*TimeFilter {
	if x != nil {
		return x.TimeFilters
	}
	return nil
}

func (x *ProfileQuery) GetHirableFilter() *wrapperspb.BoolValue {
	if x != nil {
		return x.HirableFilter
	}
	return nil
}

func (x *ProfileQuery) GetApplicationDateFilters() []*ApplicationDateFilter {
	if x != nil {
		return x.ApplicationDateFilters
	}
	return nil
}

func (x *ProfileQuery) GetApplicationOutcomeNotesFilters() []*ApplicationOutcomeNotesFilter {
	if x != nil {
		return x.ApplicationOutcomeNotesFilters
	}
	return nil
}

func (x *ProfileQuery) GetApplicationJobFilters() []*ApplicationJobFilter {
	if x != nil {
		return x.ApplicationJobFilters
	}
	return nil
}

func (x *ProfileQuery) GetCustomAttributeFilter() string {
	if x != nil {
		return x.CustomAttributeFilter
	}
	return ""
}

// Deprecated: Do not use.
func (x *ProfileQuery) GetCandidateAvailabilityFilter() *CandidateAvailabilityFilter {
	if x != nil {
		return x.CandidateAvailabilityFilter
	}
	return nil
}

func (x *ProfileQuery) GetAvailabilityFilters() []*AvailabilityFilter {
	if x != nil {
		return x.AvailabilityFilters
	}
	return nil
}

func (x *ProfileQuery) GetPersonNameFilters() []*PersonNameFilter {
	if x != nil {
		return x.PersonNameFilters
	}
	return nil
}

// Geographic region of the search.
type LocationFilter struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The address name, such as "Mountain View" or "Bay Area".
	Address string `protobuf:"bytes,1,opt,name=address,proto3" json:"address,omitempty"`
	// CLDR region code of the country/region of the address. This is used
	// to address ambiguity of the user-input location, for example, "Liverpool"
	// against "Liverpool, NY, US" or "Liverpool, UK".
	//
	// Set this field to bias location resolution toward a specific country
	// or territory. If this field is not set, application behavior is biased
	// toward the United States by default.
	//
	// See
	// https://www.unicode.org/cldr/charts/30/supplemental/territory_information.html
	// for details. Example: "CH" for Switzerland.
	// Note that this filter is not applicable for Profile Search related queries.
	RegionCode string `protobuf:"bytes,2,opt,name=region_code,json=regionCode,proto3" json:"region_code,omitempty"`
	// The latitude and longitude of the geographic center to search from. This
	// field is ignored if `address` is provided.
	LatLng *latlng.LatLng `protobuf:"bytes,3,opt,name=lat_lng,json=latLng,proto3" json:"lat_lng,omitempty"`
	// The distance_in_miles is applied when the location being searched for is
	// identified as a city or smaller. This field is ignored if the location
	// being searched for is a state or larger.
	DistanceInMiles float64 `protobuf:"fixed64,4,opt,name=distance_in_miles,json=distanceInMiles,proto3" json:"distance_in_miles,omitempty"`
	// Allows the client to return jobs without a
	// set location, specifically, telecommuting jobs (telecommuting is considered
	// by the service as a special location.
	// [Job.posting_region][google.cloud.talent.v4beta1.Job.posting_region] indicates if a job permits telecommuting.
	// If this field is set to [TelecommutePreference.TELECOMMUTE_ALLOWED][google.cloud.talent.v4beta1.LocationFilter.TelecommutePreference.TELECOMMUTE_ALLOWED],
	// telecommuting jobs are searched, and [address][google.cloud.talent.v4beta1.LocationFilter.address] and [lat_lng][google.cloud.talent.v4beta1.LocationFilter.lat_lng] are
	// ignored. If not set or set to
	// [TelecommutePreference.TELECOMMUTE_EXCLUDED][google.cloud.talent.v4beta1.LocationFilter.TelecommutePreference.TELECOMMUTE_EXCLUDED], telecommute job are not
	// searched.
	//
	// This filter can be used by itself to search exclusively for telecommuting
	// jobs, or it can be combined with another location
	// filter to search for a combination of job locations,
	// such as "Mountain View" or "telecommuting" jobs. However, when used in
	// combination with other location filters, telecommuting jobs can be
	// treated as less relevant than other jobs in the search response.
	//
	// This field is only used for job search requests.
	TelecommutePreference LocationFilter_TelecommutePreference `protobuf:"varint,5,opt,name=telecommute_preference,json=telecommutePreference,proto3,enum=google.cloud.talent.v4beta1.LocationFilter_TelecommutePreference" json:"telecommute_preference,omitempty"`
	// Whether to apply negation to the filter so profiles matching the filter
	// are excluded.
	//
	// Currently only supported in profile search.
	Negated bool `protobuf:"varint,6,opt,name=negated,proto3" json:"negated,omitempty"`
}

func (x *LocationFilter) Reset() {
	*x = LocationFilter{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_talent_v4beta1_filters_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *LocationFilter) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*LocationFilter) ProtoMessage() {}

func (x *LocationFilter) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_talent_v4beta1_filters_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use LocationFilter.ProtoReflect.Descriptor instead.
func (*LocationFilter) Descriptor() ([]byte, []int) {
	return file_google_cloud_talent_v4beta1_filters_proto_rawDescGZIP(), []int{2}
}

func (x *LocationFilter) GetAddress() string {
	if x != nil {
		return x.Address
	}
	return ""
}

func (x *LocationFilter) GetRegionCode() string {
	if x != nil {
		return x.RegionCode
	}
	return ""
}

func (x *LocationFilter) GetLatLng() *latlng.LatLng {
	if x != nil {
		return x.LatLng
	}
	return nil
}

func (x *LocationFilter) GetDistanceInMiles() float64 {
	if x != nil {
		return x.DistanceInMiles
	}
	return 0
}

func (x *LocationFilter) GetTelecommutePreference() LocationFilter_TelecommutePreference {
	if x != nil {
		return x.TelecommutePreference
	}
	return LocationFilter_TELECOMMUTE_PREFERENCE_UNSPECIFIED
}

func (x *LocationFilter) GetNegated() bool {
	if x != nil {
		return x.Negated
	}
	return false
}

// Filter on job compensation type and amount.
type CompensationFilter struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Type of filter.
	Type CompensationFilter_FilterType `protobuf:"varint,1,opt,name=type,proto3,enum=google.cloud.talent.v4beta1.CompensationFilter_FilterType" json:"type,omitempty"`
	// Required. Specify desired `base compensation entry's`
	// [CompensationInfo.CompensationUnit][google.cloud.talent.v4beta1.CompensationInfo.CompensationUnit].
	Units []CompensationInfo_CompensationUnit `protobuf:"varint,2,rep,packed,name=units,proto3,enum=google.cloud.talent.v4beta1.CompensationInfo_CompensationUnit" json:"units,omitempty"`
	// Compensation range.
	Range *CompensationInfo_CompensationRange `protobuf:"bytes,3,opt,name=range,proto3" json:"range,omitempty"`
	// If set to true, jobs with unspecified compensation range fields are
	// included.
	IncludeJobsWithUnspecifiedCompensationRange bool `protobuf:"varint,4,opt,name=include_jobs_with_unspecified_compensation_range,json=includeJobsWithUnspecifiedCompensationRange,proto3" json:"include_jobs_with_unspecified_compensation_range,omitempty"`
}

func (x *CompensationFilter) Reset() {
	*x = CompensationFilter{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_talent_v4beta1_filters_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CompensationFilter) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CompensationFilter) ProtoMessage() {}

func (x *CompensationFilter) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_talent_v4beta1_filters_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CompensationFilter.ProtoReflect.Descriptor instead.
func (*CompensationFilter) Descriptor() ([]byte, []int) {
	return file_google_cloud_talent_v4beta1_filters_proto_rawDescGZIP(), []int{3}
}

func (x *CompensationFilter) GetType() CompensationFilter_FilterType {
	if x != nil {
		return x.Type
	}
	return CompensationFilter_FILTER_TYPE_UNSPECIFIED
}

func (x *CompensationFilter) GetUnits() []CompensationInfo_CompensationUnit {
	if x != nil {
		return x.Units
	}
	return nil
}

func (x *CompensationFilter) GetRange() *CompensationInfo_CompensationRange {
	if x != nil {
		return x.Range
	}
	return nil
}

func (x *CompensationFilter) GetIncludeJobsWithUnspecifiedCompensationRange() bool {
	if x != nil {
		return x.IncludeJobsWithUnspecifiedCompensationRange
	}
	return false
}

// Parameters needed for commute search.
type CommuteFilter struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The method of transportation to calculate the commute time for.
	CommuteMethod CommuteMethod `protobuf:"varint,1,opt,name=commute_method,json=commuteMethod,proto3,enum=google.cloud.talent.v4beta1.CommuteMethod" json:"commute_method,omitempty"`
	// Required. The latitude and longitude of the location to calculate the
	// commute time from.
	StartCoordinates *latlng.LatLng `protobuf:"bytes,2,opt,name=start_coordinates,json=startCoordinates,proto3" json:"start_coordinates,omitempty"`
	// Required. The maximum travel time in seconds. The maximum allowed value is `3600s`
	// (one hour). Format is `123s`.
	TravelDuration *durationpb.Duration `protobuf:"bytes,3,opt,name=travel_duration,json=travelDuration,proto3" json:"travel_duration,omitempty"`
	// If `true`, jobs without street level addresses may also be returned.
	// For city level addresses, the city center is used. For state and coarser
	// level addresses, text matching is used.
	// If this field is set to `false` or isn't specified, only jobs that include
	// street level addresses will be returned by commute search.
	AllowImpreciseAddresses bool `protobuf:"varint,4,opt,name=allow_imprecise_addresses,json=allowImpreciseAddresses,proto3" json:"allow_imprecise_addresses,omitempty"`
	// Traffic factor to take into account while searching by commute.
	//
	// Types that are assignable to TrafficOption:
	//	*CommuteFilter_RoadTraffic_
	//	*CommuteFilter_DepartureTime
	TrafficOption isCommuteFilter_TrafficOption `protobuf_oneof:"traffic_option"`
}

func (x *CommuteFilter) Reset() {
	*x = CommuteFilter{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_talent_v4beta1_filters_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CommuteFilter) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CommuteFilter) ProtoMessage() {}

func (x *CommuteFilter) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_talent_v4beta1_filters_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CommuteFilter.ProtoReflect.Descriptor instead.
func (*CommuteFilter) Descriptor() ([]byte, []int) {
	return file_google_cloud_talent_v4beta1_filters_proto_rawDescGZIP(), []int{4}
}

func (x *CommuteFilter) GetCommuteMethod() CommuteMethod {
	if x != nil {
		return x.CommuteMethod
	}
	return CommuteMethod_COMMUTE_METHOD_UNSPECIFIED
}

func (x *CommuteFilter) GetStartCoordinates() *latlng.LatLng {
	if x != nil {
		return x.StartCoordinates
	}
	return nil
}

func (x *CommuteFilter) GetTravelDuration() *durationpb.Duration {
	if x != nil {
		return x.TravelDuration
	}
	return nil
}

func (x *CommuteFilter) GetAllowImpreciseAddresses() bool {
	if x != nil {
		return x.AllowImpreciseAddresses
	}
	return false
}

func (m *CommuteFilter) GetTrafficOption() isCommuteFilter_TrafficOption {
	if m != nil {
		return m.TrafficOption
	}
	return nil
}

func (x *CommuteFilter) GetRoadTraffic() CommuteFilter_RoadTraffic {
	if x, ok := x.GetTrafficOption().(*CommuteFilter_RoadTraffic_); ok {
		return x.RoadTraffic
	}
	return CommuteFilter_ROAD_TRAFFIC_UNSPECIFIED
}

func (x *CommuteFilter) GetDepartureTime() *timeofday.TimeOfDay {
	if x, ok := x.GetTrafficOption().(*CommuteFilter_DepartureTime); ok {
		return x.DepartureTime
	}
	return nil
}

type isCommuteFilter_TrafficOption interface {
	isCommuteFilter_TrafficOption()
}

type CommuteFilter_RoadTraffic_ struct {
	// Specifies the traffic density to use when calculating commute time.
	RoadTraffic CommuteFilter_RoadTraffic `protobuf:"varint,5,opt,name=road_traffic,json=roadTraffic,proto3,enum=google.cloud.talent.v4beta1.CommuteFilter_RoadTraffic,oneof"`
}

type CommuteFilter_DepartureTime struct {
	// The departure time used to calculate traffic impact, represented as
	// [google.type.TimeOfDay][google.type.TimeOfDay] in local time zone.
	//
	// Currently traffic model is restricted to hour level resolution.
	DepartureTime *timeofday.TimeOfDay `protobuf:"bytes,6,opt,name=departure_time,json=departureTime,proto3,oneof"`
}

func (*CommuteFilter_RoadTraffic_) isCommuteFilter_TrafficOption() {}

func (*CommuteFilter_DepartureTime) isCommuteFilter_TrafficOption() {}

// Job title of the search.
type JobTitleFilter struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The job title. For example, "Software engineer", or "Product manager".
	JobTitle string `protobuf:"bytes,1,opt,name=job_title,json=jobTitle,proto3" json:"job_title,omitempty"`
	// Whether to apply negation to the filter so profiles matching the filter
	// are excluded.
	Negated bool `protobuf:"varint,2,opt,name=negated,proto3" json:"negated,omitempty"`
}

func (x *JobTitleFilter) Reset() {
	*x = JobTitleFilter{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_talent_v4beta1_filters_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *JobTitleFilter) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*JobTitleFilter) ProtoMessage() {}

func (x *JobTitleFilter) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_talent_v4beta1_filters_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use JobTitleFilter.ProtoReflect.Descriptor instead.
func (*JobTitleFilter) Descriptor() ([]byte, []int) {
	return file_google_cloud_talent_v4beta1_filters_proto_rawDescGZIP(), []int{5}
}

func (x *JobTitleFilter) GetJobTitle() string {
	if x != nil {
		return x.JobTitle
	}
	return ""
}

func (x *JobTitleFilter) GetNegated() bool {
	if x != nil {
		return x.Negated
	}
	return false
}

// Skill filter of the search.
type SkillFilter struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The skill name. For example, "java", "j2ee", and so on.
	Skill string `protobuf:"bytes,1,opt,name=skill,proto3" json:"skill,omitempty"`
	// Whether to apply negation to the filter so profiles matching the filter
	// are excluded.
	Negated bool `protobuf:"varint,2,opt,name=negated,proto3" json:"negated,omitempty"`
}

func (x *SkillFilter) Reset() {
	*x = SkillFilter{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_talent_v4beta1_filters_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SkillFilter) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SkillFilter) ProtoMessage() {}

func (x *SkillFilter) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_talent_v4beta1_filters_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SkillFilter.ProtoReflect.Descriptor instead.
func (*SkillFilter) Descriptor() ([]byte, []int) {
	return file_google_cloud_talent_v4beta1_filters_proto_rawDescGZIP(), []int{6}
}

func (x *SkillFilter) GetSkill() string {
	if x != nil {
		return x.Skill
	}
	return ""
}

func (x *SkillFilter) GetNegated() bool {
	if x != nil {
		return x.Negated
	}
	return false
}

// Employer filter of the search.
type EmployerFilter struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the employer, for example "Google", "Alphabet".
	Employer string `protobuf:"bytes,1,opt,name=employer,proto3" json:"employer,omitempty"`
	// Define set of [EmploymentRecord][google.cloud.talent.v4beta1.EmploymentRecord]s to search against.
	//
	// Defaults to [EmployerFilterMode.ALL_EMPLOYMENT_RECORDS][google.cloud.talent.v4beta1.EmployerFilter.EmployerFilterMode.ALL_EMPLOYMENT_RECORDS].
	Mode EmployerFilter_EmployerFilterMode `protobuf:"varint,2,opt,name=mode,proto3,enum=google.cloud.talent.v4beta1.EmployerFilter_EmployerFilterMode" json:"mode,omitempty"`
	// Whether to apply negation to the filter so profiles matching the filter
	// is excluded.
	Negated bool `protobuf:"varint,3,opt,name=negated,proto3" json:"negated,omitempty"`
}

func (x *EmployerFilter) Reset() {
	*x = EmployerFilter{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_talent_v4beta1_filters_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *EmployerFilter) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*EmployerFilter) ProtoMessage() {}

func (x *EmployerFilter) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_talent_v4beta1_filters_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use EmployerFilter.ProtoReflect.Descriptor instead.
func (*EmployerFilter) Descriptor() ([]byte, []int) {
	return file_google_cloud_talent_v4beta1_filters_proto_rawDescGZIP(), []int{7}
}

func (x *EmployerFilter) GetEmployer() string {
	if x != nil {
		return x.Employer
	}
	return ""
}

func (x *EmployerFilter) GetMode() EmployerFilter_EmployerFilterMode {
	if x != nil {
		return x.Mode
	}
	return EmployerFilter_EMPLOYER_FILTER_MODE_UNSPECIFIED
}

func (x *EmployerFilter) GetNegated() bool {
	if x != nil {
		return x.Negated
	}
	return false
}

// Education filter of the search.
type EducationFilter struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The school name. For example "MIT", "University of California, Berkeley".
	School string `protobuf:"bytes,1,opt,name=school,proto3" json:"school,omitempty"`
	// The field of study. This is to search against value provided in
	// [Degree.fields_of_study][google.cloud.talent.v4beta1.Degree.fields_of_study].
	// For example "Computer Science", "Mathematics".
	FieldOfStudy string `protobuf:"bytes,2,opt,name=field_of_study,json=fieldOfStudy,proto3" json:"field_of_study,omitempty"`
	// Education degree in ISCED code. Each value in degree covers a specific
	// level of education, without any expansion to upper nor lower levels of
	// education degree.
	DegreeType DegreeType `protobuf:"varint,3,opt,name=degree_type,json=degreeType,proto3,enum=google.cloud.talent.v4beta1.DegreeType" json:"degree_type,omitempty"`
	// Whether to apply negation to the filter so profiles matching the filter
	// is excluded.
	Negated bool `protobuf:"varint,6,opt,name=negated,proto3" json:"negated,omitempty"`
}

func (x *EducationFilter) Reset() {
	*x = EducationFilter{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_talent_v4beta1_filters_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *EducationFilter) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*EducationFilter) ProtoMessage() {}

func (x *EducationFilter) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_talent_v4beta1_filters_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use EducationFilter.ProtoReflect.Descriptor instead.
func (*EducationFilter) Descriptor() ([]byte, []int) {
	return file_google_cloud_talent_v4beta1_filters_proto_rawDescGZIP(), []int{8}
}

func (x *EducationFilter) GetSchool() string {
	if x != nil {
		return x.School
	}
	return ""
}

func (x *EducationFilter) GetFieldOfStudy() string {
	if x != nil {
		return x.FieldOfStudy
	}
	return ""
}

func (x *EducationFilter) GetDegreeType() DegreeType {
	if x != nil {
		return x.DegreeType
	}
	return DegreeType_DEGREE_TYPE_UNSPECIFIED
}

func (x *EducationFilter) GetNegated() bool {
	if x != nil {
		return x.Negated
	}
	return false
}

// Work experience filter.
//
// This filter is used to search for profiles with working experience length
// between [min_experience][google.cloud.talent.v4beta1.WorkExperienceFilter.min_experience] and [max_experience][google.cloud.talent.v4beta1.WorkExperienceFilter.max_experience].
type WorkExperienceFilter struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The minimum duration of the work experience (inclusive).
	MinExperience *durationpb.Duration `protobuf:"bytes,1,opt,name=min_experience,json=minExperience,proto3" json:"min_experience,omitempty"`
	// The maximum duration of the work experience (exclusive).
	MaxExperience *durationpb.Duration `protobuf:"bytes,2,opt,name=max_experience,json=maxExperience,proto3" json:"max_experience,omitempty"`
}

func (x *WorkExperienceFilter) Reset() {
	*x = WorkExperienceFilter{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_talent_v4beta1_filters_proto_msgTypes[9]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *WorkExperienceFilter) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*WorkExperienceFilter) ProtoMessage() {}

func (x *WorkExperienceFilter) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_talent_v4beta1_filters_proto_msgTypes[9]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use WorkExperienceFilter.ProtoReflect.Descriptor instead.
func (*WorkExperienceFilter) Descriptor() ([]byte, []int) {
	return file_google_cloud_talent_v4beta1_filters_proto_rawDescGZIP(), []int{9}
}

func (x *WorkExperienceFilter) GetMinExperience() *durationpb.Duration {
	if x != nil {
		return x.MinExperience
	}
	return nil
}

func (x *WorkExperienceFilter) GetMaxExperience() *durationpb.Duration {
	if x != nil {
		return x.MaxExperience
	}
	return nil
}

// Application Date Range Filter.
//
// The API matches profiles with [Application.application_date][google.cloud.talent.v4beta1.Application.application_date] between
// start date and end date (both boundaries are inclusive). The filter is
// ignored if both [start_date][google.cloud.talent.v4beta1.ApplicationDateFilter.start_date] and [end_date][google.cloud.talent.v4beta1.ApplicationDateFilter.end_date] are missing.
type ApplicationDateFilter struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Start date. If it's missing, The API matches profiles with application date
	// not after the end date.
	StartDate *date.Date `protobuf:"bytes,1,opt,name=start_date,json=startDate,proto3" json:"start_date,omitempty"`
	// End date. If it's missing, The API matches profiles with application date
	// not before the start date.
	EndDate *date.Date `protobuf:"bytes,2,opt,name=end_date,json=endDate,proto3" json:"end_date,omitempty"`
}

func (x *ApplicationDateFilter) Reset() {
	*x = ApplicationDateFilter{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_talent_v4beta1_filters_proto_msgTypes[10]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ApplicationDateFilter) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ApplicationDateFilter) ProtoMessage() {}

func (x *ApplicationDateFilter) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_talent_v4beta1_filters_proto_msgTypes[10]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ApplicationDateFilter.ProtoReflect.Descriptor instead.
func (*ApplicationDateFilter) Descriptor() ([]byte, []int) {
	return file_google_cloud_talent_v4beta1_filters_proto_rawDescGZIP(), []int{10}
}

func (x *ApplicationDateFilter) GetStartDate() *date.Date {
	if x != nil {
		return x.StartDate
	}
	return nil
}

func (x *ApplicationDateFilter) GetEndDate() *date.Date {
	if x != nil {
		return x.EndDate
	}
	return nil
}

// Outcome Notes Filter.
type ApplicationOutcomeNotesFilter struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. User entered or selected outcome reason. The API does an exact match on the
	// [Application.outcome_notes][google.cloud.talent.v4beta1.Application.outcome_notes] in profiles.
	OutcomeNotes string `protobuf:"bytes,1,opt,name=outcome_notes,json=outcomeNotes,proto3" json:"outcome_notes,omitempty"`
	// If true, The API excludes all candidates with any
	// [Application.outcome_notes][google.cloud.talent.v4beta1.Application.outcome_notes] matching the outcome reason specified in
	// the filter.
	Negated bool `protobuf:"varint,2,opt,name=negated,proto3" json:"negated,omitempty"`
}

func (x *ApplicationOutcomeNotesFilter) Reset() {
	*x = ApplicationOutcomeNotesFilter{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_talent_v4beta1_filters_proto_msgTypes[11]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ApplicationOutcomeNotesFilter) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ApplicationOutcomeNotesFilter) ProtoMessage() {}

func (x *ApplicationOutcomeNotesFilter) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_talent_v4beta1_filters_proto_msgTypes[11]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ApplicationOutcomeNotesFilter.ProtoReflect.Descriptor instead.
func (*ApplicationOutcomeNotesFilter) Descriptor() ([]byte, []int) {
	return file_google_cloud_talent_v4beta1_filters_proto_rawDescGZIP(), []int{11}
}

func (x *ApplicationOutcomeNotesFilter) GetOutcomeNotes() string {
	if x != nil {
		return x.OutcomeNotes
	}
	return ""
}

func (x *ApplicationOutcomeNotesFilter) GetNegated() bool {
	if x != nil {
		return x.Negated
	}
	return false
}

// Filter on the job information of Application.
type ApplicationJobFilter struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The job requisition id in the application. The API does an exact match on
	// the [Job.requisition_id][google.cloud.talent.v4beta1.Job.requisition_id] of [Application.job][google.cloud.talent.v4beta1.Application.job] in profiles.
	JobRequisitionId string `protobuf:"bytes,2,opt,name=job_requisition_id,json=jobRequisitionId,proto3" json:"job_requisition_id,omitempty"`
	// The job title in the application. The API does an exact match on the
	// [Job.title][google.cloud.talent.v4beta1.Job.title] of [Application.job][google.cloud.talent.v4beta1.Application.job] in profiles.
	JobTitle string `protobuf:"bytes,3,opt,name=job_title,json=jobTitle,proto3" json:"job_title,omitempty"`
	// If true, the API excludes all profiles with any [Application.job][google.cloud.talent.v4beta1.Application.job]
	// matching the filters.
	Negated bool `protobuf:"varint,4,opt,name=negated,proto3" json:"negated,omitempty"`
}

func (x *ApplicationJobFilter) Reset() {
	*x = ApplicationJobFilter{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_talent_v4beta1_filters_proto_msgTypes[12]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ApplicationJobFilter) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ApplicationJobFilter) ProtoMessage() {}

func (x *ApplicationJobFilter) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_talent_v4beta1_filters_proto_msgTypes[12]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ApplicationJobFilter.ProtoReflect.Descriptor instead.
func (*ApplicationJobFilter) Descriptor() ([]byte, []int) {
	return file_google_cloud_talent_v4beta1_filters_proto_rawDescGZIP(), []int{12}
}

func (x *ApplicationJobFilter) GetJobRequisitionId() string {
	if x != nil {
		return x.JobRequisitionId
	}
	return ""
}

func (x *ApplicationJobFilter) GetJobTitle() string {
	if x != nil {
		return x.JobTitle
	}
	return ""
}

func (x *ApplicationJobFilter) GetNegated() bool {
	if x != nil {
		return x.Negated
	}
	return false
}

// Filter on create timestamp or update timestamp of profiles.
type TimeFilter struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Start timestamp, matching profiles with the start time. If this field
	// missing, The API matches profiles with create / update timestamp before the
	// end timestamp.
	StartTime *timestamppb.Timestamp `protobuf:"bytes,1,opt,name=start_time,json=startTime,proto3" json:"start_time,omitempty"`
	// End timestamp, matching profiles with the end time. If this field
	// missing, The API matches profiles with create / update timestamp after the
	// start timestamp.
	EndTime *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=end_time,json=endTime,proto3" json:"end_time,omitempty"`
	// Specifies which time field to filter profiles.
	//
	// Defaults to [TimeField.CREATE_TIME][google.cloud.talent.v4beta1.TimeFilter.TimeField.CREATE_TIME].
	TimeField TimeFilter_TimeField `protobuf:"varint,3,opt,name=time_field,json=timeField,proto3,enum=google.cloud.talent.v4beta1.TimeFilter_TimeField" json:"time_field,omitempty"`
}

func (x *TimeFilter) Reset() {
	*x = TimeFilter{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_talent_v4beta1_filters_proto_msgTypes[13]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *TimeFilter) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TimeFilter) ProtoMessage() {}

func (x *TimeFilter) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_talent_v4beta1_filters_proto_msgTypes[13]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TimeFilter.ProtoReflect.Descriptor instead.
func (*TimeFilter) Descriptor() ([]byte, []int) {
	return file_google_cloud_talent_v4beta1_filters_proto_rawDescGZIP(), []int{13}
}

func (x *TimeFilter) GetStartTime() *timestamppb.Timestamp {
	if x != nil {
		return x.StartTime
	}
	return nil
}

func (x *TimeFilter) GetEndTime() *timestamppb.Timestamp {
	if x != nil {
		return x.EndTime
	}
	return nil
}

func (x *TimeFilter) GetTimeField() TimeFilter_TimeField {
	if x != nil {
		return x.TimeField
	}
	return TimeFilter_TIME_FIELD_UNSPECIFIED
}

// Deprecated. Use AvailabilityFilter instead.
//
// Filter on availability signals.
//
// Deprecated: Do not use.
type CandidateAvailabilityFilter struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// It is false by default. If true, API excludes all the potential available
	// profiles.
	Negated bool `protobuf:"varint,1,opt,name=negated,proto3" json:"negated,omitempty"`
}

func (x *CandidateAvailabilityFilter) Reset() {
	*x = CandidateAvailabilityFilter{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_talent_v4beta1_filters_proto_msgTypes[14]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CandidateAvailabilityFilter) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CandidateAvailabilityFilter) ProtoMessage() {}

func (x *CandidateAvailabilityFilter) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_talent_v4beta1_filters_proto_msgTypes[14]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CandidateAvailabilityFilter.ProtoReflect.Descriptor instead.
func (*CandidateAvailabilityFilter) Descriptor() ([]byte, []int) {
	return file_google_cloud_talent_v4beta1_filters_proto_rawDescGZIP(), []int{14}
}

func (x *CandidateAvailabilityFilter) GetNegated() bool {
	if x != nil {
		return x.Negated
	}
	return false
}

// Filter on availability signals.
type AvailabilityFilter struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Type of signal to apply filter on.
	SignalType AvailabilitySignalType `protobuf:"varint,1,opt,name=signal_type,json=signalType,proto3,enum=google.cloud.talent.v4beta1.AvailabilitySignalType" json:"signal_type,omitempty"`
	// Required. Range of times to filter candidate signals by.
	Range *TimestampRange `protobuf:"bytes,2,opt,name=range,proto3" json:"range,omitempty"`
	// If multiple [AvailabilityFilter][google.cloud.talent.v4beta1.AvailabilityFilter] are provided, the default
	// behavior is to OR all filters, but if this field is set to true, this
	// particular [AvailabilityFilter][google.cloud.talent.v4beta1.AvailabilityFilter] will be AND'ed against other
	// [AvailabilityFilter][google.cloud.talent.v4beta1.AvailabilityFilter].
	Required bool `protobuf:"varint,3,opt,name=required,proto3" json:"required,omitempty"`
}

func (x *AvailabilityFilter) Reset() {
	*x = AvailabilityFilter{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_talent_v4beta1_filters_proto_msgTypes[15]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AvailabilityFilter) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AvailabilityFilter) ProtoMessage() {}

func (x *AvailabilityFilter) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_talent_v4beta1_filters_proto_msgTypes[15]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AvailabilityFilter.ProtoReflect.Descriptor instead.
func (*AvailabilityFilter) Descriptor() ([]byte, []int) {
	return file_google_cloud_talent_v4beta1_filters_proto_rawDescGZIP(), []int{15}
}

func (x *AvailabilityFilter) GetSignalType() AvailabilitySignalType {
	if x != nil {
		return x.SignalType
	}
	return AvailabilitySignalType_AVAILABILITY_SIGNAL_TYPE_UNSPECIFIED
}

func (x *AvailabilityFilter) GetRange() *TimestampRange {
	if x != nil {
		return x.Range
	}
	return nil
}

func (x *AvailabilityFilter) GetRequired() bool {
	if x != nil {
		return x.Required
	}
	return false
}

// Filter on person name.
type PersonNameFilter struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The person name. For example, "John Smith".
	//
	// Can be any combination of [PersonName.structured_name.given_name][],
	// [PersonName.structured_name.middle_initial][],
	// [PersonName.structured_name.family_name][], and
	// [PersonName.formatted_name][google.cloud.talent.v4beta1.PersonName.formatted_name].
	PersonName string `protobuf:"bytes,1,opt,name=person_name,json=personName,proto3" json:"person_name,omitempty"`
}

func (x *PersonNameFilter) Reset() {
	*x = PersonNameFilter{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_talent_v4beta1_filters_proto_msgTypes[16]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PersonNameFilter) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PersonNameFilter) ProtoMessage() {}

func (x *PersonNameFilter) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_talent_v4beta1_filters_proto_msgTypes[16]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PersonNameFilter.ProtoReflect.Descriptor instead.
func (*PersonNameFilter) Descriptor() ([]byte, []int) {
	return file_google_cloud_talent_v4beta1_filters_proto_rawDescGZIP(), []int{16}
}

func (x *PersonNameFilter) GetPersonName() string {
	if x != nil {
		return x.PersonName
	}
	return ""
}

var File_google_cloud_talent_v4beta1_filters_proto protoreflect.FileDescriptor

var file_google_cloud_talent_v4beta1_filters_proto_rawDesc = []byte{
	0x0a, 0x29, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x74,
	0x61, 0x6c, 0x65, 0x6e, 0x74, 0x2f, 0x76, 0x34, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x66, 0x69,
	0x6c, 0x74, 0x65, 0x72, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x1b, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x74, 0x61, 0x6c, 0x65, 0x6e, 0x74,
	0x2e, 0x76, 0x34, 0x62, 0x65, 0x74, 0x61, 0x31, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2f, 0x61, 0x70, 0x69, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x62, 0x65, 0x68, 0x61, 0x76,
	0x69, 0x6f, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x28, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x74, 0x61, 0x6c, 0x65, 0x6e, 0x74, 0x2f, 0x76,
	0x34, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x1a, 0x1e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x62, 0x75, 0x66, 0x2f, 0x64, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x1a, 0x20, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x62, 0x75, 0x66, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x77, 0x72, 0x61, 0x70, 0x70, 0x65, 0x72, 0x73,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x16, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x74,
	0x79, 0x70, 0x65, 0x2f, 0x64, 0x61, 0x74, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x18,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x74, 0x79, 0x70, 0x65, 0x2f, 0x6c, 0x61, 0x74, 0x6c,
	0x6e, 0x67, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1b, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2f, 0x74, 0x79, 0x70, 0x65, 0x2f, 0x74, 0x69, 0x6d, 0x65, 0x6f, 0x66, 0x64, 0x61, 0x79, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1c, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70,
	0x69, 0x2f, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x22, 0xe7, 0x06, 0x0a, 0x08, 0x4a, 0x6f, 0x62, 0x51, 0x75, 0x65, 0x72, 0x79,
	0x12, 0x14, 0x0a, 0x05, 0x71, 0x75, 0x65, 0x72, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x05, 0x71, 0x75, 0x65, 0x72, 0x79, 0x12, 0x2e, 0x0a, 0x13, 0x71, 0x75, 0x65, 0x72, 0x79, 0x5f,
	0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x5f, 0x63, 0x6f, 0x64, 0x65, 0x18, 0x0e, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x11, 0x71, 0x75, 0x65, 0x72, 0x79, 0x4c, 0x61, 0x6e, 0x67, 0x75, 0x61,
	0x67, 0x65, 0x43, 0x6f, 0x64, 0x65, 0x12, 0x1c, 0x0a, 0x09, 0x63, 0x6f, 0x6d, 0x70, 0x61, 0x6e,
	0x69, 0x65, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x09, 0x52, 0x09, 0x63, 0x6f, 0x6d, 0x70, 0x61,
	0x6e, 0x69, 0x65, 0x73, 0x12, 0x56, 0x0a, 0x10, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x5f, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2b,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x74, 0x61,
	0x6c, 0x65, 0x6e, 0x74, 0x2e, 0x76, 0x34, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x4c, 0x6f, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x52, 0x0f, 0x6c, 0x6f, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x73, 0x12, 0x4f, 0x0a, 0x0e,
	0x6a, 0x6f, 0x62, 0x5f, 0x63, 0x61, 0x74, 0x65, 0x67, 0x6f, 0x72, 0x69, 0x65, 0x73, 0x18, 0x04,
	0x20, 0x03, 0x28, 0x0e, 0x32, 0x28, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x74, 0x61, 0x6c, 0x65, 0x6e, 0x74, 0x2e, 0x76, 0x34, 0x62, 0x65, 0x74,
	0x61, 0x31, 0x2e, 0x4a, 0x6f, 0x62, 0x43, 0x61, 0x74, 0x65, 0x67, 0x6f, 0x72, 0x79, 0x52, 0x0d,
	0x6a, 0x6f, 0x62, 0x43, 0x61, 0x74, 0x65, 0x67, 0x6f, 0x72, 0x69, 0x65, 0x73, 0x12, 0x51, 0x0a,
	0x0e, 0x63, 0x6f, 0x6d, 0x6d, 0x75, 0x74, 0x65, 0x5f, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x18,
	0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x74, 0x61, 0x6c, 0x65, 0x6e, 0x74, 0x2e, 0x76, 0x34, 0x62, 0x65,
	0x74, 0x61, 0x31, 0x2e, 0x43, 0x6f, 0x6d, 0x6d, 0x75, 0x74, 0x65, 0x46, 0x69, 0x6c, 0x74, 0x65,
	0x72, 0x52, 0x0d, 0x63, 0x6f, 0x6d, 0x6d, 0x75, 0x74, 0x65, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72,
	0x12, 0x32, 0x0a, 0x15, 0x63, 0x6f, 0x6d, 0x70, 0x61, 0x6e, 0x79, 0x5f, 0x64, 0x69, 0x73, 0x70,
	0x6c, 0x61, 0x79, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x73, 0x18, 0x06, 0x20, 0x03, 0x28, 0x09, 0x52,
	0x13, 0x63, 0x6f, 0x6d, 0x70, 0x61, 0x6e, 0x79, 0x44, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x4e,
	0x61, 0x6d, 0x65, 0x73, 0x12, 0x60, 0x0a, 0x13, 0x63, 0x6f, 0x6d, 0x70, 0x65, 0x6e, 0x73, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x18, 0x07, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x74, 0x61, 0x6c, 0x65, 0x6e, 0x74, 0x2e, 0x76, 0x34, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e,
	0x43, 0x6f, 0x6d, 0x70, 0x65, 0x6e, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x46, 0x69, 0x6c, 0x74,
	0x65, 0x72, 0x52, 0x12, 0x63, 0x6f, 0x6d, 0x70, 0x65, 0x6e, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x12, 0x36, 0x0a, 0x17, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d,
	0x5f, 0x61, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x5f, 0x66, 0x69, 0x6c, 0x74, 0x65,
	0x72, 0x18, 0x08, 0x20, 0x01, 0x28, 0x09, 0x52, 0x15, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x41,
	0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x12, 0x2e,
	0x0a, 0x13, 0x64, 0x69, 0x73, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x73, 0x70, 0x65, 0x6c, 0x6c, 0x5f,
	0x63, 0x68, 0x65, 0x63, 0x6b, 0x18, 0x09, 0x20, 0x01, 0x28, 0x08, 0x52, 0x11, 0x64, 0x69, 0x73,
	0x61, 0x62, 0x6c, 0x65, 0x53, 0x70, 0x65, 0x6c, 0x6c, 0x43, 0x68, 0x65, 0x63, 0x6b, 0x12, 0x56,
	0x0a, 0x10, 0x65, 0x6d, 0x70, 0x6c, 0x6f, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x5f, 0x74, 0x79, 0x70,
	0x65, 0x73, 0x18, 0x0a, 0x20, 0x03, 0x28, 0x0e, 0x32, 0x2b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x74, 0x61, 0x6c, 0x65, 0x6e, 0x74, 0x2e, 0x76,
	0x34, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x45, 0x6d, 0x70, 0x6c, 0x6f, 0x79, 0x6d, 0x65, 0x6e,
	0x74, 0x54, 0x79, 0x70, 0x65, 0x52, 0x0f, 0x65, 0x6d, 0x70, 0x6c, 0x6f, 0x79, 0x6d, 0x65, 0x6e,
	0x74, 0x54, 0x79, 0x70, 0x65, 0x73, 0x12, 0x25, 0x0a, 0x0e, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61,
	0x67, 0x65, 0x5f, 0x63, 0x6f, 0x64, 0x65, 0x73, 0x18, 0x0b, 0x20, 0x03, 0x28, 0x09, 0x52, 0x0d,
	0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x43, 0x6f, 0x64, 0x65, 0x73, 0x12, 0x59, 0x0a,
	0x12, 0x70, 0x75, 0x62, 0x6c, 0x69, 0x73, 0x68, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x5f, 0x72, 0x61,
	0x6e, 0x67, 0x65, 0x18, 0x0c, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2b, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x74, 0x61, 0x6c, 0x65, 0x6e, 0x74, 0x2e,
	0x76, 0x34, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d,
	0x70, 0x52, 0x61, 0x6e, 0x67, 0x65, 0x52, 0x10, 0x70, 0x75, 0x62, 0x6c, 0x69, 0x73, 0x68, 0x54,
	0x69, 0x6d, 0x65, 0x52, 0x61, 0x6e, 0x67, 0x65, 0x12, 0x23, 0x0a, 0x0d, 0x65, 0x78, 0x63, 0x6c,
	0x75, 0x64, 0x65, 0x64, 0x5f, 0x6a, 0x6f, 0x62, 0x73, 0x18, 0x0d, 0x20, 0x03, 0x28, 0x09, 0x52,
	0x0c, 0x65, 0x78, 0x63, 0x6c, 0x75, 0x64, 0x65, 0x64, 0x4a, 0x6f, 0x62, 0x73, 0x22, 0xae, 0x0b,
	0x0a, 0x0c, 0x50, 0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65, 0x51, 0x75, 0x65, 0x72, 0x79, 0x12, 0x14,
	0x0a, 0x05, 0x71, 0x75, 0x65, 0x72, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x71,
	0x75, 0x65, 0x72, 0x79, 0x12, 0x56, 0x0a, 0x10, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x5f, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2b,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x74, 0x61,
	0x6c, 0x65, 0x6e, 0x74, 0x2e, 0x76, 0x34, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x4c, 0x6f, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x52, 0x0f, 0x6c, 0x6f, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x73, 0x12, 0x57, 0x0a, 0x11,
	0x6a, 0x6f, 0x62, 0x5f, 0x74, 0x69, 0x74, 0x6c, 0x65, 0x5f, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72,
	0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x74, 0x61, 0x6c, 0x65, 0x6e, 0x74, 0x2e, 0x76, 0x34,
	0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x4a, 0x6f, 0x62, 0x54, 0x69, 0x74, 0x6c, 0x65, 0x46, 0x69,
	0x6c, 0x74, 0x65, 0x72, 0x52, 0x0f, 0x6a, 0x6f, 0x62, 0x54, 0x69, 0x74, 0x6c, 0x65, 0x46, 0x69,
	0x6c, 0x74, 0x65, 0x72, 0x73, 0x12, 0x56, 0x0a, 0x10, 0x65, 0x6d, 0x70, 0x6c, 0x6f, 0x79, 0x65,
	0x72, 0x5f, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x73, 0x18, 0x04, 0x20, 0x03, 0x28, 0x0b, 0x32,
	0x2b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x74,
	0x61, 0x6c, 0x65, 0x6e, 0x74, 0x2e, 0x76, 0x34, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x45, 0x6d,
	0x70, 0x6c, 0x6f, 0x79, 0x65, 0x72, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x52, 0x0f, 0x65, 0x6d,
	0x70, 0x6c, 0x6f, 0x79, 0x65, 0x72, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x73, 0x12, 0x59, 0x0a,
	0x11, 0x65, 0x64, 0x75, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x66, 0x69, 0x6c, 0x74, 0x65,
	0x72, 0x73, 0x18, 0x05, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x74, 0x61, 0x6c, 0x65, 0x6e, 0x74, 0x2e, 0x76,
	0x34, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x45, 0x64, 0x75, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x52, 0x10, 0x65, 0x64, 0x75, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x73, 0x12, 0x4d, 0x0a, 0x0d, 0x73, 0x6b, 0x69, 0x6c,
	0x6c, 0x5f, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x73, 0x18, 0x06, 0x20, 0x03, 0x28, 0x0b, 0x32,
	0x28, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x74,
	0x61, 0x6c, 0x65, 0x6e, 0x74, 0x2e, 0x76, 0x34, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x53, 0x6b,
	0x69, 0x6c, 0x6c, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x52, 0x0c, 0x73, 0x6b, 0x69, 0x6c, 0x6c,
	0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x73, 0x12, 0x67, 0x0a, 0x16, 0x77, 0x6f, 0x72, 0x6b, 0x5f,
	0x65, 0x78, 0x70, 0x65, 0x72, 0x69, 0x65, 0x6e, 0x63, 0x65, 0x5f, 0x66, 0x69, 0x6c, 0x74, 0x65,
	0x72, 0x18, 0x07, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x31, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x74, 0x61, 0x6c, 0x65, 0x6e, 0x74, 0x2e, 0x76, 0x34,
	0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x57, 0x6f, 0x72, 0x6b, 0x45, 0x78, 0x70, 0x65, 0x72, 0x69,
	0x65, 0x6e, 0x63, 0x65, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x52, 0x14, 0x77, 0x6f, 0x72, 0x6b,
	0x45, 0x78, 0x70, 0x65, 0x72, 0x69, 0x65, 0x6e, 0x63, 0x65, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72,
	0x12, 0x4a, 0x0a, 0x0c, 0x74, 0x69, 0x6d, 0x65, 0x5f, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x73,
	0x18, 0x08, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x27, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x74, 0x61, 0x6c, 0x65, 0x6e, 0x74, 0x2e, 0x76, 0x34, 0x62,
	0x65, 0x74, 0x61, 0x31, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x52,
	0x0b, 0x74, 0x69, 0x6d, 0x65, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x73, 0x12, 0x41, 0x0a, 0x0e,
	0x68, 0x69, 0x72, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x18, 0x09,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x42, 0x6f, 0x6f, 0x6c, 0x56, 0x61, 0x6c, 0x75, 0x65,
	0x52, 0x0d, 0x68, 0x69, 0x72, 0x61, 0x62, 0x6c, 0x65, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x12,
	0x6c, 0x0a, 0x18, 0x61, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x64,
	0x61, 0x74, 0x65, 0x5f, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x73, 0x18, 0x0a, 0x20, 0x03, 0x28,
	0x0b, 0x32, 0x32, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x74, 0x61, 0x6c, 0x65, 0x6e, 0x74, 0x2e, 0x76, 0x34, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e,
	0x41, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x44, 0x61, 0x74, 0x65, 0x46,
	0x69, 0x6c, 0x74, 0x65, 0x72, 0x52, 0x16, 0x61, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x44, 0x61, 0x74, 0x65, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x73, 0x12, 0x85, 0x01,
	0x0a, 0x21, 0x61, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x6f, 0x75,
	0x74, 0x63, 0x6f, 0x6d, 0x65, 0x5f, 0x6e, 0x6f, 0x74, 0x65, 0x73, 0x5f, 0x66, 0x69, 0x6c, 0x74,
	0x65, 0x72, 0x73, 0x18, 0x0b, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x3a, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x74, 0x61, 0x6c, 0x65, 0x6e, 0x74, 0x2e,
	0x76, 0x34, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x41, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x4f, 0x75, 0x74, 0x63, 0x6f, 0x6d, 0x65, 0x4e, 0x6f, 0x74, 0x65, 0x73, 0x46,
	0x69, 0x6c, 0x74, 0x65, 0x72, 0x52, 0x1e, 0x61, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x4f, 0x75, 0x74, 0x63, 0x6f, 0x6d, 0x65, 0x4e, 0x6f, 0x74, 0x65, 0x73, 0x46, 0x69,
	0x6c, 0x74, 0x65, 0x72, 0x73, 0x12, 0x69, 0x0a, 0x17, 0x61, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x6a, 0x6f, 0x62, 0x5f, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x73,
	0x18, 0x0d, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x31, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x74, 0x61, 0x6c, 0x65, 0x6e, 0x74, 0x2e, 0x76, 0x34, 0x62,
	0x65, 0x74, 0x61, 0x31, 0x2e, 0x41, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x4a, 0x6f, 0x62, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x52, 0x15, 0x61, 0x70, 0x70, 0x6c, 0x69,
	0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4a, 0x6f, 0x62, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x73,
	0x12, 0x36, 0x0a, 0x17, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x5f, 0x61, 0x74, 0x74, 0x72, 0x69,
	0x62, 0x75, 0x74, 0x65, 0x5f, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x18, 0x0f, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x15, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x41, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75,
	0x74, 0x65, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x12, 0x80, 0x01, 0x0a, 0x1d, 0x63, 0x61, 0x6e,
	0x64, 0x69, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x61, 0x76, 0x61, 0x69, 0x6c, 0x61, 0x62, 0x69, 0x6c,
	0x69, 0x74, 0x79, 0x5f, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x18, 0x10, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x38, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x74, 0x61, 0x6c, 0x65, 0x6e, 0x74, 0x2e, 0x76, 0x34, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x43,
	0x61, 0x6e, 0x64, 0x69, 0x64, 0x61, 0x74, 0x65, 0x41, 0x76, 0x61, 0x69, 0x6c, 0x61, 0x62, 0x69,
	0x6c, 0x69, 0x74, 0x79, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x42, 0x02, 0x18, 0x01, 0x52, 0x1b,
	0x63, 0x61, 0x6e, 0x64, 0x69, 0x64, 0x61, 0x74, 0x65, 0x41, 0x76, 0x61, 0x69, 0x6c, 0x61, 0x62,
	0x69, 0x6c, 0x69, 0x74, 0x79, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x12, 0x62, 0x0a, 0x14, 0x61,
	0x76, 0x61, 0x69, 0x6c, 0x61, 0x62, 0x69, 0x6c, 0x69, 0x74, 0x79, 0x5f, 0x66, 0x69, 0x6c, 0x74,
	0x65, 0x72, 0x73, 0x18, 0x12, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x74, 0x61, 0x6c, 0x65, 0x6e, 0x74, 0x2e,
	0x76, 0x34, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x41, 0x76, 0x61, 0x69, 0x6c, 0x61, 0x62, 0x69,
	0x6c, 0x69, 0x74, 0x79, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x52, 0x13, 0x61, 0x76, 0x61, 0x69,
	0x6c, 0x61, 0x62, 0x69, 0x6c, 0x69, 0x74, 0x79, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x73, 0x12,
	0x5d, 0x0a, 0x13, 0x70, 0x65, 0x72, 0x73, 0x6f, 0x6e, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x5f, 0x66,
	0x69, 0x6c, 0x74, 0x65, 0x72, 0x73, 0x18, 0x11, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2d, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x74, 0x61, 0x6c, 0x65,
	0x6e, 0x74, 0x2e, 0x76, 0x34, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x50, 0x65, 0x72, 0x73, 0x6f,
	0x6e, 0x4e, 0x61, 0x6d, 0x65, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x52, 0x11, 0x70, 0x65, 0x72,
	0x73, 0x6f, 0x6e, 0x4e, 0x61, 0x6d, 0x65, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x73, 0x22, 0xad,
	0x03, 0x0a, 0x0e, 0x4c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x46, 0x69, 0x6c, 0x74, 0x65,
	0x72, 0x12, 0x18, 0x0a, 0x07, 0x61, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x07, 0x61, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x12, 0x1f, 0x0a, 0x0b, 0x72,
	0x65, 0x67, 0x69, 0x6f, 0x6e, 0x5f, 0x63, 0x6f, 0x64, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x0a, 0x72, 0x65, 0x67, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x64, 0x65, 0x12, 0x2c, 0x0a, 0x07,
	0x6c, 0x61, 0x74, 0x5f, 0x6c, 0x6e, 0x67, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x13, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x74, 0x79, 0x70, 0x65, 0x2e, 0x4c, 0x61, 0x74, 0x4c,
	0x6e, 0x67, 0x52, 0x06, 0x6c, 0x61, 0x74, 0x4c, 0x6e, 0x67, 0x12, 0x2a, 0x0a, 0x11, 0x64, 0x69,
	0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x5f, 0x69, 0x6e, 0x5f, 0x6d, 0x69, 0x6c, 0x65, 0x73, 0x18,
	0x04, 0x20, 0x01, 0x28, 0x01, 0x52, 0x0f, 0x64, 0x69, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x49,
	0x6e, 0x4d, 0x69, 0x6c, 0x65, 0x73, 0x12, 0x78, 0x0a, 0x16, 0x74, 0x65, 0x6c, 0x65, 0x63, 0x6f,
	0x6d, 0x6d, 0x75, 0x74, 0x65, 0x5f, 0x70, 0x72, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65,
	0x18, 0x05, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x41, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x74, 0x61, 0x6c, 0x65, 0x6e, 0x74, 0x2e, 0x76, 0x34, 0x62,
	0x65, 0x74, 0x61, 0x31, 0x2e, 0x4c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x46, 0x69, 0x6c,
	0x74, 0x65, 0x72, 0x2e, 0x54, 0x65, 0x6c, 0x65, 0x63, 0x6f, 0x6d, 0x6d, 0x75, 0x74, 0x65, 0x50,
	0x72, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x52, 0x15, 0x74, 0x65, 0x6c, 0x65, 0x63,
	0x6f, 0x6d, 0x6d, 0x75, 0x74, 0x65, 0x50, 0x72, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65,
	0x12, 0x18, 0x0a, 0x07, 0x6e, 0x65, 0x67, 0x61, 0x74, 0x65, 0x64, 0x18, 0x06, 0x20, 0x01, 0x28,
	0x08, 0x52, 0x07, 0x6e, 0x65, 0x67, 0x61, 0x74, 0x65, 0x64, 0x22, 0x72, 0x0a, 0x15, 0x54, 0x65,
	0x6c, 0x65, 0x63, 0x6f, 0x6d, 0x6d, 0x75, 0x74, 0x65, 0x50, 0x72, 0x65, 0x66, 0x65, 0x72, 0x65,
	0x6e, 0x63, 0x65, 0x12, 0x26, 0x0a, 0x22, 0x54, 0x45, 0x4c, 0x45, 0x43, 0x4f, 0x4d, 0x4d, 0x55,
	0x54, 0x45, 0x5f, 0x50, 0x52, 0x45, 0x46, 0x45, 0x52, 0x45, 0x4e, 0x43, 0x45, 0x5f, 0x55, 0x4e,
	0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x18, 0x0a, 0x14, 0x54,
	0x45, 0x4c, 0x45, 0x43, 0x4f, 0x4d, 0x4d, 0x55, 0x54, 0x45, 0x5f, 0x45, 0x58, 0x43, 0x4c, 0x55,
	0x44, 0x45, 0x44, 0x10, 0x01, 0x12, 0x17, 0x0a, 0x13, 0x54, 0x45, 0x4c, 0x45, 0x43, 0x4f, 0x4d,
	0x4d, 0x55, 0x54, 0x45, 0x5f, 0x41, 0x4c, 0x4c, 0x4f, 0x57, 0x45, 0x44, 0x10, 0x02, 0x22, 0x8b,
	0x04, 0x0a, 0x12, 0x43, 0x6f, 0x6d, 0x70, 0x65, 0x6e, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x46,
	0x69, 0x6c, 0x74, 0x65, 0x72, 0x12, 0x53, 0x0a, 0x04, 0x74, 0x79, 0x70, 0x65, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x0e, 0x32, 0x3a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x74, 0x61, 0x6c, 0x65, 0x6e, 0x74, 0x2e, 0x76, 0x34, 0x62, 0x65, 0x74, 0x61,
	0x31, 0x2e, 0x43, 0x6f, 0x6d, 0x70, 0x65, 0x6e, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x46, 0x69,
	0x6c, 0x74, 0x65, 0x72, 0x2e, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x54, 0x79, 0x70, 0x65, 0x42,
	0x03, 0xe0, 0x41, 0x02, 0x52, 0x04, 0x74, 0x79, 0x70, 0x65, 0x12, 0x59, 0x0a, 0x05, 0x75, 0x6e,
	0x69, 0x74, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0e, 0x32, 0x3e, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x74, 0x61, 0x6c, 0x65, 0x6e, 0x74, 0x2e,
	0x76, 0x34, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x43, 0x6f, 0x6d, 0x70, 0x65, 0x6e, 0x73, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x49, 0x6e, 0x66, 0x6f, 0x2e, 0x43, 0x6f, 0x6d, 0x70, 0x65, 0x6e, 0x73,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x55, 0x6e, 0x69, 0x74, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x05,
	0x75, 0x6e, 0x69, 0x74, 0x73, 0x12, 0x55, 0x0a, 0x05, 0x72, 0x61, 0x6e, 0x67, 0x65, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x3f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x74, 0x61, 0x6c, 0x65, 0x6e, 0x74, 0x2e, 0x76, 0x34, 0x62, 0x65, 0x74,
	0x61, 0x31, 0x2e, 0x43, 0x6f, 0x6d, 0x70, 0x65, 0x6e, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x49,
	0x6e, 0x66, 0x6f, 0x2e, 0x43, 0x6f, 0x6d, 0x70, 0x65, 0x6e, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x52, 0x61, 0x6e, 0x67, 0x65, 0x52, 0x05, 0x72, 0x61, 0x6e, 0x67, 0x65, 0x12, 0x65, 0x0a, 0x30,
	0x69, 0x6e, 0x63, 0x6c, 0x75, 0x64, 0x65, 0x5f, 0x6a, 0x6f, 0x62, 0x73, 0x5f, 0x77, 0x69, 0x74,
	0x68, 0x5f, 0x75, 0x6e, 0x73, 0x70, 0x65, 0x63, 0x69, 0x66, 0x69, 0x65, 0x64, 0x5f, 0x63, 0x6f,
	0x6d, 0x70, 0x65, 0x6e, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x72, 0x61, 0x6e, 0x67, 0x65,
	0x18, 0x04, 0x20, 0x01, 0x28, 0x08, 0x52, 0x2b, 0x69, 0x6e, 0x63, 0x6c, 0x75, 0x64, 0x65, 0x4a,
	0x6f, 0x62, 0x73, 0x57, 0x69, 0x74, 0x68, 0x55, 0x6e, 0x73, 0x70, 0x65, 0x63, 0x69, 0x66, 0x69,
	0x65, 0x64, 0x43, 0x6f, 0x6d, 0x70, 0x65, 0x6e, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x61,
	0x6e, 0x67, 0x65, 0x22, 0x86, 0x01, 0x0a, 0x0a, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x54, 0x79,
	0x70, 0x65, 0x12, 0x1b, 0x0a, 0x17, 0x46, 0x49, 0x4c, 0x54, 0x45, 0x52, 0x5f, 0x54, 0x59, 0x50,
	0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12,
	0x0d, 0x0a, 0x09, 0x55, 0x4e, 0x49, 0x54, 0x5f, 0x4f, 0x4e, 0x4c, 0x59, 0x10, 0x01, 0x12, 0x13,
	0x0a, 0x0f, 0x55, 0x4e, 0x49, 0x54, 0x5f, 0x41, 0x4e, 0x44, 0x5f, 0x41, 0x4d, 0x4f, 0x55, 0x4e,
	0x54, 0x10, 0x02, 0x12, 0x1a, 0x0a, 0x16, 0x41, 0x4e, 0x4e, 0x55, 0x41, 0x4c, 0x49, 0x5a, 0x45,
	0x44, 0x5f, 0x42, 0x41, 0x53, 0x45, 0x5f, 0x41, 0x4d, 0x4f, 0x55, 0x4e, 0x54, 0x10, 0x03, 0x12,
	0x1b, 0x0a, 0x17, 0x41, 0x4e, 0x4e, 0x55, 0x41, 0x4c, 0x49, 0x5a, 0x45, 0x44, 0x5f, 0x54, 0x4f,
	0x54, 0x41, 0x4c, 0x5f, 0x41, 0x4d, 0x4f, 0x55, 0x4e, 0x54, 0x10, 0x04, 0x22, 0xb1, 0x04, 0x0a,
	0x0d, 0x43, 0x6f, 0x6d, 0x6d, 0x75, 0x74, 0x65, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x12, 0x56,
	0x0a, 0x0e, 0x63, 0x6f, 0x6d, 0x6d, 0x75, 0x74, 0x65, 0x5f, 0x6d, 0x65, 0x74, 0x68, 0x6f, 0x64,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x2a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x74, 0x61, 0x6c, 0x65, 0x6e, 0x74, 0x2e, 0x76, 0x34, 0x62,
	0x65, 0x74, 0x61, 0x31, 0x2e, 0x43, 0x6f, 0x6d, 0x6d, 0x75, 0x74, 0x65, 0x4d, 0x65, 0x74, 0x68,
	0x6f, 0x64, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0d, 0x63, 0x6f, 0x6d, 0x6d, 0x75, 0x74, 0x65,
	0x4d, 0x65, 0x74, 0x68, 0x6f, 0x64, 0x12, 0x45, 0x0a, 0x11, 0x73, 0x74, 0x61, 0x72, 0x74, 0x5f,
	0x63, 0x6f, 0x6f, 0x72, 0x64, 0x69, 0x6e, 0x61, 0x74, 0x65, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x13, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x74, 0x79, 0x70, 0x65, 0x2e,
	0x4c, 0x61, 0x74, 0x4c, 0x6e, 0x67, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x10, 0x73, 0x74, 0x61,
	0x72, 0x74, 0x43, 0x6f, 0x6f, 0x72, 0x64, 0x69, 0x6e, 0x61, 0x74, 0x65, 0x73, 0x12, 0x47, 0x0a,
	0x0f, 0x74, 0x72, 0x61, 0x76, 0x65, 0x6c, 0x5f, 0x64, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x19, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x44, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0e, 0x74, 0x72, 0x61, 0x76, 0x65, 0x6c, 0x44, 0x75,
	0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x3a, 0x0a, 0x19, 0x61, 0x6c, 0x6c, 0x6f, 0x77, 0x5f,
	0x69, 0x6d, 0x70, 0x72, 0x65, 0x63, 0x69, 0x73, 0x65, 0x5f, 0x61, 0x64, 0x64, 0x72, 0x65, 0x73,
	0x73, 0x65, 0x73, 0x18, 0x04, 0x20, 0x01, 0x28, 0x08, 0x52, 0x17, 0x61, 0x6c, 0x6c, 0x6f, 0x77,
	0x49, 0x6d, 0x70, 0x72, 0x65, 0x63, 0x69, 0x73, 0x65, 0x41, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73,
	0x65, 0x73, 0x12, 0x5b, 0x0a, 0x0c, 0x72, 0x6f, 0x61, 0x64, 0x5f, 0x74, 0x72, 0x61, 0x66, 0x66,
	0x69, 0x63, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x36, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x74, 0x61, 0x6c, 0x65, 0x6e, 0x74, 0x2e, 0x76,
	0x34, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x43, 0x6f, 0x6d, 0x6d, 0x75, 0x74, 0x65, 0x46, 0x69,
	0x6c, 0x74, 0x65, 0x72, 0x2e, 0x52, 0x6f, 0x61, 0x64, 0x54, 0x72, 0x61, 0x66, 0x66, 0x69, 0x63,
	0x48, 0x00, 0x52, 0x0b, 0x72, 0x6f, 0x61, 0x64, 0x54, 0x72, 0x61, 0x66, 0x66, 0x69, 0x63, 0x12,
	0x3f, 0x0a, 0x0e, 0x64, 0x65, 0x70, 0x61, 0x72, 0x74, 0x75, 0x72, 0x65, 0x5f, 0x74, 0x69, 0x6d,
	0x65, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x16, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x74, 0x79, 0x70, 0x65, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x4f, 0x66, 0x44, 0x61, 0x79, 0x48,
	0x00, 0x52, 0x0d, 0x64, 0x65, 0x70, 0x61, 0x72, 0x74, 0x75, 0x72, 0x65, 0x54, 0x69, 0x6d, 0x65,
	0x22, 0x4c, 0x0a, 0x0b, 0x52, 0x6f, 0x61, 0x64, 0x54, 0x72, 0x61, 0x66, 0x66, 0x69, 0x63, 0x12,
	0x1c, 0x0a, 0x18, 0x52, 0x4f, 0x41, 0x44, 0x5f, 0x54, 0x52, 0x41, 0x46, 0x46, 0x49, 0x43, 0x5f,
	0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x10, 0x0a,
	0x0c, 0x54, 0x52, 0x41, 0x46, 0x46, 0x49, 0x43, 0x5f, 0x46, 0x52, 0x45, 0x45, 0x10, 0x01, 0x12,
	0x0d, 0x0a, 0x09, 0x42, 0x55, 0x53, 0x59, 0x5f, 0x48, 0x4f, 0x55, 0x52, 0x10, 0x02, 0x42, 0x10,
	0x0a, 0x0e, 0x74, 0x72, 0x61, 0x66, 0x66, 0x69, 0x63, 0x5f, 0x6f, 0x70, 0x74, 0x69, 0x6f, 0x6e,
	0x22, 0x4c, 0x0a, 0x0e, 0x4a, 0x6f, 0x62, 0x54, 0x69, 0x74, 0x6c, 0x65, 0x46, 0x69, 0x6c, 0x74,
	0x65, 0x72, 0x12, 0x20, 0x0a, 0x09, 0x6a, 0x6f, 0x62, 0x5f, 0x74, 0x69, 0x74, 0x6c, 0x65, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x08, 0x6a, 0x6f, 0x62, 0x54,
	0x69, 0x74, 0x6c, 0x65, 0x12, 0x18, 0x0a, 0x07, 0x6e, 0x65, 0x67, 0x61, 0x74, 0x65, 0x64, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x08, 0x52, 0x07, 0x6e, 0x65, 0x67, 0x61, 0x74, 0x65, 0x64, 0x22, 0x42,
	0x0a, 0x0b, 0x53, 0x6b, 0x69, 0x6c, 0x6c, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x12, 0x19, 0x0a,
	0x05, 0x73, 0x6b, 0x69, 0x6c, 0x6c, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41,
	0x02, 0x52, 0x05, 0x73, 0x6b, 0x69, 0x6c, 0x6c, 0x12, 0x18, 0x0a, 0x07, 0x6e, 0x65, 0x67, 0x61,
	0x74, 0x65, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x08, 0x52, 0x07, 0x6e, 0x65, 0x67, 0x61, 0x74,
	0x65, 0x64, 0x22, 0xbf, 0x02, 0x0a, 0x0e, 0x45, 0x6d, 0x70, 0x6c, 0x6f, 0x79, 0x65, 0x72, 0x46,
	0x69, 0x6c, 0x74, 0x65, 0x72, 0x12, 0x1f, 0x0a, 0x08, 0x65, 0x6d, 0x70, 0x6c, 0x6f, 0x79, 0x65,
	0x72, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x08, 0x65, 0x6d,
	0x70, 0x6c, 0x6f, 0x79, 0x65, 0x72, 0x12, 0x52, 0x0a, 0x04, 0x6d, 0x6f, 0x64, 0x65, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x0e, 0x32, 0x3e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x74, 0x61, 0x6c, 0x65, 0x6e, 0x74, 0x2e, 0x76, 0x34, 0x62, 0x65, 0x74,
	0x61, 0x31, 0x2e, 0x45, 0x6d, 0x70, 0x6c, 0x6f, 0x79, 0x65, 0x72, 0x46, 0x69, 0x6c, 0x74, 0x65,
	0x72, 0x2e, 0x45, 0x6d, 0x70, 0x6c, 0x6f, 0x79, 0x65, 0x72, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72,
	0x4d, 0x6f, 0x64, 0x65, 0x52, 0x04, 0x6d, 0x6f, 0x64, 0x65, 0x12, 0x18, 0x0a, 0x07, 0x6e, 0x65,
	0x67, 0x61, 0x74, 0x65, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x08, 0x52, 0x07, 0x6e, 0x65, 0x67,
	0x61, 0x74, 0x65, 0x64, 0x22, 0x9d, 0x01, 0x0a, 0x12, 0x45, 0x6d, 0x70, 0x6c, 0x6f, 0x79, 0x65,
	0x72, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x4d, 0x6f, 0x64, 0x65, 0x12, 0x24, 0x0a, 0x20, 0x45,
	0x4d, 0x50, 0x4c, 0x4f, 0x59, 0x45, 0x52, 0x5f, 0x46, 0x49, 0x4c, 0x54, 0x45, 0x52, 0x5f, 0x4d,
	0x4f, 0x44, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10,
	0x00, 0x12, 0x1a, 0x0a, 0x16, 0x41, 0x4c, 0x4c, 0x5f, 0x45, 0x4d, 0x50, 0x4c, 0x4f, 0x59, 0x4d,
	0x45, 0x4e, 0x54, 0x5f, 0x52, 0x45, 0x43, 0x4f, 0x52, 0x44, 0x53, 0x10, 0x01, 0x12, 0x23, 0x0a,
	0x1f, 0x43, 0x55, 0x52, 0x52, 0x45, 0x4e, 0x54, 0x5f, 0x45, 0x4d, 0x50, 0x4c, 0x4f, 0x59, 0x4d,
	0x45, 0x4e, 0x54, 0x5f, 0x52, 0x45, 0x43, 0x4f, 0x52, 0x44, 0x53, 0x5f, 0x4f, 0x4e, 0x4c, 0x59,
	0x10, 0x02, 0x12, 0x20, 0x0a, 0x1c, 0x50, 0x41, 0x53, 0x54, 0x5f, 0x45, 0x4d, 0x50, 0x4c, 0x4f,
	0x59, 0x4d, 0x45, 0x4e, 0x54, 0x5f, 0x52, 0x45, 0x43, 0x4f, 0x52, 0x44, 0x53, 0x5f, 0x4f, 0x4e,
	0x4c, 0x59, 0x10, 0x03, 0x22, 0xb3, 0x01, 0x0a, 0x0f, 0x45, 0x64, 0x75, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x12, 0x16, 0x0a, 0x06, 0x73, 0x63, 0x68, 0x6f,
	0x6f, 0x6c, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x73, 0x63, 0x68, 0x6f, 0x6f, 0x6c,
	0x12, 0x24, 0x0a, 0x0e, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x6f, 0x66, 0x5f, 0x73, 0x74, 0x75,
	0x64, 0x79, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0c, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x4f,
	0x66, 0x53, 0x74, 0x75, 0x64, 0x79, 0x12, 0x48, 0x0a, 0x0b, 0x64, 0x65, 0x67, 0x72, 0x65, 0x65,
	0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x27, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x74, 0x61, 0x6c, 0x65, 0x6e,
	0x74, 0x2e, 0x76, 0x34, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x44, 0x65, 0x67, 0x72, 0x65, 0x65,
	0x54, 0x79, 0x70, 0x65, 0x52, 0x0a, 0x64, 0x65, 0x67, 0x72, 0x65, 0x65, 0x54, 0x79, 0x70, 0x65,
	0x12, 0x18, 0x0a, 0x07, 0x6e, 0x65, 0x67, 0x61, 0x74, 0x65, 0x64, 0x18, 0x06, 0x20, 0x01, 0x28,
	0x08, 0x52, 0x07, 0x6e, 0x65, 0x67, 0x61, 0x74, 0x65, 0x64, 0x22, 0x9a, 0x01, 0x0a, 0x14, 0x57,
	0x6f, 0x72, 0x6b, 0x45, 0x78, 0x70, 0x65, 0x72, 0x69, 0x65, 0x6e, 0x63, 0x65, 0x46, 0x69, 0x6c,
	0x74, 0x65, 0x72, 0x12, 0x40, 0x0a, 0x0e, 0x6d, 0x69, 0x6e, 0x5f, 0x65, 0x78, 0x70, 0x65, 0x72,
	0x69, 0x65, 0x6e, 0x63, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x19, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x44, 0x75,
	0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x0d, 0x6d, 0x69, 0x6e, 0x45, 0x78, 0x70, 0x65, 0x72,
	0x69, 0x65, 0x6e, 0x63, 0x65, 0x12, 0x40, 0x0a, 0x0e, 0x6d, 0x61, 0x78, 0x5f, 0x65, 0x78, 0x70,
	0x65, 0x72, 0x69, 0x65, 0x6e, 0x63, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x19, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e,
	0x44, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x0d, 0x6d, 0x61, 0x78, 0x45, 0x78, 0x70,
	0x65, 0x72, 0x69, 0x65, 0x6e, 0x63, 0x65, 0x22, 0x77, 0x0a, 0x15, 0x41, 0x70, 0x70, 0x6c, 0x69,
	0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x44, 0x61, 0x74, 0x65, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72,
	0x12, 0x30, 0x0a, 0x0a, 0x73, 0x74, 0x61, 0x72, 0x74, 0x5f, 0x64, 0x61, 0x74, 0x65, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x11, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x74, 0x79,
	0x70, 0x65, 0x2e, 0x44, 0x61, 0x74, 0x65, 0x52, 0x09, 0x73, 0x74, 0x61, 0x72, 0x74, 0x44, 0x61,
	0x74, 0x65, 0x12, 0x2c, 0x0a, 0x08, 0x65, 0x6e, 0x64, 0x5f, 0x64, 0x61, 0x74, 0x65, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x11, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x74, 0x79,
	0x70, 0x65, 0x2e, 0x44, 0x61, 0x74, 0x65, 0x52, 0x07, 0x65, 0x6e, 0x64, 0x44, 0x61, 0x74, 0x65,
	0x22, 0x63, 0x0a, 0x1d, 0x41, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4f,
	0x75, 0x74, 0x63, 0x6f, 0x6d, 0x65, 0x4e, 0x6f, 0x74, 0x65, 0x73, 0x46, 0x69, 0x6c, 0x74, 0x65,
	0x72, 0x12, 0x28, 0x0a, 0x0d, 0x6f, 0x75, 0x74, 0x63, 0x6f, 0x6d, 0x65, 0x5f, 0x6e, 0x6f, 0x74,
	0x65, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0c, 0x6f,
	0x75, 0x74, 0x63, 0x6f, 0x6d, 0x65, 0x4e, 0x6f, 0x74, 0x65, 0x73, 0x12, 0x18, 0x0a, 0x07, 0x6e,
	0x65, 0x67, 0x61, 0x74, 0x65, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x08, 0x52, 0x07, 0x6e, 0x65,
	0x67, 0x61, 0x74, 0x65, 0x64, 0x22, 0x7b, 0x0a, 0x14, 0x41, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x4a, 0x6f, 0x62, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x12, 0x2c, 0x0a,
	0x12, 0x6a, 0x6f, 0x62, 0x5f, 0x72, 0x65, 0x71, 0x75, 0x69, 0x73, 0x69, 0x74, 0x69, 0x6f, 0x6e,
	0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x10, 0x6a, 0x6f, 0x62, 0x52, 0x65,
	0x71, 0x75, 0x69, 0x73, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x64, 0x12, 0x1b, 0x0a, 0x09, 0x6a,
	0x6f, 0x62, 0x5f, 0x74, 0x69, 0x74, 0x6c, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08,
	0x6a, 0x6f, 0x62, 0x54, 0x69, 0x74, 0x6c, 0x65, 0x12, 0x18, 0x0a, 0x07, 0x6e, 0x65, 0x67, 0x61,
	0x74, 0x65, 0x64, 0x18, 0x04, 0x20, 0x01, 0x28, 0x08, 0x52, 0x07, 0x6e, 0x65, 0x67, 0x61, 0x74,
	0x65, 0x64, 0x22, 0x9b, 0x02, 0x0a, 0x0a, 0x54, 0x69, 0x6d, 0x65, 0x46, 0x69, 0x6c, 0x74, 0x65,
	0x72, 0x12, 0x39, 0x0a, 0x0a, 0x73, 0x74, 0x61, 0x72, 0x74, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d,
	0x70, 0x52, 0x09, 0x73, 0x74, 0x61, 0x72, 0x74, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x35, 0x0a, 0x08,
	0x65, 0x6e, 0x64, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66,
	0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x07, 0x65, 0x6e, 0x64, 0x54,
	0x69, 0x6d, 0x65, 0x12, 0x50, 0x0a, 0x0a, 0x74, 0x69, 0x6d, 0x65, 0x5f, 0x66, 0x69, 0x65, 0x6c,
	0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x31, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x74, 0x61, 0x6c, 0x65, 0x6e, 0x74, 0x2e, 0x76, 0x34,
	0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72,
	0x2e, 0x54, 0x69, 0x6d, 0x65, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x52, 0x09, 0x74, 0x69, 0x6d, 0x65,
	0x46, 0x69, 0x65, 0x6c, 0x64, 0x22, 0x49, 0x0a, 0x09, 0x54, 0x69, 0x6d, 0x65, 0x46, 0x69, 0x65,
	0x6c, 0x64, 0x12, 0x1a, 0x0a, 0x16, 0x54, 0x49, 0x4d, 0x45, 0x5f, 0x46, 0x49, 0x45, 0x4c, 0x44,
	0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0f,
	0x0a, 0x0b, 0x43, 0x52, 0x45, 0x41, 0x54, 0x45, 0x5f, 0x54, 0x49, 0x4d, 0x45, 0x10, 0x01, 0x12,
	0x0f, 0x0a, 0x0b, 0x55, 0x50, 0x44, 0x41, 0x54, 0x45, 0x5f, 0x54, 0x49, 0x4d, 0x45, 0x10, 0x02,
	0x22, 0x3b, 0x0a, 0x1b, 0x43, 0x61, 0x6e, 0x64, 0x69, 0x64, 0x61, 0x74, 0x65, 0x41, 0x76, 0x61,
	0x69, 0x6c, 0x61, 0x62, 0x69, 0x6c, 0x69, 0x74, 0x79, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x12,
	0x18, 0x0a, 0x07, 0x6e, 0x65, 0x67, 0x61, 0x74, 0x65, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x08,
	0x52, 0x07, 0x6e, 0x65, 0x67, 0x61, 0x74, 0x65, 0x64, 0x3a, 0x02, 0x18, 0x01, 0x22, 0xd3, 0x01,
	0x0a, 0x12, 0x41, 0x76, 0x61, 0x69, 0x6c, 0x61, 0x62, 0x69, 0x6c, 0x69, 0x74, 0x79, 0x46, 0x69,
	0x6c, 0x74, 0x65, 0x72, 0x12, 0x59, 0x0a, 0x0b, 0x73, 0x69, 0x67, 0x6e, 0x61, 0x6c, 0x5f, 0x74,
	0x79, 0x70, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x74, 0x61, 0x6c, 0x65, 0x6e, 0x74, 0x2e,
	0x76, 0x34, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x41, 0x76, 0x61, 0x69, 0x6c, 0x61, 0x62, 0x69,
	0x6c, 0x69, 0x74, 0x79, 0x53, 0x69, 0x67, 0x6e, 0x61, 0x6c, 0x54, 0x79, 0x70, 0x65, 0x42, 0x03,
	0xe0, 0x41, 0x02, 0x52, 0x0a, 0x73, 0x69, 0x67, 0x6e, 0x61, 0x6c, 0x54, 0x79, 0x70, 0x65, 0x12,
	0x46, 0x0a, 0x05, 0x72, 0x61, 0x6e, 0x67, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2b,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x74, 0x61,
	0x6c, 0x65, 0x6e, 0x74, 0x2e, 0x76, 0x34, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x54, 0x69, 0x6d,
	0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x61, 0x6e, 0x67, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x02,
	0x52, 0x05, 0x72, 0x61, 0x6e, 0x67, 0x65, 0x12, 0x1a, 0x0a, 0x08, 0x72, 0x65, 0x71, 0x75, 0x69,
	0x72, 0x65, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x08, 0x52, 0x08, 0x72, 0x65, 0x71, 0x75, 0x69,
	0x72, 0x65, 0x64, 0x22, 0x38, 0x0a, 0x10, 0x50, 0x65, 0x72, 0x73, 0x6f, 0x6e, 0x4e, 0x61, 0x6d,
	0x65, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x12, 0x24, 0x0a, 0x0b, 0x70, 0x65, 0x72, 0x73, 0x6f,
	0x6e, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41,
	0x02, 0x52, 0x0a, 0x70, 0x65, 0x72, 0x73, 0x6f, 0x6e, 0x4e, 0x61, 0x6d, 0x65, 0x42, 0x7a, 0x0a,
	0x1f, 0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x74, 0x61, 0x6c, 0x65, 0x6e, 0x74, 0x2e, 0x76, 0x34, 0x62, 0x65, 0x74, 0x61, 0x31,
	0x42, 0x0c, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x73, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01,
	0x5a, 0x41, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x67, 0x6f, 0x6c, 0x61, 0x6e, 0x67, 0x2e,
	0x6f, 0x72, 0x67, 0x2f, 0x67, 0x65, 0x6e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2f, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x74, 0x61,
	0x6c, 0x65, 0x6e, 0x74, 0x2f, 0x76, 0x34, 0x62, 0x65, 0x74, 0x61, 0x31, 0x3b, 0x74, 0x61, 0x6c,
	0x65, 0x6e, 0x74, 0xa2, 0x02, 0x03, 0x43, 0x54, 0x53, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x33,
}

var (
	file_google_cloud_talent_v4beta1_filters_proto_rawDescOnce sync.Once
	file_google_cloud_talent_v4beta1_filters_proto_rawDescData = file_google_cloud_talent_v4beta1_filters_proto_rawDesc
)

func file_google_cloud_talent_v4beta1_filters_proto_rawDescGZIP() []byte {
	file_google_cloud_talent_v4beta1_filters_proto_rawDescOnce.Do(func() {
		file_google_cloud_talent_v4beta1_filters_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_talent_v4beta1_filters_proto_rawDescData)
	})
	return file_google_cloud_talent_v4beta1_filters_proto_rawDescData
}

var file_google_cloud_talent_v4beta1_filters_proto_enumTypes = make([]protoimpl.EnumInfo, 5)
var file_google_cloud_talent_v4beta1_filters_proto_msgTypes = make([]protoimpl.MessageInfo, 17)
var file_google_cloud_talent_v4beta1_filters_proto_goTypes = []interface{}{
	(LocationFilter_TelecommutePreference)(0),  // 0: google.cloud.talent.v4beta1.LocationFilter.TelecommutePreference
	(CompensationFilter_FilterType)(0),         // 1: google.cloud.talent.v4beta1.CompensationFilter.FilterType
	(CommuteFilter_RoadTraffic)(0),             // 2: google.cloud.talent.v4beta1.CommuteFilter.RoadTraffic
	(EmployerFilter_EmployerFilterMode)(0),     // 3: google.cloud.talent.v4beta1.EmployerFilter.EmployerFilterMode
	(TimeFilter_TimeField)(0),                  // 4: google.cloud.talent.v4beta1.TimeFilter.TimeField
	(*JobQuery)(nil),                           // 5: google.cloud.talent.v4beta1.JobQuery
	(*ProfileQuery)(nil),                       // 6: google.cloud.talent.v4beta1.ProfileQuery
	(*LocationFilter)(nil),                     // 7: google.cloud.talent.v4beta1.LocationFilter
	(*CompensationFilter)(nil),                 // 8: google.cloud.talent.v4beta1.CompensationFilter
	(*CommuteFilter)(nil),                      // 9: google.cloud.talent.v4beta1.CommuteFilter
	(*JobTitleFilter)(nil),                     // 10: google.cloud.talent.v4beta1.JobTitleFilter
	(*SkillFilter)(nil),                        // 11: google.cloud.talent.v4beta1.SkillFilter
	(*EmployerFilter)(nil),                     // 12: google.cloud.talent.v4beta1.EmployerFilter
	(*EducationFilter)(nil),                    // 13: google.cloud.talent.v4beta1.EducationFilter
	(*WorkExperienceFilter)(nil),               // 14: google.cloud.talent.v4beta1.WorkExperienceFilter
	(*ApplicationDateFilter)(nil),              // 15: google.cloud.talent.v4beta1.ApplicationDateFilter
	(*ApplicationOutcomeNotesFilter)(nil),      // 16: google.cloud.talent.v4beta1.ApplicationOutcomeNotesFilter
	(*ApplicationJobFilter)(nil),               // 17: google.cloud.talent.v4beta1.ApplicationJobFilter
	(*TimeFilter)(nil),                         // 18: google.cloud.talent.v4beta1.TimeFilter
	(*CandidateAvailabilityFilter)(nil),        // 19: google.cloud.talent.v4beta1.CandidateAvailabilityFilter
	(*AvailabilityFilter)(nil),                 // 20: google.cloud.talent.v4beta1.AvailabilityFilter
	(*PersonNameFilter)(nil),                   // 21: google.cloud.talent.v4beta1.PersonNameFilter
	(JobCategory)(0),                           // 22: google.cloud.talent.v4beta1.JobCategory
	(EmploymentType)(0),                        // 23: google.cloud.talent.v4beta1.EmploymentType
	(*TimestampRange)(nil),                     // 24: google.cloud.talent.v4beta1.TimestampRange
	(*wrapperspb.BoolValue)(nil),               // 25: google.protobuf.BoolValue
	(*latlng.LatLng)(nil),                      // 26: google.type.LatLng
	(CompensationInfo_CompensationUnit)(0),     // 27: google.cloud.talent.v4beta1.CompensationInfo.CompensationUnit
	(*CompensationInfo_CompensationRange)(nil), // 28: google.cloud.talent.v4beta1.CompensationInfo.CompensationRange
	(CommuteMethod)(0),                         // 29: google.cloud.talent.v4beta1.CommuteMethod
	(*durationpb.Duration)(nil),                // 30: google.protobuf.Duration
	(*timeofday.TimeOfDay)(nil),                // 31: google.type.TimeOfDay
	(DegreeType)(0),                            // 32: google.cloud.talent.v4beta1.DegreeType
	(*date.Date)(nil),                          // 33: google.type.Date
	(*timestamppb.Timestamp)(nil),              // 34: google.protobuf.Timestamp
	(AvailabilitySignalType)(0),                // 35: google.cloud.talent.v4beta1.AvailabilitySignalType
}
var file_google_cloud_talent_v4beta1_filters_proto_depIdxs = []int32{
	7,  // 0: google.cloud.talent.v4beta1.JobQuery.location_filters:type_name -> google.cloud.talent.v4beta1.LocationFilter
	22, // 1: google.cloud.talent.v4beta1.JobQuery.job_categories:type_name -> google.cloud.talent.v4beta1.JobCategory
	9,  // 2: google.cloud.talent.v4beta1.JobQuery.commute_filter:type_name -> google.cloud.talent.v4beta1.CommuteFilter
	8,  // 3: google.cloud.talent.v4beta1.JobQuery.compensation_filter:type_name -> google.cloud.talent.v4beta1.CompensationFilter
	23, // 4: google.cloud.talent.v4beta1.JobQuery.employment_types:type_name -> google.cloud.talent.v4beta1.EmploymentType
	24, // 5: google.cloud.talent.v4beta1.JobQuery.publish_time_range:type_name -> google.cloud.talent.v4beta1.TimestampRange
	7,  // 6: google.cloud.talent.v4beta1.ProfileQuery.location_filters:type_name -> google.cloud.talent.v4beta1.LocationFilter
	10, // 7: google.cloud.talent.v4beta1.ProfileQuery.job_title_filters:type_name -> google.cloud.talent.v4beta1.JobTitleFilter
	12, // 8: google.cloud.talent.v4beta1.ProfileQuery.employer_filters:type_name -> google.cloud.talent.v4beta1.EmployerFilter
	13, // 9: google.cloud.talent.v4beta1.ProfileQuery.education_filters:type_name -> google.cloud.talent.v4beta1.EducationFilter
	11, // 10: google.cloud.talent.v4beta1.ProfileQuery.skill_filters:type_name -> google.cloud.talent.v4beta1.SkillFilter
	14, // 11: google.cloud.talent.v4beta1.ProfileQuery.work_experience_filter:type_name -> google.cloud.talent.v4beta1.WorkExperienceFilter
	18, // 12: google.cloud.talent.v4beta1.ProfileQuery.time_filters:type_name -> google.cloud.talent.v4beta1.TimeFilter
	25, // 13: google.cloud.talent.v4beta1.ProfileQuery.hirable_filter:type_name -> google.protobuf.BoolValue
	15, // 14: google.cloud.talent.v4beta1.ProfileQuery.application_date_filters:type_name -> google.cloud.talent.v4beta1.ApplicationDateFilter
	16, // 15: google.cloud.talent.v4beta1.ProfileQuery.application_outcome_notes_filters:type_name -> google.cloud.talent.v4beta1.ApplicationOutcomeNotesFilter
	17, // 16: google.cloud.talent.v4beta1.ProfileQuery.application_job_filters:type_name -> google.cloud.talent.v4beta1.ApplicationJobFilter
	19, // 17: google.cloud.talent.v4beta1.ProfileQuery.candidate_availability_filter:type_name -> google.cloud.talent.v4beta1.CandidateAvailabilityFilter
	20, // 18: google.cloud.talent.v4beta1.ProfileQuery.availability_filters:type_name -> google.cloud.talent.v4beta1.AvailabilityFilter
	21, // 19: google.cloud.talent.v4beta1.ProfileQuery.person_name_filters:type_name -> google.cloud.talent.v4beta1.PersonNameFilter
	26, // 20: google.cloud.talent.v4beta1.LocationFilter.lat_lng:type_name -> google.type.LatLng
	0,  // 21: google.cloud.talent.v4beta1.LocationFilter.telecommute_preference:type_name -> google.cloud.talent.v4beta1.LocationFilter.TelecommutePreference
	1,  // 22: google.cloud.talent.v4beta1.CompensationFilter.type:type_name -> google.cloud.talent.v4beta1.CompensationFilter.FilterType
	27, // 23: google.cloud.talent.v4beta1.CompensationFilter.units:type_name -> google.cloud.talent.v4beta1.CompensationInfo.CompensationUnit
	28, // 24: google.cloud.talent.v4beta1.CompensationFilter.range:type_name -> google.cloud.talent.v4beta1.CompensationInfo.CompensationRange
	29, // 25: google.cloud.talent.v4beta1.CommuteFilter.commute_method:type_name -> google.cloud.talent.v4beta1.CommuteMethod
	26, // 26: google.cloud.talent.v4beta1.CommuteFilter.start_coordinates:type_name -> google.type.LatLng
	30, // 27: google.cloud.talent.v4beta1.CommuteFilter.travel_duration:type_name -> google.protobuf.Duration
	2,  // 28: google.cloud.talent.v4beta1.CommuteFilter.road_traffic:type_name -> google.cloud.talent.v4beta1.CommuteFilter.RoadTraffic
	31, // 29: google.cloud.talent.v4beta1.CommuteFilter.departure_time:type_name -> google.type.TimeOfDay
	3,  // 30: google.cloud.talent.v4beta1.EmployerFilter.mode:type_name -> google.cloud.talent.v4beta1.EmployerFilter.EmployerFilterMode
	32, // 31: google.cloud.talent.v4beta1.EducationFilter.degree_type:type_name -> google.cloud.talent.v4beta1.DegreeType
	30, // 32: google.cloud.talent.v4beta1.WorkExperienceFilter.min_experience:type_name -> google.protobuf.Duration
	30, // 33: google.cloud.talent.v4beta1.WorkExperienceFilter.max_experience:type_name -> google.protobuf.Duration
	33, // 34: google.cloud.talent.v4beta1.ApplicationDateFilter.start_date:type_name -> google.type.Date
	33, // 35: google.cloud.talent.v4beta1.ApplicationDateFilter.end_date:type_name -> google.type.Date
	34, // 36: google.cloud.talent.v4beta1.TimeFilter.start_time:type_name -> google.protobuf.Timestamp
	34, // 37: google.cloud.talent.v4beta1.TimeFilter.end_time:type_name -> google.protobuf.Timestamp
	4,  // 38: google.cloud.talent.v4beta1.TimeFilter.time_field:type_name -> google.cloud.talent.v4beta1.TimeFilter.TimeField
	35, // 39: google.cloud.talent.v4beta1.AvailabilityFilter.signal_type:type_name -> google.cloud.talent.v4beta1.AvailabilitySignalType
	24, // 40: google.cloud.talent.v4beta1.AvailabilityFilter.range:type_name -> google.cloud.talent.v4beta1.TimestampRange
	41, // [41:41] is the sub-list for method output_type
	41, // [41:41] is the sub-list for method input_type
	41, // [41:41] is the sub-list for extension type_name
	41, // [41:41] is the sub-list for extension extendee
	0,  // [0:41] is the sub-list for field type_name
}

func init() { file_google_cloud_talent_v4beta1_filters_proto_init() }
func file_google_cloud_talent_v4beta1_filters_proto_init() {
	if File_google_cloud_talent_v4beta1_filters_proto != nil {
		return
	}
	file_google_cloud_talent_v4beta1_common_proto_init()
	if !protoimpl.UnsafeEnabled {
		file_google_cloud_talent_v4beta1_filters_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*JobQuery); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_talent_v4beta1_filters_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ProfileQuery); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_talent_v4beta1_filters_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*LocationFilter); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_talent_v4beta1_filters_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CompensationFilter); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_talent_v4beta1_filters_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CommuteFilter); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_talent_v4beta1_filters_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*JobTitleFilter); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_talent_v4beta1_filters_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SkillFilter); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_talent_v4beta1_filters_proto_msgTypes[7].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*EmployerFilter); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_talent_v4beta1_filters_proto_msgTypes[8].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*EducationFilter); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_talent_v4beta1_filters_proto_msgTypes[9].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*WorkExperienceFilter); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_talent_v4beta1_filters_proto_msgTypes[10].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ApplicationDateFilter); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_talent_v4beta1_filters_proto_msgTypes[11].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ApplicationOutcomeNotesFilter); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_talent_v4beta1_filters_proto_msgTypes[12].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ApplicationJobFilter); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_talent_v4beta1_filters_proto_msgTypes[13].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*TimeFilter); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_talent_v4beta1_filters_proto_msgTypes[14].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CandidateAvailabilityFilter); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_talent_v4beta1_filters_proto_msgTypes[15].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AvailabilityFilter); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_talent_v4beta1_filters_proto_msgTypes[16].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PersonNameFilter); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	file_google_cloud_talent_v4beta1_filters_proto_msgTypes[4].OneofWrappers = []interface{}{
		(*CommuteFilter_RoadTraffic_)(nil),
		(*CommuteFilter_DepartureTime)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_talent_v4beta1_filters_proto_rawDesc,
			NumEnums:      5,
			NumMessages:   17,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_google_cloud_talent_v4beta1_filters_proto_goTypes,
		DependencyIndexes: file_google_cloud_talent_v4beta1_filters_proto_depIdxs,
		EnumInfos:         file_google_cloud_talent_v4beta1_filters_proto_enumTypes,
		MessageInfos:      file_google_cloud_talent_v4beta1_filters_proto_msgTypes,
	}.Build()
	File_google_cloud_talent_v4beta1_filters_proto = out.File
	file_google_cloud_talent_v4beta1_filters_proto_rawDesc = nil
	file_google_cloud_talent_v4beta1_filters_proto_goTypes = nil
	file_google_cloud_talent_v4beta1_filters_proto_depIdxs = nil
}
