// Copyright (c) 2016, 2018, 2021, Oracle and/or its affiliates.  All rights reserved.
// This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.
// Code generated. DO NOT EDIT.

// Data Integration API
//
// Use the Data Integration Service APIs to perform common extract, load, and transform (ETL) tasks.
//

package dataintegration

import (
	"encoding/json"
	"github.com/oracle/oci-go-sdk/v32/common"
)

// DataEntityFromViewEntityDetails The view entity data entity details.
type DataEntityFromViewEntityDetails struct {

	// The object key.
	Key *string `mandatory:"false" json:"key"`

	// The object's model version.
	ModelVersion *string `mandatory:"false" json:"modelVersion"`

	ParentRef *ParentReference `mandatory:"false" json:"parentRef"`

	// Free form text without any restriction on permitted characters. Name can have letters, numbers, and special characters. The value is editable and is restricted to 1000 characters.
	Name *string `mandatory:"false" json:"name"`

	// Detailed description for the object.
	Description *string `mandatory:"false" json:"description"`

	// The version of the object that is used to track changes in the object instance.
	ObjectVersion *int `mandatory:"false" json:"objectVersion"`

	// The external key for the object
	ExternalKey *string `mandatory:"false" json:"externalKey"`

	Shape *Shape `mandatory:"false" json:"shape"`

	// The shape ID.
	ShapeId *string `mandatory:"false" json:"shapeId"`

	Types *TypeLibrary `mandatory:"false" json:"types"`

	// Specifies other type labels.
	OtherTypeLabel *string `mandatory:"false" json:"otherTypeLabel"`

	// An array of unique keys.
	UniqueKeys []UniqueKey `mandatory:"false" json:"uniqueKeys"`

	// An array of foreign keys.
	ForeignKeys []ForeignKey `mandatory:"false" json:"foreignKeys"`

	// The resource name.
	ResourceName *string `mandatory:"false" json:"resourceName"`

	// The status of an object that can be set to value 1 for shallow references across objects, other values reserved.
	ObjectStatus *int `mandatory:"false" json:"objectStatus"`

	// Value can only contain upper case letters, underscore and numbers. It should begin with upper case letter or underscore. The value can be modified.
	Identifier *string `mandatory:"false" json:"identifier"`

	// The entity type.
	EntityType DataEntityFromViewEntityDetailsEntityTypeEnum `mandatory:"false" json:"entityType,omitempty"`
}

func (m DataEntityFromViewEntityDetails) String() string {
	return common.PointerString(m)
}

// MarshalJSON marshals to json representation
func (m DataEntityFromViewEntityDetails) MarshalJSON() (buff []byte, e error) {
	type MarshalTypeDataEntityFromViewEntityDetails DataEntityFromViewEntityDetails
	s := struct {
		DiscriminatorParam string `json:"modelType"`
		MarshalTypeDataEntityFromViewEntityDetails
	}{
		"VIEW_ENTITY",
		(MarshalTypeDataEntityFromViewEntityDetails)(m),
	}

	return json.Marshal(&s)
}

// DataEntityFromViewEntityDetailsEntityTypeEnum Enum with underlying type: string
type DataEntityFromViewEntityDetailsEntityTypeEnum string

// Set of constants representing the allowable values for DataEntityFromViewEntityDetailsEntityTypeEnum
const (
	DataEntityFromViewEntityDetailsEntityTypeTable  DataEntityFromViewEntityDetailsEntityTypeEnum = "TABLE"
	DataEntityFromViewEntityDetailsEntityTypeView   DataEntityFromViewEntityDetailsEntityTypeEnum = "VIEW"
	DataEntityFromViewEntityDetailsEntityTypeFile   DataEntityFromViewEntityDetailsEntityTypeEnum = "FILE"
	DataEntityFromViewEntityDetailsEntityTypeQueue  DataEntityFromViewEntityDetailsEntityTypeEnum = "QUEUE"
	DataEntityFromViewEntityDetailsEntityTypeStream DataEntityFromViewEntityDetailsEntityTypeEnum = "STREAM"
	DataEntityFromViewEntityDetailsEntityTypeOther  DataEntityFromViewEntityDetailsEntityTypeEnum = "OTHER"
)

var mappingDataEntityFromViewEntityDetailsEntityType = map[string]DataEntityFromViewEntityDetailsEntityTypeEnum{
	"TABLE":  DataEntityFromViewEntityDetailsEntityTypeTable,
	"VIEW":   DataEntityFromViewEntityDetailsEntityTypeView,
	"FILE":   DataEntityFromViewEntityDetailsEntityTypeFile,
	"QUEUE":  DataEntityFromViewEntityDetailsEntityTypeQueue,
	"STREAM": DataEntityFromViewEntityDetailsEntityTypeStream,
	"OTHER":  DataEntityFromViewEntityDetailsEntityTypeOther,
}

// GetDataEntityFromViewEntityDetailsEntityTypeEnumValues Enumerates the set of values for DataEntityFromViewEntityDetailsEntityTypeEnum
func GetDataEntityFromViewEntityDetailsEntityTypeEnumValues() []DataEntityFromViewEntityDetailsEntityTypeEnum {
	values := make([]DataEntityFromViewEntityDetailsEntityTypeEnum, 0)
	for _, v := range mappingDataEntityFromViewEntityDetailsEntityType {
		values = append(values, v)
	}
	return values
}
