// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// SlackAction SlackAction configures a single Slack action that is sent with each notification.
//
// See https://api.slack.com/docs/message-attachments#action_fields and https://api.slack.com/docs/message-buttons
// for more information.
//
// swagger:model SlackAction
type SlackAction struct {

	// confirm
	Confirm *SlackConfirmationField `json:"confirm,omitempty"`

	// name
	Name string `json:"name,omitempty"`

	// style
	Style string `json:"style,omitempty"`

	// text
	Text string `json:"text,omitempty"`

	// type
	Type string `json:"type,omitempty"`

	// url
	URL string `json:"url,omitempty"`

	// value
	Value string `json:"value,omitempty"`
}

// Validate validates this slack action
func (m *SlackAction) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateConfirm(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *SlackAction) validateConfirm(formats strfmt.Registry) error {
	if swag.IsZero(m.Confirm) { // not required
		return nil
	}

	if m.Confirm != nil {
		if err := m.Confirm.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("confirm")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("confirm")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this slack action based on the context it is used
func (m *SlackAction) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateConfirm(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *SlackAction) contextValidateConfirm(ctx context.Context, formats strfmt.Registry) error {

	if m.Confirm != nil {

		if swag.IsZero(m.Confirm) { // not required
			return nil
		}

		if err := m.Confirm.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("confirm")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("confirm")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *SlackAction) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *SlackAction) UnmarshalBinary(b []byte) error {
	var res SlackAction
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
