// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// GettableGrafanaRule gettable grafana rule
//
// swagger:model GettableGrafanaRule
type GettableGrafanaRule struct {

	// condition
	Condition string `json:"condition,omitempty"`

	// data
	Data []*AlertQuery `json:"data"`

	// exec err state
	// Enum: [OK Alerting Error]
	ExecErrState string `json:"exec_err_state,omitempty"`

	// id
	ID int64 `json:"id,omitempty"`

	// interval seconds
	IntervalSeconds int64 `json:"intervalSeconds,omitempty"`

	// is paused
	IsPaused bool `json:"is_paused,omitempty"`

	// namespace id
	NamespaceID int64 `json:"namespace_id,omitempty"`

	// namespace uid
	NamespaceUID string `json:"namespace_uid,omitempty"`

	// no data state
	// Enum: [Alerting NoData OK]
	NoDataState string `json:"no_data_state,omitempty"`

	// org Id
	OrgID int64 `json:"orgId,omitempty"`

	// provenance
	Provenance Provenance `json:"provenance,omitempty"`

	// rule group
	RuleGroup string `json:"rule_group,omitempty"`

	// title
	Title string `json:"title,omitempty"`

	// uid
	UID string `json:"uid,omitempty"`

	// updated
	// Format: date-time
	Updated strfmt.DateTime `json:"updated,omitempty"`

	// version
	Version int64 `json:"version,omitempty"`
}

// Validate validates this gettable grafana rule
func (m *GettableGrafanaRule) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateData(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateExecErrState(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateNoDataState(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateProvenance(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateUpdated(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *GettableGrafanaRule) validateData(formats strfmt.Registry) error {
	if swag.IsZero(m.Data) { // not required
		return nil
	}

	for i := 0; i < len(m.Data); i++ {
		if swag.IsZero(m.Data[i]) { // not required
			continue
		}

		if m.Data[i] != nil {
			if err := m.Data[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("data" + "." + strconv.Itoa(i))
				} else if ce, ok := err.(*errors.CompositeError); ok {
					return ce.ValidateName("data" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

var gettableGrafanaRuleTypeExecErrStatePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["OK","Alerting","Error"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		gettableGrafanaRuleTypeExecErrStatePropEnum = append(gettableGrafanaRuleTypeExecErrStatePropEnum, v)
	}
}

const (

	// GettableGrafanaRuleExecErrStateOK captures enum value "OK"
	GettableGrafanaRuleExecErrStateOK string = "OK"

	// GettableGrafanaRuleExecErrStateAlerting captures enum value "Alerting"
	GettableGrafanaRuleExecErrStateAlerting string = "Alerting"

	// GettableGrafanaRuleExecErrStateError captures enum value "Error"
	GettableGrafanaRuleExecErrStateError string = "Error"
)

// prop value enum
func (m *GettableGrafanaRule) validateExecErrStateEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, gettableGrafanaRuleTypeExecErrStatePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *GettableGrafanaRule) validateExecErrState(formats strfmt.Registry) error {
	if swag.IsZero(m.ExecErrState) { // not required
		return nil
	}

	// value enum
	if err := m.validateExecErrStateEnum("exec_err_state", "body", m.ExecErrState); err != nil {
		return err
	}

	return nil
}

var gettableGrafanaRuleTypeNoDataStatePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["Alerting","NoData","OK"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		gettableGrafanaRuleTypeNoDataStatePropEnum = append(gettableGrafanaRuleTypeNoDataStatePropEnum, v)
	}
}

const (

	// GettableGrafanaRuleNoDataStateAlerting captures enum value "Alerting"
	GettableGrafanaRuleNoDataStateAlerting string = "Alerting"

	// GettableGrafanaRuleNoDataStateNoData captures enum value "NoData"
	GettableGrafanaRuleNoDataStateNoData string = "NoData"

	// GettableGrafanaRuleNoDataStateOK captures enum value "OK"
	GettableGrafanaRuleNoDataStateOK string = "OK"
)

// prop value enum
func (m *GettableGrafanaRule) validateNoDataStateEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, gettableGrafanaRuleTypeNoDataStatePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *GettableGrafanaRule) validateNoDataState(formats strfmt.Registry) error {
	if swag.IsZero(m.NoDataState) { // not required
		return nil
	}

	// value enum
	if err := m.validateNoDataStateEnum("no_data_state", "body", m.NoDataState); err != nil {
		return err
	}

	return nil
}

func (m *GettableGrafanaRule) validateProvenance(formats strfmt.Registry) error {
	if swag.IsZero(m.Provenance) { // not required
		return nil
	}

	if err := m.Provenance.Validate(formats); err != nil {
		if ve, ok := err.(*errors.Validation); ok {
			return ve.ValidateName("provenance")
		} else if ce, ok := err.(*errors.CompositeError); ok {
			return ce.ValidateName("provenance")
		}
		return err
	}

	return nil
}

func (m *GettableGrafanaRule) validateUpdated(formats strfmt.Registry) error {
	if swag.IsZero(m.Updated) { // not required
		return nil
	}

	if err := validate.FormatOf("updated", "body", "date-time", m.Updated.String(), formats); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this gettable grafana rule based on the context it is used
func (m *GettableGrafanaRule) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateData(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateProvenance(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *GettableGrafanaRule) contextValidateData(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.Data); i++ {

		if m.Data[i] != nil {

			if swag.IsZero(m.Data[i]) { // not required
				return nil
			}

			if err := m.Data[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("data" + "." + strconv.Itoa(i))
				} else if ce, ok := err.(*errors.CompositeError); ok {
					return ce.ValidateName("data" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *GettableGrafanaRule) contextValidateProvenance(ctx context.Context, formats strfmt.Registry) error {

	if swag.IsZero(m.Provenance) { // not required
		return nil
	}

	if err := m.Provenance.ContextValidate(ctx, formats); err != nil {
		if ve, ok := err.(*errors.Validation); ok {
			return ve.ValidateName("provenance")
		} else if ce, ok := err.(*errors.CompositeError); ok {
			return ce.ValidateName("provenance")
		}
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *GettableGrafanaRule) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *GettableGrafanaRule) UnmarshalBinary(b []byte) error {
	var res GettableGrafanaRule
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
