// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// AlertStatus AlertStatus alert status
//
// swagger:model alertStatus
type AlertStatus struct {

	// inhibited by
	// Required: true
	InhibitedBy []string `json:"inhibitedBy"`

	// silenced by
	// Required: true
	SilencedBy []string `json:"silencedBy"`

	// state
	// Required: true
	// Enum: [[unprocessed active suppressed]]
	State *string `json:"state"`
}

// Validate validates this alert status
func (m *AlertStatus) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateInhibitedBy(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateSilencedBy(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateState(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *AlertStatus) validateInhibitedBy(formats strfmt.Registry) error {

	if err := validate.Required("inhibitedBy", "body", m.InhibitedBy); err != nil {
		return err
	}

	return nil
}

func (m *AlertStatus) validateSilencedBy(formats strfmt.Registry) error {

	if err := validate.Required("silencedBy", "body", m.SilencedBy); err != nil {
		return err
	}

	return nil
}

var alertStatusTypeStatePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["[unprocessed active suppressed]"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		alertStatusTypeStatePropEnum = append(alertStatusTypeStatePropEnum, v)
	}
}

const (

	// AlertStatusStateUnprocessedActiveSuppressed captures enum value "[unprocessed active suppressed]"
	AlertStatusStateUnprocessedActiveSuppressed string = "[unprocessed active suppressed]"
)

// prop value enum
func (m *AlertStatus) validateStateEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, alertStatusTypeStatePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *AlertStatus) validateState(formats strfmt.Registry) error {

	if err := validate.Required("state", "body", m.State); err != nil {
		return err
	}

	// value enum
	if err := m.validateStateEnum("state", "body", *m.State); err != nil {
		return err
	}

	return nil
}

// ContextValidate validates this alert status based on context it is used
func (m *AlertStatus) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *AlertStatus) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *AlertStatus) UnmarshalBinary(b []byte) error {
	var res AlertStatus
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
