// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// AddAPIKeyCommand add API key command
//
// swagger:model AddAPIKeyCommand
type AddAPIKeyCommand struct {

	// name
	Name string `json:"name,omitempty"`

	// role
	// Enum: [None Viewer Editor Admin]
	Role string `json:"role,omitempty"`

	// seconds to live
	SecondsToLive int64 `json:"secondsToLive,omitempty"`
}

// Validate validates this add API key command
func (m *AddAPIKeyCommand) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateRole(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

var addApiKeyCommandTypeRolePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["None","Viewer","Editor","Admin"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		addApiKeyCommandTypeRolePropEnum = append(addApiKeyCommandTypeRolePropEnum, v)
	}
}

const (

	// AddAPIKeyCommandRoleNone captures enum value "None"
	AddAPIKeyCommandRoleNone string = "None"

	// AddAPIKeyCommandRoleViewer captures enum value "Viewer"
	AddAPIKeyCommandRoleViewer string = "Viewer"

	// AddAPIKeyCommandRoleEditor captures enum value "Editor"
	AddAPIKeyCommandRoleEditor string = "Editor"

	// AddAPIKeyCommandRoleAdmin captures enum value "Admin"
	AddAPIKeyCommandRoleAdmin string = "Admin"
)

// prop value enum
func (m *AddAPIKeyCommand) validateRoleEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, addApiKeyCommandTypeRolePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *AddAPIKeyCommand) validateRole(formats strfmt.Registry) error {
	if swag.IsZero(m.Role) { // not required
		return nil
	}

	// value enum
	if err := m.validateRoleEnum("role", "body", m.Role); err != nil {
		return err
	}

	return nil
}

// ContextValidate validates this add API key command based on context it is used
func (m *AddAPIKeyCommand) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *AddAPIKeyCommand) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *AddAPIKeyCommand) UnmarshalBinary(b []byte) error {
	var res AddAPIKeyCommand
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
