// Code generated by go-swagger; DO NOT EDIT.

package user_preferences

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/grafana/grafana-openapi-client-go/models"
)

// UpdateUserPreferencesReader is a Reader for the UpdateUserPreferences structure.
type UpdateUserPreferencesReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *UpdateUserPreferencesReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewUpdateUserPreferencesOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 400:
		result := NewUpdateUserPreferencesBadRequest()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 401:
		result := NewUpdateUserPreferencesUnauthorized()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 500:
		result := NewUpdateUserPreferencesInternalServerError()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	default:
		return nil, runtime.NewAPIError("[PUT /user/preferences] updateUserPreferences", response, response.Code())
	}
}

// NewUpdateUserPreferencesOK creates a UpdateUserPreferencesOK with default headers values
func NewUpdateUserPreferencesOK() *UpdateUserPreferencesOK {
	return &UpdateUserPreferencesOK{}
}

/*
UpdateUserPreferencesOK describes a response with status code 200, with default header values.

An OKResponse is returned if the request was successful.
*/
type UpdateUserPreferencesOK struct {
	Payload *models.SuccessResponseBody
}

// IsSuccess returns true when this update user preferences Ok response has a 2xx status code
func (o *UpdateUserPreferencesOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this update user preferences Ok response has a 3xx status code
func (o *UpdateUserPreferencesOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this update user preferences Ok response has a 4xx status code
func (o *UpdateUserPreferencesOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this update user preferences Ok response has a 5xx status code
func (o *UpdateUserPreferencesOK) IsServerError() bool {
	return false
}

// IsCode returns true when this update user preferences Ok response a status code equal to that given
func (o *UpdateUserPreferencesOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the update user preferences Ok response
func (o *UpdateUserPreferencesOK) Code() int {
	return 200
}

func (o *UpdateUserPreferencesOK) Error() string {
	return fmt.Sprintf("[PUT /user/preferences][%d] updateUserPreferencesOk  %+v", 200, o.Payload)
}

func (o *UpdateUserPreferencesOK) String() string {
	return fmt.Sprintf("[PUT /user/preferences][%d] updateUserPreferencesOk  %+v", 200, o.Payload)
}

func (o *UpdateUserPreferencesOK) GetPayload() *models.SuccessResponseBody {
	return o.Payload
}

func (o *UpdateUserPreferencesOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.SuccessResponseBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewUpdateUserPreferencesBadRequest creates a UpdateUserPreferencesBadRequest with default headers values
func NewUpdateUserPreferencesBadRequest() *UpdateUserPreferencesBadRequest {
	return &UpdateUserPreferencesBadRequest{}
}

/*
UpdateUserPreferencesBadRequest describes a response with status code 400, with default header values.

BadRequestError is returned when the request is invalid and it cannot be processed.
*/
type UpdateUserPreferencesBadRequest struct {
	Payload *models.ErrorResponseBody
}

// IsSuccess returns true when this update user preferences bad request response has a 2xx status code
func (o *UpdateUserPreferencesBadRequest) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this update user preferences bad request response has a 3xx status code
func (o *UpdateUserPreferencesBadRequest) IsRedirect() bool {
	return false
}

// IsClientError returns true when this update user preferences bad request response has a 4xx status code
func (o *UpdateUserPreferencesBadRequest) IsClientError() bool {
	return true
}

// IsServerError returns true when this update user preferences bad request response has a 5xx status code
func (o *UpdateUserPreferencesBadRequest) IsServerError() bool {
	return false
}

// IsCode returns true when this update user preferences bad request response a status code equal to that given
func (o *UpdateUserPreferencesBadRequest) IsCode(code int) bool {
	return code == 400
}

// Code gets the status code for the update user preferences bad request response
func (o *UpdateUserPreferencesBadRequest) Code() int {
	return 400
}

func (o *UpdateUserPreferencesBadRequest) Error() string {
	return fmt.Sprintf("[PUT /user/preferences][%d] updateUserPreferencesBadRequest  %+v", 400, o.Payload)
}

func (o *UpdateUserPreferencesBadRequest) String() string {
	return fmt.Sprintf("[PUT /user/preferences][%d] updateUserPreferencesBadRequest  %+v", 400, o.Payload)
}

func (o *UpdateUserPreferencesBadRequest) GetPayload() *models.ErrorResponseBody {
	return o.Payload
}

func (o *UpdateUserPreferencesBadRequest) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponseBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewUpdateUserPreferencesUnauthorized creates a UpdateUserPreferencesUnauthorized with default headers values
func NewUpdateUserPreferencesUnauthorized() *UpdateUserPreferencesUnauthorized {
	return &UpdateUserPreferencesUnauthorized{}
}

/*
UpdateUserPreferencesUnauthorized describes a response with status code 401, with default header values.

UnauthorizedError is returned when the request is not authenticated.
*/
type UpdateUserPreferencesUnauthorized struct {
	Payload *models.ErrorResponseBody
}

// IsSuccess returns true when this update user preferences unauthorized response has a 2xx status code
func (o *UpdateUserPreferencesUnauthorized) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this update user preferences unauthorized response has a 3xx status code
func (o *UpdateUserPreferencesUnauthorized) IsRedirect() bool {
	return false
}

// IsClientError returns true when this update user preferences unauthorized response has a 4xx status code
func (o *UpdateUserPreferencesUnauthorized) IsClientError() bool {
	return true
}

// IsServerError returns true when this update user preferences unauthorized response has a 5xx status code
func (o *UpdateUserPreferencesUnauthorized) IsServerError() bool {
	return false
}

// IsCode returns true when this update user preferences unauthorized response a status code equal to that given
func (o *UpdateUserPreferencesUnauthorized) IsCode(code int) bool {
	return code == 401
}

// Code gets the status code for the update user preferences unauthorized response
func (o *UpdateUserPreferencesUnauthorized) Code() int {
	return 401
}

func (o *UpdateUserPreferencesUnauthorized) Error() string {
	return fmt.Sprintf("[PUT /user/preferences][%d] updateUserPreferencesUnauthorized  %+v", 401, o.Payload)
}

func (o *UpdateUserPreferencesUnauthorized) String() string {
	return fmt.Sprintf("[PUT /user/preferences][%d] updateUserPreferencesUnauthorized  %+v", 401, o.Payload)
}

func (o *UpdateUserPreferencesUnauthorized) GetPayload() *models.ErrorResponseBody {
	return o.Payload
}

func (o *UpdateUserPreferencesUnauthorized) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponseBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewUpdateUserPreferencesInternalServerError creates a UpdateUserPreferencesInternalServerError with default headers values
func NewUpdateUserPreferencesInternalServerError() *UpdateUserPreferencesInternalServerError {
	return &UpdateUserPreferencesInternalServerError{}
}

/*
UpdateUserPreferencesInternalServerError describes a response with status code 500, with default header values.

InternalServerError is a general error indicating something went wrong internally.
*/
type UpdateUserPreferencesInternalServerError struct {
	Payload *models.ErrorResponseBody
}

// IsSuccess returns true when this update user preferences internal server error response has a 2xx status code
func (o *UpdateUserPreferencesInternalServerError) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this update user preferences internal server error response has a 3xx status code
func (o *UpdateUserPreferencesInternalServerError) IsRedirect() bool {
	return false
}

// IsClientError returns true when this update user preferences internal server error response has a 4xx status code
func (o *UpdateUserPreferencesInternalServerError) IsClientError() bool {
	return false
}

// IsServerError returns true when this update user preferences internal server error response has a 5xx status code
func (o *UpdateUserPreferencesInternalServerError) IsServerError() bool {
	return true
}

// IsCode returns true when this update user preferences internal server error response a status code equal to that given
func (o *UpdateUserPreferencesInternalServerError) IsCode(code int) bool {
	return code == 500
}

// Code gets the status code for the update user preferences internal server error response
func (o *UpdateUserPreferencesInternalServerError) Code() int {
	return 500
}

func (o *UpdateUserPreferencesInternalServerError) Error() string {
	return fmt.Sprintf("[PUT /user/preferences][%d] updateUserPreferencesInternalServerError  %+v", 500, o.Payload)
}

func (o *UpdateUserPreferencesInternalServerError) String() string {
	return fmt.Sprintf("[PUT /user/preferences][%d] updateUserPreferencesInternalServerError  %+v", 500, o.Payload)
}

func (o *UpdateUserPreferencesInternalServerError) GetPayload() *models.ErrorResponseBody {
	return o.Payload
}

func (o *UpdateUserPreferencesInternalServerError) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponseBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
