// Code generated by go-swagger; DO NOT EDIT.

package legacy_alerts_notification_channels

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"

	"github.com/grafana/grafana-openapi-client-go/models"
)

// NewUpdateAlertNotificationChannelParams creates a new UpdateAlertNotificationChannelParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewUpdateAlertNotificationChannelParams() *UpdateAlertNotificationChannelParams {
	return &UpdateAlertNotificationChannelParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewUpdateAlertNotificationChannelParamsWithTimeout creates a new UpdateAlertNotificationChannelParams object
// with the ability to set a timeout on a request.
func NewUpdateAlertNotificationChannelParamsWithTimeout(timeout time.Duration) *UpdateAlertNotificationChannelParams {
	return &UpdateAlertNotificationChannelParams{
		timeout: timeout,
	}
}

// NewUpdateAlertNotificationChannelParamsWithContext creates a new UpdateAlertNotificationChannelParams object
// with the ability to set a context for a request.
func NewUpdateAlertNotificationChannelParamsWithContext(ctx context.Context) *UpdateAlertNotificationChannelParams {
	return &UpdateAlertNotificationChannelParams{
		Context: ctx,
	}
}

// NewUpdateAlertNotificationChannelParamsWithHTTPClient creates a new UpdateAlertNotificationChannelParams object
// with the ability to set a custom HTTPClient for a request.
func NewUpdateAlertNotificationChannelParamsWithHTTPClient(client *http.Client) *UpdateAlertNotificationChannelParams {
	return &UpdateAlertNotificationChannelParams{
		HTTPClient: client,
	}
}

/*
UpdateAlertNotificationChannelParams contains all the parameters to send to the API endpoint

	for the update alert notification channel operation.

	Typically these are written to a http.Request.
*/
type UpdateAlertNotificationChannelParams struct {

	// Body.
	Body *models.UpdateAlertNotificationCommand

	// NotificationChannelID.
	//
	// Format: int64
	NotificationChannelID int64

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the update alert notification channel params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *UpdateAlertNotificationChannelParams) WithDefaults() *UpdateAlertNotificationChannelParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the update alert notification channel params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *UpdateAlertNotificationChannelParams) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the update alert notification channel params
func (o *UpdateAlertNotificationChannelParams) WithTimeout(timeout time.Duration) *UpdateAlertNotificationChannelParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the update alert notification channel params
func (o *UpdateAlertNotificationChannelParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the update alert notification channel params
func (o *UpdateAlertNotificationChannelParams) WithContext(ctx context.Context) *UpdateAlertNotificationChannelParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the update alert notification channel params
func (o *UpdateAlertNotificationChannelParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the update alert notification channel params
func (o *UpdateAlertNotificationChannelParams) WithHTTPClient(client *http.Client) *UpdateAlertNotificationChannelParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the update alert notification channel params
func (o *UpdateAlertNotificationChannelParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithBody adds the body to the update alert notification channel params
func (o *UpdateAlertNotificationChannelParams) WithBody(body *models.UpdateAlertNotificationCommand) *UpdateAlertNotificationChannelParams {
	o.SetBody(body)
	return o
}

// SetBody adds the body to the update alert notification channel params
func (o *UpdateAlertNotificationChannelParams) SetBody(body *models.UpdateAlertNotificationCommand) {
	o.Body = body
}

// WithNotificationChannelID adds the notificationChannelID to the update alert notification channel params
func (o *UpdateAlertNotificationChannelParams) WithNotificationChannelID(notificationChannelID int64) *UpdateAlertNotificationChannelParams {
	o.SetNotificationChannelID(notificationChannelID)
	return o
}

// SetNotificationChannelID adds the notificationChannelId to the update alert notification channel params
func (o *UpdateAlertNotificationChannelParams) SetNotificationChannelID(notificationChannelID int64) {
	o.NotificationChannelID = notificationChannelID
}

// WriteToRequest writes these params to a swagger request
func (o *UpdateAlertNotificationChannelParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error
	if o.Body != nil {
		if err := r.SetBodyParam(o.Body); err != nil {
			return err
		}
	}

	// path param notification_channel_id
	if err := r.SetPathParam("notification_channel_id", swag.FormatInt64(o.NotificationChannelID)); err != nil {
		return err
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
