// Code generated by go-swagger; DO NOT EDIT.

package signed_in_user

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/grafana/grafana-openapi-client-go/models"
)

// SetHelpFlagReader is a Reader for the SetHelpFlag structure.
type SetHelpFlagReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *SetHelpFlagReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewSetHelpFlagOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 401:
		result := NewSetHelpFlagUnauthorized()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 403:
		result := NewSetHelpFlagForbidden()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 500:
		result := NewSetHelpFlagInternalServerError()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	default:
		return nil, runtime.NewAPIError("[PUT /user/helpflags/{flag_id}] setHelpFlag", response, response.Code())
	}
}

// NewSetHelpFlagOK creates a SetHelpFlagOK with default headers values
func NewSetHelpFlagOK() *SetHelpFlagOK {
	return &SetHelpFlagOK{}
}

/*
SetHelpFlagOK describes a response with status code 200, with default header values.

(empty)
*/
type SetHelpFlagOK struct {
	Payload *models.SetHelpFlagOKBody
}

// IsSuccess returns true when this set help flag Ok response has a 2xx status code
func (o *SetHelpFlagOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this set help flag Ok response has a 3xx status code
func (o *SetHelpFlagOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this set help flag Ok response has a 4xx status code
func (o *SetHelpFlagOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this set help flag Ok response has a 5xx status code
func (o *SetHelpFlagOK) IsServerError() bool {
	return false
}

// IsCode returns true when this set help flag Ok response a status code equal to that given
func (o *SetHelpFlagOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the set help flag Ok response
func (o *SetHelpFlagOK) Code() int {
	return 200
}

func (o *SetHelpFlagOK) Error() string {
	return fmt.Sprintf("[PUT /user/helpflags/{flag_id}][%d] setHelpFlagOk  %+v", 200, o.Payload)
}

func (o *SetHelpFlagOK) String() string {
	return fmt.Sprintf("[PUT /user/helpflags/{flag_id}][%d] setHelpFlagOk  %+v", 200, o.Payload)
}

func (o *SetHelpFlagOK) GetPayload() *models.SetHelpFlagOKBody {
	return o.Payload
}

func (o *SetHelpFlagOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.SetHelpFlagOKBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewSetHelpFlagUnauthorized creates a SetHelpFlagUnauthorized with default headers values
func NewSetHelpFlagUnauthorized() *SetHelpFlagUnauthorized {
	return &SetHelpFlagUnauthorized{}
}

/*
SetHelpFlagUnauthorized describes a response with status code 401, with default header values.

UnauthorizedError is returned when the request is not authenticated.
*/
type SetHelpFlagUnauthorized struct {
	Payload *models.ErrorResponseBody
}

// IsSuccess returns true when this set help flag unauthorized response has a 2xx status code
func (o *SetHelpFlagUnauthorized) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this set help flag unauthorized response has a 3xx status code
func (o *SetHelpFlagUnauthorized) IsRedirect() bool {
	return false
}

// IsClientError returns true when this set help flag unauthorized response has a 4xx status code
func (o *SetHelpFlagUnauthorized) IsClientError() bool {
	return true
}

// IsServerError returns true when this set help flag unauthorized response has a 5xx status code
func (o *SetHelpFlagUnauthorized) IsServerError() bool {
	return false
}

// IsCode returns true when this set help flag unauthorized response a status code equal to that given
func (o *SetHelpFlagUnauthorized) IsCode(code int) bool {
	return code == 401
}

// Code gets the status code for the set help flag unauthorized response
func (o *SetHelpFlagUnauthorized) Code() int {
	return 401
}

func (o *SetHelpFlagUnauthorized) Error() string {
	return fmt.Sprintf("[PUT /user/helpflags/{flag_id}][%d] setHelpFlagUnauthorized  %+v", 401, o.Payload)
}

func (o *SetHelpFlagUnauthorized) String() string {
	return fmt.Sprintf("[PUT /user/helpflags/{flag_id}][%d] setHelpFlagUnauthorized  %+v", 401, o.Payload)
}

func (o *SetHelpFlagUnauthorized) GetPayload() *models.ErrorResponseBody {
	return o.Payload
}

func (o *SetHelpFlagUnauthorized) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponseBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewSetHelpFlagForbidden creates a SetHelpFlagForbidden with default headers values
func NewSetHelpFlagForbidden() *SetHelpFlagForbidden {
	return &SetHelpFlagForbidden{}
}

/*
SetHelpFlagForbidden describes a response with status code 403, with default header values.

ForbiddenError is returned if the user/token has insufficient permissions to access the requested resource.
*/
type SetHelpFlagForbidden struct {
	Payload *models.ErrorResponseBody
}

// IsSuccess returns true when this set help flag forbidden response has a 2xx status code
func (o *SetHelpFlagForbidden) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this set help flag forbidden response has a 3xx status code
func (o *SetHelpFlagForbidden) IsRedirect() bool {
	return false
}

// IsClientError returns true when this set help flag forbidden response has a 4xx status code
func (o *SetHelpFlagForbidden) IsClientError() bool {
	return true
}

// IsServerError returns true when this set help flag forbidden response has a 5xx status code
func (o *SetHelpFlagForbidden) IsServerError() bool {
	return false
}

// IsCode returns true when this set help flag forbidden response a status code equal to that given
func (o *SetHelpFlagForbidden) IsCode(code int) bool {
	return code == 403
}

// Code gets the status code for the set help flag forbidden response
func (o *SetHelpFlagForbidden) Code() int {
	return 403
}

func (o *SetHelpFlagForbidden) Error() string {
	return fmt.Sprintf("[PUT /user/helpflags/{flag_id}][%d] setHelpFlagForbidden  %+v", 403, o.Payload)
}

func (o *SetHelpFlagForbidden) String() string {
	return fmt.Sprintf("[PUT /user/helpflags/{flag_id}][%d] setHelpFlagForbidden  %+v", 403, o.Payload)
}

func (o *SetHelpFlagForbidden) GetPayload() *models.ErrorResponseBody {
	return o.Payload
}

func (o *SetHelpFlagForbidden) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponseBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewSetHelpFlagInternalServerError creates a SetHelpFlagInternalServerError with default headers values
func NewSetHelpFlagInternalServerError() *SetHelpFlagInternalServerError {
	return &SetHelpFlagInternalServerError{}
}

/*
SetHelpFlagInternalServerError describes a response with status code 500, with default header values.

InternalServerError is a general error indicating something went wrong internally.
*/
type SetHelpFlagInternalServerError struct {
	Payload *models.ErrorResponseBody
}

// IsSuccess returns true when this set help flag internal server error response has a 2xx status code
func (o *SetHelpFlagInternalServerError) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this set help flag internal server error response has a 3xx status code
func (o *SetHelpFlagInternalServerError) IsRedirect() bool {
	return false
}

// IsClientError returns true when this set help flag internal server error response has a 4xx status code
func (o *SetHelpFlagInternalServerError) IsClientError() bool {
	return false
}

// IsServerError returns true when this set help flag internal server error response has a 5xx status code
func (o *SetHelpFlagInternalServerError) IsServerError() bool {
	return true
}

// IsCode returns true when this set help flag internal server error response a status code equal to that given
func (o *SetHelpFlagInternalServerError) IsCode(code int) bool {
	return code == 500
}

// Code gets the status code for the set help flag internal server error response
func (o *SetHelpFlagInternalServerError) Code() int {
	return 500
}

func (o *SetHelpFlagInternalServerError) Error() string {
	return fmt.Sprintf("[PUT /user/helpflags/{flag_id}][%d] setHelpFlagInternalServerError  %+v", 500, o.Payload)
}

func (o *SetHelpFlagInternalServerError) String() string {
	return fmt.Sprintf("[PUT /user/helpflags/{flag_id}][%d] setHelpFlagInternalServerError  %+v", 500, o.Payload)
}

func (o *SetHelpFlagInternalServerError) GetPayload() *models.ErrorResponseBody {
	return o.Payload
}

func (o *SetHelpFlagInternalServerError) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponseBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
