// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

// Package auditmanageriface provides an interface to enable mocking the AWS Audit Manager service client
// for testing your code.
//
// It is important to note that this interface will have breaking changes
// when the service model is updated and adds new API operations, paginators,
// and waiters.
package auditmanageriface

import (
	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/service/auditmanager"
)

// AuditManagerAPI provides an interface to enable mocking the
// auditmanager.AuditManager service client's API operation,
// paginators, and waiters. This make unit testing your code that calls out
// to the SDK's service client's calls easier.
//
// The best way to use this interface is so the SDK's service client's calls
// can be stubbed out for unit testing your code with the SDK without needing
// to inject custom request handlers into the SDK's request pipeline.
//
//	// myFunc uses an SDK service client to make a request to
//	// AWS Audit Manager.
//	func myFunc(svc auditmanageriface.AuditManagerAPI) bool {
//	    // Make svc.AssociateAssessmentReportEvidenceFolder request
//	}
//
//	func main() {
//	    sess := session.New()
//	    svc := auditmanager.New(sess)
//
//	    myFunc(svc)
//	}
//
// In your _test.go file:
//
//	// Define a mock struct to be used in your unit tests of myFunc.
//	type mockAuditManagerClient struct {
//	    auditmanageriface.AuditManagerAPI
//	}
//	func (m *mockAuditManagerClient) AssociateAssessmentReportEvidenceFolder(input *auditmanager.AssociateAssessmentReportEvidenceFolderInput) (*auditmanager.AssociateAssessmentReportEvidenceFolderOutput, error) {
//	    // mock response/functionality
//	}
//
//	func TestMyFunc(t *testing.T) {
//	    // Setup Test
//	    mockSvc := &mockAuditManagerClient{}
//
//	    myfunc(mockSvc)
//
//	    // Verify myFunc's functionality
//	}
//
// It is important to note that this interface will have breaking changes
// when the service model is updated and adds new API operations, paginators,
// and waiters. Its suggested to use the pattern above for testing, or using
// tooling to generate mocks to satisfy the interfaces.
type AuditManagerAPI interface {
	AssociateAssessmentReportEvidenceFolder(*auditmanager.AssociateAssessmentReportEvidenceFolderInput) (*auditmanager.AssociateAssessmentReportEvidenceFolderOutput, error)
	AssociateAssessmentReportEvidenceFolderWithContext(aws.Context, *auditmanager.AssociateAssessmentReportEvidenceFolderInput, ...request.Option) (*auditmanager.AssociateAssessmentReportEvidenceFolderOutput, error)
	AssociateAssessmentReportEvidenceFolderRequest(*auditmanager.AssociateAssessmentReportEvidenceFolderInput) (*request.Request, *auditmanager.AssociateAssessmentReportEvidenceFolderOutput)

	BatchAssociateAssessmentReportEvidence(*auditmanager.BatchAssociateAssessmentReportEvidenceInput) (*auditmanager.BatchAssociateAssessmentReportEvidenceOutput, error)
	BatchAssociateAssessmentReportEvidenceWithContext(aws.Context, *auditmanager.BatchAssociateAssessmentReportEvidenceInput, ...request.Option) (*auditmanager.BatchAssociateAssessmentReportEvidenceOutput, error)
	BatchAssociateAssessmentReportEvidenceRequest(*auditmanager.BatchAssociateAssessmentReportEvidenceInput) (*request.Request, *auditmanager.BatchAssociateAssessmentReportEvidenceOutput)

	BatchCreateDelegationByAssessment(*auditmanager.BatchCreateDelegationByAssessmentInput) (*auditmanager.BatchCreateDelegationByAssessmentOutput, error)
	BatchCreateDelegationByAssessmentWithContext(aws.Context, *auditmanager.BatchCreateDelegationByAssessmentInput, ...request.Option) (*auditmanager.BatchCreateDelegationByAssessmentOutput, error)
	BatchCreateDelegationByAssessmentRequest(*auditmanager.BatchCreateDelegationByAssessmentInput) (*request.Request, *auditmanager.BatchCreateDelegationByAssessmentOutput)

	BatchDeleteDelegationByAssessment(*auditmanager.BatchDeleteDelegationByAssessmentInput) (*auditmanager.BatchDeleteDelegationByAssessmentOutput, error)
	BatchDeleteDelegationByAssessmentWithContext(aws.Context, *auditmanager.BatchDeleteDelegationByAssessmentInput, ...request.Option) (*auditmanager.BatchDeleteDelegationByAssessmentOutput, error)
	BatchDeleteDelegationByAssessmentRequest(*auditmanager.BatchDeleteDelegationByAssessmentInput) (*request.Request, *auditmanager.BatchDeleteDelegationByAssessmentOutput)

	BatchDisassociateAssessmentReportEvidence(*auditmanager.BatchDisassociateAssessmentReportEvidenceInput) (*auditmanager.BatchDisassociateAssessmentReportEvidenceOutput, error)
	BatchDisassociateAssessmentReportEvidenceWithContext(aws.Context, *auditmanager.BatchDisassociateAssessmentReportEvidenceInput, ...request.Option) (*auditmanager.BatchDisassociateAssessmentReportEvidenceOutput, error)
	BatchDisassociateAssessmentReportEvidenceRequest(*auditmanager.BatchDisassociateAssessmentReportEvidenceInput) (*request.Request, *auditmanager.BatchDisassociateAssessmentReportEvidenceOutput)

	BatchImportEvidenceToAssessmentControl(*auditmanager.BatchImportEvidenceToAssessmentControlInput) (*auditmanager.BatchImportEvidenceToAssessmentControlOutput, error)
	BatchImportEvidenceToAssessmentControlWithContext(aws.Context, *auditmanager.BatchImportEvidenceToAssessmentControlInput, ...request.Option) (*auditmanager.BatchImportEvidenceToAssessmentControlOutput, error)
	BatchImportEvidenceToAssessmentControlRequest(*auditmanager.BatchImportEvidenceToAssessmentControlInput) (*request.Request, *auditmanager.BatchImportEvidenceToAssessmentControlOutput)

	CreateAssessment(*auditmanager.CreateAssessmentInput) (*auditmanager.CreateAssessmentOutput, error)
	CreateAssessmentWithContext(aws.Context, *auditmanager.CreateAssessmentInput, ...request.Option) (*auditmanager.CreateAssessmentOutput, error)
	CreateAssessmentRequest(*auditmanager.CreateAssessmentInput) (*request.Request, *auditmanager.CreateAssessmentOutput)

	CreateAssessmentFramework(*auditmanager.CreateAssessmentFrameworkInput) (*auditmanager.CreateAssessmentFrameworkOutput, error)
	CreateAssessmentFrameworkWithContext(aws.Context, *auditmanager.CreateAssessmentFrameworkInput, ...request.Option) (*auditmanager.CreateAssessmentFrameworkOutput, error)
	CreateAssessmentFrameworkRequest(*auditmanager.CreateAssessmentFrameworkInput) (*request.Request, *auditmanager.CreateAssessmentFrameworkOutput)

	CreateAssessmentReport(*auditmanager.CreateAssessmentReportInput) (*auditmanager.CreateAssessmentReportOutput, error)
	CreateAssessmentReportWithContext(aws.Context, *auditmanager.CreateAssessmentReportInput, ...request.Option) (*auditmanager.CreateAssessmentReportOutput, error)
	CreateAssessmentReportRequest(*auditmanager.CreateAssessmentReportInput) (*request.Request, *auditmanager.CreateAssessmentReportOutput)

	CreateControl(*auditmanager.CreateControlInput) (*auditmanager.CreateControlOutput, error)
	CreateControlWithContext(aws.Context, *auditmanager.CreateControlInput, ...request.Option) (*auditmanager.CreateControlOutput, error)
	CreateControlRequest(*auditmanager.CreateControlInput) (*request.Request, *auditmanager.CreateControlOutput)

	DeleteAssessment(*auditmanager.DeleteAssessmentInput) (*auditmanager.DeleteAssessmentOutput, error)
	DeleteAssessmentWithContext(aws.Context, *auditmanager.DeleteAssessmentInput, ...request.Option) (*auditmanager.DeleteAssessmentOutput, error)
	DeleteAssessmentRequest(*auditmanager.DeleteAssessmentInput) (*request.Request, *auditmanager.DeleteAssessmentOutput)

	DeleteAssessmentFramework(*auditmanager.DeleteAssessmentFrameworkInput) (*auditmanager.DeleteAssessmentFrameworkOutput, error)
	DeleteAssessmentFrameworkWithContext(aws.Context, *auditmanager.DeleteAssessmentFrameworkInput, ...request.Option) (*auditmanager.DeleteAssessmentFrameworkOutput, error)
	DeleteAssessmentFrameworkRequest(*auditmanager.DeleteAssessmentFrameworkInput) (*request.Request, *auditmanager.DeleteAssessmentFrameworkOutput)

	DeleteAssessmentFrameworkShare(*auditmanager.DeleteAssessmentFrameworkShareInput) (*auditmanager.DeleteAssessmentFrameworkShareOutput, error)
	DeleteAssessmentFrameworkShareWithContext(aws.Context, *auditmanager.DeleteAssessmentFrameworkShareInput, ...request.Option) (*auditmanager.DeleteAssessmentFrameworkShareOutput, error)
	DeleteAssessmentFrameworkShareRequest(*auditmanager.DeleteAssessmentFrameworkShareInput) (*request.Request, *auditmanager.DeleteAssessmentFrameworkShareOutput)

	DeleteAssessmentReport(*auditmanager.DeleteAssessmentReportInput) (*auditmanager.DeleteAssessmentReportOutput, error)
	DeleteAssessmentReportWithContext(aws.Context, *auditmanager.DeleteAssessmentReportInput, ...request.Option) (*auditmanager.DeleteAssessmentReportOutput, error)
	DeleteAssessmentReportRequest(*auditmanager.DeleteAssessmentReportInput) (*request.Request, *auditmanager.DeleteAssessmentReportOutput)

	DeleteControl(*auditmanager.DeleteControlInput) (*auditmanager.DeleteControlOutput, error)
	DeleteControlWithContext(aws.Context, *auditmanager.DeleteControlInput, ...request.Option) (*auditmanager.DeleteControlOutput, error)
	DeleteControlRequest(*auditmanager.DeleteControlInput) (*request.Request, *auditmanager.DeleteControlOutput)

	DeregisterAccount(*auditmanager.DeregisterAccountInput) (*auditmanager.DeregisterAccountOutput, error)
	DeregisterAccountWithContext(aws.Context, *auditmanager.DeregisterAccountInput, ...request.Option) (*auditmanager.DeregisterAccountOutput, error)
	DeregisterAccountRequest(*auditmanager.DeregisterAccountInput) (*request.Request, *auditmanager.DeregisterAccountOutput)

	DeregisterOrganizationAdminAccount(*auditmanager.DeregisterOrganizationAdminAccountInput) (*auditmanager.DeregisterOrganizationAdminAccountOutput, error)
	DeregisterOrganizationAdminAccountWithContext(aws.Context, *auditmanager.DeregisterOrganizationAdminAccountInput, ...request.Option) (*auditmanager.DeregisterOrganizationAdminAccountOutput, error)
	DeregisterOrganizationAdminAccountRequest(*auditmanager.DeregisterOrganizationAdminAccountInput) (*request.Request, *auditmanager.DeregisterOrganizationAdminAccountOutput)

	DisassociateAssessmentReportEvidenceFolder(*auditmanager.DisassociateAssessmentReportEvidenceFolderInput) (*auditmanager.DisassociateAssessmentReportEvidenceFolderOutput, error)
	DisassociateAssessmentReportEvidenceFolderWithContext(aws.Context, *auditmanager.DisassociateAssessmentReportEvidenceFolderInput, ...request.Option) (*auditmanager.DisassociateAssessmentReportEvidenceFolderOutput, error)
	DisassociateAssessmentReportEvidenceFolderRequest(*auditmanager.DisassociateAssessmentReportEvidenceFolderInput) (*request.Request, *auditmanager.DisassociateAssessmentReportEvidenceFolderOutput)

	GetAccountStatus(*auditmanager.GetAccountStatusInput) (*auditmanager.GetAccountStatusOutput, error)
	GetAccountStatusWithContext(aws.Context, *auditmanager.GetAccountStatusInput, ...request.Option) (*auditmanager.GetAccountStatusOutput, error)
	GetAccountStatusRequest(*auditmanager.GetAccountStatusInput) (*request.Request, *auditmanager.GetAccountStatusOutput)

	GetAssessment(*auditmanager.GetAssessmentInput) (*auditmanager.GetAssessmentOutput, error)
	GetAssessmentWithContext(aws.Context, *auditmanager.GetAssessmentInput, ...request.Option) (*auditmanager.GetAssessmentOutput, error)
	GetAssessmentRequest(*auditmanager.GetAssessmentInput) (*request.Request, *auditmanager.GetAssessmentOutput)

	GetAssessmentFramework(*auditmanager.GetAssessmentFrameworkInput) (*auditmanager.GetAssessmentFrameworkOutput, error)
	GetAssessmentFrameworkWithContext(aws.Context, *auditmanager.GetAssessmentFrameworkInput, ...request.Option) (*auditmanager.GetAssessmentFrameworkOutput, error)
	GetAssessmentFrameworkRequest(*auditmanager.GetAssessmentFrameworkInput) (*request.Request, *auditmanager.GetAssessmentFrameworkOutput)

	GetAssessmentReportUrl(*auditmanager.GetAssessmentReportUrlInput) (*auditmanager.GetAssessmentReportUrlOutput, error)
	GetAssessmentReportUrlWithContext(aws.Context, *auditmanager.GetAssessmentReportUrlInput, ...request.Option) (*auditmanager.GetAssessmentReportUrlOutput, error)
	GetAssessmentReportUrlRequest(*auditmanager.GetAssessmentReportUrlInput) (*request.Request, *auditmanager.GetAssessmentReportUrlOutput)

	GetChangeLogs(*auditmanager.GetChangeLogsInput) (*auditmanager.GetChangeLogsOutput, error)
	GetChangeLogsWithContext(aws.Context, *auditmanager.GetChangeLogsInput, ...request.Option) (*auditmanager.GetChangeLogsOutput, error)
	GetChangeLogsRequest(*auditmanager.GetChangeLogsInput) (*request.Request, *auditmanager.GetChangeLogsOutput)

	GetChangeLogsPages(*auditmanager.GetChangeLogsInput, func(*auditmanager.GetChangeLogsOutput, bool) bool) error
	GetChangeLogsPagesWithContext(aws.Context, *auditmanager.GetChangeLogsInput, func(*auditmanager.GetChangeLogsOutput, bool) bool, ...request.Option) error

	GetControl(*auditmanager.GetControlInput) (*auditmanager.GetControlOutput, error)
	GetControlWithContext(aws.Context, *auditmanager.GetControlInput, ...request.Option) (*auditmanager.GetControlOutput, error)
	GetControlRequest(*auditmanager.GetControlInput) (*request.Request, *auditmanager.GetControlOutput)

	GetDelegations(*auditmanager.GetDelegationsInput) (*auditmanager.GetDelegationsOutput, error)
	GetDelegationsWithContext(aws.Context, *auditmanager.GetDelegationsInput, ...request.Option) (*auditmanager.GetDelegationsOutput, error)
	GetDelegationsRequest(*auditmanager.GetDelegationsInput) (*request.Request, *auditmanager.GetDelegationsOutput)

	GetDelegationsPages(*auditmanager.GetDelegationsInput, func(*auditmanager.GetDelegationsOutput, bool) bool) error
	GetDelegationsPagesWithContext(aws.Context, *auditmanager.GetDelegationsInput, func(*auditmanager.GetDelegationsOutput, bool) bool, ...request.Option) error

	GetEvidence(*auditmanager.GetEvidenceInput) (*auditmanager.GetEvidenceOutput, error)
	GetEvidenceWithContext(aws.Context, *auditmanager.GetEvidenceInput, ...request.Option) (*auditmanager.GetEvidenceOutput, error)
	GetEvidenceRequest(*auditmanager.GetEvidenceInput) (*request.Request, *auditmanager.GetEvidenceOutput)

	GetEvidenceByEvidenceFolder(*auditmanager.GetEvidenceByEvidenceFolderInput) (*auditmanager.GetEvidenceByEvidenceFolderOutput, error)
	GetEvidenceByEvidenceFolderWithContext(aws.Context, *auditmanager.GetEvidenceByEvidenceFolderInput, ...request.Option) (*auditmanager.GetEvidenceByEvidenceFolderOutput, error)
	GetEvidenceByEvidenceFolderRequest(*auditmanager.GetEvidenceByEvidenceFolderInput) (*request.Request, *auditmanager.GetEvidenceByEvidenceFolderOutput)

	GetEvidenceByEvidenceFolderPages(*auditmanager.GetEvidenceByEvidenceFolderInput, func(*auditmanager.GetEvidenceByEvidenceFolderOutput, bool) bool) error
	GetEvidenceByEvidenceFolderPagesWithContext(aws.Context, *auditmanager.GetEvidenceByEvidenceFolderInput, func(*auditmanager.GetEvidenceByEvidenceFolderOutput, bool) bool, ...request.Option) error

	GetEvidenceFolder(*auditmanager.GetEvidenceFolderInput) (*auditmanager.GetEvidenceFolderOutput, error)
	GetEvidenceFolderWithContext(aws.Context, *auditmanager.GetEvidenceFolderInput, ...request.Option) (*auditmanager.GetEvidenceFolderOutput, error)
	GetEvidenceFolderRequest(*auditmanager.GetEvidenceFolderInput) (*request.Request, *auditmanager.GetEvidenceFolderOutput)

	GetEvidenceFoldersByAssessment(*auditmanager.GetEvidenceFoldersByAssessmentInput) (*auditmanager.GetEvidenceFoldersByAssessmentOutput, error)
	GetEvidenceFoldersByAssessmentWithContext(aws.Context, *auditmanager.GetEvidenceFoldersByAssessmentInput, ...request.Option) (*auditmanager.GetEvidenceFoldersByAssessmentOutput, error)
	GetEvidenceFoldersByAssessmentRequest(*auditmanager.GetEvidenceFoldersByAssessmentInput) (*request.Request, *auditmanager.GetEvidenceFoldersByAssessmentOutput)

	GetEvidenceFoldersByAssessmentPages(*auditmanager.GetEvidenceFoldersByAssessmentInput, func(*auditmanager.GetEvidenceFoldersByAssessmentOutput, bool) bool) error
	GetEvidenceFoldersByAssessmentPagesWithContext(aws.Context, *auditmanager.GetEvidenceFoldersByAssessmentInput, func(*auditmanager.GetEvidenceFoldersByAssessmentOutput, bool) bool, ...request.Option) error

	GetEvidenceFoldersByAssessmentControl(*auditmanager.GetEvidenceFoldersByAssessmentControlInput) (*auditmanager.GetEvidenceFoldersByAssessmentControlOutput, error)
	GetEvidenceFoldersByAssessmentControlWithContext(aws.Context, *auditmanager.GetEvidenceFoldersByAssessmentControlInput, ...request.Option) (*auditmanager.GetEvidenceFoldersByAssessmentControlOutput, error)
	GetEvidenceFoldersByAssessmentControlRequest(*auditmanager.GetEvidenceFoldersByAssessmentControlInput) (*request.Request, *auditmanager.GetEvidenceFoldersByAssessmentControlOutput)

	GetEvidenceFoldersByAssessmentControlPages(*auditmanager.GetEvidenceFoldersByAssessmentControlInput, func(*auditmanager.GetEvidenceFoldersByAssessmentControlOutput, bool) bool) error
	GetEvidenceFoldersByAssessmentControlPagesWithContext(aws.Context, *auditmanager.GetEvidenceFoldersByAssessmentControlInput, func(*auditmanager.GetEvidenceFoldersByAssessmentControlOutput, bool) bool, ...request.Option) error

	GetInsights(*auditmanager.GetInsightsInput) (*auditmanager.GetInsightsOutput, error)
	GetInsightsWithContext(aws.Context, *auditmanager.GetInsightsInput, ...request.Option) (*auditmanager.GetInsightsOutput, error)
	GetInsightsRequest(*auditmanager.GetInsightsInput) (*request.Request, *auditmanager.GetInsightsOutput)

	GetInsightsByAssessment(*auditmanager.GetInsightsByAssessmentInput) (*auditmanager.GetInsightsByAssessmentOutput, error)
	GetInsightsByAssessmentWithContext(aws.Context, *auditmanager.GetInsightsByAssessmentInput, ...request.Option) (*auditmanager.GetInsightsByAssessmentOutput, error)
	GetInsightsByAssessmentRequest(*auditmanager.GetInsightsByAssessmentInput) (*request.Request, *auditmanager.GetInsightsByAssessmentOutput)

	GetOrganizationAdminAccount(*auditmanager.GetOrganizationAdminAccountInput) (*auditmanager.GetOrganizationAdminAccountOutput, error)
	GetOrganizationAdminAccountWithContext(aws.Context, *auditmanager.GetOrganizationAdminAccountInput, ...request.Option) (*auditmanager.GetOrganizationAdminAccountOutput, error)
	GetOrganizationAdminAccountRequest(*auditmanager.GetOrganizationAdminAccountInput) (*request.Request, *auditmanager.GetOrganizationAdminAccountOutput)

	GetServicesInScope(*auditmanager.GetServicesInScopeInput) (*auditmanager.GetServicesInScopeOutput, error)
	GetServicesInScopeWithContext(aws.Context, *auditmanager.GetServicesInScopeInput, ...request.Option) (*auditmanager.GetServicesInScopeOutput, error)
	GetServicesInScopeRequest(*auditmanager.GetServicesInScopeInput) (*request.Request, *auditmanager.GetServicesInScopeOutput)

	GetSettings(*auditmanager.GetSettingsInput) (*auditmanager.GetSettingsOutput, error)
	GetSettingsWithContext(aws.Context, *auditmanager.GetSettingsInput, ...request.Option) (*auditmanager.GetSettingsOutput, error)
	GetSettingsRequest(*auditmanager.GetSettingsInput) (*request.Request, *auditmanager.GetSettingsOutput)

	ListAssessmentControlInsightsByControlDomain(*auditmanager.ListAssessmentControlInsightsByControlDomainInput) (*auditmanager.ListAssessmentControlInsightsByControlDomainOutput, error)
	ListAssessmentControlInsightsByControlDomainWithContext(aws.Context, *auditmanager.ListAssessmentControlInsightsByControlDomainInput, ...request.Option) (*auditmanager.ListAssessmentControlInsightsByControlDomainOutput, error)
	ListAssessmentControlInsightsByControlDomainRequest(*auditmanager.ListAssessmentControlInsightsByControlDomainInput) (*request.Request, *auditmanager.ListAssessmentControlInsightsByControlDomainOutput)

	ListAssessmentControlInsightsByControlDomainPages(*auditmanager.ListAssessmentControlInsightsByControlDomainInput, func(*auditmanager.ListAssessmentControlInsightsByControlDomainOutput, bool) bool) error
	ListAssessmentControlInsightsByControlDomainPagesWithContext(aws.Context, *auditmanager.ListAssessmentControlInsightsByControlDomainInput, func(*auditmanager.ListAssessmentControlInsightsByControlDomainOutput, bool) bool, ...request.Option) error

	ListAssessmentFrameworkShareRequests(*auditmanager.ListAssessmentFrameworkShareRequestsInput) (*auditmanager.ListAssessmentFrameworkShareRequestsOutput, error)
	ListAssessmentFrameworkShareRequestsWithContext(aws.Context, *auditmanager.ListAssessmentFrameworkShareRequestsInput, ...request.Option) (*auditmanager.ListAssessmentFrameworkShareRequestsOutput, error)
	ListAssessmentFrameworkShareRequestsRequest(*auditmanager.ListAssessmentFrameworkShareRequestsInput) (*request.Request, *auditmanager.ListAssessmentFrameworkShareRequestsOutput)

	ListAssessmentFrameworkShareRequestsPages(*auditmanager.ListAssessmentFrameworkShareRequestsInput, func(*auditmanager.ListAssessmentFrameworkShareRequestsOutput, bool) bool) error
	ListAssessmentFrameworkShareRequestsPagesWithContext(aws.Context, *auditmanager.ListAssessmentFrameworkShareRequestsInput, func(*auditmanager.ListAssessmentFrameworkShareRequestsOutput, bool) bool, ...request.Option) error

	ListAssessmentFrameworks(*auditmanager.ListAssessmentFrameworksInput) (*auditmanager.ListAssessmentFrameworksOutput, error)
	ListAssessmentFrameworksWithContext(aws.Context, *auditmanager.ListAssessmentFrameworksInput, ...request.Option) (*auditmanager.ListAssessmentFrameworksOutput, error)
	ListAssessmentFrameworksRequest(*auditmanager.ListAssessmentFrameworksInput) (*request.Request, *auditmanager.ListAssessmentFrameworksOutput)

	ListAssessmentFrameworksPages(*auditmanager.ListAssessmentFrameworksInput, func(*auditmanager.ListAssessmentFrameworksOutput, bool) bool) error
	ListAssessmentFrameworksPagesWithContext(aws.Context, *auditmanager.ListAssessmentFrameworksInput, func(*auditmanager.ListAssessmentFrameworksOutput, bool) bool, ...request.Option) error

	ListAssessmentReports(*auditmanager.ListAssessmentReportsInput) (*auditmanager.ListAssessmentReportsOutput, error)
	ListAssessmentReportsWithContext(aws.Context, *auditmanager.ListAssessmentReportsInput, ...request.Option) (*auditmanager.ListAssessmentReportsOutput, error)
	ListAssessmentReportsRequest(*auditmanager.ListAssessmentReportsInput) (*request.Request, *auditmanager.ListAssessmentReportsOutput)

	ListAssessmentReportsPages(*auditmanager.ListAssessmentReportsInput, func(*auditmanager.ListAssessmentReportsOutput, bool) bool) error
	ListAssessmentReportsPagesWithContext(aws.Context, *auditmanager.ListAssessmentReportsInput, func(*auditmanager.ListAssessmentReportsOutput, bool) bool, ...request.Option) error

	ListAssessments(*auditmanager.ListAssessmentsInput) (*auditmanager.ListAssessmentsOutput, error)
	ListAssessmentsWithContext(aws.Context, *auditmanager.ListAssessmentsInput, ...request.Option) (*auditmanager.ListAssessmentsOutput, error)
	ListAssessmentsRequest(*auditmanager.ListAssessmentsInput) (*request.Request, *auditmanager.ListAssessmentsOutput)

	ListAssessmentsPages(*auditmanager.ListAssessmentsInput, func(*auditmanager.ListAssessmentsOutput, bool) bool) error
	ListAssessmentsPagesWithContext(aws.Context, *auditmanager.ListAssessmentsInput, func(*auditmanager.ListAssessmentsOutput, bool) bool, ...request.Option) error

	ListControlDomainInsights(*auditmanager.ListControlDomainInsightsInput) (*auditmanager.ListControlDomainInsightsOutput, error)
	ListControlDomainInsightsWithContext(aws.Context, *auditmanager.ListControlDomainInsightsInput, ...request.Option) (*auditmanager.ListControlDomainInsightsOutput, error)
	ListControlDomainInsightsRequest(*auditmanager.ListControlDomainInsightsInput) (*request.Request, *auditmanager.ListControlDomainInsightsOutput)

	ListControlDomainInsightsPages(*auditmanager.ListControlDomainInsightsInput, func(*auditmanager.ListControlDomainInsightsOutput, bool) bool) error
	ListControlDomainInsightsPagesWithContext(aws.Context, *auditmanager.ListControlDomainInsightsInput, func(*auditmanager.ListControlDomainInsightsOutput, bool) bool, ...request.Option) error

	ListControlDomainInsightsByAssessment(*auditmanager.ListControlDomainInsightsByAssessmentInput) (*auditmanager.ListControlDomainInsightsByAssessmentOutput, error)
	ListControlDomainInsightsByAssessmentWithContext(aws.Context, *auditmanager.ListControlDomainInsightsByAssessmentInput, ...request.Option) (*auditmanager.ListControlDomainInsightsByAssessmentOutput, error)
	ListControlDomainInsightsByAssessmentRequest(*auditmanager.ListControlDomainInsightsByAssessmentInput) (*request.Request, *auditmanager.ListControlDomainInsightsByAssessmentOutput)

	ListControlDomainInsightsByAssessmentPages(*auditmanager.ListControlDomainInsightsByAssessmentInput, func(*auditmanager.ListControlDomainInsightsByAssessmentOutput, bool) bool) error
	ListControlDomainInsightsByAssessmentPagesWithContext(aws.Context, *auditmanager.ListControlDomainInsightsByAssessmentInput, func(*auditmanager.ListControlDomainInsightsByAssessmentOutput, bool) bool, ...request.Option) error

	ListControlInsightsByControlDomain(*auditmanager.ListControlInsightsByControlDomainInput) (*auditmanager.ListControlInsightsByControlDomainOutput, error)
	ListControlInsightsByControlDomainWithContext(aws.Context, *auditmanager.ListControlInsightsByControlDomainInput, ...request.Option) (*auditmanager.ListControlInsightsByControlDomainOutput, error)
	ListControlInsightsByControlDomainRequest(*auditmanager.ListControlInsightsByControlDomainInput) (*request.Request, *auditmanager.ListControlInsightsByControlDomainOutput)

	ListControlInsightsByControlDomainPages(*auditmanager.ListControlInsightsByControlDomainInput, func(*auditmanager.ListControlInsightsByControlDomainOutput, bool) bool) error
	ListControlInsightsByControlDomainPagesWithContext(aws.Context, *auditmanager.ListControlInsightsByControlDomainInput, func(*auditmanager.ListControlInsightsByControlDomainOutput, bool) bool, ...request.Option) error

	ListControls(*auditmanager.ListControlsInput) (*auditmanager.ListControlsOutput, error)
	ListControlsWithContext(aws.Context, *auditmanager.ListControlsInput, ...request.Option) (*auditmanager.ListControlsOutput, error)
	ListControlsRequest(*auditmanager.ListControlsInput) (*request.Request, *auditmanager.ListControlsOutput)

	ListControlsPages(*auditmanager.ListControlsInput, func(*auditmanager.ListControlsOutput, bool) bool) error
	ListControlsPagesWithContext(aws.Context, *auditmanager.ListControlsInput, func(*auditmanager.ListControlsOutput, bool) bool, ...request.Option) error

	ListKeywordsForDataSource(*auditmanager.ListKeywordsForDataSourceInput) (*auditmanager.ListKeywordsForDataSourceOutput, error)
	ListKeywordsForDataSourceWithContext(aws.Context, *auditmanager.ListKeywordsForDataSourceInput, ...request.Option) (*auditmanager.ListKeywordsForDataSourceOutput, error)
	ListKeywordsForDataSourceRequest(*auditmanager.ListKeywordsForDataSourceInput) (*request.Request, *auditmanager.ListKeywordsForDataSourceOutput)

	ListKeywordsForDataSourcePages(*auditmanager.ListKeywordsForDataSourceInput, func(*auditmanager.ListKeywordsForDataSourceOutput, bool) bool) error
	ListKeywordsForDataSourcePagesWithContext(aws.Context, *auditmanager.ListKeywordsForDataSourceInput, func(*auditmanager.ListKeywordsForDataSourceOutput, bool) bool, ...request.Option) error

	ListNotifications(*auditmanager.ListNotificationsInput) (*auditmanager.ListNotificationsOutput, error)
	ListNotificationsWithContext(aws.Context, *auditmanager.ListNotificationsInput, ...request.Option) (*auditmanager.ListNotificationsOutput, error)
	ListNotificationsRequest(*auditmanager.ListNotificationsInput) (*request.Request, *auditmanager.ListNotificationsOutput)

	ListNotificationsPages(*auditmanager.ListNotificationsInput, func(*auditmanager.ListNotificationsOutput, bool) bool) error
	ListNotificationsPagesWithContext(aws.Context, *auditmanager.ListNotificationsInput, func(*auditmanager.ListNotificationsOutput, bool) bool, ...request.Option) error

	ListTagsForResource(*auditmanager.ListTagsForResourceInput) (*auditmanager.ListTagsForResourceOutput, error)
	ListTagsForResourceWithContext(aws.Context, *auditmanager.ListTagsForResourceInput, ...request.Option) (*auditmanager.ListTagsForResourceOutput, error)
	ListTagsForResourceRequest(*auditmanager.ListTagsForResourceInput) (*request.Request, *auditmanager.ListTagsForResourceOutput)

	RegisterAccount(*auditmanager.RegisterAccountInput) (*auditmanager.RegisterAccountOutput, error)
	RegisterAccountWithContext(aws.Context, *auditmanager.RegisterAccountInput, ...request.Option) (*auditmanager.RegisterAccountOutput, error)
	RegisterAccountRequest(*auditmanager.RegisterAccountInput) (*request.Request, *auditmanager.RegisterAccountOutput)

	RegisterOrganizationAdminAccount(*auditmanager.RegisterOrganizationAdminAccountInput) (*auditmanager.RegisterOrganizationAdminAccountOutput, error)
	RegisterOrganizationAdminAccountWithContext(aws.Context, *auditmanager.RegisterOrganizationAdminAccountInput, ...request.Option) (*auditmanager.RegisterOrganizationAdminAccountOutput, error)
	RegisterOrganizationAdminAccountRequest(*auditmanager.RegisterOrganizationAdminAccountInput) (*request.Request, *auditmanager.RegisterOrganizationAdminAccountOutput)

	StartAssessmentFrameworkShare(*auditmanager.StartAssessmentFrameworkShareInput) (*auditmanager.StartAssessmentFrameworkShareOutput, error)
	StartAssessmentFrameworkShareWithContext(aws.Context, *auditmanager.StartAssessmentFrameworkShareInput, ...request.Option) (*auditmanager.StartAssessmentFrameworkShareOutput, error)
	StartAssessmentFrameworkShareRequest(*auditmanager.StartAssessmentFrameworkShareInput) (*request.Request, *auditmanager.StartAssessmentFrameworkShareOutput)

	TagResource(*auditmanager.TagResourceInput) (*auditmanager.TagResourceOutput, error)
	TagResourceWithContext(aws.Context, *auditmanager.TagResourceInput, ...request.Option) (*auditmanager.TagResourceOutput, error)
	TagResourceRequest(*auditmanager.TagResourceInput) (*request.Request, *auditmanager.TagResourceOutput)

	UntagResource(*auditmanager.UntagResourceInput) (*auditmanager.UntagResourceOutput, error)
	UntagResourceWithContext(aws.Context, *auditmanager.UntagResourceInput, ...request.Option) (*auditmanager.UntagResourceOutput, error)
	UntagResourceRequest(*auditmanager.UntagResourceInput) (*request.Request, *auditmanager.UntagResourceOutput)

	UpdateAssessment(*auditmanager.UpdateAssessmentInput) (*auditmanager.UpdateAssessmentOutput, error)
	UpdateAssessmentWithContext(aws.Context, *auditmanager.UpdateAssessmentInput, ...request.Option) (*auditmanager.UpdateAssessmentOutput, error)
	UpdateAssessmentRequest(*auditmanager.UpdateAssessmentInput) (*request.Request, *auditmanager.UpdateAssessmentOutput)

	UpdateAssessmentControl(*auditmanager.UpdateAssessmentControlInput) (*auditmanager.UpdateAssessmentControlOutput, error)
	UpdateAssessmentControlWithContext(aws.Context, *auditmanager.UpdateAssessmentControlInput, ...request.Option) (*auditmanager.UpdateAssessmentControlOutput, error)
	UpdateAssessmentControlRequest(*auditmanager.UpdateAssessmentControlInput) (*request.Request, *auditmanager.UpdateAssessmentControlOutput)

	UpdateAssessmentControlSetStatus(*auditmanager.UpdateAssessmentControlSetStatusInput) (*auditmanager.UpdateAssessmentControlSetStatusOutput, error)
	UpdateAssessmentControlSetStatusWithContext(aws.Context, *auditmanager.UpdateAssessmentControlSetStatusInput, ...request.Option) (*auditmanager.UpdateAssessmentControlSetStatusOutput, error)
	UpdateAssessmentControlSetStatusRequest(*auditmanager.UpdateAssessmentControlSetStatusInput) (*request.Request, *auditmanager.UpdateAssessmentControlSetStatusOutput)

	UpdateAssessmentFramework(*auditmanager.UpdateAssessmentFrameworkInput) (*auditmanager.UpdateAssessmentFrameworkOutput, error)
	UpdateAssessmentFrameworkWithContext(aws.Context, *auditmanager.UpdateAssessmentFrameworkInput, ...request.Option) (*auditmanager.UpdateAssessmentFrameworkOutput, error)
	UpdateAssessmentFrameworkRequest(*auditmanager.UpdateAssessmentFrameworkInput) (*request.Request, *auditmanager.UpdateAssessmentFrameworkOutput)

	UpdateAssessmentFrameworkShare(*auditmanager.UpdateAssessmentFrameworkShareInput) (*auditmanager.UpdateAssessmentFrameworkShareOutput, error)
	UpdateAssessmentFrameworkShareWithContext(aws.Context, *auditmanager.UpdateAssessmentFrameworkShareInput, ...request.Option) (*auditmanager.UpdateAssessmentFrameworkShareOutput, error)
	UpdateAssessmentFrameworkShareRequest(*auditmanager.UpdateAssessmentFrameworkShareInput) (*request.Request, *auditmanager.UpdateAssessmentFrameworkShareOutput)

	UpdateAssessmentStatus(*auditmanager.UpdateAssessmentStatusInput) (*auditmanager.UpdateAssessmentStatusOutput, error)
	UpdateAssessmentStatusWithContext(aws.Context, *auditmanager.UpdateAssessmentStatusInput, ...request.Option) (*auditmanager.UpdateAssessmentStatusOutput, error)
	UpdateAssessmentStatusRequest(*auditmanager.UpdateAssessmentStatusInput) (*request.Request, *auditmanager.UpdateAssessmentStatusOutput)

	UpdateControl(*auditmanager.UpdateControlInput) (*auditmanager.UpdateControlOutput, error)
	UpdateControlWithContext(aws.Context, *auditmanager.UpdateControlInput, ...request.Option) (*auditmanager.UpdateControlOutput, error)
	UpdateControlRequest(*auditmanager.UpdateControlInput) (*request.Request, *auditmanager.UpdateControlOutput)

	UpdateSettings(*auditmanager.UpdateSettingsInput) (*auditmanager.UpdateSettingsOutput, error)
	UpdateSettingsWithContext(aws.Context, *auditmanager.UpdateSettingsInput, ...request.Option) (*auditmanager.UpdateSettingsOutput, error)
	UpdateSettingsRequest(*auditmanager.UpdateSettingsInput) (*request.Request, *auditmanager.UpdateSettingsOutput)

	ValidateAssessmentReportIntegrity(*auditmanager.ValidateAssessmentReportIntegrityInput) (*auditmanager.ValidateAssessmentReportIntegrityOutput, error)
	ValidateAssessmentReportIntegrityWithContext(aws.Context, *auditmanager.ValidateAssessmentReportIntegrityInput, ...request.Option) (*auditmanager.ValidateAssessmentReportIntegrityOutput, error)
	ValidateAssessmentReportIntegrityRequest(*auditmanager.ValidateAssessmentReportIntegrityInput) (*request.Request, *auditmanager.ValidateAssessmentReportIntegrityOutput)
}

var _ AuditManagerAPI = (*auditmanager.AuditManager)(nil)
