package webplus

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreatePkgVersion invokes the webplus.CreatePkgVersion API synchronously
// api document: https://help.aliyun.com/api/webplus/createpkgversion.html
func (client *Client) CreatePkgVersion(request *CreatePkgVersionRequest) (response *CreatePkgVersionResponse, err error) {
	response = CreateCreatePkgVersionResponse()
	err = client.DoAction(request, response)
	return
}

// CreatePkgVersionWithChan invokes the webplus.CreatePkgVersion API asynchronously
// api document: https://help.aliyun.com/api/webplus/createpkgversion.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) CreatePkgVersionWithChan(request *CreatePkgVersionRequest) (<-chan *CreatePkgVersionResponse, <-chan error) {
	responseChan := make(chan *CreatePkgVersionResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreatePkgVersion(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreatePkgVersionWithCallback invokes the webplus.CreatePkgVersion API asynchronously
// api document: https://help.aliyun.com/api/webplus/createpkgversion.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) CreatePkgVersionWithCallback(request *CreatePkgVersionRequest, callback func(response *CreatePkgVersionResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreatePkgVersionResponse
		var err error
		defer close(result)
		response, err = client.CreatePkgVersion(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreatePkgVersionRequest is the request struct for api CreatePkgVersion
type CreatePkgVersionRequest struct {
	*requests.RoaRequest
	PackageSource         string `position:"Body" name:"PackageSource"`
	PkgVersionLabel       string `position:"Body" name:"PkgVersionLabel"`
	PkgVersionDescription string `position:"Body" name:"PkgVersionDescription"`
	AppId                 string `position:"Body" name:"AppId"`
}

// CreatePkgVersionResponse is the response struct for api CreatePkgVersion
type CreatePkgVersionResponse struct {
	*responses.BaseResponse
	RequestId  string     `json:"RequestId" xml:"RequestId"`
	Code       string     `json:"Code" xml:"Code"`
	Message    string     `json:"Message" xml:"Message"`
	PkgVersion PkgVersion `json:"PkgVersion" xml:"PkgVersion"`
}

// CreateCreatePkgVersionRequest creates a request to invoke CreatePkgVersion API
func CreateCreatePkgVersionRequest() (request *CreatePkgVersionRequest) {
	request = &CreatePkgVersionRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("WebPlus", "2019-03-20", "CreatePkgVersion", "/pop/v1/wam/pkgVersion", "", "")
	request.Method = requests.POST
	return
}

// CreateCreatePkgVersionResponse creates a response to parse from CreatePkgVersion response
func CreateCreatePkgVersionResponse() (response *CreatePkgVersionResponse) {
	response = &CreatePkgVersionResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
