package retailcloud

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// RebuildAppInstance invokes the retailcloud.RebuildAppInstance API synchronously
func (client *Client) RebuildAppInstance(request *RebuildAppInstanceRequest) (response *RebuildAppInstanceResponse, err error) {
	response = CreateRebuildAppInstanceResponse()
	err = client.DoAction(request, response)
	return
}

// RebuildAppInstanceWithChan invokes the retailcloud.RebuildAppInstance API asynchronously
func (client *Client) RebuildAppInstanceWithChan(request *RebuildAppInstanceRequest) (<-chan *RebuildAppInstanceResponse, <-chan error) {
	responseChan := make(chan *RebuildAppInstanceResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.RebuildAppInstance(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// RebuildAppInstanceWithCallback invokes the retailcloud.RebuildAppInstance API asynchronously
func (client *Client) RebuildAppInstanceWithCallback(request *RebuildAppInstanceRequest, callback func(response *RebuildAppInstanceResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *RebuildAppInstanceResponse
		var err error
		defer close(result)
		response, err = client.RebuildAppInstance(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// RebuildAppInstanceRequest is the request struct for api RebuildAppInstance
type RebuildAppInstanceRequest struct {
	*requests.RpcRequest
	AppId         requests.Integer `position:"Query" name:"AppId"`
	EnvId         requests.Integer `position:"Query" name:"EnvId"`
	AppInstanceId string           `position:"Query" name:"AppInstanceId"`
}

// RebuildAppInstanceResponse is the response struct for api RebuildAppInstance
type RebuildAppInstanceResponse struct {
	*responses.BaseResponse
	Code      int    `json:"Code" xml:"Code"`
	RequestId string `json:"RequestId" xml:"RequestId"`
	ErrMsg    string `json:"ErrMsg" xml:"ErrMsg"`
	Result    Result `json:"Result" xml:"Result"`
}

// CreateRebuildAppInstanceRequest creates a request to invoke RebuildAppInstance API
func CreateRebuildAppInstanceRequest() (request *RebuildAppInstanceRequest) {
	request = &RebuildAppInstanceRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("retailcloud", "2018-03-13", "RebuildAppInstance", "", "")
	request.Method = requests.POST
	return
}

// CreateRebuildAppInstanceResponse creates a response to parse from RebuildAppInstance response
func CreateRebuildAppInstanceResponse() (response *RebuildAppInstanceResponse) {
	response = &RebuildAppInstanceResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
