package devops_rdc

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateCommonGroup invokes the devops_rdc.CreateCommonGroup API synchronously
func (client *Client) CreateCommonGroup(request *CreateCommonGroupRequest) (response *CreateCommonGroupResponse, err error) {
	response = CreateCreateCommonGroupResponse()
	err = client.DoAction(request, response)
	return
}

// CreateCommonGroupWithChan invokes the devops_rdc.CreateCommonGroup API asynchronously
func (client *Client) CreateCommonGroupWithChan(request *CreateCommonGroupRequest) (<-chan *CreateCommonGroupResponse, <-chan error) {
	responseChan := make(chan *CreateCommonGroupResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateCommonGroup(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateCommonGroupWithCallback invokes the devops_rdc.CreateCommonGroup API asynchronously
func (client *Client) CreateCommonGroupWithCallback(request *CreateCommonGroupRequest, callback func(response *CreateCommonGroupResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateCommonGroupResponse
		var err error
		defer close(result)
		response, err = client.CreateCommonGroup(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateCommonGroupRequest is the request struct for api CreateCommonGroup
type CreateCommonGroupRequest struct {
	*requests.RpcRequest
	SmartGroupId string `position:"Body" name:"SmartGroupId"`
	Name         string `position:"Body" name:"Name"`
	Description  string `position:"Body" name:"Description"`
	ProjectId    string `position:"Body" name:"ProjectId"`
	OrgId        string `position:"Body" name:"OrgId"`
}

// CreateCommonGroupResponse is the response struct for api CreateCommonGroup
type CreateCommonGroupResponse struct {
	*responses.BaseResponse
	Successful bool   `json:"Successful" xml:"Successful"`
	ErrorCode  string `json:"ErrorCode" xml:"ErrorCode"`
	ErrorMsg   string `json:"ErrorMsg" xml:"ErrorMsg"`
	RequestId  string `json:"RequestId" xml:"RequestId"`
	Object     Object `json:"Object" xml:"Object"`
}

// CreateCreateCommonGroupRequest creates a request to invoke CreateCommonGroup API
func CreateCreateCommonGroupRequest() (request *CreateCommonGroupRequest) {
	request = &CreateCommonGroupRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("devops-rdc", "2020-03-03", "CreateCommonGroup", "", "")
	request.Method = requests.POST
	return
}

// CreateCreateCommonGroupResponse creates a response to parse from CreateCommonGroup response
func CreateCreateCommonGroupResponse() (response *CreateCommonGroupResponse) {
	response = &CreateCommonGroupResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
