package alimt

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// TranslateCertificate invokes the alimt.TranslateCertificate API synchronously
func (client *Client) TranslateCertificate(request *TranslateCertificateRequest) (response *TranslateCertificateResponse, err error) {
	response = CreateTranslateCertificateResponse()
	err = client.DoAction(request, response)
	return
}

// TranslateCertificateWithChan invokes the alimt.TranslateCertificate API asynchronously
func (client *Client) TranslateCertificateWithChan(request *TranslateCertificateRequest) (<-chan *TranslateCertificateResponse, <-chan error) {
	responseChan := make(chan *TranslateCertificateResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.TranslateCertificate(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// TranslateCertificateWithCallback invokes the alimt.TranslateCertificate API asynchronously
func (client *Client) TranslateCertificateWithCallback(request *TranslateCertificateRequest, callback func(response *TranslateCertificateResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *TranslateCertificateResponse
		var err error
		defer close(result)
		response, err = client.TranslateCertificate(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// TranslateCertificateRequest is the request struct for api TranslateCertificate
type TranslateCertificateRequest struct {
	*requests.RpcRequest
	Ext             string `position:"Body" name:"Ext"`
	SourceLanguage  string `position:"Body" name:"SourceLanguage"`
	CertificateType string `position:"Body" name:"CertificateType"`
	ResultType      string `position:"Body" name:"ResultType"`
	ImageUrl        string `position:"Body" name:"ImageUrl"`
	TargetLanguage  string `position:"Body" name:"TargetLanguage"`
}

// TranslateCertificateResponse is the response struct for api TranslateCertificate
type TranslateCertificateResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Data      Data   `json:"Data" xml:"Data"`
}

// CreateTranslateCertificateRequest creates a request to invoke TranslateCertificate API
func CreateTranslateCertificateRequest() (request *TranslateCertificateRequest) {
	request = &TranslateCertificateRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("alimt", "2018-10-12", "TranslateCertificate", "", "")
	request.Method = requests.POST
	return
}

// CreateTranslateCertificateResponse creates a response to parse from TranslateCertificate response
func CreateTranslateCertificateResponse() (response *TranslateCertificateResponse) {
	response = &TranslateCertificateResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
