package scdn

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// BatchStartScdnDomain invokes the scdn.BatchStartScdnDomain API synchronously
func (client *Client) BatchStartScdnDomain(request *BatchStartScdnDomainRequest) (response *BatchStartScdnDomainResponse, err error) {
	response = CreateBatchStartScdnDomainResponse()
	err = client.DoAction(request, response)
	return
}

// BatchStartScdnDomainWithChan invokes the scdn.BatchStartScdnDomain API asynchronously
func (client *Client) BatchStartScdnDomainWithChan(request *BatchStartScdnDomainRequest) (<-chan *BatchStartScdnDomainResponse, <-chan error) {
	responseChan := make(chan *BatchStartScdnDomainResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.BatchStartScdnDomain(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// BatchStartScdnDomainWithCallback invokes the scdn.BatchStartScdnDomain API asynchronously
func (client *Client) BatchStartScdnDomainWithCallback(request *BatchStartScdnDomainRequest, callback func(response *BatchStartScdnDomainResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *BatchStartScdnDomainResponse
		var err error
		defer close(result)
		response, err = client.BatchStartScdnDomain(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// BatchStartScdnDomainRequest is the request struct for api BatchStartScdnDomain
type BatchStartScdnDomainRequest struct {
	*requests.RpcRequest
	DomainNames   string           `position:"Query" name:"DomainNames"`
	OwnerId       requests.Integer `position:"Query" name:"OwnerId"`
	SecurityToken string           `position:"Query" name:"SecurityToken"`
}

// BatchStartScdnDomainResponse is the response struct for api BatchStartScdnDomain
type BatchStartScdnDomainResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateBatchStartScdnDomainRequest creates a request to invoke BatchStartScdnDomain API
func CreateBatchStartScdnDomainRequest() (request *BatchStartScdnDomainRequest) {
	request = &BatchStartScdnDomainRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("scdn", "2017-11-15", "BatchStartScdnDomain", "", "")
	request.Method = requests.POST
	return
}

// CreateBatchStartScdnDomainResponse creates a response to parse from BatchStartScdnDomain response
func CreateBatchStartScdnDomainResponse() (response *BatchStartScdnDomainResponse) {
	response = &BatchStartScdnDomainResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
