package dataworks_public

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// StopDISyncInstance invokes the dataworks_public.StopDISyncInstance API synchronously
func (client *Client) StopDISyncInstance(request *StopDISyncInstanceRequest) (response *StopDISyncInstanceResponse, err error) {
	response = CreateStopDISyncInstanceResponse()
	err = client.DoAction(request, response)
	return
}

// StopDISyncInstanceWithChan invokes the dataworks_public.StopDISyncInstance API asynchronously
func (client *Client) StopDISyncInstanceWithChan(request *StopDISyncInstanceRequest) (<-chan *StopDISyncInstanceResponse, <-chan error) {
	responseChan := make(chan *StopDISyncInstanceResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.StopDISyncInstance(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// StopDISyncInstanceWithCallback invokes the dataworks_public.StopDISyncInstance API asynchronously
func (client *Client) StopDISyncInstanceWithCallback(request *StopDISyncInstanceRequest, callback func(response *StopDISyncInstanceResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *StopDISyncInstanceResponse
		var err error
		defer close(result)
		response, err = client.StopDISyncInstance(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// StopDISyncInstanceRequest is the request struct for api StopDISyncInstance
type StopDISyncInstanceRequest struct {
	*requests.RpcRequest
	TaskType  string           `position:"Query" name:"TaskType"`
	ProjectId requests.Integer `position:"Query" name:"ProjectId"`
	FileId    requests.Integer `position:"Query" name:"FileId"`
}

// StopDISyncInstanceResponse is the response struct for api StopDISyncInstance
type StopDISyncInstanceResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Success   bool   `json:"Success" xml:"Success"`
	Data      Data   `json:"Data" xml:"Data"`
}

// CreateStopDISyncInstanceRequest creates a request to invoke StopDISyncInstance API
func CreateStopDISyncInstanceRequest() (request *StopDISyncInstanceRequest) {
	request = &StopDISyncInstanceRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("dataworks-public", "2020-05-18", "StopDISyncInstance", "", "")
	request.Method = requests.POST
	return
}

// CreateStopDISyncInstanceResponse creates a response to parse from StopDISyncInstance response
func CreateStopDISyncInstanceResponse() (response *StopDISyncInstanceResponse) {
	response = &StopDISyncInstanceResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
