/*
 * net.c - network functions for GINI
 * Copyright 2002, 2003 Krisztian Pifko <monsta@users.sourceforge.net>
 *
 * Author:
 *	Krisztian Pifko <monsta@users.sourceforge.net>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */
#include <string.h>
 
#include "net.h"

void closesocket (int sock)
{
  if (shutdown (sock, SHUT_RDWR) != -1) {
    close (sock);
  }
}

/*
void closesocket_s (char *s,int sock)
{
  printf("closesocket: %s %d\n",s,sock);
  if (shutdown (sock, SHUT_RDWR) != -1) {
    close (sock);
  }
}
*/

int acceptconnection (int sock, u_long * remote_ip)
{
  int len;
  struct sockaddr_in clientaddr;
  u_long val;
  u_long ip;
  int newsock;
  len = sizeof (clientaddr);
  newsock = accept (sock, (struct sockaddr *) &clientaddr, &len);
  if (newsock >= 0) {
    ip = ntohl (clientaddr.sin_addr.s_addr);
    *remote_ip = ip;
// if(ip==0x7f000001 || ip==local_ip.ip){
    val = 1;
    if (!BLOCK) {
      ioctl (newsock, FIONBIO, &val);
    }
    return newsock;
// }
// closesocket(newsock);
  }
  return -1;
}

int listenonport (u_short port)
{
  int sock;
  struct sockaddr_in name;
  int bindval;
  int listenval;
  sock = socket (PF_INET, SOCK_STREAM, 0);
  if (sock >= 0) {
    name.sin_family = AF_INET;
    name.sin_port = htons (port);
    name.sin_addr.s_addr = htonl (INADDR_ANY);
    bindval = bind (sock, (struct sockaddr *) &name, sizeof (name));
    if (bindval >= 0) {
      listenval = listen (sock, SOMAXCONN);
      if (listenval >= 0) {
	u_long val = 1;
	if (!BLOCK) {
	  ioctl (sock, FIONBIO, &val);
	}
	return sock;
      }
    }
    closesocket (sock);
  }
  return -1;
}

/*
int connectto (in_addr_t addr, in_port_t port)
{
  struct sockaddr_in myaddr;
  int sock;
  int err;
  myaddr.sin_family = AF_INET;
  myaddr.sin_port = htons ((u_short) port);
  *(u_long *) (&myaddr.sin_addr) = htonl (addr);
//  *(ulong*)(&myaddr.sin_addr)=addr;
  sock = socket (PF_INET, SOCK_STREAM, 0);
  if (sock < 0) {
    return -1;
  }
  err = connect (sock, (struct sockaddr *) &myaddr, sizeof (myaddr));
  if (err < 0) {
    return -1;
  }
  err = 1;
//  ioctl (sock, FIONBIO, &err);
  return sock;
}
*/

int connectto2 (char *address, int connect_port)
{
  struct sockaddr_in a;
  struct hostent *host;
  int s, err;
  u_int32_t nl;
  if ((s = socket (AF_INET, SOCK_STREAM, 0)) < 0) {
    close (s);
    return -1;
  }

  memset (&a, 0, sizeof (a));
  a.sin_port = htons (connect_port);
  a.sin_family = AF_INET;
  host = gethostbyname (address);
  if (host != NULL) {
    memcpy (&nl, host->h_addr, sizeof (u_int32_t));
//              nl=host->h_addr;
    a.sin_addr.s_addr = nl;
  } else {
    close (s);
    return -1;
  }

  if (connect (s, (struct sockaddr *) &a, sizeof (a)) < 0) {
    closesocket (s);
    return -1;
  }
  err = 1;
//  ioctl (s, FIONBIO, &err);
  return s;
}

int connect_udp (u_long ip, int port)
{
  struct sockaddr_in rem_addr;
  int sock;
  int err;
  rem_addr.sin_family = AF_INET;
  rem_addr.sin_port = htons ((u_short) port);
  *(u_long *) (&rem_addr.sin_addr) = htonl (ip);
  sock = socket (PF_INET, SOCK_DGRAM, 0);
  if (sock < 0) {
    return -1;
  }
  err = connect (sock, (struct sockaddr *) &rem_addr, sizeof (rem_addr));
  if (err < 0) {
    return -1;
  }
  err = 1;
  ioctl (sock, FIONBIO, &err);
  return sock;
}
